/*
 * POS Terminal Management API
 * This API provides endpoints for managing your point-of-sale (POS) payment terminals. You can use the API to obtain information about a specific terminal, retrieve overviews of your terminals and stores, and assign terminals to a merchant account or store.  For more information, refer to [Assign terminals](https://docs.adyen.com/point-of-sale/automating-terminal-management/assign-terminals-api).  ## Authentication Each request to the Terminal Management API must be signed with an API key. For this, obtain an API Key from your Customer Area, as described in [How to get the API key](https://docs.adyen.com/development-resources/api-credentials#generate-api-key). Then set this key to the `X-API-Key` header value, for example:  ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: Your_API_key\" \\ ... ``` Note that when going live, you need to generate new web service user credentials to access the [live endpoints](https://docs.adyen.com/development-resources/live-endpoints).  ## Versioning Terminal Management API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://postfmapi-test.adyen.com/postfmapi/terminal/v1/getTerminalsUnderAccount ``` When using versioned endpoints, Boolean response values are returned in string format: `\"true\"` or `\"false\"`. If you omit the version from the endpoint URL, Boolean response values are returned like this: `true` or `false`.
 *
 * The version of the OpenAPI document: 1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.posterminalmanagement;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.posterminalmanagement.Store;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * GetStoresUnderAccountResponse
 */
@JsonPropertyOrder({
  GetStoresUnderAccountResponse.JSON_PROPERTY_STORES
})

public class GetStoresUnderAccountResponse {
  public static final String JSON_PROPERTY_STORES = "stores";
  private List<Store> stores = null;

  public GetStoresUnderAccountResponse() { 
  }

  public GetStoresUnderAccountResponse stores(List<Store> stores) {
    this.stores = stores;
    return this;
  }

  public GetStoresUnderAccountResponse addStoresItem(Store storesItem) {
    if (this.stores == null) {
      this.stores = new ArrayList<>();
    }
    this.stores.add(storesItem);
    return this;
  }

   /**
   * Array that returns a list of all stores for the specified merchant account, or for all merchant accounts under the company account.
   * @return stores
  **/
  @ApiModelProperty(value = "Array that returns a list of all stores for the specified merchant account, or for all merchant accounts under the company account.")
  @JsonProperty(JSON_PROPERTY_STORES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Store> getStores() {
    return stores;
  }


  @JsonProperty(JSON_PROPERTY_STORES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStores(List<Store> stores) {
    this.stores = stores;
  }


  /**
   * Return true if this GetStoresUnderAccountResponse object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetStoresUnderAccountResponse getStoresUnderAccountResponse = (GetStoresUnderAccountResponse) o;
    return Objects.equals(this.stores, getStoresUnderAccountResponse.stores);
  }

  @Override
  public int hashCode() {
    return Objects.hash(stores);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetStoresUnderAccountResponse {\n");
    sb.append("    stores: ").append(toIndentedString(stores)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of GetStoresUnderAccountResponse given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of GetStoresUnderAccountResponse
   * @throws JsonProcessingException if the JSON string is invalid with respect to GetStoresUnderAccountResponse
   */
  public static GetStoresUnderAccountResponse fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, GetStoresUnderAccountResponse.class);
  }
/**
  * Convert an instance of GetStoresUnderAccountResponse to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

