/*
 * POS Terminal Management API
 * This API provides endpoints for managing your point-of-sale (POS) payment terminals. You can use the API to obtain information about a specific terminal, retrieve overviews of your terminals and stores, and assign terminals to a merchant account or store.  For more information, refer to [Assign terminals](https://docs.adyen.com/point-of-sale/automating-terminal-management/assign-terminals-api).  ## Authentication Each request to the Terminal Management API must be signed with an API key. For this, obtain an API Key from your Customer Area, as described in [How to get the API key](https://docs.adyen.com/development-resources/api-credentials#generate-api-key). Then set this key to the `X-API-Key` header value, for example:  ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: Your_API_key\" \\ ... ``` Note that when going live, you need to generate new web service user credentials to access the [live endpoints](https://docs.adyen.com/development-resources/live-endpoints).  ## Versioning Terminal Management API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://postfmapi-test.adyen.com/postfmapi/terminal/v1/getTerminalsUnderAccount ``` When using versioned endpoints, Boolean response values are returned in string format: `\"true\"` or `\"false\"`. If you omit the version from the endpoint URL, Boolean response values are returned like this: `true` or `false`.
 *
 * The version of the OpenAPI document: 1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.posterminalmanagement;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.posterminalmanagement.Store;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * MerchantAccount
 */
@JsonPropertyOrder({
  MerchantAccount.JSON_PROPERTY_IN_STORE_TERMINALS,
  MerchantAccount.JSON_PROPERTY_INVENTORY_TERMINALS,
  MerchantAccount.JSON_PROPERTY_MERCHANT_ACCOUNT,
  MerchantAccount.JSON_PROPERTY_STORES
})

public class MerchantAccount {
  public static final String JSON_PROPERTY_IN_STORE_TERMINALS = "inStoreTerminals";
  private List<String> inStoreTerminals = null;

  public static final String JSON_PROPERTY_INVENTORY_TERMINALS = "inventoryTerminals";
  private List<String> inventoryTerminals = null;

  public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
  private String merchantAccount;

  public static final String JSON_PROPERTY_STORES = "stores";
  private List<Store> stores = null;

  public MerchantAccount() { 
  }

  public MerchantAccount inStoreTerminals(List<String> inStoreTerminals) {
    this.inStoreTerminals = inStoreTerminals;
    return this;
  }

  public MerchantAccount addInStoreTerminalsItem(String inStoreTerminalsItem) {
    if (this.inStoreTerminals == null) {
      this.inStoreTerminals = new ArrayList<>();
    }
    this.inStoreTerminals.add(inStoreTerminalsItem);
    return this;
  }

   /**
   * List of terminals assigned to this merchant account as in-store terminals. This means that the terminal is ready to be boarded, or is already boarded.
   * @return inStoreTerminals
  **/
  @ApiModelProperty(value = "List of terminals assigned to this merchant account as in-store terminals. This means that the terminal is ready to be boarded, or is already boarded.")
  @JsonProperty(JSON_PROPERTY_IN_STORE_TERMINALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getInStoreTerminals() {
    return inStoreTerminals;
  }


  @JsonProperty(JSON_PROPERTY_IN_STORE_TERMINALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInStoreTerminals(List<String> inStoreTerminals) {
    this.inStoreTerminals = inStoreTerminals;
  }


  public MerchantAccount inventoryTerminals(List<String> inventoryTerminals) {
    this.inventoryTerminals = inventoryTerminals;
    return this;
  }

  public MerchantAccount addInventoryTerminalsItem(String inventoryTerminalsItem) {
    if (this.inventoryTerminals == null) {
      this.inventoryTerminals = new ArrayList<>();
    }
    this.inventoryTerminals.add(inventoryTerminalsItem);
    return this;
  }

   /**
   * List of terminals assigned to the inventory of this merchant account.
   * @return inventoryTerminals
  **/
  @ApiModelProperty(value = "List of terminals assigned to the inventory of this merchant account.")
  @JsonProperty(JSON_PROPERTY_INVENTORY_TERMINALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getInventoryTerminals() {
    return inventoryTerminals;
  }


  @JsonProperty(JSON_PROPERTY_INVENTORY_TERMINALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInventoryTerminals(List<String> inventoryTerminals) {
    this.inventoryTerminals = inventoryTerminals;
  }


  public MerchantAccount merchantAccount(String merchantAccount) {
    this.merchantAccount = merchantAccount;
    return this;
  }

   /**
   * The merchant account.
   * @return merchantAccount
  **/
  @ApiModelProperty(required = true, value = "The merchant account.")
  @JsonProperty(JSON_PROPERTY_MERCHANT_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMerchantAccount() {
    return merchantAccount;
  }


  @JsonProperty(JSON_PROPERTY_MERCHANT_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantAccount(String merchantAccount) {
    this.merchantAccount = merchantAccount;
  }


  public MerchantAccount stores(List<Store> stores) {
    this.stores = stores;
    return this;
  }

  public MerchantAccount addStoresItem(Store storesItem) {
    if (this.stores == null) {
      this.stores = new ArrayList<>();
    }
    this.stores.add(storesItem);
    return this;
  }

   /**
   * Array of stores under this merchant account.
   * @return stores
  **/
  @ApiModelProperty(value = "Array of stores under this merchant account.")
  @JsonProperty(JSON_PROPERTY_STORES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Store> getStores() {
    return stores;
  }


  @JsonProperty(JSON_PROPERTY_STORES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStores(List<Store> stores) {
    this.stores = stores;
  }


  /**
   * Return true if this MerchantAccount object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MerchantAccount merchantAccount = (MerchantAccount) o;
    return Objects.equals(this.inStoreTerminals, merchantAccount.inStoreTerminals) &&
        Objects.equals(this.inventoryTerminals, merchantAccount.inventoryTerminals) &&
        Objects.equals(this.merchantAccount, merchantAccount.merchantAccount) &&
        Objects.equals(this.stores, merchantAccount.stores);
  }

  @Override
  public int hashCode() {
    return Objects.hash(inStoreTerminals, inventoryTerminals, merchantAccount, stores);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MerchantAccount {\n");
    sb.append("    inStoreTerminals: ").append(toIndentedString(inStoreTerminals)).append("\n");
    sb.append("    inventoryTerminals: ").append(toIndentedString(inventoryTerminals)).append("\n");
    sb.append("    merchantAccount: ").append(toIndentedString(merchantAccount)).append("\n");
    sb.append("    stores: ").append(toIndentedString(stores)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of MerchantAccount given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of MerchantAccount
   * @throws JsonProcessingException if the JSON string is invalid with respect to MerchantAccount
   */
  public static MerchantAccount fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, MerchantAccount.class);
  }
/**
  * Convert an instance of MerchantAccount to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

