/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.service.legalentitymanagement;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.legalentitymanagement.GeneratePciDescriptionRequest;
import com.adyen.model.legalentitymanagement.GeneratePciDescriptionResponse;
import com.adyen.model.legalentitymanagement.GetPciQuestionnaireInfosResponse;
import com.adyen.model.legalentitymanagement.GetPciQuestionnaireResponse;
import com.adyen.model.legalentitymanagement.PciSigningRequest;
import com.adyen.model.legalentitymanagement.PciSigningResponse;
import com.adyen.model.legalentitymanagement.ServiceError;
import com.adyen.model.RequestOptions;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class PciQuestionnairesApi extends Service {

    public static final String API_VERSION = "3";

    protected String baseURL;

    /**
    * PCI questionnaires constructor in {@link com.adyen.service.legalentitymanagement package}.
    * @param client {@link Client } (required)
    */
    public PciQuestionnairesApi(Client client) {
        super(client);
        this.baseURL = createBaseURL("https://kyc-test.adyen.com/lem/v3");
    }

    /**
    * PCI questionnaires constructor in {@link com.adyen.service.legalentitymanagement package}.
    * Please use this constructor only if you would like to pass along your own url for routing or testing purposes. The latest API version is defined in this class as a constant.
    * @param client {@link Client } (required)
    * @param baseURL {@link String } (required)
    */
    public PciQuestionnairesApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    /**
    * Get PCI questionnaire details
    *
    * @param id {@link String } The unique identifier of the legal entity to get PCI questionnaire information. (required)
    * @return {@link GetPciQuestionnaireInfosResponse }
    * @throws ApiException if fails to make API call
    */
    public GetPciQuestionnaireInfosResponse getPciQuestionnaireDetails(String id) throws ApiException, IOException {
        return getPciQuestionnaireDetails(id, null);
    }

    /**
    * Get PCI questionnaire details
    *
    * @param id {@link String } The unique identifier of the legal entity to get PCI questionnaire information. (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link GetPciQuestionnaireInfosResponse }
    * @throws ApiException if fails to make API call
    */
    public GetPciQuestionnaireInfosResponse getPciQuestionnaireDetails(String id, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);

        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/legalEntities/{id}/pciQuestionnaires", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return GetPciQuestionnaireInfosResponse.fromJson(jsonResult);
    }

    /**
    * Get PCI questionnaire
    *
    * @param id {@link String } The legal entity ID of the individual who signed the PCI questionnaire. (required)
    * @param pciid {@link String } The unique identifier of the signed PCI questionnaire. (required)
    * @return {@link GetPciQuestionnaireResponse }
    * @throws ApiException if fails to make API call
    */
    public GetPciQuestionnaireResponse getPciQuestionnaire(String id, String pciid) throws ApiException, IOException {
        return getPciQuestionnaire(id, pciid, null);
    }

    /**
    * Get PCI questionnaire
    *
    * @param id {@link String } The legal entity ID of the individual who signed the PCI questionnaire. (required)
    * @param pciid {@link String } The unique identifier of the signed PCI questionnaire. (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link GetPciQuestionnaireResponse }
    * @throws ApiException if fails to make API call
    */
    public GetPciQuestionnaireResponse getPciQuestionnaire(String id, String pciid, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        if (pciid == null) {
            throw new IllegalArgumentException("Please provide the pciid path parameter");
        }
        pathParams.put("pciid", pciid);

        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/legalEntities/{id}/pciQuestionnaires/{pciid}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return GetPciQuestionnaireResponse.fromJson(jsonResult);
    }

    /**
    * Generate PCI questionnaire
    *
    * @param id {@link String } The unique identifier of the legal entity to get PCI questionnaire information. (required)
    * @param generatePciDescriptionRequest {@link GeneratePciDescriptionRequest }  (required)
    * @return {@link GeneratePciDescriptionResponse }
    * @throws ApiException if fails to make API call
    */
    public GeneratePciDescriptionResponse generatePciQuestionnaire(String id, GeneratePciDescriptionRequest generatePciDescriptionRequest) throws ApiException, IOException {
        return generatePciQuestionnaire(id, generatePciDescriptionRequest, null);
    }

    /**
    * Generate PCI questionnaire
    *
    * @param id {@link String } The unique identifier of the legal entity to get PCI questionnaire information. (required)
    * @param generatePciDescriptionRequest {@link GeneratePciDescriptionRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link GeneratePciDescriptionResponse }
    * @throws ApiException if fails to make API call
    */
    public GeneratePciDescriptionResponse generatePciQuestionnaire(String id, GeneratePciDescriptionRequest generatePciDescriptionRequest, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);

        String requestBody = generatePciDescriptionRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/legalEntities/{id}/pciQuestionnaires/generatePciTemplates", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return GeneratePciDescriptionResponse.fromJson(jsonResult);
    }

    /**
    * Sign PCI questionnaire
    *
    * @param id {@link String } The legal entity ID of the individual who signed the PCI questionnaire. (required)
    * @param pciSigningRequest {@link PciSigningRequest }  (required)
    * @return {@link PciSigningResponse }
    * @throws ApiException if fails to make API call
    */
    public PciSigningResponse signPciQuestionnaire(String id, PciSigningRequest pciSigningRequest) throws ApiException, IOException {
        return signPciQuestionnaire(id, pciSigningRequest, null);
    }

    /**
    * Sign PCI questionnaire
    *
    * @param id {@link String } The legal entity ID of the individual who signed the PCI questionnaire. (required)
    * @param pciSigningRequest {@link PciSigningRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link PciSigningResponse }
    * @throws ApiException if fails to make API call
    */
    public PciSigningResponse signPciQuestionnaire(String id, PciSigningRequest pciSigningRequest, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);

        String requestBody = pciSigningRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/legalEntities/{id}/pciQuestionnaires/signPciTemplates", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return PciSigningResponse.fromJson(jsonResult);
    }
}
