/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"addressEditable", "enabled"})
public class Avs {
    public static final String JSON_PROPERTY_ADDRESS_EDITABLE = "addressEditable";
    private Boolean addressEditable;
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private EnabledEnum enabled;

    public Avs addressEditable(Boolean addressEditable) {
        this.addressEditable = addressEditable;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the shopper is allowed to modify the billing address for the current payment request.")
    @JsonProperty(value="addressEditable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAddressEditable() {
        return this.addressEditable;
    }

    @JsonProperty(value="addressEditable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddressEditable(Boolean addressEditable) {
        this.addressEditable = addressEditable;
    }

    public Avs enabled(EnabledEnum enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(value="Specifies whether the shopper should enter their billing address during checkout.  Allowed values: * yes \u2014 Perform AVS checks for every card payment. * automatic \u2014 Perform AVS checks only when required to optimize the conversion rate. * no \u2014 Do not perform AVS checks.")
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EnabledEnum getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnabled(EnabledEnum enabled) {
        this.enabled = enabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Avs avs = (Avs)o;
        return Objects.equals(this.addressEditable, avs.addressEditable) && Objects.equals((Object)this.enabled, (Object)avs.enabled);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.addressEditable, this.enabled});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Avs {\n");
        sb.append("    addressEditable: ").append(this.toIndentedString(this.addressEditable)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString((Object)this.enabled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Avs fromJson(String jsonString) throws JsonProcessingException {
        return (Avs)JSON.getMapper().readValue(jsonString, Avs.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum EnabledEnum {
        YES("yes"),
        NO("no"),
        AUTOMATIC("automatic");

        private String value;

        private EnabledEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EnabledEnum fromValue(String value) {
            for (EnabledEnum b : EnabledEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

