/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.CheckoutOrderResponse;
import com.adyen.model.checkout.FraudResult;
import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.ServiceError2;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"additionalData", "fraudResult", "merchantReference", "order", "pspReference", "refusalReason", "refusalReasonCode", "resultCode", "serviceError", "shopperLocale"})
public class PaymentVerificationResponse {
    public static final String JSON_PROPERTY_ADDITIONAL_DATA = "additionalData";
    private Map<String, String> additionalData = null;
    public static final String JSON_PROPERTY_FRAUD_RESULT = "fraudResult";
    private FraudResult fraudResult;
    public static final String JSON_PROPERTY_MERCHANT_REFERENCE = "merchantReference";
    private String merchantReference;
    public static final String JSON_PROPERTY_ORDER = "order";
    private CheckoutOrderResponse order;
    public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
    private String pspReference;
    public static final String JSON_PROPERTY_REFUSAL_REASON = "refusalReason";
    private String refusalReason;
    public static final String JSON_PROPERTY_REFUSAL_REASON_CODE = "refusalReasonCode";
    private String refusalReasonCode;
    public static final String JSON_PROPERTY_RESULT_CODE = "resultCode";
    private ResultCodeEnum resultCode;
    public static final String JSON_PROPERTY_SERVICE_ERROR = "serviceError";
    private ServiceError2 serviceError;
    public static final String JSON_PROPERTY_SHOPPER_LOCALE = "shopperLocale";
    private String shopperLocale;

    public PaymentVerificationResponse additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        return this;
    }

    public PaymentVerificationResponse putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    @ApiModelProperty(value="Contains additional information about the payment. Some data fields are included only if you select them first: Go to **Customer Area** > **Developers** > **Additional data**.")
    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
    }

    public PaymentVerificationResponse fraudResult(FraudResult fraudResult) {
        this.fraudResult = fraudResult;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="fraudResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FraudResult getFraudResult() {
        return this.fraudResult;
    }

    @JsonProperty(value="fraudResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFraudResult(FraudResult fraudResult) {
        this.fraudResult = fraudResult;
    }

    public PaymentVerificationResponse merchantReference(String merchantReference) {
        this.merchantReference = merchantReference;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique value that you provided in the initial `/paymentSession` request as a `reference` field.")
    @JsonProperty(value="merchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantReference() {
        return this.merchantReference;
    }

    @JsonProperty(value="merchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantReference(String merchantReference) {
        this.merchantReference = merchantReference;
    }

    public PaymentVerificationResponse order(CheckoutOrderResponse order) {
        this.order = order;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="order")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CheckoutOrderResponse getOrder() {
        return this.order;
    }

    @JsonProperty(value="order")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrder(CheckoutOrderResponse order) {
        this.order = order;
    }

    public PaymentVerificationResponse pspReference(String pspReference) {
        this.pspReference = pspReference;
        return this;
    }

    @ApiModelProperty(value="Adyen's 16-character reference associated with the transaction/request. This value is globally unique; quote it when communicating with us about this request.")
    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPspReference() {
        return this.pspReference;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
    }

    public PaymentVerificationResponse refusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
        return this;
    }

    @ApiModelProperty(value="If the payment's authorisation is refused or an error occurs during authorisation, this field holds Adyen's mapped reason for the refusal or a description of the error. When a transaction fails, the authorisation response includes `resultCode` and `refusalReason` values.  For more information, see [Refusal reasons](https://docs.adyen.com/development-resources/refusal-reasons).")
    @JsonProperty(value="refusalReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRefusalReason() {
        return this.refusalReason;
    }

    @JsonProperty(value="refusalReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
    }

    public PaymentVerificationResponse refusalReasonCode(String refusalReasonCode) {
        this.refusalReasonCode = refusalReasonCode;
        return this;
    }

    @ApiModelProperty(value="Code that specifies the refusal reason. For more information, see [Authorisation refusal reasons](https://docs.adyen.com/development-resources/refusal-reasons).")
    @JsonProperty(value="refusalReasonCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRefusalReasonCode() {
        return this.refusalReasonCode;
    }

    @JsonProperty(value="refusalReasonCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefusalReasonCode(String refusalReasonCode) {
        this.refusalReasonCode = refusalReasonCode;
    }

    public PaymentVerificationResponse resultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
        return this;
    }

    @ApiModelProperty(value="The result of the payment. For more information, see [Result codes](https://docs.adyen.com/online-payments/payment-result-codes).  Possible values:  * **AuthenticationFinished** \u2013 The payment has been successfully authenticated with 3D Secure 2. Returned for 3D Secure 2 authentication-only transactions. * **AuthenticationNotRequired** \u2013 The transaction does not require 3D Secure authentication. Returned for [standalone authentication-only integrations](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only). * **Authorised** \u2013 The payment was successfully authorised. This state serves as an indicator to proceed with the delivery of goods and services. This is a final state. * **Cancelled** \u2013 Indicates the payment has been cancelled (either by the shopper or the merchant) before processing was completed. This is a final state. * **ChallengeShopper** \u2013 The issuer requires further shopper interaction before the payment can be authenticated. Returned for 3D Secure 2 transactions. * **Error** \u2013 There was an error when the payment was being processed. The reason is given in the `refusalReason` field. This is a final state. * **IdentifyShopper** \u2013 The issuer requires the shopper's device fingerprint before the payment can be authenticated. Returned for 3D Secure 2 transactions. * **PartiallyAuthorised** \u2013 The payment has been authorised for a partial amount. This happens for card payments when the merchant supports Partial Authorisations and the cardholder has insufficient funds. * **Pending** \u2013 Indicates that it is not possible to obtain the final status of the payment. This can happen if the systems providing final status information for the payment are unavailable, or if the shopper needs to take further action to complete the payment. * **PresentToShopper** \u2013 Indicates that the response contains additional information that you need to present to a shopper, so that they can use it to complete a payment. * **Received** \u2013 Indicates the payment has successfully been received by Adyen, and will be processed. This is the initial state for all payments. * **RedirectShopper** \u2013 Indicates the shopper should be redirected to an external web page or app to complete the authorisation. * **Refused** \u2013 Indicates the payment was refused. The reason is given in the `refusalReason` field. This is a final state.")
    @JsonProperty(value="resultCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResultCodeEnum getResultCode() {
        return this.resultCode;
    }

    @JsonProperty(value="resultCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
    }

    public PaymentVerificationResponse serviceError(ServiceError2 serviceError) {
        this.serviceError = serviceError;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="serviceError")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ServiceError2 getServiceError() {
        return this.serviceError;
    }

    @JsonProperty(value="serviceError")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setServiceError(ServiceError2 serviceError) {
        this.serviceError = serviceError;
    }

    public PaymentVerificationResponse shopperLocale(String shopperLocale) {
        this.shopperLocale = shopperLocale;
        return this;
    }

    @ApiModelProperty(required=true, value="The shopperLocale value provided in the payment request.")
    @JsonProperty(value="shopperLocale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperLocale() {
        return this.shopperLocale;
    }

    @JsonProperty(value="shopperLocale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperLocale(String shopperLocale) {
        this.shopperLocale = shopperLocale;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentVerificationResponse paymentVerificationResponse = (PaymentVerificationResponse)o;
        return Objects.equals(this.additionalData, paymentVerificationResponse.additionalData) && Objects.equals(this.fraudResult, paymentVerificationResponse.fraudResult) && Objects.equals(this.merchantReference, paymentVerificationResponse.merchantReference) && Objects.equals(this.order, paymentVerificationResponse.order) && Objects.equals(this.pspReference, paymentVerificationResponse.pspReference) && Objects.equals(this.refusalReason, paymentVerificationResponse.refusalReason) && Objects.equals(this.refusalReasonCode, paymentVerificationResponse.refusalReasonCode) && Objects.equals((Object)this.resultCode, (Object)paymentVerificationResponse.resultCode) && Objects.equals(this.serviceError, paymentVerificationResponse.serviceError) && Objects.equals(this.shopperLocale, paymentVerificationResponse.shopperLocale);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.additionalData, this.fraudResult, this.merchantReference, this.order, this.pspReference, this.refusalReason, this.refusalReasonCode, this.resultCode, this.serviceError, this.shopperLocale});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentVerificationResponse {\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    fraudResult: ").append(this.toIndentedString(this.fraudResult)).append("\n");
        sb.append("    merchantReference: ").append(this.toIndentedString(this.merchantReference)).append("\n");
        sb.append("    order: ").append(this.toIndentedString(this.order)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("    refusalReason: ").append(this.toIndentedString(this.refusalReason)).append("\n");
        sb.append("    refusalReasonCode: ").append(this.toIndentedString(this.refusalReasonCode)).append("\n");
        sb.append("    resultCode: ").append(this.toIndentedString((Object)this.resultCode)).append("\n");
        sb.append("    serviceError: ").append(this.toIndentedString(this.serviceError)).append("\n");
        sb.append("    shopperLocale: ").append(this.toIndentedString(this.shopperLocale)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PaymentVerificationResponse fromJson(String jsonString) throws JsonProcessingException {
        return (PaymentVerificationResponse)JSON.getMapper().readValue(jsonString, PaymentVerificationResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ResultCodeEnum {
        AUTHENTICATIONFINISHED("AuthenticationFinished"),
        AUTHENTICATIONNOTREQUIRED("AuthenticationNotRequired"),
        AUTHORISED("Authorised"),
        CANCELLED("Cancelled"),
        CHALLENGESHOPPER("ChallengeShopper"),
        ERROR("Error"),
        IDENTIFYSHOPPER("IdentifyShopper"),
        PARTIALLYAUTHORISED("PartiallyAuthorised"),
        PENDING("Pending"),
        PRESENTTOSHOPPER("PresentToShopper"),
        RECEIVED("Received"),
        REDIRECTSHOPPER("RedirectShopper"),
        REFUSED("Refused"),
        SUCCESS("Success");

        private String value;

        private ResultCodeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ResultCodeEnum fromValue(String value) {
            for (ResultCodeEnum b : ResultCodeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

