/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.disputes;

import com.adyen.model.disputes.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"defenseDocumentType", "disputePspReference", "merchantAccountCode"})
public class DownloadDefenseDocumentRequest {
    public static final String JSON_PROPERTY_DEFENSE_DOCUMENT_TYPE = "defenseDocumentType";
    private String defenseDocumentType;
    public static final String JSON_PROPERTY_DISPUTE_PSP_REFERENCE = "disputePspReference";
    private String disputePspReference;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT_CODE = "merchantAccountCode";
    private String merchantAccountCode;

    public DownloadDefenseDocumentRequest defenseDocumentType(String defenseDocumentType) {
        this.defenseDocumentType = defenseDocumentType;
        return this;
    }

    @ApiModelProperty(required=true, value="The document type code of the defense document.")
    @JsonProperty(value="defenseDocumentType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDefenseDocumentType() {
        return this.defenseDocumentType;
    }

    @JsonProperty(value="defenseDocumentType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDefenseDocumentType(String defenseDocumentType) {
        this.defenseDocumentType = defenseDocumentType;
    }

    public DownloadDefenseDocumentRequest disputePspReference(String disputePspReference) {
        this.disputePspReference = disputePspReference;
        return this;
    }

    @ApiModelProperty(required=true, value="The PSP reference assigned to the dispute.")
    @JsonProperty(value="disputePspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisputePspReference() {
        return this.disputePspReference;
    }

    @JsonProperty(value="disputePspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisputePspReference(String disputePspReference) {
        this.disputePspReference = disputePspReference;
    }

    public DownloadDefenseDocumentRequest merchantAccountCode(String merchantAccountCode) {
        this.merchantAccountCode = merchantAccountCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The merchant account identifier, for which you want to process the dispute transaction.")
    @JsonProperty(value="merchantAccountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccountCode() {
        return this.merchantAccountCode;
    }

    @JsonProperty(value="merchantAccountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccountCode(String merchantAccountCode) {
        this.merchantAccountCode = merchantAccountCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DownloadDefenseDocumentRequest downloadDefenseDocumentRequest = (DownloadDefenseDocumentRequest)o;
        return Objects.equals(this.defenseDocumentType, downloadDefenseDocumentRequest.defenseDocumentType) && Objects.equals(this.disputePspReference, downloadDefenseDocumentRequest.disputePspReference) && Objects.equals(this.merchantAccountCode, downloadDefenseDocumentRequest.merchantAccountCode);
    }

    public int hashCode() {
        return Objects.hash(this.defenseDocumentType, this.disputePspReference, this.merchantAccountCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DownloadDefenseDocumentRequest {\n");
        sb.append("    defenseDocumentType: ").append(this.toIndentedString(this.defenseDocumentType)).append("\n");
        sb.append("    disputePspReference: ").append(this.toIndentedString(this.disputePspReference)).append("\n");
        sb.append("    merchantAccountCode: ").append(this.toIndentedString(this.merchantAccountCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static DownloadDefenseDocumentRequest fromJson(String jsonString) throws JsonProcessingException {
        return (DownloadDefenseDocumentRequest)JSON.getMapper().readValue(jsonString, DownloadDefenseDocumentRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

