/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.adyen.model.management.TerminalReassignmentTarget;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"companyId", "merchantId", "reassignmentTarget", "status", "storeId"})
public class TerminalAssignment {
    public static final String JSON_PROPERTY_COMPANY_ID = "companyId";
    private String companyId;
    public static final String JSON_PROPERTY_MERCHANT_ID = "merchantId";
    private String merchantId;
    public static final String JSON_PROPERTY_REASSIGNMENT_TARGET = "reassignmentTarget";
    private TerminalReassignmentTarget reassignmentTarget;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_STORE_ID = "storeId";
    private String storeId;

    public TerminalAssignment companyId(String companyId) {
        this.companyId = companyId;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the company account to which terminal is assigned.")
    @JsonProperty(value="companyId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="companyId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public TerminalAssignment merchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the merchant account to which terminal is assigned.")
    @JsonProperty(value="merchantId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantId() {
        return this.merchantId;
    }

    @JsonProperty(value="merchantId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public TerminalAssignment reassignmentTarget(TerminalReassignmentTarget reassignmentTarget) {
        this.reassignmentTarget = reassignmentTarget;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="reassignmentTarget")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TerminalReassignmentTarget getReassignmentTarget() {
        return this.reassignmentTarget;
    }

    @JsonProperty(value="reassignmentTarget")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReassignmentTarget(TerminalReassignmentTarget reassignmentTarget) {
        this.reassignmentTarget = reassignmentTarget;
    }

    public TerminalAssignment status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="The status of the reassignment. Possible values:   * `reassignmentInProgress`: the terminal was boarded and is now scheduled to remove the configuration. Wait for the terminal to synchronize with the Adyen platform.  * `deployed`: the terminal is deployed and reassigned.   * `inventory`: the terminal is in inventory and cannot process transactions.  ")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public TerminalAssignment storeId(String storeId) {
        this.storeId = storeId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the store to which terminal is assigned.")
    @JsonProperty(value="storeId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStoreId() {
        return this.storeId;
    }

    @JsonProperty(value="storeId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TerminalAssignment terminalAssignment = (TerminalAssignment)o;
        return Objects.equals(this.companyId, terminalAssignment.companyId) && Objects.equals(this.merchantId, terminalAssignment.merchantId) && Objects.equals(this.reassignmentTarget, terminalAssignment.reassignmentTarget) && Objects.equals((Object)this.status, (Object)terminalAssignment.status) && Objects.equals(this.storeId, terminalAssignment.storeId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.companyId, this.merchantId, this.reassignmentTarget, this.status, this.storeId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TerminalAssignment {\n");
        sb.append("    companyId: ").append(this.toIndentedString(this.companyId)).append("\n");
        sb.append("    merchantId: ").append(this.toIndentedString(this.merchantId)).append("\n");
        sb.append("    reassignmentTarget: ").append(this.toIndentedString(this.reassignmentTarget)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    storeId: ").append(this.toIndentedString(this.storeId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static TerminalAssignment fromJson(String jsonString) throws JsonProcessingException {
        return (TerminalAssignment)JSON.getMapper().readValue(jsonString, TerminalAssignment.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum StatusEnum {
        REASSIGNMENTINPROGRESS("reassignmentInProgress"),
        DEPLOYED("deployed"),
        INVENTORY("inventory");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

