/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpaywebhooks;

import com.adyen.model.marketpaywebhooks.AccountHolderStatus;
import com.adyen.model.marketpaywebhooks.ErrorFieldType;
import com.adyen.model.marketpaywebhooks.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"accountHolderCode", "invalidFields", "newStatus", "oldStatus", "reason"})
public class AccountHolderStatusChangeNotificationContent {
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER_CODE = "accountHolderCode";
    private String accountHolderCode;
    public static final String JSON_PROPERTY_INVALID_FIELDS = "invalidFields";
    private List<ErrorFieldType> invalidFields = null;
    public static final String JSON_PROPERTY_NEW_STATUS = "newStatus";
    private AccountHolderStatus newStatus;
    public static final String JSON_PROPERTY_OLD_STATUS = "oldStatus";
    private AccountHolderStatus oldStatus;
    public static final String JSON_PROPERTY_REASON = "reason";
    private String reason;

    public AccountHolderStatusChangeNotificationContent accountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The code of the account holder.")
    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountHolderCode() {
        return this.accountHolderCode;
    }

    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
    }

    public AccountHolderStatusChangeNotificationContent invalidFields(List<ErrorFieldType> invalidFields) {
        this.invalidFields = invalidFields;
        return this;
    }

    public AccountHolderStatusChangeNotificationContent addInvalidFieldsItem(ErrorFieldType invalidFieldsItem) {
        if (this.invalidFields == null) {
            this.invalidFields = new ArrayList<ErrorFieldType>();
        }
        this.invalidFields.add(invalidFieldsItem);
        return this;
    }

    @ApiModelProperty(value="in case the account holder has not been updated, contains account holder fields, that did not pass the validation.")
    @JsonProperty(value="invalidFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ErrorFieldType> getInvalidFields() {
        return this.invalidFields;
    }

    @JsonProperty(value="invalidFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInvalidFields(List<ErrorFieldType> invalidFields) {
        this.invalidFields = invalidFields;
    }

    public AccountHolderStatusChangeNotificationContent newStatus(AccountHolderStatus newStatus) {
        this.newStatus = newStatus;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="newStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AccountHolderStatus getNewStatus() {
        return this.newStatus;
    }

    @JsonProperty(value="newStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNewStatus(AccountHolderStatus newStatus) {
        this.newStatus = newStatus;
    }

    public AccountHolderStatusChangeNotificationContent oldStatus(AccountHolderStatus oldStatus) {
        this.oldStatus = oldStatus;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="oldStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AccountHolderStatus getOldStatus() {
        return this.oldStatus;
    }

    @JsonProperty(value="oldStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOldStatus(AccountHolderStatus oldStatus) {
        this.oldStatus = oldStatus;
    }

    public AccountHolderStatusChangeNotificationContent reason(String reason) {
        this.reason = reason;
        return this;
    }

    @ApiModelProperty(value="The reason for the status change.")
    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReason() {
        return this.reason;
    }

    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReason(String reason) {
        this.reason = reason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountHolderStatusChangeNotificationContent accountHolderStatusChangeNotificationContent = (AccountHolderStatusChangeNotificationContent)o;
        return Objects.equals(this.accountHolderCode, accountHolderStatusChangeNotificationContent.accountHolderCode) && Objects.equals(this.invalidFields, accountHolderStatusChangeNotificationContent.invalidFields) && Objects.equals(this.newStatus, accountHolderStatusChangeNotificationContent.newStatus) && Objects.equals(this.oldStatus, accountHolderStatusChangeNotificationContent.oldStatus) && Objects.equals(this.reason, accountHolderStatusChangeNotificationContent.reason);
    }

    public int hashCode() {
        return Objects.hash(this.accountHolderCode, this.invalidFields, this.newStatus, this.oldStatus, this.reason);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountHolderStatusChangeNotificationContent {\n");
        sb.append("    accountHolderCode: ").append(this.toIndentedString(this.accountHolderCode)).append("\n");
        sb.append("    invalidFields: ").append(this.toIndentedString(this.invalidFields)).append("\n");
        sb.append("    newStatus: ").append(this.toIndentedString(this.newStatus)).append("\n");
        sb.append("    oldStatus: ").append(this.toIndentedString(this.oldStatus)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static AccountHolderStatusChangeNotificationContent fromJson(String jsonString) throws JsonProcessingException {
        return (AccountHolderStatusChangeNotificationContent)JSON.getMapper().readValue(jsonString, AccountHolderStatusChangeNotificationContent.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

