/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payout;

import com.adyen.model.payout.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonPropertyOrder(value={"contract", "recurringDetailName", "recurringExpiry", "recurringFrequency", "tokenService"})
public class Recurring {
    public static final String JSON_PROPERTY_CONTRACT = "contract";
    private ContractEnum contract;
    public static final String JSON_PROPERTY_RECURRING_DETAIL_NAME = "recurringDetailName";
    private String recurringDetailName;
    public static final String JSON_PROPERTY_RECURRING_EXPIRY = "recurringExpiry";
    private OffsetDateTime recurringExpiry;
    public static final String JSON_PROPERTY_RECURRING_FREQUENCY = "recurringFrequency";
    private String recurringFrequency;
    public static final String JSON_PROPERTY_TOKEN_SERVICE = "tokenService";
    private TokenServiceEnum tokenService;

    public Recurring contract(ContractEnum contract) {
        this.contract = contract;
        return this;
    }

    @ApiModelProperty(value="The type of recurring contract to be used. Possible values: * `ONECLICK` \u2013 Payment details can be used to initiate a one-click payment, where the shopper enters the [card security code (CVC/CVV)](https://docs.adyen.com/payments-fundamentals/payment-glossary#card-security-code-cvc-cvv-cid). * `RECURRING` \u2013 Payment details can be used without the card security code to initiate [card-not-present transactions](https://docs.adyen.com/payments-fundamentals/payment-glossary#card-not-present-cnp). * `ONECLICK,RECURRING` \u2013 Payment details can be used regardless of whether the shopper is on your site or not. * `PAYOUT` \u2013 Payment details can be used to [make a payout](https://docs.adyen.com/online-payments/online-payouts).")
    @JsonProperty(value="contract")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ContractEnum getContract() {
        return this.contract;
    }

    @JsonProperty(value="contract")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContract(ContractEnum contract) {
        this.contract = contract;
    }

    public Recurring recurringDetailName(String recurringDetailName) {
        this.recurringDetailName = recurringDetailName;
        return this;
    }

    @ApiModelProperty(value="A descriptive name for this detail.")
    @JsonProperty(value="recurringDetailName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRecurringDetailName() {
        return this.recurringDetailName;
    }

    @JsonProperty(value="recurringDetailName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurringDetailName(String recurringDetailName) {
        this.recurringDetailName = recurringDetailName;
    }

    public Recurring recurringExpiry(OffsetDateTime recurringExpiry) {
        this.recurringExpiry = recurringExpiry;
        return this;
    }

    @ApiModelProperty(value="Date after which no further authorisations shall be performed. Only for 3D Secure 2.")
    @JsonProperty(value="recurringExpiry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getRecurringExpiry() {
        return this.recurringExpiry;
    }

    @JsonProperty(value="recurringExpiry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurringExpiry(OffsetDateTime recurringExpiry) {
        this.recurringExpiry = recurringExpiry;
    }

    public Recurring recurringFrequency(String recurringFrequency) {
        this.recurringFrequency = recurringFrequency;
        return this;
    }

    @ApiModelProperty(value="Minimum number of days between authorisations. Only for 3D Secure 2.")
    @JsonProperty(value="recurringFrequency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRecurringFrequency() {
        return this.recurringFrequency;
    }

    @JsonProperty(value="recurringFrequency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurringFrequency(String recurringFrequency) {
        this.recurringFrequency = recurringFrequency;
    }

    public Recurring tokenService(TokenServiceEnum tokenService) {
        this.tokenService = tokenService;
        return this;
    }

    @ApiModelProperty(value="The name of the token service.")
    @JsonProperty(value="tokenService")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TokenServiceEnum getTokenService() {
        return this.tokenService;
    }

    @JsonProperty(value="tokenService")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTokenService(TokenServiceEnum tokenService) {
        this.tokenService = tokenService;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Recurring recurring = (Recurring)o;
        return Objects.equals((Object)this.contract, (Object)recurring.contract) && Objects.equals(this.recurringDetailName, recurring.recurringDetailName) && Objects.equals(this.recurringExpiry, recurring.recurringExpiry) && Objects.equals(this.recurringFrequency, recurring.recurringFrequency) && Objects.equals((Object)this.tokenService, (Object)recurring.tokenService);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.contract, this.recurringDetailName, this.recurringExpiry, this.recurringFrequency, this.tokenService});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Recurring {\n");
        sb.append("    contract: ").append(this.toIndentedString((Object)this.contract)).append("\n");
        sb.append("    recurringDetailName: ").append(this.toIndentedString(this.recurringDetailName)).append("\n");
        sb.append("    recurringExpiry: ").append(this.toIndentedString(this.recurringExpiry)).append("\n");
        sb.append("    recurringFrequency: ").append(this.toIndentedString(this.recurringFrequency)).append("\n");
        sb.append("    tokenService: ").append(this.toIndentedString((Object)this.tokenService)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Recurring fromJson(String jsonString) throws JsonProcessingException {
        return (Recurring)JSON.getMapper().readValue(jsonString, Recurring.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TokenServiceEnum {
        VISATOKENSERVICE("VISATOKENSERVICE"),
        MCTOKENSERVICE("MCTOKENSERVICE");

        private String value;

        private TokenServiceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TokenServiceEnum fromValue(String value) {
            for (TokenServiceEnum b : TokenServiceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ContractEnum {
        ONECLICK("ONECLICK"),
        RECURRING("RECURRING"),
        PAYOUT("PAYOUT");

        private String value;

        private ContractEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ContractEnum fromValue(String value) {
            for (ContractEnum b : ContractEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

