/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.management;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.management.AndroidApp;
import com.adyen.model.management.AndroidAppsResponse;
import com.adyen.model.management.AndroidCertificatesResponse;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class AndroidFilesCompanyLevelApi
extends Service {
    public static final String API_VERSION = "3";
    protected String baseURL;

    public AndroidFilesCompanyLevelApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://management-test.adyen.com/v3");
    }

    public AndroidFilesCompanyLevelApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public AndroidAppsResponse listAndroidApps(String companyId) throws ApiException, IOException {
        return this.listAndroidApps(companyId, null, null, null, null, null);
    }

    public AndroidAppsResponse listAndroidApps(String companyId, Integer pageNumber, Integer pageSize, String packageName, Integer versionCode, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (companyId == null) {
            throw new IllegalArgumentException("Please provide the companyId path parameter");
        }
        pathParams.put("companyId", companyId);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (pageNumber != null) {
            queryParams.put("pageNumber", pageNumber.toString());
        }
        if (pageSize != null) {
            queryParams.put("pageSize", pageSize.toString());
        }
        if (packageName != null) {
            queryParams.put("packageName", packageName);
        }
        if (versionCode != null) {
            queryParams.put("versionCode", versionCode.toString());
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/companies/{companyId}/androidApps", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return AndroidAppsResponse.fromJson(jsonResult);
    }

    public AndroidApp getAndroidApp(String companyId, String id) throws ApiException, IOException {
        return this.getAndroidApp(companyId, id, null);
    }

    public AndroidApp getAndroidApp(String companyId, String id, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (companyId == null) {
            throw new IllegalArgumentException("Please provide the companyId path parameter");
        }
        pathParams.put("companyId", companyId);
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/companies/{companyId}/androidApps/{id}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return AndroidApp.fromJson(jsonResult);
    }

    public AndroidCertificatesResponse listAndroidCertificates(String companyId) throws ApiException, IOException {
        return this.listAndroidCertificates(companyId, null, null, null, null);
    }

    public AndroidCertificatesResponse listAndroidCertificates(String companyId, Integer pageNumber, Integer pageSize, String certificateName, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (companyId == null) {
            throw new IllegalArgumentException("Please provide the companyId path parameter");
        }
        pathParams.put("companyId", companyId);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (pageNumber != null) {
            queryParams.put("pageNumber", pageNumber.toString());
        }
        if (pageSize != null) {
            queryParams.put("pageSize", pageSize.toString());
        }
        if (certificateName != null) {
            queryParams.put("certificateName", certificateName);
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/companies/{companyId}/androidCertificates", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return AndroidCertificatesResponse.fromJson(jsonResult);
    }

    public void uploadAndroidApp(String companyId) throws ApiException, IOException {
        this.uploadAndroidApp(companyId, null);
    }

    public void uploadAndroidApp(String companyId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (companyId == null) {
            throw new IllegalArgumentException("Please provide the companyId path parameter");
        }
        pathParams.put("companyId", companyId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/companies/{companyId}/androidApps", null);
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
    }
}

