/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.legalentitymanagement;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * LegalEntityAssociation
 */
@JsonPropertyOrder({
  LegalEntityAssociation.JSON_PROPERTY_ASSOCIATOR_ID,
  LegalEntityAssociation.JSON_PROPERTY_ENTITY_TYPE,
  LegalEntityAssociation.JSON_PROPERTY_JOB_TITLE,
  LegalEntityAssociation.JSON_PROPERTY_LEGAL_ENTITY_ID,
  LegalEntityAssociation.JSON_PROPERTY_NAME,
  LegalEntityAssociation.JSON_PROPERTY_SETTLOR_EXEMPTION_REASON,
  LegalEntityAssociation.JSON_PROPERTY_TYPE
})

public class LegalEntityAssociation {
  public static final String JSON_PROPERTY_ASSOCIATOR_ID = "associatorId";
  private String associatorId;

  public static final String JSON_PROPERTY_ENTITY_TYPE = "entityType";
  private String entityType;

  public static final String JSON_PROPERTY_JOB_TITLE = "jobTitle";
  private String jobTitle;

  public static final String JSON_PROPERTY_LEGAL_ENTITY_ID = "legalEntityId";
  private String legalEntityId;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_SETTLOR_EXEMPTION_REASON = "settlorExemptionReason";
  private List<String> settlorExemptionReason = null;

  /**
   * Defines the relationship of the legal entity to the current legal entity.  Possible values for organizations: **uboThroughOwnership**, **uboThroughControl**, **director**, **signatory**, or **ultimateParentCompany**.  Possible values for sole proprietorships: **soleProprietorship**.  Possible value for trusts: **trust**  Possible values for trust members: **definedBeneficiary**, **protector**, **secondaryTrustee**, **settlor**, **uboThroughControl**, or **uboThroughOwnership**.
   */
  public enum TypeEnum {
    DEFINEDBENEFICIARY("definedBeneficiary"),
    
    DIRECTOR("director"),
    
    PCISIGNATORY("pciSignatory"),
    
    PROTECTOR("protector"),
    
    SECONDARYTRUSTEE("secondaryTrustee"),
    
    SETTLOR("settlor"),
    
    SIGNATORY("signatory"),
    
    SOLEPROPRIETORSHIP("soleProprietorship"),
    
    TRUST("trust"),
    
    TRUSTOWNERSHIP("trustOwnership"),
    
    UBOTHROUGHCONTROL("uboThroughControl"),
    
    UBOTHROUGHOWNERSHIP("uboThroughOwnership"),
    
    ULTIMATEPARENTCOMPANY("ultimateParentCompany"),
    
    UNDEFINEDBENEFICIARY("undefinedBeneficiary");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public LegalEntityAssociation() { 
  }

  public LegalEntityAssociation associatorId(String associatorId) {
    this.associatorId = associatorId;
    return this;
  }

   /**
   * The unique identifier of another legal entity with which the &#x60;legalEntityId&#x60; is associated. When the &#x60;legalEntityId&#x60; is associated to legal entities other than the current one, the response returns all the associations.
   * @return associatorId
  **/
  @ApiModelProperty(value = "The unique identifier of another legal entity with which the `legalEntityId` is associated. When the `legalEntityId` is associated to legal entities other than the current one, the response returns all the associations.")
  @JsonProperty(JSON_PROPERTY_ASSOCIATOR_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAssociatorId() {
    return associatorId;
  }


  @JsonProperty(JSON_PROPERTY_ASSOCIATOR_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAssociatorId(String associatorId) {
    this.associatorId = associatorId;
  }


  public LegalEntityAssociation entityType(String entityType) {
    this.entityType = entityType;
    return this;
  }

   /**
   * The legal entity type of associated legal entity.  For example, **organization**, **soleProprietorship** or **individual**.
   * @return entityType
  **/
  @ApiModelProperty(value = "The legal entity type of associated legal entity.  For example, **organization**, **soleProprietorship** or **individual**.")
  @JsonProperty(JSON_PROPERTY_ENTITY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getEntityType() {
    return entityType;
  }


  @JsonProperty(JSON_PROPERTY_ENTITY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEntityType(String entityType) {
    this.entityType = entityType;
  }


  public LegalEntityAssociation jobTitle(String jobTitle) {
    this.jobTitle = jobTitle;
    return this;
  }

   /**
   * The individual&#39;s job title if the &#x60;type&#x60; is **uboThroughControl** or **signatory**.
   * @return jobTitle
  **/
  @ApiModelProperty(value = "The individual's job title if the `type` is **uboThroughControl** or **signatory**.")
  @JsonProperty(JSON_PROPERTY_JOB_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getJobTitle() {
    return jobTitle;
  }


  @JsonProperty(JSON_PROPERTY_JOB_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setJobTitle(String jobTitle) {
    this.jobTitle = jobTitle;
  }


  public LegalEntityAssociation legalEntityId(String legalEntityId) {
    this.legalEntityId = legalEntityId;
    return this;
  }

   /**
   * The unique identifier of the associated [legal entity](https://docs.adyen.com/api-explorer/legalentity/latest/post/legalEntities#responses-200-id).
   * @return legalEntityId
  **/
  @ApiModelProperty(required = true, value = "The unique identifier of the associated [legal entity](https://docs.adyen.com/api-explorer/legalentity/latest/post/legalEntities#responses-200-id).")
  @JsonProperty(JSON_PROPERTY_LEGAL_ENTITY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLegalEntityId() {
    return legalEntityId;
  }


  @JsonProperty(JSON_PROPERTY_LEGAL_ENTITY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLegalEntityId(String legalEntityId) {
    this.legalEntityId = legalEntityId;
  }


  public LegalEntityAssociation name(String name) {
    this.name = name;
    return this;
  }

   /**
   * The name of the associated [legal entity](https://docs.adyen.com/api-explorer/legalentity/latest/post/legalEntities#responses-200-id).  - For **individual**, &#x60;name.firstName&#x60; and &#x60;name.lastName&#x60;. - For **organization**, &#x60;legalName&#x60;. - For **soleProprietorship**, &#x60;name&#x60;.
   * @return name
  **/
  @ApiModelProperty(value = "The name of the associated [legal entity](https://docs.adyen.com/api-explorer/legalentity/latest/post/legalEntities#responses-200-id).  - For **individual**, `name.firstName` and `name.lastName`. - For **organization**, `legalName`. - For **soleProprietorship**, `name`.")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public LegalEntityAssociation settlorExemptionReason(List<String> settlorExemptionReason) {
    this.settlorExemptionReason = settlorExemptionReason;
    return this;
  }

  public LegalEntityAssociation addSettlorExemptionReasonItem(String settlorExemptionReasonItem) {
    if (this.settlorExemptionReason == null) {
      this.settlorExemptionReason = new ArrayList<>();
    }
    this.settlorExemptionReason.add(settlorExemptionReasonItem);
    return this;
  }

   /**
   * Defines the Kyc Exemption Reason for a Settlor associated with a trust.  For example, **professionalServiceProvider**, **deceased**, or **contributionBelowThreshold**.
   * @return settlorExemptionReason
  **/
  @ApiModelProperty(value = "Defines the Kyc Exemption Reason for a Settlor associated with a trust.  For example, **professionalServiceProvider**, **deceased**, or **contributionBelowThreshold**.")
  @JsonProperty(JSON_PROPERTY_SETTLOR_EXEMPTION_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getSettlorExemptionReason() {
    return settlorExemptionReason;
  }


  @JsonProperty(JSON_PROPERTY_SETTLOR_EXEMPTION_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSettlorExemptionReason(List<String> settlorExemptionReason) {
    this.settlorExemptionReason = settlorExemptionReason;
  }


  public LegalEntityAssociation type(TypeEnum type) {
    this.type = type;
    return this;
  }

   /**
   * Defines the relationship of the legal entity to the current legal entity.  Possible values for organizations: **uboThroughOwnership**, **uboThroughControl**, **director**, **signatory**, or **ultimateParentCompany**.  Possible values for sole proprietorships: **soleProprietorship**.  Possible value for trusts: **trust**  Possible values for trust members: **definedBeneficiary**, **protector**, **secondaryTrustee**, **settlor**, **uboThroughControl**, or **uboThroughOwnership**.
   * @return type
  **/
  @ApiModelProperty(required = true, value = "Defines the relationship of the legal entity to the current legal entity.  Possible values for organizations: **uboThroughOwnership**, **uboThroughControl**, **director**, **signatory**, or **ultimateParentCompany**.  Possible values for sole proprietorships: **soleProprietorship**.  Possible value for trusts: **trust**  Possible values for trust members: **definedBeneficiary**, **protector**, **secondaryTrustee**, **settlor**, **uboThroughControl**, or **uboThroughOwnership**.")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  /**
   * Return true if this LegalEntityAssociation object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LegalEntityAssociation legalEntityAssociation = (LegalEntityAssociation) o;
    return Objects.equals(this.associatorId, legalEntityAssociation.associatorId) &&
        Objects.equals(this.entityType, legalEntityAssociation.entityType) &&
        Objects.equals(this.jobTitle, legalEntityAssociation.jobTitle) &&
        Objects.equals(this.legalEntityId, legalEntityAssociation.legalEntityId) &&
        Objects.equals(this.name, legalEntityAssociation.name) &&
        Objects.equals(this.settlorExemptionReason, legalEntityAssociation.settlorExemptionReason) &&
        Objects.equals(this.type, legalEntityAssociation.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(associatorId, entityType, jobTitle, legalEntityId, name, settlorExemptionReason, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LegalEntityAssociation {\n");
    sb.append("    associatorId: ").append(toIndentedString(associatorId)).append("\n");
    sb.append("    entityType: ").append(toIndentedString(entityType)).append("\n");
    sb.append("    jobTitle: ").append(toIndentedString(jobTitle)).append("\n");
    sb.append("    legalEntityId: ").append(toIndentedString(legalEntityId)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    settlorExemptionReason: ").append(toIndentedString(settlorExemptionReason)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of LegalEntityAssociation given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of LegalEntityAssociation
   * @throws JsonProcessingException if the JSON string is invalid with respect to LegalEntityAssociation
   */
  public static LegalEntityAssociation fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, LegalEntityAssociation.class);
  }
/**
  * Convert an instance of LegalEntityAssociation to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

