/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.management;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.management.Currency;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * ModelConfiguration
 */
@JsonPropertyOrder({
  ModelConfiguration.JSON_PROPERTY_BRAND,
  ModelConfiguration.JSON_PROPERTY_CURRENCIES,
  ModelConfiguration.JSON_PROPERTY_SOURCES
})
@JsonTypeName("Configuration")

public class ModelConfiguration {
  public static final String JSON_PROPERTY_BRAND = "brand";
  private String brand;

  public static final String JSON_PROPERTY_CURRENCIES = "currencies";
  private List<Currency> currencies = new ArrayList<>();

  public static final String JSON_PROPERTY_SOURCES = "sources";
  private List<String> sources = null;

  public ModelConfiguration() { 
  }

  public ModelConfiguration brand(String brand) {
    this.brand = brand;
    return this;
  }

   /**
   * Payment method, like **eftpos_australia** or **mc**. See the [possible values](https://docs.adyen.com/development-resources/paymentmethodvariant#management-api). 
   * @return brand
  **/
  @ApiModelProperty(required = true, value = "Payment method, like **eftpos_australia** or **mc**. See the [possible values](https://docs.adyen.com/development-resources/paymentmethodvariant#management-api). ")
  @JsonProperty(JSON_PROPERTY_BRAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBrand() {
    return brand;
  }


  @JsonProperty(JSON_PROPERTY_BRAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBrand(String brand) {
    this.brand = brand;
  }


  public ModelConfiguration currencies(List<Currency> currencies) {
    this.currencies = currencies;
    return this;
  }

  public ModelConfiguration addCurrenciesItem(Currency currenciesItem) {
    this.currencies.add(currenciesItem);
    return this;
  }

   /**
   * Currency, and surcharge percentage or amount.
   * @return currencies
  **/
  @ApiModelProperty(required = true, value = "Currency, and surcharge percentage or amount.")
  @JsonProperty(JSON_PROPERTY_CURRENCIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Currency> getCurrencies() {
    return currencies;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrencies(List<Currency> currencies) {
    this.currencies = currencies;
  }


  public ModelConfiguration sources(List<String> sources) {
    this.sources = sources;
    return this;
  }

  public ModelConfiguration addSourcesItem(String sourcesItem) {
    if (this.sources == null) {
      this.sources = new ArrayList<>();
    }
    this.sources.add(sourcesItem);
    return this;
  }

   /**
   * Funding source. Possible values: * **Credit** * **Debit**
   * @return sources
  **/
  @ApiModelProperty(value = "Funding source. Possible values: * **Credit** * **Debit**")
  @JsonProperty(JSON_PROPERTY_SOURCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getSources() {
    return sources;
  }


  @JsonProperty(JSON_PROPERTY_SOURCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSources(List<String> sources) {
    this.sources = sources;
  }


  /**
   * Return true if this Configuration object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ModelConfiguration configuration = (ModelConfiguration) o;
    return Objects.equals(this.brand, configuration.brand) &&
        Objects.equals(this.currencies, configuration.currencies) &&
        Objects.equals(this.sources, configuration.sources);
  }

  @Override
  public int hashCode() {
    return Objects.hash(brand, currencies, sources);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ModelConfiguration {\n");
    sb.append("    brand: ").append(toIndentedString(brand)).append("\n");
    sb.append("    currencies: ").append(toIndentedString(currencies)).append("\n");
    sb.append("    sources: ").append(toIndentedString(sources)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of ModelConfiguration given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of ModelConfiguration
   * @throws JsonProcessingException if the JSON string is invalid with respect to ModelConfiguration
   */
  public static ModelConfiguration fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, ModelConfiguration.class);
  }
/**
  * Convert an instance of ModelConfiguration to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

