/*
 * Account API
 * This API is used for the classic integration. If you are just starting your implementation, refer to our [new integration guide](https://docs.adyen.com/marketplaces-and-platforms) instead.  The Account API provides endpoints for managing account-related entities on your platform. These related entities include account holders, accounts, bank accounts, shareholders, and verification-related documents. The management operations include actions such as creation, retrieval, updating, and deletion of them.  For more information, refer to our [documentation](https://docs.adyen.com/marketplaces-and-platforms/classic). ## Authentication Your Adyen contact will provide your API credential and an API key. To connect to the API, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication. For example:  ``` curl -U \"ws@MarketPlace.YOUR_PLATFORM_ACCOUNT\":\"YOUR_WS_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ``` When going live, you need to generate new web service user credentials to access the [live endpoints](https://docs.adyen.com/development-resources/live-endpoints).  ## Versioning The Account API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://cal-test.adyen.com/cal/services/Account/v6/createAccountHolder ```
 *
 * The version of the OpenAPI document: 6
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.marketpayaccount;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.marketpayaccount.DocumentDetail;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * UploadDocumentRequest
 */
@JsonPropertyOrder({
  UploadDocumentRequest.JSON_PROPERTY_DOCUMENT_CONTENT,
  UploadDocumentRequest.JSON_PROPERTY_DOCUMENT_DETAIL
})

public class UploadDocumentRequest {
  public static final String JSON_PROPERTY_DOCUMENT_CONTENT = "documentContent";
  private byte[] documentContent;

  public static final String JSON_PROPERTY_DOCUMENT_DETAIL = "documentDetail";
  private DocumentDetail documentDetail;

  public UploadDocumentRequest() { 
  }

  public UploadDocumentRequest documentContent(byte[] documentContent) {
    this.documentContent = documentContent;
    return this;
  }

   /**
   * The content of the document, in Base64-encoded string format.  To learn about document requirements, refer to [Verification checks](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-checks).
   * @return documentContent
  **/
  @ApiModelProperty(required = true, value = "The content of the document, in Base64-encoded string format.  To learn about document requirements, refer to [Verification checks](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-checks).")
  @JsonProperty(JSON_PROPERTY_DOCUMENT_CONTENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public byte[] getDocumentContent() {
    return documentContent;
  }


  @JsonProperty(JSON_PROPERTY_DOCUMENT_CONTENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDocumentContent(byte[] documentContent) {
    this.documentContent = documentContent;
  }


  public UploadDocumentRequest documentDetail(DocumentDetail documentDetail) {
    this.documentDetail = documentDetail;
    return this;
  }

   /**
   * Get documentDetail
   * @return documentDetail
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_DOCUMENT_DETAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DocumentDetail getDocumentDetail() {
    return documentDetail;
  }


  @JsonProperty(JSON_PROPERTY_DOCUMENT_DETAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDocumentDetail(DocumentDetail documentDetail) {
    this.documentDetail = documentDetail;
  }


  /**
   * Return true if this UploadDocumentRequest object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UploadDocumentRequest uploadDocumentRequest = (UploadDocumentRequest) o;
    return Arrays.equals(this.documentContent, uploadDocumentRequest.documentContent) &&
        Objects.equals(this.documentDetail, uploadDocumentRequest.documentDetail);
  }

  @Override
  public int hashCode() {
    return Objects.hash(Arrays.hashCode(documentContent), documentDetail);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UploadDocumentRequest {\n");
    sb.append("    documentContent: ").append(toIndentedString(documentContent)).append("\n");
    sb.append("    documentDetail: ").append(toIndentedString(documentDetail)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of UploadDocumentRequest given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of UploadDocumentRequest
   * @throws JsonProcessingException if the JSON string is invalid with respect to UploadDocumentRequest
   */
  public static UploadDocumentRequest fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, UploadDocumentRequest.class);
  }
/**
  * Convert an instance of UploadDocumentRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

