/*
 * Transfers API
 *
 * The version of the OpenAPI document: 4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.transfers;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.transfers.Amount;
import com.adyen.model.transfers.CapitalBalance;
import com.adyen.model.transfers.Counterparty;
import com.adyen.model.transfers.Fee;
import com.adyen.model.transfers.Repayment;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * CapitalGrant
 */
@JsonPropertyOrder({
  CapitalGrant.JSON_PROPERTY_AMOUNT,
  CapitalGrant.JSON_PROPERTY_BALANCES,
  CapitalGrant.JSON_PROPERTY_COUNTERPARTY,
  CapitalGrant.JSON_PROPERTY_FEE,
  CapitalGrant.JSON_PROPERTY_GRANT_ACCOUNT_ID,
  CapitalGrant.JSON_PROPERTY_GRANT_OFFER_ID,
  CapitalGrant.JSON_PROPERTY_ID,
  CapitalGrant.JSON_PROPERTY_REPAYMENT,
  CapitalGrant.JSON_PROPERTY_STATUS
})

public class CapitalGrant {
  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private Amount amount;

  public static final String JSON_PROPERTY_BALANCES = "balances";
  private CapitalBalance balances;

  public static final String JSON_PROPERTY_COUNTERPARTY = "counterparty";
  private Counterparty counterparty;

  public static final String JSON_PROPERTY_FEE = "fee";
  private Fee fee;

  public static final String JSON_PROPERTY_GRANT_ACCOUNT_ID = "grantAccountId";
  private String grantAccountId;

  public static final String JSON_PROPERTY_GRANT_OFFER_ID = "grantOfferId";
  private String grantOfferId;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_REPAYMENT = "repayment";
  private Repayment repayment;

  /**
   * The current status of the grant. Possible values: **Pending**, **Active**, **Repaid**.
   */
  public enum StatusEnum {
    PENDING("Pending"),
    
    ACTIVE("Active"),
    
    REPAID("Repaid");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  public CapitalGrant() { 
  }

  public CapitalGrant amount(Amount amount) {
    this.amount = amount;
    return this;
  }

   /**
   * Get amount
   * @return amount
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Amount getAmount() {
    return amount;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmount(Amount amount) {
    this.amount = amount;
  }


  public CapitalGrant balances(CapitalBalance balances) {
    this.balances = balances;
    return this;
  }

   /**
   * Get balances
   * @return balances
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_BALANCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CapitalBalance getBalances() {
    return balances;
  }


  @JsonProperty(JSON_PROPERTY_BALANCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBalances(CapitalBalance balances) {
    this.balances = balances;
  }


  public CapitalGrant counterparty(Counterparty counterparty) {
    this.counterparty = counterparty;
    return this;
  }

   /**
   * Get counterparty
   * @return counterparty
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_COUNTERPARTY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Counterparty getCounterparty() {
    return counterparty;
  }


  @JsonProperty(JSON_PROPERTY_COUNTERPARTY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCounterparty(Counterparty counterparty) {
    this.counterparty = counterparty;
  }


  public CapitalGrant fee(Fee fee) {
    this.fee = fee;
    return this;
  }

   /**
   * Get fee
   * @return fee
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Fee getFee() {
    return fee;
  }


  @JsonProperty(JSON_PROPERTY_FEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFee(Fee fee) {
    this.fee = fee;
  }


  public CapitalGrant grantAccountId(String grantAccountId) {
    this.grantAccountId = grantAccountId;
    return this;
  }

   /**
   * The identifier of the grant account used for the grant.
   * @return grantAccountId
  **/
  @ApiModelProperty(required = true, value = "The identifier of the grant account used for the grant.")
  @JsonProperty(JSON_PROPERTY_GRANT_ACCOUNT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getGrantAccountId() {
    return grantAccountId;
  }


  @JsonProperty(JSON_PROPERTY_GRANT_ACCOUNT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGrantAccountId(String grantAccountId) {
    this.grantAccountId = grantAccountId;
  }


  public CapitalGrant grantOfferId(String grantOfferId) {
    this.grantOfferId = grantOfferId;
    return this;
  }

   /**
   * The identifier of the grant offer that has been selected and from which the grant details will be used.
   * @return grantOfferId
  **/
  @ApiModelProperty(required = true, value = "The identifier of the grant offer that has been selected and from which the grant details will be used.")
  @JsonProperty(JSON_PROPERTY_GRANT_OFFER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getGrantOfferId() {
    return grantOfferId;
  }


  @JsonProperty(JSON_PROPERTY_GRANT_OFFER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGrantOfferId(String grantOfferId) {
    this.grantOfferId = grantOfferId;
  }


  public CapitalGrant id(String id) {
    this.id = id;
    return this;
  }

   /**
   * The identifier of the grant reference.
   * @return id
  **/
  @ApiModelProperty(required = true, value = "The identifier of the grant reference.")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public CapitalGrant repayment(Repayment repayment) {
    this.repayment = repayment;
    return this;
  }

   /**
   * Get repayment
   * @return repayment
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_REPAYMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Repayment getRepayment() {
    return repayment;
  }


  @JsonProperty(JSON_PROPERTY_REPAYMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRepayment(Repayment repayment) {
    this.repayment = repayment;
  }


  public CapitalGrant status(StatusEnum status) {
    this.status = status;
    return this;
  }

   /**
   * The current status of the grant. Possible values: **Pending**, **Active**, **Repaid**.
   * @return status
  **/
  @ApiModelProperty(required = true, value = "The current status of the grant. Possible values: **Pending**, **Active**, **Repaid**.")
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StatusEnum getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  /**
   * Return true if this CapitalGrant object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CapitalGrant capitalGrant = (CapitalGrant) o;
    return Objects.equals(this.amount, capitalGrant.amount) &&
        Objects.equals(this.balances, capitalGrant.balances) &&
        Objects.equals(this.counterparty, capitalGrant.counterparty) &&
        Objects.equals(this.fee, capitalGrant.fee) &&
        Objects.equals(this.grantAccountId, capitalGrant.grantAccountId) &&
        Objects.equals(this.grantOfferId, capitalGrant.grantOfferId) &&
        Objects.equals(this.id, capitalGrant.id) &&
        Objects.equals(this.repayment, capitalGrant.repayment) &&
        Objects.equals(this.status, capitalGrant.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(amount, balances, counterparty, fee, grantAccountId, grantOfferId, id, repayment, status);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CapitalGrant {\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    balances: ").append(toIndentedString(balances)).append("\n");
    sb.append("    counterparty: ").append(toIndentedString(counterparty)).append("\n");
    sb.append("    fee: ").append(toIndentedString(fee)).append("\n");
    sb.append("    grantAccountId: ").append(toIndentedString(grantAccountId)).append("\n");
    sb.append("    grantOfferId: ").append(toIndentedString(grantOfferId)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    repayment: ").append(toIndentedString(repayment)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of CapitalGrant given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of CapitalGrant
   * @throws JsonProcessingException if the JSON string is invalid with respect to CapitalGrant
   */
  public static CapitalGrant fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, CapitalGrant.class);
  }
/**
  * Convert an instance of CapitalGrant to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

