/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.checkout;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * AdditionalDataRetry
 */
@JsonPropertyOrder({
  AdditionalDataRetry.JSON_PROPERTY_RETRY_CHAIN_ATTEMPT_NUMBER,
  AdditionalDataRetry.JSON_PROPERTY_RETRY_ORDER_ATTEMPT_NUMBER,
  AdditionalDataRetry.JSON_PROPERTY_RETRY_SKIP_RETRY
})

public class AdditionalDataRetry {
  public static final String JSON_PROPERTY_RETRY_CHAIN_ATTEMPT_NUMBER = "retry.chainAttemptNumber";
  private String retryChainAttemptNumber;

  public static final String JSON_PROPERTY_RETRY_ORDER_ATTEMPT_NUMBER = "retry.orderAttemptNumber";
  private String retryOrderAttemptNumber;

  public static final String JSON_PROPERTY_RETRY_SKIP_RETRY = "retry.skipRetry";
  private String retrySkipRetry;

  public AdditionalDataRetry() { 
  }

  public AdditionalDataRetry retryChainAttemptNumber(String retryChainAttemptNumber) {
    this.retryChainAttemptNumber = retryChainAttemptNumber;
    return this;
  }

   /**
   * The number of times the transaction (not order) has been retried between different payment service providers. For instance, the &#x60;chainAttemptNumber&#x60; set to 2 means that this transaction has been recently tried on another provider before being sent to Adyen.  &gt; If you submit &#x60;retry.chainAttemptNumber&#x60;, &#x60;retry.orderAttemptNumber&#x60;, and &#x60;retry.skipRetry&#x60; values, we also recommend you provide the &#x60;merchantOrderReference&#x60; to facilitate linking payment attempts together.
   * @return retryChainAttemptNumber
  **/
  @ApiModelProperty(value = "The number of times the transaction (not order) has been retried between different payment service providers. For instance, the `chainAttemptNumber` set to 2 means that this transaction has been recently tried on another provider before being sent to Adyen.  > If you submit `retry.chainAttemptNumber`, `retry.orderAttemptNumber`, and `retry.skipRetry` values, we also recommend you provide the `merchantOrderReference` to facilitate linking payment attempts together.")
  @JsonProperty(JSON_PROPERTY_RETRY_CHAIN_ATTEMPT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRetryChainAttemptNumber() {
    return retryChainAttemptNumber;
  }


  @JsonProperty(JSON_PROPERTY_RETRY_CHAIN_ATTEMPT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRetryChainAttemptNumber(String retryChainAttemptNumber) {
    this.retryChainAttemptNumber = retryChainAttemptNumber;
  }


  public AdditionalDataRetry retryOrderAttemptNumber(String retryOrderAttemptNumber) {
    this.retryOrderAttemptNumber = retryOrderAttemptNumber;
    return this;
  }

   /**
   * The index of the attempt to bill a particular order, which is identified by the &#x60;merchantOrderReference&#x60; field. For example, if a recurring transaction fails and is retried one day later, then the order number for these attempts would be 1 and 2, respectively.  &gt; If you submit &#x60;retry.chainAttemptNumber&#x60;, &#x60;retry.orderAttemptNumber&#x60;, and &#x60;retry.skipRetry&#x60; values, we also recommend you provide the &#x60;merchantOrderReference&#x60; to facilitate linking payment attempts together.
   * @return retryOrderAttemptNumber
  **/
  @ApiModelProperty(value = "The index of the attempt to bill a particular order, which is identified by the `merchantOrderReference` field. For example, if a recurring transaction fails and is retried one day later, then the order number for these attempts would be 1 and 2, respectively.  > If you submit `retry.chainAttemptNumber`, `retry.orderAttemptNumber`, and `retry.skipRetry` values, we also recommend you provide the `merchantOrderReference` to facilitate linking payment attempts together.")
  @JsonProperty(JSON_PROPERTY_RETRY_ORDER_ATTEMPT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRetryOrderAttemptNumber() {
    return retryOrderAttemptNumber;
  }


  @JsonProperty(JSON_PROPERTY_RETRY_ORDER_ATTEMPT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRetryOrderAttemptNumber(String retryOrderAttemptNumber) {
    this.retryOrderAttemptNumber = retryOrderAttemptNumber;
  }


  public AdditionalDataRetry retrySkipRetry(String retrySkipRetry) {
    this.retrySkipRetry = retrySkipRetry;
    return this;
  }

   /**
   * The Boolean value indicating whether Adyen should skip or retry this transaction, if possible.  &gt; If you submit &#x60;retry.chainAttemptNumber&#x60;, &#x60;retry.orderAttemptNumber&#x60;, and &#x60;retry.skipRetry&#x60; values, we also recommend you provide the &#x60;merchantOrderReference&#x60; to facilitate linking payment attempts together.
   * @return retrySkipRetry
  **/
  @ApiModelProperty(value = "The Boolean value indicating whether Adyen should skip or retry this transaction, if possible.  > If you submit `retry.chainAttemptNumber`, `retry.orderAttemptNumber`, and `retry.skipRetry` values, we also recommend you provide the `merchantOrderReference` to facilitate linking payment attempts together.")
  @JsonProperty(JSON_PROPERTY_RETRY_SKIP_RETRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRetrySkipRetry() {
    return retrySkipRetry;
  }


  @JsonProperty(JSON_PROPERTY_RETRY_SKIP_RETRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRetrySkipRetry(String retrySkipRetry) {
    this.retrySkipRetry = retrySkipRetry;
  }


  /**
   * Return true if this AdditionalDataRetry object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AdditionalDataRetry additionalDataRetry = (AdditionalDataRetry) o;
    return Objects.equals(this.retryChainAttemptNumber, additionalDataRetry.retryChainAttemptNumber) &&
        Objects.equals(this.retryOrderAttemptNumber, additionalDataRetry.retryOrderAttemptNumber) &&
        Objects.equals(this.retrySkipRetry, additionalDataRetry.retrySkipRetry);
  }

  @Override
  public int hashCode() {
    return Objects.hash(retryChainAttemptNumber, retryOrderAttemptNumber, retrySkipRetry);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AdditionalDataRetry {\n");
    sb.append("    retryChainAttemptNumber: ").append(toIndentedString(retryChainAttemptNumber)).append("\n");
    sb.append("    retryOrderAttemptNumber: ").append(toIndentedString(retryOrderAttemptNumber)).append("\n");
    sb.append("    retrySkipRetry: ").append(toIndentedString(retrySkipRetry)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of AdditionalDataRetry given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of AdditionalDataRetry
   * @throws JsonProcessingException if the JSON string is invalid with respect to AdditionalDataRetry
   */
  public static AdditionalDataRetry fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, AdditionalDataRetry.class);
  }
/**
  * Convert an instance of AdditionalDataRetry to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

