/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.checkout;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.checkout.InputDetail;
import com.adyen.model.checkout.PaymentMethodGroup;
import com.adyen.model.checkout.PaymentMethodIssuer;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * PaymentMethod
 */
@JsonPropertyOrder({
  PaymentMethod.JSON_PROPERTY_BRAND,
  PaymentMethod.JSON_PROPERTY_BRANDS,
  PaymentMethod.JSON_PROPERTY_CONFIGURATION,
  PaymentMethod.JSON_PROPERTY_FUNDING_SOURCE,
  PaymentMethod.JSON_PROPERTY_GROUP,
  PaymentMethod.JSON_PROPERTY_INPUT_DETAILS,
  PaymentMethod.JSON_PROPERTY_ISSUERS,
  PaymentMethod.JSON_PROPERTY_NAME,
  PaymentMethod.JSON_PROPERTY_TYPE
})

public class PaymentMethod {
  public static final String JSON_PROPERTY_BRAND = "brand";
  private String brand;

  public static final String JSON_PROPERTY_BRANDS = "brands";
  private List<String> brands = null;

  public static final String JSON_PROPERTY_CONFIGURATION = "configuration";
  private Map<String, String> configuration = null;

  /**
   * The funding source of the payment method.
   */
  public enum FundingSourceEnum {
    CREDIT("credit"),
    
    DEBIT("debit");

    private String value;

    FundingSourceEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static FundingSourceEnum fromValue(String value) {
      for (FundingSourceEnum b : FundingSourceEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_FUNDING_SOURCE = "fundingSource";
  private FundingSourceEnum fundingSource;

  public static final String JSON_PROPERTY_GROUP = "group";
  private PaymentMethodGroup group;

  public static final String JSON_PROPERTY_INPUT_DETAILS = "inputDetails";
  private List<InputDetail> inputDetails = null;

  public static final String JSON_PROPERTY_ISSUERS = "issuers";
  private List<PaymentMethodIssuer> issuers = null;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_TYPE = "type";
  private String type;

  public PaymentMethod() { 
  }

  public PaymentMethod brand(String brand) {
    this.brand = brand;
    return this;
  }

   /**
   * Brand for the selected gift card. For example: plastix, hmclub.
   * @return brand
  **/
  @ApiModelProperty(value = "Brand for the selected gift card. For example: plastix, hmclub.")
  @JsonProperty(JSON_PROPERTY_BRAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBrand() {
    return brand;
  }


  @JsonProperty(JSON_PROPERTY_BRAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBrand(String brand) {
    this.brand = brand;
  }


  public PaymentMethod brands(List<String> brands) {
    this.brands = brands;
    return this;
  }

  public PaymentMethod addBrandsItem(String brandsItem) {
    if (this.brands == null) {
      this.brands = new ArrayList<>();
    }
    this.brands.add(brandsItem);
    return this;
  }

   /**
   * List of possible brands. For example: visa, mc.
   * @return brands
  **/
  @ApiModelProperty(value = "List of possible brands. For example: visa, mc.")
  @JsonProperty(JSON_PROPERTY_BRANDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getBrands() {
    return brands;
  }


  @JsonProperty(JSON_PROPERTY_BRANDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBrands(List<String> brands) {
    this.brands = brands;
  }


  public PaymentMethod configuration(Map<String, String> configuration) {
    this.configuration = configuration;
    return this;
  }

  public PaymentMethod putConfigurationItem(String key, String configurationItem) {
    if (this.configuration == null) {
      this.configuration = new HashMap<>();
    }
    this.configuration.put(key, configurationItem);
    return this;
  }

   /**
   * The configuration of the payment method.
   * @return configuration
  **/
  @ApiModelProperty(value = "The configuration of the payment method.")
  @JsonProperty(JSON_PROPERTY_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, String> getConfiguration() {
    return configuration;
  }


  @JsonProperty(JSON_PROPERTY_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setConfiguration(Map<String, String> configuration) {
    this.configuration = configuration;
  }


  public PaymentMethod fundingSource(FundingSourceEnum fundingSource) {
    this.fundingSource = fundingSource;
    return this;
  }

   /**
   * The funding source of the payment method.
   * @return fundingSource
  **/
  @ApiModelProperty(value = "The funding source of the payment method.")
  @JsonProperty(JSON_PROPERTY_FUNDING_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public FundingSourceEnum getFundingSource() {
    return fundingSource;
  }


  @JsonProperty(JSON_PROPERTY_FUNDING_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFundingSource(FundingSourceEnum fundingSource) {
    this.fundingSource = fundingSource;
  }


  public PaymentMethod group(PaymentMethodGroup group) {
    this.group = group;
    return this;
  }

   /**
   * Get group
   * @return group
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_GROUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PaymentMethodGroup getGroup() {
    return group;
  }


  @JsonProperty(JSON_PROPERTY_GROUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroup(PaymentMethodGroup group) {
    this.group = group;
  }


  public PaymentMethod inputDetails(List<InputDetail> inputDetails) {
    this.inputDetails = inputDetails;
    return this;
  }

  public PaymentMethod addInputDetailsItem(InputDetail inputDetailsItem) {
    if (this.inputDetails == null) {
      this.inputDetails = new ArrayList<>();
    }
    this.inputDetails.add(inputDetailsItem);
    return this;
  }

   /**
   * All input details to be provided to complete the payment with this payment method.
   * @return inputDetails
   * @deprecated
  **/
  @Deprecated
  @ApiModelProperty(value = "All input details to be provided to complete the payment with this payment method.")
  @JsonProperty(JSON_PROPERTY_INPUT_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<InputDetail> getInputDetails() {
    return inputDetails;
  }


  @Deprecated
  @JsonProperty(JSON_PROPERTY_INPUT_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInputDetails(List<InputDetail> inputDetails) {
    this.inputDetails = inputDetails;
  }


  public PaymentMethod issuers(List<PaymentMethodIssuer> issuers) {
    this.issuers = issuers;
    return this;
  }

  public PaymentMethod addIssuersItem(PaymentMethodIssuer issuersItem) {
    if (this.issuers == null) {
      this.issuers = new ArrayList<>();
    }
    this.issuers.add(issuersItem);
    return this;
  }

   /**
   * A list of issuers for this payment method.
   * @return issuers
  **/
  @ApiModelProperty(value = "A list of issuers for this payment method.")
  @JsonProperty(JSON_PROPERTY_ISSUERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<PaymentMethodIssuer> getIssuers() {
    return issuers;
  }


  @JsonProperty(JSON_PROPERTY_ISSUERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIssuers(List<PaymentMethodIssuer> issuers) {
    this.issuers = issuers;
  }


  public PaymentMethod name(String name) {
    this.name = name;
    return this;
  }

   /**
   * The displayable name of this payment method.
   * @return name
  **/
  @ApiModelProperty(value = "The displayable name of this payment method.")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public PaymentMethod type(String type) {
    this.type = type;
    return this;
  }

   /**
   * The unique payment method code.
   * @return type
  **/
  @ApiModelProperty(value = "The unique payment method code.")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(String type) {
    this.type = type;
  }


  /**
   * Return true if this PaymentMethod object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentMethod paymentMethod = (PaymentMethod) o;
    return Objects.equals(this.brand, paymentMethod.brand) &&
        Objects.equals(this.brands, paymentMethod.brands) &&
        Objects.equals(this.configuration, paymentMethod.configuration) &&
        Objects.equals(this.fundingSource, paymentMethod.fundingSource) &&
        Objects.equals(this.group, paymentMethod.group) &&
        Objects.equals(this.inputDetails, paymentMethod.inputDetails) &&
        Objects.equals(this.issuers, paymentMethod.issuers) &&
        Objects.equals(this.name, paymentMethod.name) &&
        Objects.equals(this.type, paymentMethod.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(brand, brands, configuration, fundingSource, group, inputDetails, issuers, name, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentMethod {\n");
    sb.append("    brand: ").append(toIndentedString(brand)).append("\n");
    sb.append("    brands: ").append(toIndentedString(brands)).append("\n");
    sb.append("    configuration: ").append(toIndentedString(configuration)).append("\n");
    sb.append("    fundingSource: ").append(toIndentedString(fundingSource)).append("\n");
    sb.append("    group: ").append(toIndentedString(group)).append("\n");
    sb.append("    inputDetails: ").append(toIndentedString(inputDetails)).append("\n");
    sb.append("    issuers: ").append(toIndentedString(issuers)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of PaymentMethod given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of PaymentMethod
   * @throws JsonProcessingException if the JSON string is invalid with respect to PaymentMethod
   */
  public static PaymentMethod fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, PaymentMethod.class);
  }
/**
  * Convert an instance of PaymentMethod to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

