/*
 * Adyen Recurring API
 * The Recurring APIs allow you to manage and remove your tokens or saved payment details. Tokens should be created with validation during a payment request.  For more information, refer to our [Tokenization documentation](https://docs.adyen.com/online-payments/tokenization). ## Authentication You need an [API credential](https://docs.adyen.com/development-resources/api-credentials) to authenticate to the API.  If using an API key, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication, for example:  ``` curl -U \"ws@Company.YOUR_COMPANY_ACCOUNT\":\"YOUR_BASIC_AUTHENTICATION_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ```  ## Versioning Recurring API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://pal-test.adyen.com/pal/servlet/Recurring/v68/disable ```  ## Going live  To authenticate to the live endpoints, you need an [API credential](https://docs.adyen.com/development-resources/api-credentials) from your live Customer Area.  The live endpoint URLs contain a prefix which is unique to your company account: ```  https://{PREFIX}-pal-live.adyenpayments.com/pal/servlet/Recurring/v68/disable ```  Get your `{PREFIX}` from your live Customer Area under **Developers** > **API URLs** > **Prefix**.
 *
 * The version of the OpenAPI document: 68
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.recurring;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * TokenDetails
 */
@JsonPropertyOrder({
  TokenDetails.JSON_PROPERTY_TOKEN_DATA,
  TokenDetails.JSON_PROPERTY_TOKEN_DATA_TYPE
})

public class TokenDetails {
  public static final String JSON_PROPERTY_TOKEN_DATA = "tokenData";
  private Map<String, String> tokenData = null;

  public static final String JSON_PROPERTY_TOKEN_DATA_TYPE = "tokenDataType";
  private String tokenDataType;

  public TokenDetails() { 
  }

  public TokenDetails tokenData(Map<String, String> tokenData) {
    this.tokenData = tokenData;
    return this;
  }

  public TokenDetails putTokenDataItem(String key, String tokenDataItem) {
    if (this.tokenData == null) {
      this.tokenData = new HashMap<>();
    }
    this.tokenData.put(key, tokenDataItem);
    return this;
  }

   /**
   * Get tokenData
   * @return tokenData
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOKEN_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, String> getTokenData() {
    return tokenData;
  }


  @JsonProperty(JSON_PROPERTY_TOKEN_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTokenData(Map<String, String> tokenData) {
    this.tokenData = tokenData;
  }


  public TokenDetails tokenDataType(String tokenDataType) {
    this.tokenDataType = tokenDataType;
    return this;
  }

   /**
   * Get tokenDataType
   * @return tokenDataType
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOKEN_DATA_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTokenDataType() {
    return tokenDataType;
  }


  @JsonProperty(JSON_PROPERTY_TOKEN_DATA_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTokenDataType(String tokenDataType) {
    this.tokenDataType = tokenDataType;
  }


  /**
   * Return true if this TokenDetails object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TokenDetails tokenDetails = (TokenDetails) o;
    return Objects.equals(this.tokenData, tokenDetails.tokenData) &&
        Objects.equals(this.tokenDataType, tokenDetails.tokenDataType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tokenData, tokenDataType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TokenDetails {\n");
    sb.append("    tokenData: ").append(toIndentedString(tokenData)).append("\n");
    sb.append("    tokenDataType: ").append(toIndentedString(tokenDataType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of TokenDetails given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of TokenDetails
   * @throws JsonProcessingException if the JSON string is invalid with respect to TokenDetails
   */
  public static TokenDetails fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, TokenDetails.class);
  }
/**
  * Convert an instance of TokenDetails to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

