/*
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.service.balanceplatform;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.balanceplatform.RestServiceError;
import com.adyen.model.balanceplatform.TransactionRule;
import com.adyen.model.balanceplatform.TransactionRuleInfo;
import com.adyen.model.balanceplatform.TransactionRuleResponse;
import com.adyen.model.RequestOptions;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class TransactionRulesApi extends Service {

    public static final String API_VERSION = "2";

    protected String baseURL;

    /**
    * Transaction rules constructor in {@link com.adyen.service.balanceplatform package}.
    * @param client {@link Client } (required)
    */
    public TransactionRulesApi(Client client) {
        super(client);
        this.baseURL = createBaseURL("https://balanceplatform-api-test.adyen.com/bcl/v2");
    }

    /**
    * Transaction rules constructor in {@link com.adyen.service.balanceplatform package}.
    * Please use this constructor only if you would like to pass along your own url for routing or testing purposes. The latest API version is defined in this class as a constant.
    * @param client {@link Client } (required)
    * @param baseURL {@link String } (required)
    */
    public TransactionRulesApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    /**
    * Delete a transaction rule
    *
    * @param transactionRuleId {@link String } The unique identifier of the transaction rule. (required)
    * @return {@link TransactionRule }
    * @throws ApiException if fails to make API call
    */
    public TransactionRule deleteTransactionRule(String transactionRuleId) throws ApiException, IOException {
        return deleteTransactionRule(transactionRuleId, null);
    }

    /**
    * Delete a transaction rule
    *
    * @param transactionRuleId {@link String } The unique identifier of the transaction rule. (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link TransactionRule }
    * @throws ApiException if fails to make API call
    */
    public TransactionRule deleteTransactionRule(String transactionRuleId, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (transactionRuleId == null) {
            throw new IllegalArgumentException("Please provide the transactionRuleId path parameter");
        }
        pathParams.put("transactionRuleId", transactionRuleId);

        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/transactionRules/{transactionRuleId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.DELETE, pathParams);
        return TransactionRule.fromJson(jsonResult);
    }

    /**
    * Get a transaction rule
    *
    * @param transactionRuleId {@link String } The unique identifier of the transaction rule. (required)
    * @return {@link TransactionRuleResponse }
    * @throws ApiException if fails to make API call
    */
    public TransactionRuleResponse getTransactionRule(String transactionRuleId) throws ApiException, IOException {
        return getTransactionRule(transactionRuleId, null);
    }

    /**
    * Get a transaction rule
    *
    * @param transactionRuleId {@link String } The unique identifier of the transaction rule. (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link TransactionRuleResponse }
    * @throws ApiException if fails to make API call
    */
    public TransactionRuleResponse getTransactionRule(String transactionRuleId, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (transactionRuleId == null) {
            throw new IllegalArgumentException("Please provide the transactionRuleId path parameter");
        }
        pathParams.put("transactionRuleId", transactionRuleId);

        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/transactionRules/{transactionRuleId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return TransactionRuleResponse.fromJson(jsonResult);
    }

    /**
    * Update a transaction rule
    *
    * @param transactionRuleId {@link String } The unique identifier of the transaction rule. (required)
    * @param transactionRuleInfo {@link TransactionRuleInfo }  (required)
    * @return {@link TransactionRule }
    * @throws ApiException if fails to make API call
    */
    public TransactionRule updateTransactionRule(String transactionRuleId, TransactionRuleInfo transactionRuleInfo) throws ApiException, IOException {
        return updateTransactionRule(transactionRuleId, transactionRuleInfo, null);
    }

    /**
    * Update a transaction rule
    *
    * @param transactionRuleId {@link String } The unique identifier of the transaction rule. (required)
    * @param transactionRuleInfo {@link TransactionRuleInfo }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link TransactionRule }
    * @throws ApiException if fails to make API call
    */
    public TransactionRule updateTransactionRule(String transactionRuleId, TransactionRuleInfo transactionRuleInfo, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (transactionRuleId == null) {
            throw new IllegalArgumentException("Please provide the transactionRuleId path parameter");
        }
        pathParams.put("transactionRuleId", transactionRuleId);

        String requestBody = transactionRuleInfo.toJson();
        Resource resource = new Resource(this, this.baseURL + "/transactionRules/{transactionRuleId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
        return TransactionRule.fromJson(jsonResult);
    }

    /**
    * Create a transaction rule
    *
    * @param transactionRuleInfo {@link TransactionRuleInfo }  (required)
    * @return {@link TransactionRule }
    * @throws ApiException if fails to make API call
    */
    public TransactionRule createTransactionRule(TransactionRuleInfo transactionRuleInfo) throws ApiException, IOException {
        return createTransactionRule(transactionRuleInfo, null);
    }

    /**
    * Create a transaction rule
    *
    * @param transactionRuleInfo {@link TransactionRuleInfo }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link TransactionRule }
    * @throws ApiException if fails to make API call
    */
    public TransactionRule createTransactionRule(TransactionRuleInfo transactionRuleInfo, RequestOptions requestOptions) throws ApiException, IOException {

        String requestBody = transactionRuleInfo.toJson();
        Resource resource = new Resource(this, this.baseURL + "/transactionRules", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return TransactionRule.fromJson(jsonResult);
    }
}
