/*
 * Adyen Payment API
 *
 * The version of the OpenAPI document: 68
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.payment;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.payment.AcctInfo;
import com.adyen.model.payment.DeviceRenderOptions;
import com.adyen.model.payment.Phone;
import com.adyen.model.payment.SDKEphemPubKey;
import com.adyen.model.payment.ThreeDSRequestorAuthenticationInfo;
import com.adyen.model.payment.ThreeDSRequestorPriorAuthenticationInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * ThreeDS2RequestData
 */
@JsonPropertyOrder({
  ThreeDS2RequestData.JSON_PROPERTY_ACCT_INFO,
  ThreeDS2RequestData.JSON_PROPERTY_ACCT_TYPE,
  ThreeDS2RequestData.JSON_PROPERTY_ACQUIRER_B_I_N,
  ThreeDS2RequestData.JSON_PROPERTY_ACQUIRER_MERCHANT_I_D,
  ThreeDS2RequestData.JSON_PROPERTY_ADDR_MATCH,
  ThreeDS2RequestData.JSON_PROPERTY_AUTHENTICATION_ONLY,
  ThreeDS2RequestData.JSON_PROPERTY_CHALLENGE_INDICATOR,
  ThreeDS2RequestData.JSON_PROPERTY_DEVICE_CHANNEL,
  ThreeDS2RequestData.JSON_PROPERTY_DEVICE_RENDER_OPTIONS,
  ThreeDS2RequestData.JSON_PROPERTY_HOME_PHONE,
  ThreeDS2RequestData.JSON_PROPERTY_MCC,
  ThreeDS2RequestData.JSON_PROPERTY_MERCHANT_NAME,
  ThreeDS2RequestData.JSON_PROPERTY_MESSAGE_VERSION,
  ThreeDS2RequestData.JSON_PROPERTY_MOBILE_PHONE,
  ThreeDS2RequestData.JSON_PROPERTY_NOTIFICATION_U_R_L,
  ThreeDS2RequestData.JSON_PROPERTY_PAY_TOKEN_IND,
  ThreeDS2RequestData.JSON_PROPERTY_PAYMENT_AUTHENTICATION_USE_CASE,
  ThreeDS2RequestData.JSON_PROPERTY_PURCHASE_INSTAL_DATA,
  ThreeDS2RequestData.JSON_PROPERTY_RECURRING_EXPIRY,
  ThreeDS2RequestData.JSON_PROPERTY_RECURRING_FREQUENCY,
  ThreeDS2RequestData.JSON_PROPERTY_SDK_APP_I_D,
  ThreeDS2RequestData.JSON_PROPERTY_SDK_ENC_DATA,
  ThreeDS2RequestData.JSON_PROPERTY_SDK_EPHEM_PUB_KEY,
  ThreeDS2RequestData.JSON_PROPERTY_SDK_MAX_TIMEOUT,
  ThreeDS2RequestData.JSON_PROPERTY_SDK_REFERENCE_NUMBER,
  ThreeDS2RequestData.JSON_PROPERTY_SDK_TRANS_I_D,
  ThreeDS2RequestData.JSON_PROPERTY_SDK_VERSION,
  ThreeDS2RequestData.JSON_PROPERTY_THREE_D_S_COMP_IND,
  ThreeDS2RequestData.JSON_PROPERTY_THREE_D_S_REQUESTOR_AUTHENTICATION_IND,
  ThreeDS2RequestData.JSON_PROPERTY_THREE_D_S_REQUESTOR_AUTHENTICATION_INFO,
  ThreeDS2RequestData.JSON_PROPERTY_THREE_D_S_REQUESTOR_CHALLENGE_IND,
  ThreeDS2RequestData.JSON_PROPERTY_THREE_D_S_REQUESTOR_I_D,
  ThreeDS2RequestData.JSON_PROPERTY_THREE_D_S_REQUESTOR_NAME,
  ThreeDS2RequestData.JSON_PROPERTY_THREE_D_S_REQUESTOR_PRIOR_AUTHENTICATION_INFO,
  ThreeDS2RequestData.JSON_PROPERTY_THREE_D_S_REQUESTOR_U_R_L,
  ThreeDS2RequestData.JSON_PROPERTY_TRANS_TYPE,
  ThreeDS2RequestData.JSON_PROPERTY_TRANSACTION_TYPE,
  ThreeDS2RequestData.JSON_PROPERTY_WHITE_LIST_STATUS,
  ThreeDS2RequestData.JSON_PROPERTY_WORK_PHONE
})

public class ThreeDS2RequestData {
  public static final String JSON_PROPERTY_ACCT_INFO = "acctInfo";
  private AcctInfo acctInfo;

  /**
   * Indicates the type of account. For example, for a multi-account card product. Length: 2 characters. Allowed values: * **01** — Not applicable * **02** — Credit * **03** — Debit
   */
  public enum AcctTypeEnum {
    _01("01"),
    
    _02("02"),
    
    _03("03");

    private String value;

    AcctTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static AcctTypeEnum fromValue(String value) {
      for (AcctTypeEnum b : AcctTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ACCT_TYPE = "acctType";
  private AcctTypeEnum acctType;

  public static final String JSON_PROPERTY_ACQUIRER_B_I_N = "acquirerBIN";
  private String acquirerBIN;

  public static final String JSON_PROPERTY_ACQUIRER_MERCHANT_I_D = "acquirerMerchantID";
  private String acquirerMerchantID;

  /**
   * Indicates whether the Cardholder Shipping Address and Cardholder Billing Address are the same. Allowed values: * **Y** — Shipping Address matches Billing Address. * **N** — Shipping Address does not match Billing Address.
   */
  public enum AddrMatchEnum {
    Y("Y"),
    
    N("N");

    private String value;

    AddrMatchEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static AddrMatchEnum fromValue(String value) {
      for (AddrMatchEnum b : AddrMatchEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ADDR_MATCH = "addrMatch";
  private AddrMatchEnum addrMatch;

  public static final String JSON_PROPERTY_AUTHENTICATION_ONLY = "authenticationOnly";
  private Boolean authenticationOnly = false;

  /**
   * Possibility to specify a preference for receiving a challenge from the issuer. Allowed values: * &#x60;noPreference&#x60; * &#x60;requestNoChallenge&#x60; * &#x60;requestChallenge&#x60; * &#x60;requestChallengeAsMandate&#x60; 
   */
  public enum ChallengeIndicatorEnum {
    NOPREFERENCE("noPreference"),
    
    REQUESTNOCHALLENGE("requestNoChallenge"),
    
    REQUESTCHALLENGE("requestChallenge"),
    
    REQUESTCHALLENGEASMANDATE("requestChallengeAsMandate");

    private String value;

    ChallengeIndicatorEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ChallengeIndicatorEnum fromValue(String value) {
      for (ChallengeIndicatorEnum b : ChallengeIndicatorEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CHALLENGE_INDICATOR = "challengeIndicator";
  private ChallengeIndicatorEnum challengeIndicator;

  public static final String JSON_PROPERTY_DEVICE_CHANNEL = "deviceChannel";
  private String deviceChannel;

  public static final String JSON_PROPERTY_DEVICE_RENDER_OPTIONS = "deviceRenderOptions";
  private DeviceRenderOptions deviceRenderOptions;

  public static final String JSON_PROPERTY_HOME_PHONE = "homePhone";
  private Phone homePhone;

  public static final String JSON_PROPERTY_MCC = "mcc";
  private String mcc;

  public static final String JSON_PROPERTY_MERCHANT_NAME = "merchantName";
  private String merchantName;

  public static final String JSON_PROPERTY_MESSAGE_VERSION = "messageVersion";
  private String messageVersion;

  public static final String JSON_PROPERTY_MOBILE_PHONE = "mobilePhone";
  private Phone mobilePhone;

  public static final String JSON_PROPERTY_NOTIFICATION_U_R_L = "notificationURL";
  private String notificationURL;

  public static final String JSON_PROPERTY_PAY_TOKEN_IND = "payTokenInd";
  private Boolean payTokenInd;

  public static final String JSON_PROPERTY_PAYMENT_AUTHENTICATION_USE_CASE = "paymentAuthenticationUseCase";
  private String paymentAuthenticationUseCase;

  public static final String JSON_PROPERTY_PURCHASE_INSTAL_DATA = "purchaseInstalData";
  private String purchaseInstalData;

  public static final String JSON_PROPERTY_RECURRING_EXPIRY = "recurringExpiry";
  private String recurringExpiry;

  public static final String JSON_PROPERTY_RECURRING_FREQUENCY = "recurringFrequency";
  private String recurringFrequency;

  public static final String JSON_PROPERTY_SDK_APP_I_D = "sdkAppID";
  private String sdkAppID;

  public static final String JSON_PROPERTY_SDK_ENC_DATA = "sdkEncData";
  private String sdkEncData;

  public static final String JSON_PROPERTY_SDK_EPHEM_PUB_KEY = "sdkEphemPubKey";
  private SDKEphemPubKey sdkEphemPubKey;

  public static final String JSON_PROPERTY_SDK_MAX_TIMEOUT = "sdkMaxTimeout";
  private Integer sdkMaxTimeout = 60;

  public static final String JSON_PROPERTY_SDK_REFERENCE_NUMBER = "sdkReferenceNumber";
  private String sdkReferenceNumber;

  public static final String JSON_PROPERTY_SDK_TRANS_I_D = "sdkTransID";
  private String sdkTransID;

  public static final String JSON_PROPERTY_SDK_VERSION = "sdkVersion";
  private String sdkVersion;

  public static final String JSON_PROPERTY_THREE_D_S_COMP_IND = "threeDSCompInd";
  private String threeDSCompInd;

  public static final String JSON_PROPERTY_THREE_D_S_REQUESTOR_AUTHENTICATION_IND = "threeDSRequestorAuthenticationInd";
  private String threeDSRequestorAuthenticationInd;

  public static final String JSON_PROPERTY_THREE_D_S_REQUESTOR_AUTHENTICATION_INFO = "threeDSRequestorAuthenticationInfo";
  private ThreeDSRequestorAuthenticationInfo threeDSRequestorAuthenticationInfo;

  /**
   * Indicates whether a challenge is requested for this transaction. Possible values: * **01** — No preference * **02** — No challenge requested * **03** — Challenge requested (3DS Requestor preference) * **04** — Challenge requested (Mandate) * **05** — No challenge (transactional risk analysis is already performed) * **06** — Data Only
   */
  public enum ThreeDSRequestorChallengeIndEnum {
    _01("01"),
    
    _02("02"),
    
    _03("03"),
    
    _04("04"),
    
    _05("05"),
    
    _06("06");

    private String value;

    ThreeDSRequestorChallengeIndEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ThreeDSRequestorChallengeIndEnum fromValue(String value) {
      for (ThreeDSRequestorChallengeIndEnum b : ThreeDSRequestorChallengeIndEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_THREE_D_S_REQUESTOR_CHALLENGE_IND = "threeDSRequestorChallengeInd";
  private ThreeDSRequestorChallengeIndEnum threeDSRequestorChallengeInd;

  public static final String JSON_PROPERTY_THREE_D_S_REQUESTOR_I_D = "threeDSRequestorID";
  private String threeDSRequestorID;

  public static final String JSON_PROPERTY_THREE_D_S_REQUESTOR_NAME = "threeDSRequestorName";
  private String threeDSRequestorName;

  public static final String JSON_PROPERTY_THREE_D_S_REQUESTOR_PRIOR_AUTHENTICATION_INFO = "threeDSRequestorPriorAuthenticationInfo";
  private ThreeDSRequestorPriorAuthenticationInfo threeDSRequestorPriorAuthenticationInfo;

  public static final String JSON_PROPERTY_THREE_D_S_REQUESTOR_U_R_L = "threeDSRequestorURL";
  private String threeDSRequestorURL;

  /**
   * Identifies the type of transaction being authenticated. Length: 2 characters. Allowed values: * **01** — Goods/Service Purchase * **03** — Check Acceptance * **10** — Account Funding * **11** — Quasi-Cash Transaction * **28** — Prepaid Activation and Load
   */
  public enum TransTypeEnum {
    _01("01"),
    
    _03("03"),
    
    _10("10"),
    
    _11("11"),
    
    _28("28");

    private String value;

    TransTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TransTypeEnum fromValue(String value) {
      for (TransTypeEnum b : TransTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TRANS_TYPE = "transType";
  private TransTypeEnum transType;

  /**
   * Identify the type of the transaction being authenticated.
   */
  public enum TransactionTypeEnum {
    GOODSORSERVICEPURCHASE("goodsOrServicePurchase"),
    
    CHECKACCEPTANCE("checkAcceptance"),
    
    ACCOUNTFUNDING("accountFunding"),
    
    QUASICASHTRANSACTION("quasiCashTransaction"),
    
    PREPAIDACTIVATIONANDLOAD("prepaidActivationAndLoad");

    private String value;

    TransactionTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TransactionTypeEnum fromValue(String value) {
      for (TransactionTypeEnum b : TransactionTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TRANSACTION_TYPE = "transactionType";
  private TransactionTypeEnum transactionType;

  public static final String JSON_PROPERTY_WHITE_LIST_STATUS = "whiteListStatus";
  private String whiteListStatus;

  public static final String JSON_PROPERTY_WORK_PHONE = "workPhone";
  private Phone workPhone;

  public ThreeDS2RequestData() { 
  }

  public ThreeDS2RequestData acctInfo(AcctInfo acctInfo) {
    this.acctInfo = acctInfo;
    return this;
  }

   /**
   * Get acctInfo
   * @return acctInfo
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ACCT_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AcctInfo getAcctInfo() {
    return acctInfo;
  }


 /**
  * acctInfo
  *
  * @param acctInfo
  */ 
  @JsonProperty(JSON_PROPERTY_ACCT_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAcctInfo(AcctInfo acctInfo) {
    this.acctInfo = acctInfo;
  }


  public ThreeDS2RequestData acctType(AcctTypeEnum acctType) {
    this.acctType = acctType;
    return this;
  }

   /**
   * Indicates the type of account. For example, for a multi-account card product. Length: 2 characters. Allowed values: * **01** — Not applicable * **02** — Credit * **03** — Debit
   * @return acctType
  **/
  @ApiModelProperty(value = "Indicates the type of account. For example, for a multi-account card product. Length: 2 characters. Allowed values: * **01** — Not applicable * **02** — Credit * **03** — Debit")
  @JsonProperty(JSON_PROPERTY_ACCT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AcctTypeEnum getAcctType() {
    return acctType;
  }


 /**
  * Indicates the type of account. For example, for a multi-account card product. Length: 2 characters. Allowed values: * **01** — Not applicable * **02** — Credit * **03** — Debit
  *
  * @param acctType
  */ 
  @JsonProperty(JSON_PROPERTY_ACCT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAcctType(AcctTypeEnum acctType) {
    this.acctType = acctType;
  }


  public ThreeDS2RequestData acquirerBIN(String acquirerBIN) {
    this.acquirerBIN = acquirerBIN;
    return this;
  }

   /**
   * Required for [authentication-only integration](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only). The acquiring BIN enrolled for 3D Secure 2. This string should match the value that you will use in the authorisation. Use 123456 on the Test platform.
   * @return acquirerBIN
  **/
  @ApiModelProperty(value = "Required for [authentication-only integration](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only). The acquiring BIN enrolled for 3D Secure 2. This string should match the value that you will use in the authorisation. Use 123456 on the Test platform.")
  @JsonProperty(JSON_PROPERTY_ACQUIRER_B_I_N)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAcquirerBIN() {
    return acquirerBIN;
  }


 /**
  * Required for [authentication-only integration](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only). The acquiring BIN enrolled for 3D Secure 2. This string should match the value that you will use in the authorisation. Use 123456 on the Test platform.
  *
  * @param acquirerBIN
  */ 
  @JsonProperty(JSON_PROPERTY_ACQUIRER_B_I_N)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAcquirerBIN(String acquirerBIN) {
    this.acquirerBIN = acquirerBIN;
  }


  public ThreeDS2RequestData acquirerMerchantID(String acquirerMerchantID) {
    this.acquirerMerchantID = acquirerMerchantID;
    return this;
  }

   /**
   * Required for [authentication-only integration](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only). The merchantId that is enrolled for 3D Secure 2 by the merchant&#39;s acquirer. This string should match the value that you will use in the authorisation. Use 123456 on the Test platform.
   * @return acquirerMerchantID
  **/
  @ApiModelProperty(value = "Required for [authentication-only integration](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only). The merchantId that is enrolled for 3D Secure 2 by the merchant's acquirer. This string should match the value that you will use in the authorisation. Use 123456 on the Test platform.")
  @JsonProperty(JSON_PROPERTY_ACQUIRER_MERCHANT_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAcquirerMerchantID() {
    return acquirerMerchantID;
  }


 /**
  * Required for [authentication-only integration](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only). The merchantId that is enrolled for 3D Secure 2 by the merchant&#39;s acquirer. This string should match the value that you will use in the authorisation. Use 123456 on the Test platform.
  *
  * @param acquirerMerchantID
  */ 
  @JsonProperty(JSON_PROPERTY_ACQUIRER_MERCHANT_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAcquirerMerchantID(String acquirerMerchantID) {
    this.acquirerMerchantID = acquirerMerchantID;
  }


  public ThreeDS2RequestData addrMatch(AddrMatchEnum addrMatch) {
    this.addrMatch = addrMatch;
    return this;
  }

   /**
   * Indicates whether the Cardholder Shipping Address and Cardholder Billing Address are the same. Allowed values: * **Y** — Shipping Address matches Billing Address. * **N** — Shipping Address does not match Billing Address.
   * @return addrMatch
  **/
  @ApiModelProperty(value = "Indicates whether the Cardholder Shipping Address and Cardholder Billing Address are the same. Allowed values: * **Y** — Shipping Address matches Billing Address. * **N** — Shipping Address does not match Billing Address.")
  @JsonProperty(JSON_PROPERTY_ADDR_MATCH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AddrMatchEnum getAddrMatch() {
    return addrMatch;
  }


 /**
  * Indicates whether the Cardholder Shipping Address and Cardholder Billing Address are the same. Allowed values: * **Y** — Shipping Address matches Billing Address. * **N** — Shipping Address does not match Billing Address.
  *
  * @param addrMatch
  */ 
  @JsonProperty(JSON_PROPERTY_ADDR_MATCH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddrMatch(AddrMatchEnum addrMatch) {
    this.addrMatch = addrMatch;
  }


  public ThreeDS2RequestData authenticationOnly(Boolean authenticationOnly) {
    this.authenticationOnly = authenticationOnly;
    return this;
  }

   /**
   * If set to true, you will only perform the [3D Secure 2 authentication](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only), and not the payment authorisation.
   * @return authenticationOnly
   * @deprecated
  **/
  @Deprecated
  @ApiModelProperty(value = "If set to true, you will only perform the [3D Secure 2 authentication](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only), and not the payment authorisation.")
  @JsonProperty(JSON_PROPERTY_AUTHENTICATION_ONLY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAuthenticationOnly() {
    return authenticationOnly;
  }


 /**
  * If set to true, you will only perform the [3D Secure 2 authentication](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only), and not the payment authorisation.
  *
  * @param authenticationOnly
  */ 
  @Deprecated
  @JsonProperty(JSON_PROPERTY_AUTHENTICATION_ONLY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAuthenticationOnly(Boolean authenticationOnly) {
    this.authenticationOnly = authenticationOnly;
  }


  public ThreeDS2RequestData challengeIndicator(ChallengeIndicatorEnum challengeIndicator) {
    this.challengeIndicator = challengeIndicator;
    return this;
  }

   /**
   * Possibility to specify a preference for receiving a challenge from the issuer. Allowed values: * &#x60;noPreference&#x60; * &#x60;requestNoChallenge&#x60; * &#x60;requestChallenge&#x60; * &#x60;requestChallengeAsMandate&#x60; 
   * @return challengeIndicator
   * @deprecated
  **/
  @Deprecated
  @ApiModelProperty(value = "Possibility to specify a preference for receiving a challenge from the issuer. Allowed values: * `noPreference` * `requestNoChallenge` * `requestChallenge` * `requestChallengeAsMandate` ")
  @JsonProperty(JSON_PROPERTY_CHALLENGE_INDICATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChallengeIndicatorEnum getChallengeIndicator() {
    return challengeIndicator;
  }


 /**
  * Possibility to specify a preference for receiving a challenge from the issuer. Allowed values: * &#x60;noPreference&#x60; * &#x60;requestNoChallenge&#x60; * &#x60;requestChallenge&#x60; * &#x60;requestChallengeAsMandate&#x60; 
  *
  * @param challengeIndicator
  */ 
  @Deprecated
  @JsonProperty(JSON_PROPERTY_CHALLENGE_INDICATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChallengeIndicator(ChallengeIndicatorEnum challengeIndicator) {
    this.challengeIndicator = challengeIndicator;
  }


  public ThreeDS2RequestData deviceChannel(String deviceChannel) {
    this.deviceChannel = deviceChannel;
    return this;
  }

   /**
   * The environment of the shopper. Allowed values: * &#x60;app&#x60; * &#x60;browser&#x60;
   * @return deviceChannel
  **/
  @ApiModelProperty(required = true, value = "The environment of the shopper. Allowed values: * `app` * `browser`")
  @JsonProperty(JSON_PROPERTY_DEVICE_CHANNEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDeviceChannel() {
    return deviceChannel;
  }


 /**
  * The environment of the shopper. Allowed values: * &#x60;app&#x60; * &#x60;browser&#x60;
  *
  * @param deviceChannel
  */ 
  @JsonProperty(JSON_PROPERTY_DEVICE_CHANNEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeviceChannel(String deviceChannel) {
    this.deviceChannel = deviceChannel;
  }


  public ThreeDS2RequestData deviceRenderOptions(DeviceRenderOptions deviceRenderOptions) {
    this.deviceRenderOptions = deviceRenderOptions;
    return this;
  }

   /**
   * Get deviceRenderOptions
   * @return deviceRenderOptions
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DEVICE_RENDER_OPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DeviceRenderOptions getDeviceRenderOptions() {
    return deviceRenderOptions;
  }


 /**
  * deviceRenderOptions
  *
  * @param deviceRenderOptions
  */ 
  @JsonProperty(JSON_PROPERTY_DEVICE_RENDER_OPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeviceRenderOptions(DeviceRenderOptions deviceRenderOptions) {
    this.deviceRenderOptions = deviceRenderOptions;
  }


  public ThreeDS2RequestData homePhone(Phone homePhone) {
    this.homePhone = homePhone;
    return this;
  }

   /**
   * Get homePhone
   * @return homePhone
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_HOME_PHONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Phone getHomePhone() {
    return homePhone;
  }


 /**
  * homePhone
  *
  * @param homePhone
  */ 
  @JsonProperty(JSON_PROPERTY_HOME_PHONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHomePhone(Phone homePhone) {
    this.homePhone = homePhone;
  }


  public ThreeDS2RequestData mcc(String mcc) {
    this.mcc = mcc;
    return this;
  }

   /**
   * Required for merchants that have been enrolled for 3D Secure 2 by another party than Adyen, mostly [authentication-only integrations](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only). The &#x60;mcc&#x60; is a four-digit code with which the previously given &#x60;acquirerMerchantID&#x60; is registered at the scheme.
   * @return mcc
  **/
  @ApiModelProperty(value = "Required for merchants that have been enrolled for 3D Secure 2 by another party than Adyen, mostly [authentication-only integrations](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only). The `mcc` is a four-digit code with which the previously given `acquirerMerchantID` is registered at the scheme.")
  @JsonProperty(JSON_PROPERTY_MCC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMcc() {
    return mcc;
  }


 /**
  * Required for merchants that have been enrolled for 3D Secure 2 by another party than Adyen, mostly [authentication-only integrations](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only). The &#x60;mcc&#x60; is a four-digit code with which the previously given &#x60;acquirerMerchantID&#x60; is registered at the scheme.
  *
  * @param mcc
  */ 
  @JsonProperty(JSON_PROPERTY_MCC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMcc(String mcc) {
    this.mcc = mcc;
  }


  public ThreeDS2RequestData merchantName(String merchantName) {
    this.merchantName = merchantName;
    return this;
  }

   /**
   * Required for [authentication-only integration](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only). The merchant name that the issuer presents to the shopper if they get a challenge. We recommend to use the same value that you will use in the authorization. Maximum length is 40 characters. &gt; Optional for a [full 3D Secure 2 integration](https://docs.adyen.com/online-payments/3d-secure/native-3ds2/api-integration). Use this field if you are enrolled for 3D Secure 2 with us and want to override the merchant name already configured on your account.
   * @return merchantName
  **/
  @ApiModelProperty(value = "Required for [authentication-only integration](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only). The merchant name that the issuer presents to the shopper if they get a challenge. We recommend to use the same value that you will use in the authorization. Maximum length is 40 characters. > Optional for a [full 3D Secure 2 integration](https://docs.adyen.com/online-payments/3d-secure/native-3ds2/api-integration). Use this field if you are enrolled for 3D Secure 2 with us and want to override the merchant name already configured on your account.")
  @JsonProperty(JSON_PROPERTY_MERCHANT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMerchantName() {
    return merchantName;
  }


 /**
  * Required for [authentication-only integration](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only). The merchant name that the issuer presents to the shopper if they get a challenge. We recommend to use the same value that you will use in the authorization. Maximum length is 40 characters. &gt; Optional for a [full 3D Secure 2 integration](https://docs.adyen.com/online-payments/3d-secure/native-3ds2/api-integration). Use this field if you are enrolled for 3D Secure 2 with us and want to override the merchant name already configured on your account.
  *
  * @param merchantName
  */ 
  @JsonProperty(JSON_PROPERTY_MERCHANT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantName(String merchantName) {
    this.merchantName = merchantName;
  }


  public ThreeDS2RequestData messageVersion(String messageVersion) {
    this.messageVersion = messageVersion;
    return this;
  }

   /**
   * The &#x60;messageVersion&#x60; value indicating the 3D Secure 2 protocol version.
   * @return messageVersion
  **/
  @ApiModelProperty(value = "The `messageVersion` value indicating the 3D Secure 2 protocol version.")
  @JsonProperty(JSON_PROPERTY_MESSAGE_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMessageVersion() {
    return messageVersion;
  }


 /**
  * The &#x60;messageVersion&#x60; value indicating the 3D Secure 2 protocol version.
  *
  * @param messageVersion
  */ 
  @JsonProperty(JSON_PROPERTY_MESSAGE_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessageVersion(String messageVersion) {
    this.messageVersion = messageVersion;
  }


  public ThreeDS2RequestData mobilePhone(Phone mobilePhone) {
    this.mobilePhone = mobilePhone;
    return this;
  }

   /**
   * Get mobilePhone
   * @return mobilePhone
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MOBILE_PHONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Phone getMobilePhone() {
    return mobilePhone;
  }


 /**
  * mobilePhone
  *
  * @param mobilePhone
  */ 
  @JsonProperty(JSON_PROPERTY_MOBILE_PHONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMobilePhone(Phone mobilePhone) {
    this.mobilePhone = mobilePhone;
  }


  public ThreeDS2RequestData notificationURL(String notificationURL) {
    this.notificationURL = notificationURL;
    return this;
  }

   /**
   * URL to where the issuer should send the &#x60;CRes&#x60;. Required if you are not using components for &#x60;channel&#x60; **Web** or if you are using classic integration &#x60;deviceChannel&#x60; **browser**.
   * @return notificationURL
  **/
  @ApiModelProperty(value = "URL to where the issuer should send the `CRes`. Required if you are not using components for `channel` **Web** or if you are using classic integration `deviceChannel` **browser**.")
  @JsonProperty(JSON_PROPERTY_NOTIFICATION_U_R_L)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getNotificationURL() {
    return notificationURL;
  }


 /**
  * URL to where the issuer should send the &#x60;CRes&#x60;. Required if you are not using components for &#x60;channel&#x60; **Web** or if you are using classic integration &#x60;deviceChannel&#x60; **browser**.
  *
  * @param notificationURL
  */ 
  @JsonProperty(JSON_PROPERTY_NOTIFICATION_U_R_L)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNotificationURL(String notificationURL) {
    this.notificationURL = notificationURL;
  }


  public ThreeDS2RequestData payTokenInd(Boolean payTokenInd) {
    this.payTokenInd = payTokenInd;
    return this;
  }

   /**
   * Value **true** indicates that the transaction was de-tokenised prior to being received by the ACS.
   * @return payTokenInd
  **/
  @ApiModelProperty(value = "Value **true** indicates that the transaction was de-tokenised prior to being received by the ACS.")
  @JsonProperty(JSON_PROPERTY_PAY_TOKEN_IND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPayTokenInd() {
    return payTokenInd;
  }


 /**
  * Value **true** indicates that the transaction was de-tokenised prior to being received by the ACS.
  *
  * @param payTokenInd
  */ 
  @JsonProperty(JSON_PROPERTY_PAY_TOKEN_IND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPayTokenInd(Boolean payTokenInd) {
    this.payTokenInd = payTokenInd;
  }


  public ThreeDS2RequestData paymentAuthenticationUseCase(String paymentAuthenticationUseCase) {
    this.paymentAuthenticationUseCase = paymentAuthenticationUseCase;
    return this;
  }

   /**
   * Indicates the type of payment for which an authentication is requested (message extension)
   * @return paymentAuthenticationUseCase
  **/
  @ApiModelProperty(value = "Indicates the type of payment for which an authentication is requested (message extension)")
  @JsonProperty(JSON_PROPERTY_PAYMENT_AUTHENTICATION_USE_CASE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPaymentAuthenticationUseCase() {
    return paymentAuthenticationUseCase;
  }


 /**
  * Indicates the type of payment for which an authentication is requested (message extension)
  *
  * @param paymentAuthenticationUseCase
  */ 
  @JsonProperty(JSON_PROPERTY_PAYMENT_AUTHENTICATION_USE_CASE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentAuthenticationUseCase(String paymentAuthenticationUseCase) {
    this.paymentAuthenticationUseCase = paymentAuthenticationUseCase;
  }


  public ThreeDS2RequestData purchaseInstalData(String purchaseInstalData) {
    this.purchaseInstalData = purchaseInstalData;
    return this;
  }

   /**
   * Indicates the maximum number of authorisations permitted for instalment payments. Length: 1–3 characters.
   * @return purchaseInstalData
  **/
  @ApiModelProperty(value = "Indicates the maximum number of authorisations permitted for instalment payments. Length: 1–3 characters.")
  @JsonProperty(JSON_PROPERTY_PURCHASE_INSTAL_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPurchaseInstalData() {
    return purchaseInstalData;
  }


 /**
  * Indicates the maximum number of authorisations permitted for instalment payments. Length: 1–3 characters.
  *
  * @param purchaseInstalData
  */ 
  @JsonProperty(JSON_PROPERTY_PURCHASE_INSTAL_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPurchaseInstalData(String purchaseInstalData) {
    this.purchaseInstalData = purchaseInstalData;
  }


  public ThreeDS2RequestData recurringExpiry(String recurringExpiry) {
    this.recurringExpiry = recurringExpiry;
    return this;
  }

   /**
   * Date after which no further authorisations shall be performed. Format: YYYYMMDD
   * @return recurringExpiry
  **/
  @ApiModelProperty(value = "Date after which no further authorisations shall be performed. Format: YYYYMMDD")
  @JsonProperty(JSON_PROPERTY_RECURRING_EXPIRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRecurringExpiry() {
    return recurringExpiry;
  }


 /**
  * Date after which no further authorisations shall be performed. Format: YYYYMMDD
  *
  * @param recurringExpiry
  */ 
  @JsonProperty(JSON_PROPERTY_RECURRING_EXPIRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecurringExpiry(String recurringExpiry) {
    this.recurringExpiry = recurringExpiry;
  }


  public ThreeDS2RequestData recurringFrequency(String recurringFrequency) {
    this.recurringFrequency = recurringFrequency;
    return this;
  }

   /**
   * Indicates the minimum number of days between authorisations. Maximum length: 4 characters.
   * @return recurringFrequency
  **/
  @ApiModelProperty(value = "Indicates the minimum number of days between authorisations. Maximum length: 4 characters.")
  @JsonProperty(JSON_PROPERTY_RECURRING_FREQUENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRecurringFrequency() {
    return recurringFrequency;
  }


 /**
  * Indicates the minimum number of days between authorisations. Maximum length: 4 characters.
  *
  * @param recurringFrequency
  */ 
  @JsonProperty(JSON_PROPERTY_RECURRING_FREQUENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecurringFrequency(String recurringFrequency) {
    this.recurringFrequency = recurringFrequency;
  }


  public ThreeDS2RequestData sdkAppID(String sdkAppID) {
    this.sdkAppID = sdkAppID;
    return this;
  }

   /**
   * The &#x60;sdkAppID&#x60; value as received from the 3D Secure 2 SDK. Required for &#x60;deviceChannel&#x60; set to **app**.
   * @return sdkAppID
  **/
  @ApiModelProperty(value = "The `sdkAppID` value as received from the 3D Secure 2 SDK. Required for `deviceChannel` set to **app**.")
  @JsonProperty(JSON_PROPERTY_SDK_APP_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSdkAppID() {
    return sdkAppID;
  }


 /**
  * The &#x60;sdkAppID&#x60; value as received from the 3D Secure 2 SDK. Required for &#x60;deviceChannel&#x60; set to **app**.
  *
  * @param sdkAppID
  */ 
  @JsonProperty(JSON_PROPERTY_SDK_APP_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSdkAppID(String sdkAppID) {
    this.sdkAppID = sdkAppID;
  }


  public ThreeDS2RequestData sdkEncData(String sdkEncData) {
    this.sdkEncData = sdkEncData;
    return this;
  }

   /**
   * The &#x60;sdkEncData&#x60; value as received from the 3D Secure 2 SDK. Required for &#x60;deviceChannel&#x60; set to **app**.
   * @return sdkEncData
  **/
  @ApiModelProperty(value = "The `sdkEncData` value as received from the 3D Secure 2 SDK. Required for `deviceChannel` set to **app**.")
  @JsonProperty(JSON_PROPERTY_SDK_ENC_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSdkEncData() {
    return sdkEncData;
  }


 /**
  * The &#x60;sdkEncData&#x60; value as received from the 3D Secure 2 SDK. Required for &#x60;deviceChannel&#x60; set to **app**.
  *
  * @param sdkEncData
  */ 
  @JsonProperty(JSON_PROPERTY_SDK_ENC_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSdkEncData(String sdkEncData) {
    this.sdkEncData = sdkEncData;
  }


  public ThreeDS2RequestData sdkEphemPubKey(SDKEphemPubKey sdkEphemPubKey) {
    this.sdkEphemPubKey = sdkEphemPubKey;
    return this;
  }

   /**
   * Get sdkEphemPubKey
   * @return sdkEphemPubKey
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SDK_EPHEM_PUB_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SDKEphemPubKey getSdkEphemPubKey() {
    return sdkEphemPubKey;
  }


 /**
  * sdkEphemPubKey
  *
  * @param sdkEphemPubKey
  */ 
  @JsonProperty(JSON_PROPERTY_SDK_EPHEM_PUB_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSdkEphemPubKey(SDKEphemPubKey sdkEphemPubKey) {
    this.sdkEphemPubKey = sdkEphemPubKey;
  }


  public ThreeDS2RequestData sdkMaxTimeout(Integer sdkMaxTimeout) {
    this.sdkMaxTimeout = sdkMaxTimeout;
    return this;
  }

   /**
   * The maximum amount of time in minutes for the 3D Secure 2 authentication process. Optional and only for &#x60;deviceChannel&#x60; set to **app**. Defaults to **60** minutes.
   * @return sdkMaxTimeout
  **/
  @ApiModelProperty(value = "The maximum amount of time in minutes for the 3D Secure 2 authentication process. Optional and only for `deviceChannel` set to **app**. Defaults to **60** minutes.")
  @JsonProperty(JSON_PROPERTY_SDK_MAX_TIMEOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSdkMaxTimeout() {
    return sdkMaxTimeout;
  }


 /**
  * The maximum amount of time in minutes for the 3D Secure 2 authentication process. Optional and only for &#x60;deviceChannel&#x60; set to **app**. Defaults to **60** minutes.
  *
  * @param sdkMaxTimeout
  */ 
  @JsonProperty(JSON_PROPERTY_SDK_MAX_TIMEOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSdkMaxTimeout(Integer sdkMaxTimeout) {
    this.sdkMaxTimeout = sdkMaxTimeout;
  }


  public ThreeDS2RequestData sdkReferenceNumber(String sdkReferenceNumber) {
    this.sdkReferenceNumber = sdkReferenceNumber;
    return this;
  }

   /**
   * The &#x60;sdkReferenceNumber&#x60; value as received from the 3D Secure 2 SDK. Only for &#x60;deviceChannel&#x60; set to **app**.
   * @return sdkReferenceNumber
  **/
  @ApiModelProperty(value = "The `sdkReferenceNumber` value as received from the 3D Secure 2 SDK. Only for `deviceChannel` set to **app**.")
  @JsonProperty(JSON_PROPERTY_SDK_REFERENCE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSdkReferenceNumber() {
    return sdkReferenceNumber;
  }


 /**
  * The &#x60;sdkReferenceNumber&#x60; value as received from the 3D Secure 2 SDK. Only for &#x60;deviceChannel&#x60; set to **app**.
  *
  * @param sdkReferenceNumber
  */ 
  @JsonProperty(JSON_PROPERTY_SDK_REFERENCE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSdkReferenceNumber(String sdkReferenceNumber) {
    this.sdkReferenceNumber = sdkReferenceNumber;
  }


  public ThreeDS2RequestData sdkTransID(String sdkTransID) {
    this.sdkTransID = sdkTransID;
    return this;
  }

   /**
   * The &#x60;sdkTransID&#x60; value as received from the 3D Secure 2 SDK. Only for &#x60;deviceChannel&#x60; set to **app**.
   * @return sdkTransID
  **/
  @ApiModelProperty(value = "The `sdkTransID` value as received from the 3D Secure 2 SDK. Only for `deviceChannel` set to **app**.")
  @JsonProperty(JSON_PROPERTY_SDK_TRANS_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSdkTransID() {
    return sdkTransID;
  }


 /**
  * The &#x60;sdkTransID&#x60; value as received from the 3D Secure 2 SDK. Only for &#x60;deviceChannel&#x60; set to **app**.
  *
  * @param sdkTransID
  */ 
  @JsonProperty(JSON_PROPERTY_SDK_TRANS_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSdkTransID(String sdkTransID) {
    this.sdkTransID = sdkTransID;
  }


  public ThreeDS2RequestData sdkVersion(String sdkVersion) {
    this.sdkVersion = sdkVersion;
    return this;
  }

   /**
   * Version of the 3D Secure 2 mobile SDK.  Only for &#x60;deviceChannel&#x60; set to **app**.
   * @return sdkVersion
  **/
  @ApiModelProperty(value = "Version of the 3D Secure 2 mobile SDK.  Only for `deviceChannel` set to **app**.")
  @JsonProperty(JSON_PROPERTY_SDK_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSdkVersion() {
    return sdkVersion;
  }


 /**
  * Version of the 3D Secure 2 mobile SDK.  Only for &#x60;deviceChannel&#x60; set to **app**.
  *
  * @param sdkVersion
  */ 
  @JsonProperty(JSON_PROPERTY_SDK_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSdkVersion(String sdkVersion) {
    this.sdkVersion = sdkVersion;
  }


  public ThreeDS2RequestData threeDSCompInd(String threeDSCompInd) {
    this.threeDSCompInd = threeDSCompInd;
    return this;
  }

   /**
   * Completion indicator for the device fingerprinting.
   * @return threeDSCompInd
  **/
  @ApiModelProperty(value = "Completion indicator for the device fingerprinting.")
  @JsonProperty(JSON_PROPERTY_THREE_D_S_COMP_IND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getThreeDSCompInd() {
    return threeDSCompInd;
  }


 /**
  * Completion indicator for the device fingerprinting.
  *
  * @param threeDSCompInd
  */ 
  @JsonProperty(JSON_PROPERTY_THREE_D_S_COMP_IND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThreeDSCompInd(String threeDSCompInd) {
    this.threeDSCompInd = threeDSCompInd;
  }


  public ThreeDS2RequestData threeDSRequestorAuthenticationInd(String threeDSRequestorAuthenticationInd) {
    this.threeDSRequestorAuthenticationInd = threeDSRequestorAuthenticationInd;
    return this;
  }

   /**
   * Indicates the type of Authentication request.
   * @return threeDSRequestorAuthenticationInd
  **/
  @ApiModelProperty(value = "Indicates the type of Authentication request.")
  @JsonProperty(JSON_PROPERTY_THREE_D_S_REQUESTOR_AUTHENTICATION_IND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getThreeDSRequestorAuthenticationInd() {
    return threeDSRequestorAuthenticationInd;
  }


 /**
  * Indicates the type of Authentication request.
  *
  * @param threeDSRequestorAuthenticationInd
  */ 
  @JsonProperty(JSON_PROPERTY_THREE_D_S_REQUESTOR_AUTHENTICATION_IND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThreeDSRequestorAuthenticationInd(String threeDSRequestorAuthenticationInd) {
    this.threeDSRequestorAuthenticationInd = threeDSRequestorAuthenticationInd;
  }


  public ThreeDS2RequestData threeDSRequestorAuthenticationInfo(ThreeDSRequestorAuthenticationInfo threeDSRequestorAuthenticationInfo) {
    this.threeDSRequestorAuthenticationInfo = threeDSRequestorAuthenticationInfo;
    return this;
  }

   /**
   * Get threeDSRequestorAuthenticationInfo
   * @return threeDSRequestorAuthenticationInfo
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_THREE_D_S_REQUESTOR_AUTHENTICATION_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ThreeDSRequestorAuthenticationInfo getThreeDSRequestorAuthenticationInfo() {
    return threeDSRequestorAuthenticationInfo;
  }


 /**
  * threeDSRequestorAuthenticationInfo
  *
  * @param threeDSRequestorAuthenticationInfo
  */ 
  @JsonProperty(JSON_PROPERTY_THREE_D_S_REQUESTOR_AUTHENTICATION_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThreeDSRequestorAuthenticationInfo(ThreeDSRequestorAuthenticationInfo threeDSRequestorAuthenticationInfo) {
    this.threeDSRequestorAuthenticationInfo = threeDSRequestorAuthenticationInfo;
  }


  public ThreeDS2RequestData threeDSRequestorChallengeInd(ThreeDSRequestorChallengeIndEnum threeDSRequestorChallengeInd) {
    this.threeDSRequestorChallengeInd = threeDSRequestorChallengeInd;
    return this;
  }

   /**
   * Indicates whether a challenge is requested for this transaction. Possible values: * **01** — No preference * **02** — No challenge requested * **03** — Challenge requested (3DS Requestor preference) * **04** — Challenge requested (Mandate) * **05** — No challenge (transactional risk analysis is already performed) * **06** — Data Only
   * @return threeDSRequestorChallengeInd
  **/
  @ApiModelProperty(value = "Indicates whether a challenge is requested for this transaction. Possible values: * **01** — No preference * **02** — No challenge requested * **03** — Challenge requested (3DS Requestor preference) * **04** — Challenge requested (Mandate) * **05** — No challenge (transactional risk analysis is already performed) * **06** — Data Only")
  @JsonProperty(JSON_PROPERTY_THREE_D_S_REQUESTOR_CHALLENGE_IND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ThreeDSRequestorChallengeIndEnum getThreeDSRequestorChallengeInd() {
    return threeDSRequestorChallengeInd;
  }


 /**
  * Indicates whether a challenge is requested for this transaction. Possible values: * **01** — No preference * **02** — No challenge requested * **03** — Challenge requested (3DS Requestor preference) * **04** — Challenge requested (Mandate) * **05** — No challenge (transactional risk analysis is already performed) * **06** — Data Only
  *
  * @param threeDSRequestorChallengeInd
  */ 
  @JsonProperty(JSON_PROPERTY_THREE_D_S_REQUESTOR_CHALLENGE_IND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThreeDSRequestorChallengeInd(ThreeDSRequestorChallengeIndEnum threeDSRequestorChallengeInd) {
    this.threeDSRequestorChallengeInd = threeDSRequestorChallengeInd;
  }


  public ThreeDS2RequestData threeDSRequestorID(String threeDSRequestorID) {
    this.threeDSRequestorID = threeDSRequestorID;
    return this;
  }

   /**
   * Required for [authentication-only integration](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only) for Visa. Unique 3D Secure requestor identifier assigned by the Directory Server when you enrol for 3D Secure 2.
   * @return threeDSRequestorID
  **/
  @ApiModelProperty(value = "Required for [authentication-only integration](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only) for Visa. Unique 3D Secure requestor identifier assigned by the Directory Server when you enrol for 3D Secure 2.")
  @JsonProperty(JSON_PROPERTY_THREE_D_S_REQUESTOR_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getThreeDSRequestorID() {
    return threeDSRequestorID;
  }


 /**
  * Required for [authentication-only integration](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only) for Visa. Unique 3D Secure requestor identifier assigned by the Directory Server when you enrol for 3D Secure 2.
  *
  * @param threeDSRequestorID
  */ 
  @JsonProperty(JSON_PROPERTY_THREE_D_S_REQUESTOR_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThreeDSRequestorID(String threeDSRequestorID) {
    this.threeDSRequestorID = threeDSRequestorID;
  }


  public ThreeDS2RequestData threeDSRequestorName(String threeDSRequestorName) {
    this.threeDSRequestorName = threeDSRequestorName;
    return this;
  }

   /**
   * Required for [authentication-only integration](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only) for Visa. Unique 3D Secure requestor name assigned by the Directory Server when you enrol for 3D Secure 2.
   * @return threeDSRequestorName
  **/
  @ApiModelProperty(value = "Required for [authentication-only integration](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only) for Visa. Unique 3D Secure requestor name assigned by the Directory Server when you enrol for 3D Secure 2.")
  @JsonProperty(JSON_PROPERTY_THREE_D_S_REQUESTOR_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getThreeDSRequestorName() {
    return threeDSRequestorName;
  }


 /**
  * Required for [authentication-only integration](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only) for Visa. Unique 3D Secure requestor name assigned by the Directory Server when you enrol for 3D Secure 2.
  *
  * @param threeDSRequestorName
  */ 
  @JsonProperty(JSON_PROPERTY_THREE_D_S_REQUESTOR_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThreeDSRequestorName(String threeDSRequestorName) {
    this.threeDSRequestorName = threeDSRequestorName;
  }


  public ThreeDS2RequestData threeDSRequestorPriorAuthenticationInfo(ThreeDSRequestorPriorAuthenticationInfo threeDSRequestorPriorAuthenticationInfo) {
    this.threeDSRequestorPriorAuthenticationInfo = threeDSRequestorPriorAuthenticationInfo;
    return this;
  }

   /**
   * Get threeDSRequestorPriorAuthenticationInfo
   * @return threeDSRequestorPriorAuthenticationInfo
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_THREE_D_S_REQUESTOR_PRIOR_AUTHENTICATION_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ThreeDSRequestorPriorAuthenticationInfo getThreeDSRequestorPriorAuthenticationInfo() {
    return threeDSRequestorPriorAuthenticationInfo;
  }


 /**
  * threeDSRequestorPriorAuthenticationInfo
  *
  * @param threeDSRequestorPriorAuthenticationInfo
  */ 
  @JsonProperty(JSON_PROPERTY_THREE_D_S_REQUESTOR_PRIOR_AUTHENTICATION_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThreeDSRequestorPriorAuthenticationInfo(ThreeDSRequestorPriorAuthenticationInfo threeDSRequestorPriorAuthenticationInfo) {
    this.threeDSRequestorPriorAuthenticationInfo = threeDSRequestorPriorAuthenticationInfo;
  }


  public ThreeDS2RequestData threeDSRequestorURL(String threeDSRequestorURL) {
    this.threeDSRequestorURL = threeDSRequestorURL;
    return this;
  }

   /**
   * URL of the (customer service) website that will be shown to the shopper in case of technical errors during the 3D Secure 2 process.
   * @return threeDSRequestorURL
  **/
  @ApiModelProperty(value = "URL of the (customer service) website that will be shown to the shopper in case of technical errors during the 3D Secure 2 process.")
  @JsonProperty(JSON_PROPERTY_THREE_D_S_REQUESTOR_U_R_L)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getThreeDSRequestorURL() {
    return threeDSRequestorURL;
  }


 /**
  * URL of the (customer service) website that will be shown to the shopper in case of technical errors during the 3D Secure 2 process.
  *
  * @param threeDSRequestorURL
  */ 
  @JsonProperty(JSON_PROPERTY_THREE_D_S_REQUESTOR_U_R_L)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThreeDSRequestorURL(String threeDSRequestorURL) {
    this.threeDSRequestorURL = threeDSRequestorURL;
  }


  public ThreeDS2RequestData transType(TransTypeEnum transType) {
    this.transType = transType;
    return this;
  }

   /**
   * Identifies the type of transaction being authenticated. Length: 2 characters. Allowed values: * **01** — Goods/Service Purchase * **03** — Check Acceptance * **10** — Account Funding * **11** — Quasi-Cash Transaction * **28** — Prepaid Activation and Load
   * @return transType
  **/
  @ApiModelProperty(value = "Identifies the type of transaction being authenticated. Length: 2 characters. Allowed values: * **01** — Goods/Service Purchase * **03** — Check Acceptance * **10** — Account Funding * **11** — Quasi-Cash Transaction * **28** — Prepaid Activation and Load")
  @JsonProperty(JSON_PROPERTY_TRANS_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TransTypeEnum getTransType() {
    return transType;
  }


 /**
  * Identifies the type of transaction being authenticated. Length: 2 characters. Allowed values: * **01** — Goods/Service Purchase * **03** — Check Acceptance * **10** — Account Funding * **11** — Quasi-Cash Transaction * **28** — Prepaid Activation and Load
  *
  * @param transType
  */ 
  @JsonProperty(JSON_PROPERTY_TRANS_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransType(TransTypeEnum transType) {
    this.transType = transType;
  }


  public ThreeDS2RequestData transactionType(TransactionTypeEnum transactionType) {
    this.transactionType = transactionType;
    return this;
  }

   /**
   * Identify the type of the transaction being authenticated.
   * @return transactionType
  **/
  @ApiModelProperty(value = "Identify the type of the transaction being authenticated.")
  @JsonProperty(JSON_PROPERTY_TRANSACTION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TransactionTypeEnum getTransactionType() {
    return transactionType;
  }


 /**
  * Identify the type of the transaction being authenticated.
  *
  * @param transactionType
  */ 
  @JsonProperty(JSON_PROPERTY_TRANSACTION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransactionType(TransactionTypeEnum transactionType) {
    this.transactionType = transactionType;
  }


  public ThreeDS2RequestData whiteListStatus(String whiteListStatus) {
    this.whiteListStatus = whiteListStatus;
    return this;
  }

   /**
   * The &#x60;whiteListStatus&#x60; value returned from a previous 3D Secure 2 transaction, only applicable for 3D Secure 2 protocol version 2.2.0.
   * @return whiteListStatus
  **/
  @ApiModelProperty(value = "The `whiteListStatus` value returned from a previous 3D Secure 2 transaction, only applicable for 3D Secure 2 protocol version 2.2.0.")
  @JsonProperty(JSON_PROPERTY_WHITE_LIST_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getWhiteListStatus() {
    return whiteListStatus;
  }


 /**
  * The &#x60;whiteListStatus&#x60; value returned from a previous 3D Secure 2 transaction, only applicable for 3D Secure 2 protocol version 2.2.0.
  *
  * @param whiteListStatus
  */ 
  @JsonProperty(JSON_PROPERTY_WHITE_LIST_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWhiteListStatus(String whiteListStatus) {
    this.whiteListStatus = whiteListStatus;
  }


  public ThreeDS2RequestData workPhone(Phone workPhone) {
    this.workPhone = workPhone;
    return this;
  }

   /**
   * Get workPhone
   * @return workPhone
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_WORK_PHONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Phone getWorkPhone() {
    return workPhone;
  }


 /**
  * workPhone
  *
  * @param workPhone
  */ 
  @JsonProperty(JSON_PROPERTY_WORK_PHONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWorkPhone(Phone workPhone) {
    this.workPhone = workPhone;
  }


  /**
   * Return true if this ThreeDS2RequestData object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ThreeDS2RequestData threeDS2RequestData = (ThreeDS2RequestData) o;
    return Objects.equals(this.acctInfo, threeDS2RequestData.acctInfo) &&
        Objects.equals(this.acctType, threeDS2RequestData.acctType) &&
        Objects.equals(this.acquirerBIN, threeDS2RequestData.acquirerBIN) &&
        Objects.equals(this.acquirerMerchantID, threeDS2RequestData.acquirerMerchantID) &&
        Objects.equals(this.addrMatch, threeDS2RequestData.addrMatch) &&
        Objects.equals(this.authenticationOnly, threeDS2RequestData.authenticationOnly) &&
        Objects.equals(this.challengeIndicator, threeDS2RequestData.challengeIndicator) &&
        Objects.equals(this.deviceChannel, threeDS2RequestData.deviceChannel) &&
        Objects.equals(this.deviceRenderOptions, threeDS2RequestData.deviceRenderOptions) &&
        Objects.equals(this.homePhone, threeDS2RequestData.homePhone) &&
        Objects.equals(this.mcc, threeDS2RequestData.mcc) &&
        Objects.equals(this.merchantName, threeDS2RequestData.merchantName) &&
        Objects.equals(this.messageVersion, threeDS2RequestData.messageVersion) &&
        Objects.equals(this.mobilePhone, threeDS2RequestData.mobilePhone) &&
        Objects.equals(this.notificationURL, threeDS2RequestData.notificationURL) &&
        Objects.equals(this.payTokenInd, threeDS2RequestData.payTokenInd) &&
        Objects.equals(this.paymentAuthenticationUseCase, threeDS2RequestData.paymentAuthenticationUseCase) &&
        Objects.equals(this.purchaseInstalData, threeDS2RequestData.purchaseInstalData) &&
        Objects.equals(this.recurringExpiry, threeDS2RequestData.recurringExpiry) &&
        Objects.equals(this.recurringFrequency, threeDS2RequestData.recurringFrequency) &&
        Objects.equals(this.sdkAppID, threeDS2RequestData.sdkAppID) &&
        Objects.equals(this.sdkEncData, threeDS2RequestData.sdkEncData) &&
        Objects.equals(this.sdkEphemPubKey, threeDS2RequestData.sdkEphemPubKey) &&
        Objects.equals(this.sdkMaxTimeout, threeDS2RequestData.sdkMaxTimeout) &&
        Objects.equals(this.sdkReferenceNumber, threeDS2RequestData.sdkReferenceNumber) &&
        Objects.equals(this.sdkTransID, threeDS2RequestData.sdkTransID) &&
        Objects.equals(this.sdkVersion, threeDS2RequestData.sdkVersion) &&
        Objects.equals(this.threeDSCompInd, threeDS2RequestData.threeDSCompInd) &&
        Objects.equals(this.threeDSRequestorAuthenticationInd, threeDS2RequestData.threeDSRequestorAuthenticationInd) &&
        Objects.equals(this.threeDSRequestorAuthenticationInfo, threeDS2RequestData.threeDSRequestorAuthenticationInfo) &&
        Objects.equals(this.threeDSRequestorChallengeInd, threeDS2RequestData.threeDSRequestorChallengeInd) &&
        Objects.equals(this.threeDSRequestorID, threeDS2RequestData.threeDSRequestorID) &&
        Objects.equals(this.threeDSRequestorName, threeDS2RequestData.threeDSRequestorName) &&
        Objects.equals(this.threeDSRequestorPriorAuthenticationInfo, threeDS2RequestData.threeDSRequestorPriorAuthenticationInfo) &&
        Objects.equals(this.threeDSRequestorURL, threeDS2RequestData.threeDSRequestorURL) &&
        Objects.equals(this.transType, threeDS2RequestData.transType) &&
        Objects.equals(this.transactionType, threeDS2RequestData.transactionType) &&
        Objects.equals(this.whiteListStatus, threeDS2RequestData.whiteListStatus) &&
        Objects.equals(this.workPhone, threeDS2RequestData.workPhone);
  }

  @Override
  public int hashCode() {
    return Objects.hash(acctInfo, acctType, acquirerBIN, acquirerMerchantID, addrMatch, authenticationOnly, challengeIndicator, deviceChannel, deviceRenderOptions, homePhone, mcc, merchantName, messageVersion, mobilePhone, notificationURL, payTokenInd, paymentAuthenticationUseCase, purchaseInstalData, recurringExpiry, recurringFrequency, sdkAppID, sdkEncData, sdkEphemPubKey, sdkMaxTimeout, sdkReferenceNumber, sdkTransID, sdkVersion, threeDSCompInd, threeDSRequestorAuthenticationInd, threeDSRequestorAuthenticationInfo, threeDSRequestorChallengeInd, threeDSRequestorID, threeDSRequestorName, threeDSRequestorPriorAuthenticationInfo, threeDSRequestorURL, transType, transactionType, whiteListStatus, workPhone);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ThreeDS2RequestData {\n");
    sb.append("    acctInfo: ").append(toIndentedString(acctInfo)).append("\n");
    sb.append("    acctType: ").append(toIndentedString(acctType)).append("\n");
    sb.append("    acquirerBIN: ").append(toIndentedString(acquirerBIN)).append("\n");
    sb.append("    acquirerMerchantID: ").append(toIndentedString(acquirerMerchantID)).append("\n");
    sb.append("    addrMatch: ").append(toIndentedString(addrMatch)).append("\n");
    sb.append("    authenticationOnly: ").append(toIndentedString(authenticationOnly)).append("\n");
    sb.append("    challengeIndicator: ").append(toIndentedString(challengeIndicator)).append("\n");
    sb.append("    deviceChannel: ").append(toIndentedString(deviceChannel)).append("\n");
    sb.append("    deviceRenderOptions: ").append(toIndentedString(deviceRenderOptions)).append("\n");
    sb.append("    homePhone: ").append(toIndentedString(homePhone)).append("\n");
    sb.append("    mcc: ").append(toIndentedString(mcc)).append("\n");
    sb.append("    merchantName: ").append(toIndentedString(merchantName)).append("\n");
    sb.append("    messageVersion: ").append(toIndentedString(messageVersion)).append("\n");
    sb.append("    mobilePhone: ").append(toIndentedString(mobilePhone)).append("\n");
    sb.append("    notificationURL: ").append(toIndentedString(notificationURL)).append("\n");
    sb.append("    payTokenInd: ").append(toIndentedString(payTokenInd)).append("\n");
    sb.append("    paymentAuthenticationUseCase: ").append(toIndentedString(paymentAuthenticationUseCase)).append("\n");
    sb.append("    purchaseInstalData: ").append(toIndentedString(purchaseInstalData)).append("\n");
    sb.append("    recurringExpiry: ").append(toIndentedString(recurringExpiry)).append("\n");
    sb.append("    recurringFrequency: ").append(toIndentedString(recurringFrequency)).append("\n");
    sb.append("    sdkAppID: ").append(toIndentedString(sdkAppID)).append("\n");
    sb.append("    sdkEncData: ").append(toIndentedString(sdkEncData)).append("\n");
    sb.append("    sdkEphemPubKey: ").append(toIndentedString(sdkEphemPubKey)).append("\n");
    sb.append("    sdkMaxTimeout: ").append(toIndentedString(sdkMaxTimeout)).append("\n");
    sb.append("    sdkReferenceNumber: ").append(toIndentedString(sdkReferenceNumber)).append("\n");
    sb.append("    sdkTransID: ").append(toIndentedString(sdkTransID)).append("\n");
    sb.append("    sdkVersion: ").append(toIndentedString(sdkVersion)).append("\n");
    sb.append("    threeDSCompInd: ").append(toIndentedString(threeDSCompInd)).append("\n");
    sb.append("    threeDSRequestorAuthenticationInd: ").append(toIndentedString(threeDSRequestorAuthenticationInd)).append("\n");
    sb.append("    threeDSRequestorAuthenticationInfo: ").append(toIndentedString(threeDSRequestorAuthenticationInfo)).append("\n");
    sb.append("    threeDSRequestorChallengeInd: ").append(toIndentedString(threeDSRequestorChallengeInd)).append("\n");
    sb.append("    threeDSRequestorID: ").append(toIndentedString(threeDSRequestorID)).append("\n");
    sb.append("    threeDSRequestorName: ").append(toIndentedString(threeDSRequestorName)).append("\n");
    sb.append("    threeDSRequestorPriorAuthenticationInfo: ").append(toIndentedString(threeDSRequestorPriorAuthenticationInfo)).append("\n");
    sb.append("    threeDSRequestorURL: ").append(toIndentedString(threeDSRequestorURL)).append("\n");
    sb.append("    transType: ").append(toIndentedString(transType)).append("\n");
    sb.append("    transactionType: ").append(toIndentedString(transactionType)).append("\n");
    sb.append("    whiteListStatus: ").append(toIndentedString(whiteListStatus)).append("\n");
    sb.append("    workPhone: ").append(toIndentedString(workPhone)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of ThreeDS2RequestData given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of ThreeDS2RequestData
   * @throws JsonProcessingException if the JSON string is invalid with respect to ThreeDS2RequestData
   */
  public static ThreeDS2RequestData fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, ThreeDS2RequestData.class);
  }
/**
  * Convert an instance of ThreeDS2RequestData to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

