/*
 * POS Terminal Management API
 *
 * The version of the OpenAPI document: 1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.posterminalmanagement;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.posterminalmanagement.Address;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * Store
 */
@JsonPropertyOrder({
  Store.JSON_PROPERTY_ADDRESS,
  Store.JSON_PROPERTY_DESCRIPTION,
  Store.JSON_PROPERTY_IN_STORE_TERMINALS,
  Store.JSON_PROPERTY_MERCHANT_ACCOUNT_CODE,
  Store.JSON_PROPERTY_STATUS,
  Store.JSON_PROPERTY_STORE
})

public class Store {
  public static final String JSON_PROPERTY_ADDRESS = "address";
  private Address address;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_IN_STORE_TERMINALS = "inStoreTerminals";
  private List<String> inStoreTerminals = null;

  public static final String JSON_PROPERTY_MERCHANT_ACCOUNT_CODE = "merchantAccountCode";
  private String merchantAccountCode;

  public static final String JSON_PROPERTY_STATUS = "status";
  private String status;

  public static final String JSON_PROPERTY_STORE = "store";
  private String store;

  public Store() { 
  }

  public Store address(Address address) {
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Address getAddress() {
    return address;
  }


 /**
  * address
  *
  * @param address
  */ 
  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress(Address address) {
    this.address = address;
  }


  public Store description(String description) {
    this.description = description;
    return this;
  }

   /**
   * The description of the store.
   * @return description
  **/
  @ApiModelProperty(value = "The description of the store.")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


 /**
  * The description of the store.
  *
  * @param description
  */ 
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public Store inStoreTerminals(List<String> inStoreTerminals) {
    this.inStoreTerminals = inStoreTerminals;
    return this;
  }

  public Store addInStoreTerminalsItem(String inStoreTerminalsItem) {
    if (this.inStoreTerminals == null) {
      this.inStoreTerminals = new ArrayList<>();
    }
    this.inStoreTerminals.add(inStoreTerminalsItem);
    return this;
  }

   /**
   * The list of terminals assigned to the store.
   * @return inStoreTerminals
  **/
  @ApiModelProperty(value = "The list of terminals assigned to the store.")
  @JsonProperty(JSON_PROPERTY_IN_STORE_TERMINALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getInStoreTerminals() {
    return inStoreTerminals;
  }


 /**
  * The list of terminals assigned to the store.
  *
  * @param inStoreTerminals
  */ 
  @JsonProperty(JSON_PROPERTY_IN_STORE_TERMINALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInStoreTerminals(List<String> inStoreTerminals) {
    this.inStoreTerminals = inStoreTerminals;
  }


  public Store merchantAccountCode(String merchantAccountCode) {
    this.merchantAccountCode = merchantAccountCode;
    return this;
  }

   /**
   * The code of the merchant account.
   * @return merchantAccountCode
  **/
  @ApiModelProperty(value = "The code of the merchant account.")
  @JsonProperty(JSON_PROPERTY_MERCHANT_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMerchantAccountCode() {
    return merchantAccountCode;
  }


 /**
  * The code of the merchant account.
  *
  * @param merchantAccountCode
  */ 
  @JsonProperty(JSON_PROPERTY_MERCHANT_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantAccountCode(String merchantAccountCode) {
    this.merchantAccountCode = merchantAccountCode;
  }


  public Store status(String status) {
    this.status = status;
    return this;
  }

   /**
   * The status of the store:  - &#x60;PreActive&#x60;: the store has been created, but not yet activated.   - &#x60;Active&#x60;: the store has been activated. This means you can process payments for this store.   - &#x60;Inactive&#x60;: the store is currently not active.   - &#x60;InactiveWithModifications&#x60;: the store is currently not active, but payment modifications such as refunds are possible.   - &#x60;Closed&#x60;: the store has been closed. 
   * @return status
  **/
  @ApiModelProperty(value = "The status of the store:  - `PreActive`: the store has been created, but not yet activated.   - `Active`: the store has been activated. This means you can process payments for this store.   - `Inactive`: the store is currently not active.   - `InactiveWithModifications`: the store is currently not active, but payment modifications such as refunds are possible.   - `Closed`: the store has been closed. ")
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStatus() {
    return status;
  }


 /**
  * The status of the store:  - &#x60;PreActive&#x60;: the store has been created, but not yet activated.   - &#x60;Active&#x60;: the store has been activated. This means you can process payments for this store.   - &#x60;Inactive&#x60;: the store is currently not active.   - &#x60;InactiveWithModifications&#x60;: the store is currently not active, but payment modifications such as refunds are possible.   - &#x60;Closed&#x60;: the store has been closed. 
  *
  * @param status
  */ 
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(String status) {
    this.status = status;
  }


  public Store store(String store) {
    this.store = store;
    return this;
  }

   /**
   * The code of the store.
   * @return store
  **/
  @ApiModelProperty(required = true, value = "The code of the store.")
  @JsonProperty(JSON_PROPERTY_STORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStore() {
    return store;
  }


 /**
  * The code of the store.
  *
  * @param store
  */ 
  @JsonProperty(JSON_PROPERTY_STORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStore(String store) {
    this.store = store;
  }


  /**
   * Return true if this Store object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Store store = (Store) o;
    return Objects.equals(this.address, store.address) &&
        Objects.equals(this.description, store.description) &&
        Objects.equals(this.inStoreTerminals, store.inStoreTerminals) &&
        Objects.equals(this.merchantAccountCode, store.merchantAccountCode) &&
        Objects.equals(this.status, store.status) &&
        Objects.equals(this.store, store.store);
  }

  @Override
  public int hashCode() {
    return Objects.hash(address, description, inStoreTerminals, merchantAccountCode, status, store);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Store {\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    inStoreTerminals: ").append(toIndentedString(inStoreTerminals)).append("\n");
    sb.append("    merchantAccountCode: ").append(toIndentedString(merchantAccountCode)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    store: ").append(toIndentedString(store)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of Store given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Store
   * @throws JsonProcessingException if the JSON string is invalid with respect to Store
   */
  public static Store fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, Store.class);
  }
/**
  * Convert an instance of Store to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

