/*
 * Authentication webhooks
 *
 * The version of the OpenAPI document: 1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.acswebhooks;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.acswebhooks.AuthenticationInfo;
import com.adyen.model.acswebhooks.PurchaseInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * AuthenticationNotificationData
 */
@JsonPropertyOrder({
  AuthenticationNotificationData.JSON_PROPERTY_AUTHENTICATION,
  AuthenticationNotificationData.JSON_PROPERTY_BALANCE_PLATFORM,
  AuthenticationNotificationData.JSON_PROPERTY_ID,
  AuthenticationNotificationData.JSON_PROPERTY_PAYMENT_INSTRUMENT_ID,
  AuthenticationNotificationData.JSON_PROPERTY_PURCHASE,
  AuthenticationNotificationData.JSON_PROPERTY_STATUS
})

public class AuthenticationNotificationData {
  public static final String JSON_PROPERTY_AUTHENTICATION = "authentication";
  private AuthenticationInfo authentication;

  public static final String JSON_PROPERTY_BALANCE_PLATFORM = "balancePlatform";
  private String balancePlatform;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_PAYMENT_INSTRUMENT_ID = "paymentInstrumentId";
  private String paymentInstrumentId;

  public static final String JSON_PROPERTY_PURCHASE = "purchase";
  private PurchaseInfo purchase;

  /**
   * Outcome of the authentication. Allowed values: * authenticated * rejected * error
   */
  public enum StatusEnum {
    AUTHENTICATED("authenticated"),
    
    REJECTED("rejected"),
    
    ERROR("error");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  public AuthenticationNotificationData() { 
  }

  public AuthenticationNotificationData authentication(AuthenticationInfo authentication) {
    this.authentication = authentication;
    return this;
  }

   /**
   * Get authentication
   * @return authentication
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_AUTHENTICATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AuthenticationInfo getAuthentication() {
    return authentication;
  }


 /**
  * authentication
  *
  * @param authentication
  */ 
  @JsonProperty(JSON_PROPERTY_AUTHENTICATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAuthentication(AuthenticationInfo authentication) {
    this.authentication = authentication;
  }


  public AuthenticationNotificationData balancePlatform(String balancePlatform) {
    this.balancePlatform = balancePlatform;
    return this;
  }

   /**
   * The unique identifier of the balance platform.
   * @return balancePlatform
  **/
  @ApiModelProperty(value = "The unique identifier of the balance platform.")
  @JsonProperty(JSON_PROPERTY_BALANCE_PLATFORM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBalancePlatform() {
    return balancePlatform;
  }


 /**
  * The unique identifier of the balance platform.
  *
  * @param balancePlatform
  */ 
  @JsonProperty(JSON_PROPERTY_BALANCE_PLATFORM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBalancePlatform(String balancePlatform) {
    this.balancePlatform = balancePlatform;
  }


  public AuthenticationNotificationData id(String id) {
    this.id = id;
    return this;
  }

   /**
   * Unique identifier of the authentication.
   * @return id
  **/
  @ApiModelProperty(required = true, value = "Unique identifier of the authentication.")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


 /**
  * Unique identifier of the authentication.
  *
  * @param id
  */ 
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public AuthenticationNotificationData paymentInstrumentId(String paymentInstrumentId) {
    this.paymentInstrumentId = paymentInstrumentId;
    return this;
  }

   /**
   * Unique identifier of the payment instrument that was used for the authentication.
   * @return paymentInstrumentId
  **/
  @ApiModelProperty(required = true, value = "Unique identifier of the payment instrument that was used for the authentication.")
  @JsonProperty(JSON_PROPERTY_PAYMENT_INSTRUMENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPaymentInstrumentId() {
    return paymentInstrumentId;
  }


 /**
  * Unique identifier of the payment instrument that was used for the authentication.
  *
  * @param paymentInstrumentId
  */ 
  @JsonProperty(JSON_PROPERTY_PAYMENT_INSTRUMENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentInstrumentId(String paymentInstrumentId) {
    this.paymentInstrumentId = paymentInstrumentId;
  }


  public AuthenticationNotificationData purchase(PurchaseInfo purchase) {
    this.purchase = purchase;
    return this;
  }

   /**
   * Get purchase
   * @return purchase
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_PURCHASE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PurchaseInfo getPurchase() {
    return purchase;
  }


 /**
  * purchase
  *
  * @param purchase
  */ 
  @JsonProperty(JSON_PROPERTY_PURCHASE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPurchase(PurchaseInfo purchase) {
    this.purchase = purchase;
  }


  public AuthenticationNotificationData status(StatusEnum status) {
    this.status = status;
    return this;
  }

   /**
   * Outcome of the authentication. Allowed values: * authenticated * rejected * error
   * @return status
  **/
  @ApiModelProperty(required = true, value = "Outcome of the authentication. Allowed values: * authenticated * rejected * error")
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StatusEnum getStatus() {
    return status;
  }


 /**
  * Outcome of the authentication. Allowed values: * authenticated * rejected * error
  *
  * @param status
  */ 
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  /**
   * Return true if this AuthenticationNotificationData object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AuthenticationNotificationData authenticationNotificationData = (AuthenticationNotificationData) o;
    return Objects.equals(this.authentication, authenticationNotificationData.authentication) &&
        Objects.equals(this.balancePlatform, authenticationNotificationData.balancePlatform) &&
        Objects.equals(this.id, authenticationNotificationData.id) &&
        Objects.equals(this.paymentInstrumentId, authenticationNotificationData.paymentInstrumentId) &&
        Objects.equals(this.purchase, authenticationNotificationData.purchase) &&
        Objects.equals(this.status, authenticationNotificationData.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(authentication, balancePlatform, id, paymentInstrumentId, purchase, status);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AuthenticationNotificationData {\n");
    sb.append("    authentication: ").append(toIndentedString(authentication)).append("\n");
    sb.append("    balancePlatform: ").append(toIndentedString(balancePlatform)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    paymentInstrumentId: ").append(toIndentedString(paymentInstrumentId)).append("\n");
    sb.append("    purchase: ").append(toIndentedString(purchase)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of AuthenticationNotificationData given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of AuthenticationNotificationData
   * @throws JsonProcessingException if the JSON string is invalid with respect to AuthenticationNotificationData
   */
  public static AuthenticationNotificationData fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, AuthenticationNotificationData.class);
  }
/**
  * Convert an instance of AuthenticationNotificationData to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

