/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.legalentitymanagement;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * CALocalAccountIdentification
 */
@JsonPropertyOrder({
  CALocalAccountIdentification.JSON_PROPERTY_ACCOUNT_NUMBER,
  CALocalAccountIdentification.JSON_PROPERTY_ACCOUNT_TYPE,
  CALocalAccountIdentification.JSON_PROPERTY_FORM_FACTOR,
  CALocalAccountIdentification.JSON_PROPERTY_INSTITUTION_NUMBER,
  CALocalAccountIdentification.JSON_PROPERTY_TRANSIT_NUMBER,
  CALocalAccountIdentification.JSON_PROPERTY_TYPE
})

public class CALocalAccountIdentification {
  public static final String JSON_PROPERTY_ACCOUNT_NUMBER = "accountNumber";
  private String accountNumber;

  /**
   * The bank account type.  Possible values: **checking** or **savings**. Defaults to **checking**.
   */
  public enum AccountTypeEnum {
    CHECKING("checking"),
    
    SAVINGS("savings");

    private String value;

    AccountTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static AccountTypeEnum fromValue(String value) {
      for (AccountTypeEnum b : AccountTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ACCOUNT_TYPE = "accountType";
  private AccountTypeEnum accountType = AccountTypeEnum.CHECKING;

  public static final String JSON_PROPERTY_FORM_FACTOR = "formFactor";
  private String formFactor = "physical";

  public static final String JSON_PROPERTY_INSTITUTION_NUMBER = "institutionNumber";
  private String institutionNumber;

  public static final String JSON_PROPERTY_TRANSIT_NUMBER = "transitNumber";
  private String transitNumber;

  /**
   * **caLocal**
   */
  public enum TypeEnum {
    CALOCAL("caLocal");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type = TypeEnum.CALOCAL;

  public CALocalAccountIdentification() { 
  }

  public CALocalAccountIdentification accountNumber(String accountNumber) {
    this.accountNumber = accountNumber;
    return this;
  }

   /**
   * The 5- to 12-digit bank account number, without separators or whitespace.
   * @return accountNumber
  **/
  @ApiModelProperty(required = true, value = "The 5- to 12-digit bank account number, without separators or whitespace.")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAccountNumber() {
    return accountNumber;
  }


 /**
  * The 5- to 12-digit bank account number, without separators or whitespace.
  *
  * @param accountNumber
  */ 
  @JsonProperty(JSON_PROPERTY_ACCOUNT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountNumber(String accountNumber) {
    this.accountNumber = accountNumber;
  }


  public CALocalAccountIdentification accountType(AccountTypeEnum accountType) {
    this.accountType = accountType;
    return this;
  }

   /**
   * The bank account type.  Possible values: **checking** or **savings**. Defaults to **checking**.
   * @return accountType
  **/
  @ApiModelProperty(value = "The bank account type.  Possible values: **checking** or **savings**. Defaults to **checking**.")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AccountTypeEnum getAccountType() {
    return accountType;
  }


 /**
  * The bank account type.  Possible values: **checking** or **savings**. Defaults to **checking**.
  *
  * @param accountType
  */ 
  @JsonProperty(JSON_PROPERTY_ACCOUNT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountType(AccountTypeEnum accountType) {
    this.accountType = accountType;
  }


  public CALocalAccountIdentification formFactor(String formFactor) {
    this.formFactor = formFactor;
    return this;
  }

   /**
   * Business accounts with a &#x60;formFactor&#x60; value of **physical** are business accounts issued under the central bank of that country. The default value is **physical** for NL, US, and UK business accounts.   Adyen creates a local IBAN for business accounts when the &#x60;formFactor&#x60;å value is set to **virtual**. The local IBANs that are supported are for DE and FR, which reference a physical NL account, with funds being routed through the central bank of NL.
   * @return formFactor
  **/
  @ApiModelProperty(value = "Business accounts with a `formFactor` value of **physical** are business accounts issued under the central bank of that country. The default value is **physical** for NL, US, and UK business accounts.   Adyen creates a local IBAN for business accounts when the `formFactor`å value is set to **virtual**. The local IBANs that are supported are for DE and FR, which reference a physical NL account, with funds being routed through the central bank of NL.")
  @JsonProperty(JSON_PROPERTY_FORM_FACTOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFormFactor() {
    return formFactor;
  }


 /**
  * Business accounts with a &#x60;formFactor&#x60; value of **physical** are business accounts issued under the central bank of that country. The default value is **physical** for NL, US, and UK business accounts.   Adyen creates a local IBAN for business accounts when the &#x60;formFactor&#x60;å value is set to **virtual**. The local IBANs that are supported are for DE and FR, which reference a physical NL account, with funds being routed through the central bank of NL.
  *
  * @param formFactor
  */ 
  @JsonProperty(JSON_PROPERTY_FORM_FACTOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFormFactor(String formFactor) {
    this.formFactor = formFactor;
  }


  public CALocalAccountIdentification institutionNumber(String institutionNumber) {
    this.institutionNumber = institutionNumber;
    return this;
  }

   /**
   * The 3-digit institution number, without separators or whitespace.
   * @return institutionNumber
  **/
  @ApiModelProperty(required = true, value = "The 3-digit institution number, without separators or whitespace.")
  @JsonProperty(JSON_PROPERTY_INSTITUTION_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getInstitutionNumber() {
    return institutionNumber;
  }


 /**
  * The 3-digit institution number, without separators or whitespace.
  *
  * @param institutionNumber
  */ 
  @JsonProperty(JSON_PROPERTY_INSTITUTION_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInstitutionNumber(String institutionNumber) {
    this.institutionNumber = institutionNumber;
  }


  public CALocalAccountIdentification transitNumber(String transitNumber) {
    this.transitNumber = transitNumber;
    return this;
  }

   /**
   * The 5-digit transit number, without separators or whitespace.
   * @return transitNumber
  **/
  @ApiModelProperty(required = true, value = "The 5-digit transit number, without separators or whitespace.")
  @JsonProperty(JSON_PROPERTY_TRANSIT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTransitNumber() {
    return transitNumber;
  }


 /**
  * The 5-digit transit number, without separators or whitespace.
  *
  * @param transitNumber
  */ 
  @JsonProperty(JSON_PROPERTY_TRANSIT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransitNumber(String transitNumber) {
    this.transitNumber = transitNumber;
  }


  public CALocalAccountIdentification type(TypeEnum type) {
    this.type = type;
    return this;
  }

   /**
   * **caLocal**
   * @return type
  **/
  @ApiModelProperty(required = true, value = "**caLocal**")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


 /**
  * **caLocal**
  *
  * @param type
  */ 
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  /**
   * Return true if this CALocalAccountIdentification object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CALocalAccountIdentification caLocalAccountIdentification = (CALocalAccountIdentification) o;
    return Objects.equals(this.accountNumber, caLocalAccountIdentification.accountNumber) &&
        Objects.equals(this.accountType, caLocalAccountIdentification.accountType) &&
        Objects.equals(this.formFactor, caLocalAccountIdentification.formFactor) &&
        Objects.equals(this.institutionNumber, caLocalAccountIdentification.institutionNumber) &&
        Objects.equals(this.transitNumber, caLocalAccountIdentification.transitNumber) &&
        Objects.equals(this.type, caLocalAccountIdentification.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountNumber, accountType, formFactor, institutionNumber, transitNumber, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CALocalAccountIdentification {\n");
    sb.append("    accountNumber: ").append(toIndentedString(accountNumber)).append("\n");
    sb.append("    accountType: ").append(toIndentedString(accountType)).append("\n");
    sb.append("    formFactor: ").append(toIndentedString(formFactor)).append("\n");
    sb.append("    institutionNumber: ").append(toIndentedString(institutionNumber)).append("\n");
    sb.append("    transitNumber: ").append(toIndentedString(transitNumber)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of CALocalAccountIdentification given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of CALocalAccountIdentification
   * @throws JsonProcessingException if the JSON string is invalid with respect to CALocalAccountIdentification
   */
  public static CALocalAccountIdentification fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, CALocalAccountIdentification.class);
  }
/**
  * Convert an instance of CALocalAccountIdentification to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

