/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.management;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * Commission
 */
@JsonPropertyOrder({
  Commission.JSON_PROPERTY_FIXED_AMOUNT,
  Commission.JSON_PROPERTY_VARIABLE_PERCENTAGE
})

public class Commission {
  public static final String JSON_PROPERTY_FIXED_AMOUNT = "fixedAmount";
  private Long fixedAmount;

  public static final String JSON_PROPERTY_VARIABLE_PERCENTAGE = "variablePercentage";
  private Long variablePercentage;

  public Commission() { 
  }

  public Commission fixedAmount(Long fixedAmount) {
    this.fixedAmount = fixedAmount;
    return this;
  }

   /**
   * A fixed commission fee, in minor units.
   * @return fixedAmount
  **/
  @ApiModelProperty(value = "A fixed commission fee, in minor units.")
  @JsonProperty(JSON_PROPERTY_FIXED_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getFixedAmount() {
    return fixedAmount;
  }


 /**
  * A fixed commission fee, in minor units.
  *
  * @param fixedAmount
  */ 
  @JsonProperty(JSON_PROPERTY_FIXED_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFixedAmount(Long fixedAmount) {
    this.fixedAmount = fixedAmount;
  }


  public Commission variablePercentage(Long variablePercentage) {
    this.variablePercentage = variablePercentage;
    return this;
  }

   /**
   * A variable commission fee, in basis points.
   * @return variablePercentage
  **/
  @ApiModelProperty(value = "A variable commission fee, in basis points.")
  @JsonProperty(JSON_PROPERTY_VARIABLE_PERCENTAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getVariablePercentage() {
    return variablePercentage;
  }


 /**
  * A variable commission fee, in basis points.
  *
  * @param variablePercentage
  */ 
  @JsonProperty(JSON_PROPERTY_VARIABLE_PERCENTAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVariablePercentage(Long variablePercentage) {
    this.variablePercentage = variablePercentage;
  }


  /**
   * Return true if this Commission object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Commission commission = (Commission) o;
    return Objects.equals(this.fixedAmount, commission.fixedAmount) &&
        Objects.equals(this.variablePercentage, commission.variablePercentage);
  }

  @Override
  public int hashCode() {
    return Objects.hash(fixedAmount, variablePercentage);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Commission {\n");
    sb.append("    fixedAmount: ").append(toIndentedString(fixedAmount)).append("\n");
    sb.append("    variablePercentage: ").append(toIndentedString(variablePercentage)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of Commission given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Commission
   * @throws JsonProcessingException if the JSON string is invalid with respect to Commission
   */
  public static Commission fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, Commission.class);
  }
/**
  * Convert an instance of Commission to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

