/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.management;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * GooglePayInfo
 */
@JsonPropertyOrder({
  GooglePayInfo.JSON_PROPERTY_MERCHANT_ID,
  GooglePayInfo.JSON_PROPERTY_REUSE_MERCHANT_ID
})

public class GooglePayInfo {
  public static final String JSON_PROPERTY_MERCHANT_ID = "merchantId";
  private String merchantId;

  public static final String JSON_PROPERTY_REUSE_MERCHANT_ID = "reuseMerchantId";
  private Boolean reuseMerchantId;

  public GooglePayInfo() { 
  }

  public GooglePayInfo merchantId(String merchantId) {
    this.merchantId = merchantId;
    return this;
  }

   /**
   * Google Pay [Merchant ID](https://support.google.com/paymentscenter/answer/7163092?hl&#x3D;en). Character length and limitations: 16 alphanumeric characters or 20 numeric characters.
   * @return merchantId
  **/
  @ApiModelProperty(required = true, value = "Google Pay [Merchant ID](https://support.google.com/paymentscenter/answer/7163092?hl=en). Character length and limitations: 16 alphanumeric characters or 20 numeric characters.")
  @JsonProperty(JSON_PROPERTY_MERCHANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMerchantId() {
    return merchantId;
  }


 /**
  * Google Pay [Merchant ID](https://support.google.com/paymentscenter/answer/7163092?hl&#x3D;en). Character length and limitations: 16 alphanumeric characters or 20 numeric characters.
  *
  * @param merchantId
  */ 
  @JsonProperty(JSON_PROPERTY_MERCHANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantId(String merchantId) {
    this.merchantId = merchantId;
  }


  public GooglePayInfo reuseMerchantId(Boolean reuseMerchantId) {
    this.reuseMerchantId = reuseMerchantId;
    return this;
  }

   /**
   * Indicates whether the Google Pay Merchant ID is used for several merchant accounts. Default value: **false**.
   * @return reuseMerchantId
  **/
  @ApiModelProperty(value = "Indicates whether the Google Pay Merchant ID is used for several merchant accounts. Default value: **false**.")
  @JsonProperty(JSON_PROPERTY_REUSE_MERCHANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getReuseMerchantId() {
    return reuseMerchantId;
  }


 /**
  * Indicates whether the Google Pay Merchant ID is used for several merchant accounts. Default value: **false**.
  *
  * @param reuseMerchantId
  */ 
  @JsonProperty(JSON_PROPERTY_REUSE_MERCHANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReuseMerchantId(Boolean reuseMerchantId) {
    this.reuseMerchantId = reuseMerchantId;
  }


  /**
   * Return true if this GooglePayInfo object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GooglePayInfo googlePayInfo = (GooglePayInfo) o;
    return Objects.equals(this.merchantId, googlePayInfo.merchantId) &&
        Objects.equals(this.reuseMerchantId, googlePayInfo.reuseMerchantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(merchantId, reuseMerchantId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GooglePayInfo {\n");
    sb.append("    merchantId: ").append(toIndentedString(merchantId)).append("\n");
    sb.append("    reuseMerchantId: ").append(toIndentedString(reuseMerchantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of GooglePayInfo given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of GooglePayInfo
   * @throws JsonProcessingException if the JSON string is invalid with respect to GooglePayInfo
   */
  public static GooglePayInfo fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, GooglePayInfo.class);
  }
/**
  * Convert an instance of GooglePayInfo to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

