/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.management;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * TerminalReassignmentTarget
 */
@JsonPropertyOrder({
  TerminalReassignmentTarget.JSON_PROPERTY_COMPANY_ID,
  TerminalReassignmentTarget.JSON_PROPERTY_INVENTORY,
  TerminalReassignmentTarget.JSON_PROPERTY_MERCHANT_ID,
  TerminalReassignmentTarget.JSON_PROPERTY_STORE_ID
})

public class TerminalReassignmentTarget {
  public static final String JSON_PROPERTY_COMPANY_ID = "companyId";
  private String companyId;

  public static final String JSON_PROPERTY_INVENTORY = "inventory";
  private Boolean inventory;

  public static final String JSON_PROPERTY_MERCHANT_ID = "merchantId";
  private String merchantId;

  public static final String JSON_PROPERTY_STORE_ID = "storeId";
  private String storeId;

  public TerminalReassignmentTarget() { 
  }

  public TerminalReassignmentTarget companyId(String companyId) {
    this.companyId = companyId;
    return this;
  }

   /**
   * The unique identifier of the company account to which the terminal is reassigned.
   * @return companyId
  **/
  @ApiModelProperty(value = "The unique identifier of the company account to which the terminal is reassigned.")
  @JsonProperty(JSON_PROPERTY_COMPANY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCompanyId() {
    return companyId;
  }


 /**
  * The unique identifier of the company account to which the terminal is reassigned.
  *
  * @param companyId
  */ 
  @JsonProperty(JSON_PROPERTY_COMPANY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCompanyId(String companyId) {
    this.companyId = companyId;
  }


  public TerminalReassignmentTarget inventory(Boolean inventory) {
    this.inventory = inventory;
    return this;
  }

   /**
   * Indicates if the terminal is reassigned to the inventory of the merchant account. - If **true**, the terminal is in the inventory of the merchant account and cannot process transactions. - If **false**, the terminal is reassigned directly to the merchant account and can process transactions.
   * @return inventory
  **/
  @ApiModelProperty(required = true, value = "Indicates if the terminal is reassigned to the inventory of the merchant account. - If **true**, the terminal is in the inventory of the merchant account and cannot process transactions. - If **false**, the terminal is reassigned directly to the merchant account and can process transactions.")
  @JsonProperty(JSON_PROPERTY_INVENTORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getInventory() {
    return inventory;
  }


 /**
  * Indicates if the terminal is reassigned to the inventory of the merchant account. - If **true**, the terminal is in the inventory of the merchant account and cannot process transactions. - If **false**, the terminal is reassigned directly to the merchant account and can process transactions.
  *
  * @param inventory
  */ 
  @JsonProperty(JSON_PROPERTY_INVENTORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInventory(Boolean inventory) {
    this.inventory = inventory;
  }


  public TerminalReassignmentTarget merchantId(String merchantId) {
    this.merchantId = merchantId;
    return this;
  }

   /**
   * The unique identifier of the merchant account to which the terminal is reassigned.
   * @return merchantId
  **/
  @ApiModelProperty(value = "The unique identifier of the merchant account to which the terminal is reassigned.")
  @JsonProperty(JSON_PROPERTY_MERCHANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMerchantId() {
    return merchantId;
  }


 /**
  * The unique identifier of the merchant account to which the terminal is reassigned.
  *
  * @param merchantId
  */ 
  @JsonProperty(JSON_PROPERTY_MERCHANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantId(String merchantId) {
    this.merchantId = merchantId;
  }


  public TerminalReassignmentTarget storeId(String storeId) {
    this.storeId = storeId;
    return this;
  }

   /**
   * The unique identifier of the store to which the terminal is reassigned.
   * @return storeId
  **/
  @ApiModelProperty(value = "The unique identifier of the store to which the terminal is reassigned.")
  @JsonProperty(JSON_PROPERTY_STORE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStoreId() {
    return storeId;
  }


 /**
  * The unique identifier of the store to which the terminal is reassigned.
  *
  * @param storeId
  */ 
  @JsonProperty(JSON_PROPERTY_STORE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStoreId(String storeId) {
    this.storeId = storeId;
  }


  /**
   * Return true if this TerminalReassignmentTarget object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TerminalReassignmentTarget terminalReassignmentTarget = (TerminalReassignmentTarget) o;
    return Objects.equals(this.companyId, terminalReassignmentTarget.companyId) &&
        Objects.equals(this.inventory, terminalReassignmentTarget.inventory) &&
        Objects.equals(this.merchantId, terminalReassignmentTarget.merchantId) &&
        Objects.equals(this.storeId, terminalReassignmentTarget.storeId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(companyId, inventory, merchantId, storeId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TerminalReassignmentTarget {\n");
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    inventory: ").append(toIndentedString(inventory)).append("\n");
    sb.append("    merchantId: ").append(toIndentedString(merchantId)).append("\n");
    sb.append("    storeId: ").append(toIndentedString(storeId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of TerminalReassignmentTarget given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of TerminalReassignmentTarget
   * @throws JsonProcessingException if the JSON string is invalid with respect to TerminalReassignmentTarget
   */
  public static TerminalReassignmentTarget fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, TerminalReassignmentTarget.class);
  }
/**
  * Convert an instance of TerminalReassignmentTarget to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

