/*
 * Notification Configuration API
 * This API is used for the classic integration. If you are just starting your implementation, refer to our [new integration guide](https://docs.adyen.com/marketplaces-and-platforms) instead.  The Notification Configuration API provides endpoints for setting up and testing notifications that inform you of events on your platform, for example when a verification check or a payout has been completed.  For more information, refer to our [documentation](https://docs.adyen.com/marketplaces-and-platforms/classic/notifications). ## Authentication Your Adyen contact will provide your API credential and an API key. To connect to the API, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication. For example:  ``` curl -U \"ws@MarketPlace.YOUR_PLATFORM_ACCOUNT\":\"YOUR_WS_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ``` When going live, you need to generate new web service user credentials to access the [live endpoints](https://docs.adyen.com/development-resources/live-endpoints).  ## Versioning The Notification Configuration API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://cal-test.adyen.com/cal/services/Notification/v6/createNotificationConfiguration ```
 *
 * The version of the OpenAPI document: 6
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.marketpayconfiguration;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * TestNotificationConfigurationRequest
 */
@JsonPropertyOrder({
  TestNotificationConfigurationRequest.JSON_PROPERTY_EVENT_TYPES,
  TestNotificationConfigurationRequest.JSON_PROPERTY_NOTIFICATION_ID
})

public class TestNotificationConfigurationRequest {
  /**
   * Gets or Sets eventTypes
   */
  public enum EventTypesEnum {
    ACCOUNT_CLOSED("ACCOUNT_CLOSED"),
    
    ACCOUNT_CREATED("ACCOUNT_CREATED"),
    
    ACCOUNT_FUNDS_BELOW_THRESHOLD("ACCOUNT_FUNDS_BELOW_THRESHOLD"),
    
    ACCOUNT_HOLDER_CREATED("ACCOUNT_HOLDER_CREATED"),
    
    ACCOUNT_HOLDER_LIMIT_REACHED("ACCOUNT_HOLDER_LIMIT_REACHED"),
    
    ACCOUNT_HOLDER_MIGRATED("ACCOUNT_HOLDER_MIGRATED"),
    
    ACCOUNT_HOLDER_PAYOUT("ACCOUNT_HOLDER_PAYOUT"),
    
    ACCOUNT_HOLDER_STATUS_CHANGE("ACCOUNT_HOLDER_STATUS_CHANGE"),
    
    ACCOUNT_HOLDER_STORE_STATUS_CHANGE("ACCOUNT_HOLDER_STORE_STATUS_CHANGE"),
    
    ACCOUNT_HOLDER_UPCOMING_DEADLINE("ACCOUNT_HOLDER_UPCOMING_DEADLINE"),
    
    ACCOUNT_HOLDER_UPDATED("ACCOUNT_HOLDER_UPDATED"),
    
    ACCOUNT_HOLDER_VERIFICATION("ACCOUNT_HOLDER_VERIFICATION"),
    
    ACCOUNT_UPDATED("ACCOUNT_UPDATED"),
    
    BENEFICIARY_SETUP("BENEFICIARY_SETUP"),
    
    COMPENSATE_NEGATIVE_BALANCE("COMPENSATE_NEGATIVE_BALANCE"),
    
    DIRECT_DEBIT_INITIATED("DIRECT_DEBIT_INITIATED"),
    
    FUNDS_MIGRATED("FUNDS_MIGRATED"),
    
    PAYMENT_FAILURE("PAYMENT_FAILURE"),
    
    PENDING_CREDIT("PENDING_CREDIT"),
    
    REFUND_FUNDS_TRANSFER("REFUND_FUNDS_TRANSFER"),
    
    REPORT_AVAILABLE("REPORT_AVAILABLE"),
    
    SCHEDULED_REFUNDS("SCHEDULED_REFUNDS"),
    
    SCORE_SIGNAL_TRIGGERED("SCORE_SIGNAL_TRIGGERED"),
    
    TRANSFER_FUNDS("TRANSFER_FUNDS"),
    
    TRANSFER_NOT_PAIDOUT_TRANSFERS("TRANSFER_NOT_PAIDOUT_TRANSFERS");

    private String value;

    EventTypesEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static EventTypesEnum fromValue(String value) {
      for (EventTypesEnum b : EventTypesEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_EVENT_TYPES = "eventTypes";
  private List<EventTypesEnum> eventTypes = null;

  public static final String JSON_PROPERTY_NOTIFICATION_ID = "notificationId";
  private Long notificationId;

  public TestNotificationConfigurationRequest() { 
  }

  public TestNotificationConfigurationRequest eventTypes(List<EventTypesEnum> eventTypes) {
    this.eventTypes = eventTypes;
    return this;
  }

  public TestNotificationConfigurationRequest addEventTypesItem(EventTypesEnum eventTypesItem) {
    if (this.eventTypes == null) {
      this.eventTypes = new ArrayList<>();
    }
    this.eventTypes.add(eventTypesItem);
    return this;
  }

   /**
   * The event types to test.  If left blank, then all of the configured event types will be tested. &gt;Permitted values: &#x60;ACCOUNT_HOLDER_CREATED&#x60;, &#x60;ACCOUNT_CREATED&#x60;, &#x60;ACCOUNT_UPDATED&#x60;, &#x60;ACCOUNT_HOLDER_UPDATED&#x60;, &#x60;ACCOUNT_HOLDER_STATUS_CHANGE&#x60;, &#x60;ACCOUNT_HOLDER_STORE_STATUS_CHANGE&#x60; &#x60;ACCOUNT_HOLDER_VERIFICATION&#x60;, &#x60;ACCOUNT_HOLDER_LIMIT_REACHED&#x60;, &#x60;ACCOUNT_HOLDER_PAYOUT&#x60;, &#x60;PAYMENT_FAILURE&#x60;, &#x60;SCHEDULED_REFUNDS&#x60;, &#x60;REPORT_AVAILABLE&#x60;, &#x60;TRANSFER_FUNDS&#x60;, &#x60;BENEFICIARY_SETUP&#x60;, &#x60;COMPENSATE_NEGATIVE_BALANCE&#x60;.
   * @return eventTypes
  **/
  @ApiModelProperty(value = "The event types to test.  If left blank, then all of the configured event types will be tested. >Permitted values: `ACCOUNT_HOLDER_CREATED`, `ACCOUNT_CREATED`, `ACCOUNT_UPDATED`, `ACCOUNT_HOLDER_UPDATED`, `ACCOUNT_HOLDER_STATUS_CHANGE`, `ACCOUNT_HOLDER_STORE_STATUS_CHANGE` `ACCOUNT_HOLDER_VERIFICATION`, `ACCOUNT_HOLDER_LIMIT_REACHED`, `ACCOUNT_HOLDER_PAYOUT`, `PAYMENT_FAILURE`, `SCHEDULED_REFUNDS`, `REPORT_AVAILABLE`, `TRANSFER_FUNDS`, `BENEFICIARY_SETUP`, `COMPENSATE_NEGATIVE_BALANCE`.")
  @JsonProperty(JSON_PROPERTY_EVENT_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<EventTypesEnum> getEventTypes() {
    return eventTypes;
  }


  @JsonProperty(JSON_PROPERTY_EVENT_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEventTypes(List<EventTypesEnum> eventTypes) {
    this.eventTypes = eventTypes;
  }


  public TestNotificationConfigurationRequest notificationId(Long notificationId) {
    this.notificationId = notificationId;
    return this;
  }

   /**
   * The ID of the notification subscription configuration to be tested.
   * @return notificationId
  **/
  @ApiModelProperty(required = true, value = "The ID of the notification subscription configuration to be tested.")
  @JsonProperty(JSON_PROPERTY_NOTIFICATION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getNotificationId() {
    return notificationId;
  }


  @JsonProperty(JSON_PROPERTY_NOTIFICATION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNotificationId(Long notificationId) {
    this.notificationId = notificationId;
  }


  /**
   * Return true if this TestNotificationConfigurationRequest object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TestNotificationConfigurationRequest testNotificationConfigurationRequest = (TestNotificationConfigurationRequest) o;
    return Objects.equals(this.eventTypes, testNotificationConfigurationRequest.eventTypes) &&
        Objects.equals(this.notificationId, testNotificationConfigurationRequest.notificationId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(eventTypes, notificationId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TestNotificationConfigurationRequest {\n");
    sb.append("    eventTypes: ").append(toIndentedString(eventTypes)).append("\n");
    sb.append("    notificationId: ").append(toIndentedString(notificationId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of TestNotificationConfigurationRequest given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of TestNotificationConfigurationRequest
   * @throws JsonProcessingException if the JSON string is invalid with respect to TestNotificationConfigurationRequest
   */
  public static TestNotificationConfigurationRequest fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, TestNotificationConfigurationRequest.class);
  }
/**
  * Convert an instance of TestNotificationConfigurationRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

