/*
 * Classic Platforms - Notifications
 *
 * The version of the OpenAPI document: 6
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.marketpaywebhooks;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.marketpaywebhooks.Transaction;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * RefundResult
 */
@JsonPropertyOrder({
  RefundResult.JSON_PROPERTY_ORIGINAL_TRANSACTION,
  RefundResult.JSON_PROPERTY_PSP_REFERENCE,
  RefundResult.JSON_PROPERTY_RESPONSE
})

public class RefundResult {
  public static final String JSON_PROPERTY_ORIGINAL_TRANSACTION = "originalTransaction";
  private Transaction originalTransaction;

  public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
  private String pspReference;

  public static final String JSON_PROPERTY_RESPONSE = "response";
  private String response;

  public RefundResult() { 
  }

  public RefundResult originalTransaction(Transaction originalTransaction) {
    this.originalTransaction = originalTransaction;
    return this;
  }

   /**
   * Get originalTransaction
   * @return originalTransaction
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ORIGINAL_TRANSACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Transaction getOriginalTransaction() {
    return originalTransaction;
  }


  @JsonProperty(JSON_PROPERTY_ORIGINAL_TRANSACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOriginalTransaction(Transaction originalTransaction) {
    this.originalTransaction = originalTransaction;
  }


  public RefundResult pspReference(String pspReference) {
    this.pspReference = pspReference;
    return this;
  }

   /**
   * The reference of the refund.
   * @return pspReference
  **/
  @ApiModelProperty(value = "The reference of the refund.")
  @JsonProperty(JSON_PROPERTY_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPspReference() {
    return pspReference;
  }


  @JsonProperty(JSON_PROPERTY_PSP_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPspReference(String pspReference) {
    this.pspReference = pspReference;
  }


  public RefundResult response(String response) {
    this.response = response;
    return this;
  }

   /**
   * The response indicating if the refund has been received for processing.
   * @return response
  **/
  @ApiModelProperty(value = "The response indicating if the refund has been received for processing.")
  @JsonProperty(JSON_PROPERTY_RESPONSE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getResponse() {
    return response;
  }


  @JsonProperty(JSON_PROPERTY_RESPONSE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResponse(String response) {
    this.response = response;
  }


  /**
   * Return true if this RefundResult object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RefundResult refundResult = (RefundResult) o;
    return Objects.equals(this.originalTransaction, refundResult.originalTransaction) &&
        Objects.equals(this.pspReference, refundResult.pspReference) &&
        Objects.equals(this.response, refundResult.response);
  }

  @Override
  public int hashCode() {
    return Objects.hash(originalTransaction, pspReference, response);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RefundResult {\n");
    sb.append("    originalTransaction: ").append(toIndentedString(originalTransaction)).append("\n");
    sb.append("    pspReference: ").append(toIndentedString(pspReference)).append("\n");
    sb.append("    response: ").append(toIndentedString(response)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of RefundResult given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of RefundResult
   * @throws JsonProcessingException if the JSON string is invalid with respect to RefundResult
   */
  public static RefundResult fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, RefundResult.class);
  }
/**
  * Convert an instance of RefundResult to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

