/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.management;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.management.AfterpayTouchInfo;
import com.adyen.model.management.ApplePayInfo;
import com.adyen.model.management.BcmcInfo;
import com.adyen.model.management.CartesBancairesInfo;
import com.adyen.model.management.ClearpayInfo;
import com.adyen.model.management.GenericPmWithTdiInfo;
import com.adyen.model.management.GiroPayInfo;
import com.adyen.model.management.GooglePayInfo;
import com.adyen.model.management.KlarnaInfo;
import com.adyen.model.management.MealVoucherFRInfo;
import com.adyen.model.management.PayPalInfo;
import com.adyen.model.management.SofortInfo;
import com.adyen.model.management.SwishInfo;
import com.adyen.model.management.TwintInfo;
import com.adyen.model.management.VippsInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * PaymentMethodSetupInfo
 */
@JsonPropertyOrder({
  PaymentMethodSetupInfo.JSON_PROPERTY_AFTERPAY_TOUCH,
  PaymentMethodSetupInfo.JSON_PROPERTY_APPLE_PAY,
  PaymentMethodSetupInfo.JSON_PROPERTY_BCMC,
  PaymentMethodSetupInfo.JSON_PROPERTY_BUSINESS_LINE_ID,
  PaymentMethodSetupInfo.JSON_PROPERTY_CARTES_BANCAIRES,
  PaymentMethodSetupInfo.JSON_PROPERTY_CLEARPAY,
  PaymentMethodSetupInfo.JSON_PROPERTY_COUNTRIES,
  PaymentMethodSetupInfo.JSON_PROPERTY_CUP,
  PaymentMethodSetupInfo.JSON_PROPERTY_CURRENCIES,
  PaymentMethodSetupInfo.JSON_PROPERTY_CUSTOM_ROUTING_FLAGS,
  PaymentMethodSetupInfo.JSON_PROPERTY_DINERS,
  PaymentMethodSetupInfo.JSON_PROPERTY_DISCOVER,
  PaymentMethodSetupInfo.JSON_PROPERTY_EFTPOS_AUSTRALIA,
  PaymentMethodSetupInfo.JSON_PROPERTY_GIRO_PAY,
  PaymentMethodSetupInfo.JSON_PROPERTY_GIROCARD,
  PaymentMethodSetupInfo.JSON_PROPERTY_GOOGLE_PAY,
  PaymentMethodSetupInfo.JSON_PROPERTY_IDEAL,
  PaymentMethodSetupInfo.JSON_PROPERTY_INTERAC_CARD,
  PaymentMethodSetupInfo.JSON_PROPERTY_JCB,
  PaymentMethodSetupInfo.JSON_PROPERTY_KLARNA,
  PaymentMethodSetupInfo.JSON_PROPERTY_MAESTRO,
  PaymentMethodSetupInfo.JSON_PROPERTY_MC,
  PaymentMethodSetupInfo.JSON_PROPERTY_MEAL_VOUCHER_F_R,
  PaymentMethodSetupInfo.JSON_PROPERTY_PAYPAL,
  PaymentMethodSetupInfo.JSON_PROPERTY_REFERENCE,
  PaymentMethodSetupInfo.JSON_PROPERTY_SHOPPER_INTERACTION,
  PaymentMethodSetupInfo.JSON_PROPERTY_SOFORT,
  PaymentMethodSetupInfo.JSON_PROPERTY_STORE_IDS,
  PaymentMethodSetupInfo.JSON_PROPERTY_SWISH,
  PaymentMethodSetupInfo.JSON_PROPERTY_TWINT,
  PaymentMethodSetupInfo.JSON_PROPERTY_TYPE,
  PaymentMethodSetupInfo.JSON_PROPERTY_VIPPS,
  PaymentMethodSetupInfo.JSON_PROPERTY_VISA
})

public class PaymentMethodSetupInfo {
  public static final String JSON_PROPERTY_AFTERPAY_TOUCH = "afterpayTouch";
  private AfterpayTouchInfo afterpayTouch;

  public static final String JSON_PROPERTY_APPLE_PAY = "applePay";
  private ApplePayInfo applePay;

  public static final String JSON_PROPERTY_BCMC = "bcmc";
  private BcmcInfo bcmc;

  public static final String JSON_PROPERTY_BUSINESS_LINE_ID = "businessLineId";
  private String businessLineId;

  public static final String JSON_PROPERTY_CARTES_BANCAIRES = "cartesBancaires";
  private CartesBancairesInfo cartesBancaires;

  public static final String JSON_PROPERTY_CLEARPAY = "clearpay";
  private ClearpayInfo clearpay;

  public static final String JSON_PROPERTY_COUNTRIES = "countries";
  private List<String> countries = null;

  public static final String JSON_PROPERTY_CUP = "cup";
  private GenericPmWithTdiInfo cup;

  public static final String JSON_PROPERTY_CURRENCIES = "currencies";
  private List<String> currencies = null;

  public static final String JSON_PROPERTY_CUSTOM_ROUTING_FLAGS = "customRoutingFlags";
  private List<String> customRoutingFlags = null;

  public static final String JSON_PROPERTY_DINERS = "diners";
  private GenericPmWithTdiInfo diners;

  public static final String JSON_PROPERTY_DISCOVER = "discover";
  private GenericPmWithTdiInfo discover;

  public static final String JSON_PROPERTY_EFTPOS_AUSTRALIA = "eftpos_australia";
  private GenericPmWithTdiInfo eftposAustralia;

  public static final String JSON_PROPERTY_GIRO_PAY = "giroPay";
  private GiroPayInfo giroPay;

  public static final String JSON_PROPERTY_GIROCARD = "girocard";
  private GenericPmWithTdiInfo girocard;

  public static final String JSON_PROPERTY_GOOGLE_PAY = "googlePay";
  private GooglePayInfo googlePay;

  public static final String JSON_PROPERTY_IDEAL = "ideal";
  private GenericPmWithTdiInfo ideal;

  public static final String JSON_PROPERTY_INTERAC_CARD = "interac_card";
  private GenericPmWithTdiInfo interacCard;

  public static final String JSON_PROPERTY_JCB = "jcb";
  private GenericPmWithTdiInfo jcb;

  public static final String JSON_PROPERTY_KLARNA = "klarna";
  private KlarnaInfo klarna;

  public static final String JSON_PROPERTY_MAESTRO = "maestro";
  private GenericPmWithTdiInfo maestro;

  public static final String JSON_PROPERTY_MC = "mc";
  private GenericPmWithTdiInfo mc;

  public static final String JSON_PROPERTY_MEAL_VOUCHER_F_R = "mealVoucher_FR";
  private MealVoucherFRInfo mealVoucherFR;

  public static final String JSON_PROPERTY_PAYPAL = "paypal";
  private PayPalInfo paypal;

  public static final String JSON_PROPERTY_REFERENCE = "reference";
  private String reference;

  /**
   * The sales channel. Required if the merchant account does not have a sales channel. When you provide this field, it overrides the default sales channel set on the merchant account.  Possible values: **eCommerce**, **pos**, **contAuth**, and **moto**. 
   */
  public enum ShopperInteractionEnum {
    ECOMMERCE("eCommerce"),
    
    POS("pos"),
    
    MOTO("moto"),
    
    CONTAUTH("contAuth");

    private String value;

    ShopperInteractionEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ShopperInteractionEnum fromValue(String value) {
      for (ShopperInteractionEnum b : ShopperInteractionEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SHOPPER_INTERACTION = "shopperInteraction";
  private ShopperInteractionEnum shopperInteraction;

  public static final String JSON_PROPERTY_SOFORT = "sofort";
  private SofortInfo sofort;

  public static final String JSON_PROPERTY_STORE_IDS = "storeIds";
  private List<String> storeIds = null;

  public static final String JSON_PROPERTY_SWISH = "swish";
  private SwishInfo swish;

  public static final String JSON_PROPERTY_TWINT = "twint";
  private TwintInfo twint;

  /**
   * Payment method [variant](https://docs.adyen.com/development-resources/paymentmethodvariant#management-api).
   */
  public enum TypeEnum {
    AFTERPAYTOUCH("afterpaytouch"),
    
    ALIPAY("alipay"),
    
    ALIPAY_HK("alipay_hk"),
    
    AMEX("amex"),
    
    APPLEPAY("applepay"),
    
    BCMC("bcmc"),
    
    BLIK("blik"),
    
    CARTEBANCAIRE("cartebancaire"),
    
    CLEARPAY("clearpay"),
    
    CUP("cup"),
    
    DINERS("diners"),
    
    DIRECTDEBIT_GB("directdebit_GB"),
    
    DISCOVER("discover"),
    
    EBANKING_FI("ebanking_FI"),
    
    EFTPOS_AUSTRALIA("eftpos_australia"),
    
    ELO("elo"),
    
    ELOCREDIT("elocredit"),
    
    ELODEBIT("elodebit"),
    
    GIROCARD("girocard"),
    
    GOOGLEPAY("googlepay"),
    
    HIPER("hiper"),
    
    HIPERCARD("hipercard"),
    
    IDEAL("ideal"),
    
    INTERAC_CARD("interac_card"),
    
    JCB("jcb"),
    
    KLARNA("klarna"),
    
    KLARNA_ACCOUNT("klarna_account"),
    
    KLARNA_PAYNOW("klarna_paynow"),
    
    MAESTRO("maestro"),
    
    MBWAY("mbway"),
    
    MC("mc"),
    
    MCDEBIT("mcdebit"),
    
    MEALVOUCHER_FR("mealVoucher_FR"),
    
    MOBILEPAY("mobilepay"),
    
    MULTIBANCO("multibanco"),
    
    ONLINEBANKING_PL("onlineBanking_PL"),
    
    PAYBYBANK("paybybank"),
    
    PAYPAL("paypal"),
    
    PAYSHOP("payshop"),
    
    SWISH("swish"),
    
    TRUSTLY("trustly"),
    
    TWINT("twint"),
    
    TWINT_POS("twint_pos"),
    
    VIPPS("vipps"),
    
    VISA("visa"),
    
    VISADEBIT("visadebit"),
    
    VPAY("vpay"),
    
    WECHATPAY("wechatpay"),
    
    WECHATPAY_POS("wechatpay_pos");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_VIPPS = "vipps";
  private VippsInfo vipps;

  public static final String JSON_PROPERTY_VISA = "visa";
  private GenericPmWithTdiInfo visa;

  public PaymentMethodSetupInfo() { 
  }

  public PaymentMethodSetupInfo afterpayTouch(AfterpayTouchInfo afterpayTouch) {
    this.afterpayTouch = afterpayTouch;
    return this;
  }

   /**
   * Get afterpayTouch
   * @return afterpayTouch
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_AFTERPAY_TOUCH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AfterpayTouchInfo getAfterpayTouch() {
    return afterpayTouch;
  }


 /**
  * afterpayTouch
  *
  * @param afterpayTouch
  */ 
  @JsonProperty(JSON_PROPERTY_AFTERPAY_TOUCH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAfterpayTouch(AfterpayTouchInfo afterpayTouch) {
    this.afterpayTouch = afterpayTouch;
  }


  public PaymentMethodSetupInfo applePay(ApplePayInfo applePay) {
    this.applePay = applePay;
    return this;
  }

   /**
   * Get applePay
   * @return applePay
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_APPLE_PAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApplePayInfo getApplePay() {
    return applePay;
  }


 /**
  * applePay
  *
  * @param applePay
  */ 
  @JsonProperty(JSON_PROPERTY_APPLE_PAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApplePay(ApplePayInfo applePay) {
    this.applePay = applePay;
  }


  public PaymentMethodSetupInfo bcmc(BcmcInfo bcmc) {
    this.bcmc = bcmc;
    return this;
  }

   /**
   * Get bcmc
   * @return bcmc
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_BCMC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BcmcInfo getBcmc() {
    return bcmc;
  }


 /**
  * bcmc
  *
  * @param bcmc
  */ 
  @JsonProperty(JSON_PROPERTY_BCMC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBcmc(BcmcInfo bcmc) {
    this.bcmc = bcmc;
  }


  public PaymentMethodSetupInfo businessLineId(String businessLineId) {
    this.businessLineId = businessLineId;
    return this;
  }

   /**
   * The unique identifier of the business line. Required if you are a [platform model](https://docs.adyen.com/platforms).
   * @return businessLineId
  **/
  @ApiModelProperty(value = "The unique identifier of the business line. Required if you are a [platform model](https://docs.adyen.com/platforms).")
  @JsonProperty(JSON_PROPERTY_BUSINESS_LINE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBusinessLineId() {
    return businessLineId;
  }


 /**
  * The unique identifier of the business line. Required if you are a [platform model](https://docs.adyen.com/platforms).
  *
  * @param businessLineId
  */ 
  @JsonProperty(JSON_PROPERTY_BUSINESS_LINE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBusinessLineId(String businessLineId) {
    this.businessLineId = businessLineId;
  }


  public PaymentMethodSetupInfo cartesBancaires(CartesBancairesInfo cartesBancaires) {
    this.cartesBancaires = cartesBancaires;
    return this;
  }

   /**
   * Get cartesBancaires
   * @return cartesBancaires
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CARTES_BANCAIRES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CartesBancairesInfo getCartesBancaires() {
    return cartesBancaires;
  }


 /**
  * cartesBancaires
  *
  * @param cartesBancaires
  */ 
  @JsonProperty(JSON_PROPERTY_CARTES_BANCAIRES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCartesBancaires(CartesBancairesInfo cartesBancaires) {
    this.cartesBancaires = cartesBancaires;
  }


  public PaymentMethodSetupInfo clearpay(ClearpayInfo clearpay) {
    this.clearpay = clearpay;
    return this;
  }

   /**
   * Get clearpay
   * @return clearpay
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CLEARPAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ClearpayInfo getClearpay() {
    return clearpay;
  }


 /**
  * clearpay
  *
  * @param clearpay
  */ 
  @JsonProperty(JSON_PROPERTY_CLEARPAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClearpay(ClearpayInfo clearpay) {
    this.clearpay = clearpay;
  }


  public PaymentMethodSetupInfo countries(List<String> countries) {
    this.countries = countries;
    return this;
  }

  public PaymentMethodSetupInfo addCountriesItem(String countriesItem) {
    if (this.countries == null) {
      this.countries = new ArrayList<>();
    }
    this.countries.add(countriesItem);
    return this;
  }

   /**
   * The list of countries where a payment method is available. By default, all countries supported by the payment method.
   * @return countries
  **/
  @ApiModelProperty(value = "The list of countries where a payment method is available. By default, all countries supported by the payment method.")
  @JsonProperty(JSON_PROPERTY_COUNTRIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getCountries() {
    return countries;
  }


 /**
  * The list of countries where a payment method is available. By default, all countries supported by the payment method.
  *
  * @param countries
  */ 
  @JsonProperty(JSON_PROPERTY_COUNTRIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountries(List<String> countries) {
    this.countries = countries;
  }


  public PaymentMethodSetupInfo cup(GenericPmWithTdiInfo cup) {
    this.cup = cup;
    return this;
  }

   /**
   * Get cup
   * @return cup
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GenericPmWithTdiInfo getCup() {
    return cup;
  }


 /**
  * cup
  *
  * @param cup
  */ 
  @JsonProperty(JSON_PROPERTY_CUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCup(GenericPmWithTdiInfo cup) {
    this.cup = cup;
  }


  public PaymentMethodSetupInfo currencies(List<String> currencies) {
    this.currencies = currencies;
    return this;
  }

  public PaymentMethodSetupInfo addCurrenciesItem(String currenciesItem) {
    if (this.currencies == null) {
      this.currencies = new ArrayList<>();
    }
    this.currencies.add(currenciesItem);
    return this;
  }

   /**
   * The list of currencies that a payment method supports. By default, all currencies supported by the payment method.
   * @return currencies
  **/
  @ApiModelProperty(value = "The list of currencies that a payment method supports. By default, all currencies supported by the payment method.")
  @JsonProperty(JSON_PROPERTY_CURRENCIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getCurrencies() {
    return currencies;
  }


 /**
  * The list of currencies that a payment method supports. By default, all currencies supported by the payment method.
  *
  * @param currencies
  */ 
  @JsonProperty(JSON_PROPERTY_CURRENCIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrencies(List<String> currencies) {
    this.currencies = currencies;
  }


  public PaymentMethodSetupInfo customRoutingFlags(List<String> customRoutingFlags) {
    this.customRoutingFlags = customRoutingFlags;
    return this;
  }

  public PaymentMethodSetupInfo addCustomRoutingFlagsItem(String customRoutingFlagsItem) {
    if (this.customRoutingFlags == null) {
      this.customRoutingFlags = new ArrayList<>();
    }
    this.customRoutingFlags.add(customRoutingFlagsItem);
    return this;
  }

   /**
   * The list of custom routing flags to route payment to the intended acquirer.
   * @return customRoutingFlags
  **/
  @ApiModelProperty(value = "The list of custom routing flags to route payment to the intended acquirer.")
  @JsonProperty(JSON_PROPERTY_CUSTOM_ROUTING_FLAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getCustomRoutingFlags() {
    return customRoutingFlags;
  }


 /**
  * The list of custom routing flags to route payment to the intended acquirer.
  *
  * @param customRoutingFlags
  */ 
  @JsonProperty(JSON_PROPERTY_CUSTOM_ROUTING_FLAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomRoutingFlags(List<String> customRoutingFlags) {
    this.customRoutingFlags = customRoutingFlags;
  }


  public PaymentMethodSetupInfo diners(GenericPmWithTdiInfo diners) {
    this.diners = diners;
    return this;
  }

   /**
   * Get diners
   * @return diners
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DINERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GenericPmWithTdiInfo getDiners() {
    return diners;
  }


 /**
  * diners
  *
  * @param diners
  */ 
  @JsonProperty(JSON_PROPERTY_DINERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDiners(GenericPmWithTdiInfo diners) {
    this.diners = diners;
  }


  public PaymentMethodSetupInfo discover(GenericPmWithTdiInfo discover) {
    this.discover = discover;
    return this;
  }

   /**
   * Get discover
   * @return discover
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DISCOVER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GenericPmWithTdiInfo getDiscover() {
    return discover;
  }


 /**
  * discover
  *
  * @param discover
  */ 
  @JsonProperty(JSON_PROPERTY_DISCOVER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDiscover(GenericPmWithTdiInfo discover) {
    this.discover = discover;
  }


  public PaymentMethodSetupInfo eftposAustralia(GenericPmWithTdiInfo eftposAustralia) {
    this.eftposAustralia = eftposAustralia;
    return this;
  }

   /**
   * Get eftposAustralia
   * @return eftposAustralia
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_EFTPOS_AUSTRALIA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GenericPmWithTdiInfo getEftposAustralia() {
    return eftposAustralia;
  }


 /**
  * eftposAustralia
  *
  * @param eftposAustralia
  */ 
  @JsonProperty(JSON_PROPERTY_EFTPOS_AUSTRALIA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEftposAustralia(GenericPmWithTdiInfo eftposAustralia) {
    this.eftposAustralia = eftposAustralia;
  }


  public PaymentMethodSetupInfo giroPay(GiroPayInfo giroPay) {
    this.giroPay = giroPay;
    return this;
  }

   /**
   * Get giroPay
   * @return giroPay
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_GIRO_PAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GiroPayInfo getGiroPay() {
    return giroPay;
  }


 /**
  * giroPay
  *
  * @param giroPay
  */ 
  @JsonProperty(JSON_PROPERTY_GIRO_PAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGiroPay(GiroPayInfo giroPay) {
    this.giroPay = giroPay;
  }


  public PaymentMethodSetupInfo girocard(GenericPmWithTdiInfo girocard) {
    this.girocard = girocard;
    return this;
  }

   /**
   * Get girocard
   * @return girocard
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_GIROCARD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GenericPmWithTdiInfo getGirocard() {
    return girocard;
  }


 /**
  * girocard
  *
  * @param girocard
  */ 
  @JsonProperty(JSON_PROPERTY_GIROCARD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGirocard(GenericPmWithTdiInfo girocard) {
    this.girocard = girocard;
  }


  public PaymentMethodSetupInfo googlePay(GooglePayInfo googlePay) {
    this.googlePay = googlePay;
    return this;
  }

   /**
   * Get googlePay
   * @return googlePay
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_GOOGLE_PAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GooglePayInfo getGooglePay() {
    return googlePay;
  }


 /**
  * googlePay
  *
  * @param googlePay
  */ 
  @JsonProperty(JSON_PROPERTY_GOOGLE_PAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGooglePay(GooglePayInfo googlePay) {
    this.googlePay = googlePay;
  }


  public PaymentMethodSetupInfo ideal(GenericPmWithTdiInfo ideal) {
    this.ideal = ideal;
    return this;
  }

   /**
   * Get ideal
   * @return ideal
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_IDEAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GenericPmWithTdiInfo getIdeal() {
    return ideal;
  }


 /**
  * ideal
  *
  * @param ideal
  */ 
  @JsonProperty(JSON_PROPERTY_IDEAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdeal(GenericPmWithTdiInfo ideal) {
    this.ideal = ideal;
  }


  public PaymentMethodSetupInfo interacCard(GenericPmWithTdiInfo interacCard) {
    this.interacCard = interacCard;
    return this;
  }

   /**
   * Get interacCard
   * @return interacCard
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INTERAC_CARD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GenericPmWithTdiInfo getInteracCard() {
    return interacCard;
  }


 /**
  * interacCard
  *
  * @param interacCard
  */ 
  @JsonProperty(JSON_PROPERTY_INTERAC_CARD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInteracCard(GenericPmWithTdiInfo interacCard) {
    this.interacCard = interacCard;
  }


  public PaymentMethodSetupInfo jcb(GenericPmWithTdiInfo jcb) {
    this.jcb = jcb;
    return this;
  }

   /**
   * Get jcb
   * @return jcb
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_JCB)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GenericPmWithTdiInfo getJcb() {
    return jcb;
  }


 /**
  * jcb
  *
  * @param jcb
  */ 
  @JsonProperty(JSON_PROPERTY_JCB)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setJcb(GenericPmWithTdiInfo jcb) {
    this.jcb = jcb;
  }


  public PaymentMethodSetupInfo klarna(KlarnaInfo klarna) {
    this.klarna = klarna;
    return this;
  }

   /**
   * Get klarna
   * @return klarna
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_KLARNA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KlarnaInfo getKlarna() {
    return klarna;
  }


 /**
  * klarna
  *
  * @param klarna
  */ 
  @JsonProperty(JSON_PROPERTY_KLARNA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setKlarna(KlarnaInfo klarna) {
    this.klarna = klarna;
  }


  public PaymentMethodSetupInfo maestro(GenericPmWithTdiInfo maestro) {
    this.maestro = maestro;
    return this;
  }

   /**
   * Get maestro
   * @return maestro
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MAESTRO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GenericPmWithTdiInfo getMaestro() {
    return maestro;
  }


 /**
  * maestro
  *
  * @param maestro
  */ 
  @JsonProperty(JSON_PROPERTY_MAESTRO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaestro(GenericPmWithTdiInfo maestro) {
    this.maestro = maestro;
  }


  public PaymentMethodSetupInfo mc(GenericPmWithTdiInfo mc) {
    this.mc = mc;
    return this;
  }

   /**
   * Get mc
   * @return mc
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GenericPmWithTdiInfo getMc() {
    return mc;
  }


 /**
  * mc
  *
  * @param mc
  */ 
  @JsonProperty(JSON_PROPERTY_MC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMc(GenericPmWithTdiInfo mc) {
    this.mc = mc;
  }


  public PaymentMethodSetupInfo mealVoucherFR(MealVoucherFRInfo mealVoucherFR) {
    this.mealVoucherFR = mealVoucherFR;
    return this;
  }

   /**
   * Get mealVoucherFR
   * @return mealVoucherFR
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MEAL_VOUCHER_F_R)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MealVoucherFRInfo getMealVoucherFR() {
    return mealVoucherFR;
  }


 /**
  * mealVoucherFR
  *
  * @param mealVoucherFR
  */ 
  @JsonProperty(JSON_PROPERTY_MEAL_VOUCHER_F_R)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMealVoucherFR(MealVoucherFRInfo mealVoucherFR) {
    this.mealVoucherFR = mealVoucherFR;
  }


  public PaymentMethodSetupInfo paypal(PayPalInfo paypal) {
    this.paypal = paypal;
    return this;
  }

   /**
   * Get paypal
   * @return paypal
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAYPAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PayPalInfo getPaypal() {
    return paypal;
  }


 /**
  * paypal
  *
  * @param paypal
  */ 
  @JsonProperty(JSON_PROPERTY_PAYPAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaypal(PayPalInfo paypal) {
    this.paypal = paypal;
  }


  public PaymentMethodSetupInfo reference(String reference) {
    this.reference = reference;
    return this;
  }

   /**
   * Your reference for the payment method. Supported characters a-z, A-Z, 0-9.
   * @return reference
  **/
  @ApiModelProperty(value = "Your reference for the payment method. Supported characters a-z, A-Z, 0-9.")
  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReference() {
    return reference;
  }


 /**
  * Your reference for the payment method. Supported characters a-z, A-Z, 0-9.
  *
  * @param reference
  */ 
  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReference(String reference) {
    this.reference = reference;
  }


  public PaymentMethodSetupInfo shopperInteraction(ShopperInteractionEnum shopperInteraction) {
    this.shopperInteraction = shopperInteraction;
    return this;
  }

   /**
   * The sales channel. Required if the merchant account does not have a sales channel. When you provide this field, it overrides the default sales channel set on the merchant account.  Possible values: **eCommerce**, **pos**, **contAuth**, and **moto**. 
   * @return shopperInteraction
  **/
  @ApiModelProperty(value = "The sales channel. Required if the merchant account does not have a sales channel. When you provide this field, it overrides the default sales channel set on the merchant account.  Possible values: **eCommerce**, **pos**, **contAuth**, and **moto**. ")
  @JsonProperty(JSON_PROPERTY_SHOPPER_INTERACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ShopperInteractionEnum getShopperInteraction() {
    return shopperInteraction;
  }


 /**
  * The sales channel. Required if the merchant account does not have a sales channel. When you provide this field, it overrides the default sales channel set on the merchant account.  Possible values: **eCommerce**, **pos**, **contAuth**, and **moto**. 
  *
  * @param shopperInteraction
  */ 
  @JsonProperty(JSON_PROPERTY_SHOPPER_INTERACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperInteraction(ShopperInteractionEnum shopperInteraction) {
    this.shopperInteraction = shopperInteraction;
  }


  public PaymentMethodSetupInfo sofort(SofortInfo sofort) {
    this.sofort = sofort;
    return this;
  }

   /**
   * Get sofort
   * @return sofort
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOFORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SofortInfo getSofort() {
    return sofort;
  }


 /**
  * sofort
  *
  * @param sofort
  */ 
  @JsonProperty(JSON_PROPERTY_SOFORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSofort(SofortInfo sofort) {
    this.sofort = sofort;
  }


  public PaymentMethodSetupInfo storeIds(List<String> storeIds) {
    this.storeIds = storeIds;
    return this;
  }

  public PaymentMethodSetupInfo addStoreIdsItem(String storeIdsItem) {
    if (this.storeIds == null) {
      this.storeIds = new ArrayList<>();
    }
    this.storeIds.add(storeIdsItem);
    return this;
  }

   /**
   * The unique identifier of the store for which to configure the payment method, if any.
   * @return storeIds
  **/
  @ApiModelProperty(value = "The unique identifier of the store for which to configure the payment method, if any.")
  @JsonProperty(JSON_PROPERTY_STORE_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getStoreIds() {
    return storeIds;
  }


 /**
  * The unique identifier of the store for which to configure the payment method, if any.
  *
  * @param storeIds
  */ 
  @JsonProperty(JSON_PROPERTY_STORE_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStoreIds(List<String> storeIds) {
    this.storeIds = storeIds;
  }


  public PaymentMethodSetupInfo swish(SwishInfo swish) {
    this.swish = swish;
    return this;
  }

   /**
   * Get swish
   * @return swish
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SWISH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SwishInfo getSwish() {
    return swish;
  }


 /**
  * swish
  *
  * @param swish
  */ 
  @JsonProperty(JSON_PROPERTY_SWISH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSwish(SwishInfo swish) {
    this.swish = swish;
  }


  public PaymentMethodSetupInfo twint(TwintInfo twint) {
    this.twint = twint;
    return this;
  }

   /**
   * Get twint
   * @return twint
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TWINT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TwintInfo getTwint() {
    return twint;
  }


 /**
  * twint
  *
  * @param twint
  */ 
  @JsonProperty(JSON_PROPERTY_TWINT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTwint(TwintInfo twint) {
    this.twint = twint;
  }


  public PaymentMethodSetupInfo type(TypeEnum type) {
    this.type = type;
    return this;
  }

   /**
   * Payment method [variant](https://docs.adyen.com/development-resources/paymentmethodvariant#management-api).
   * @return type
  **/
  @ApiModelProperty(required = true, value = "Payment method [variant](https://docs.adyen.com/development-resources/paymentmethodvariant#management-api).")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


 /**
  * Payment method [variant](https://docs.adyen.com/development-resources/paymentmethodvariant#management-api).
  *
  * @param type
  */ 
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public PaymentMethodSetupInfo vipps(VippsInfo vipps) {
    this.vipps = vipps;
    return this;
  }

   /**
   * Get vipps
   * @return vipps
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_VIPPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public VippsInfo getVipps() {
    return vipps;
  }


 /**
  * vipps
  *
  * @param vipps
  */ 
  @JsonProperty(JSON_PROPERTY_VIPPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVipps(VippsInfo vipps) {
    this.vipps = vipps;
  }


  public PaymentMethodSetupInfo visa(GenericPmWithTdiInfo visa) {
    this.visa = visa;
    return this;
  }

   /**
   * Get visa
   * @return visa
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_VISA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GenericPmWithTdiInfo getVisa() {
    return visa;
  }


 /**
  * visa
  *
  * @param visa
  */ 
  @JsonProperty(JSON_PROPERTY_VISA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVisa(GenericPmWithTdiInfo visa) {
    this.visa = visa;
  }


  /**
   * Return true if this PaymentMethodSetupInfo object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentMethodSetupInfo paymentMethodSetupInfo = (PaymentMethodSetupInfo) o;
    return Objects.equals(this.afterpayTouch, paymentMethodSetupInfo.afterpayTouch) &&
        Objects.equals(this.applePay, paymentMethodSetupInfo.applePay) &&
        Objects.equals(this.bcmc, paymentMethodSetupInfo.bcmc) &&
        Objects.equals(this.businessLineId, paymentMethodSetupInfo.businessLineId) &&
        Objects.equals(this.cartesBancaires, paymentMethodSetupInfo.cartesBancaires) &&
        Objects.equals(this.clearpay, paymentMethodSetupInfo.clearpay) &&
        Objects.equals(this.countries, paymentMethodSetupInfo.countries) &&
        Objects.equals(this.cup, paymentMethodSetupInfo.cup) &&
        Objects.equals(this.currencies, paymentMethodSetupInfo.currencies) &&
        Objects.equals(this.customRoutingFlags, paymentMethodSetupInfo.customRoutingFlags) &&
        Objects.equals(this.diners, paymentMethodSetupInfo.diners) &&
        Objects.equals(this.discover, paymentMethodSetupInfo.discover) &&
        Objects.equals(this.eftposAustralia, paymentMethodSetupInfo.eftposAustralia) &&
        Objects.equals(this.giroPay, paymentMethodSetupInfo.giroPay) &&
        Objects.equals(this.girocard, paymentMethodSetupInfo.girocard) &&
        Objects.equals(this.googlePay, paymentMethodSetupInfo.googlePay) &&
        Objects.equals(this.ideal, paymentMethodSetupInfo.ideal) &&
        Objects.equals(this.interacCard, paymentMethodSetupInfo.interacCard) &&
        Objects.equals(this.jcb, paymentMethodSetupInfo.jcb) &&
        Objects.equals(this.klarna, paymentMethodSetupInfo.klarna) &&
        Objects.equals(this.maestro, paymentMethodSetupInfo.maestro) &&
        Objects.equals(this.mc, paymentMethodSetupInfo.mc) &&
        Objects.equals(this.mealVoucherFR, paymentMethodSetupInfo.mealVoucherFR) &&
        Objects.equals(this.paypal, paymentMethodSetupInfo.paypal) &&
        Objects.equals(this.reference, paymentMethodSetupInfo.reference) &&
        Objects.equals(this.shopperInteraction, paymentMethodSetupInfo.shopperInteraction) &&
        Objects.equals(this.sofort, paymentMethodSetupInfo.sofort) &&
        Objects.equals(this.storeIds, paymentMethodSetupInfo.storeIds) &&
        Objects.equals(this.swish, paymentMethodSetupInfo.swish) &&
        Objects.equals(this.twint, paymentMethodSetupInfo.twint) &&
        Objects.equals(this.type, paymentMethodSetupInfo.type) &&
        Objects.equals(this.vipps, paymentMethodSetupInfo.vipps) &&
        Objects.equals(this.visa, paymentMethodSetupInfo.visa);
  }

  @Override
  public int hashCode() {
    return Objects.hash(afterpayTouch, applePay, bcmc, businessLineId, cartesBancaires, clearpay, countries, cup, currencies, customRoutingFlags, diners, discover, eftposAustralia, giroPay, girocard, googlePay, ideal, interacCard, jcb, klarna, maestro, mc, mealVoucherFR, paypal, reference, shopperInteraction, sofort, storeIds, swish, twint, type, vipps, visa);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentMethodSetupInfo {\n");
    sb.append("    afterpayTouch: ").append(toIndentedString(afterpayTouch)).append("\n");
    sb.append("    applePay: ").append(toIndentedString(applePay)).append("\n");
    sb.append("    bcmc: ").append(toIndentedString(bcmc)).append("\n");
    sb.append("    businessLineId: ").append(toIndentedString(businessLineId)).append("\n");
    sb.append("    cartesBancaires: ").append(toIndentedString(cartesBancaires)).append("\n");
    sb.append("    clearpay: ").append(toIndentedString(clearpay)).append("\n");
    sb.append("    countries: ").append(toIndentedString(countries)).append("\n");
    sb.append("    cup: ").append(toIndentedString(cup)).append("\n");
    sb.append("    currencies: ").append(toIndentedString(currencies)).append("\n");
    sb.append("    customRoutingFlags: ").append(toIndentedString(customRoutingFlags)).append("\n");
    sb.append("    diners: ").append(toIndentedString(diners)).append("\n");
    sb.append("    discover: ").append(toIndentedString(discover)).append("\n");
    sb.append("    eftposAustralia: ").append(toIndentedString(eftposAustralia)).append("\n");
    sb.append("    giroPay: ").append(toIndentedString(giroPay)).append("\n");
    sb.append("    girocard: ").append(toIndentedString(girocard)).append("\n");
    sb.append("    googlePay: ").append(toIndentedString(googlePay)).append("\n");
    sb.append("    ideal: ").append(toIndentedString(ideal)).append("\n");
    sb.append("    interacCard: ").append(toIndentedString(interacCard)).append("\n");
    sb.append("    jcb: ").append(toIndentedString(jcb)).append("\n");
    sb.append("    klarna: ").append(toIndentedString(klarna)).append("\n");
    sb.append("    maestro: ").append(toIndentedString(maestro)).append("\n");
    sb.append("    mc: ").append(toIndentedString(mc)).append("\n");
    sb.append("    mealVoucherFR: ").append(toIndentedString(mealVoucherFR)).append("\n");
    sb.append("    paypal: ").append(toIndentedString(paypal)).append("\n");
    sb.append("    reference: ").append(toIndentedString(reference)).append("\n");
    sb.append("    shopperInteraction: ").append(toIndentedString(shopperInteraction)).append("\n");
    sb.append("    sofort: ").append(toIndentedString(sofort)).append("\n");
    sb.append("    storeIds: ").append(toIndentedString(storeIds)).append("\n");
    sb.append("    swish: ").append(toIndentedString(swish)).append("\n");
    sb.append("    twint: ").append(toIndentedString(twint)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    vipps: ").append(toIndentedString(vipps)).append("\n");
    sb.append("    visa: ").append(toIndentedString(visa)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of PaymentMethodSetupInfo given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of PaymentMethodSetupInfo
   * @throws JsonProcessingException if the JSON string is invalid with respect to PaymentMethodSetupInfo
   */
  public static PaymentMethodSetupInfo fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, PaymentMethodSetupInfo.class);
  }
/**
  * Convert an instance of PaymentMethodSetupInfo to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

