/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.management;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.management.TerminalProductPrice;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * TerminalProduct
 */
@JsonPropertyOrder({
  TerminalProduct.JSON_PROPERTY_DESCRIPTION,
  TerminalProduct.JSON_PROPERTY_ID,
  TerminalProduct.JSON_PROPERTY_ITEMS_INCLUDED,
  TerminalProduct.JSON_PROPERTY_NAME,
  TerminalProduct.JSON_PROPERTY_PRICE
})

public class TerminalProduct {
  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_ITEMS_INCLUDED = "itemsIncluded";
  private List<String> itemsIncluded = null;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_PRICE = "price";
  private TerminalProductPrice price;

  public TerminalProduct() { 
  }

  public TerminalProduct description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Information about items included and integration options.
   * @return description
  **/
  @ApiModelProperty(value = "Information about items included and integration options.")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


 /**
  * Information about items included and integration options.
  *
  * @param description
  */ 
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public TerminalProduct id(String id) {
    this.id = id;
    return this;
  }

   /**
   * The unique identifier of the product.
   * @return id
  **/
  @ApiModelProperty(value = "The unique identifier of the product.")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


 /**
  * The unique identifier of the product.
  *
  * @param id
  */ 
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public TerminalProduct itemsIncluded(List<String> itemsIncluded) {
    this.itemsIncluded = itemsIncluded;
    return this;
  }

  public TerminalProduct addItemsIncludedItem(String itemsIncludedItem) {
    if (this.itemsIncluded == null) {
      this.itemsIncluded = new ArrayList<>();
    }
    this.itemsIncluded.add(itemsIncludedItem);
    return this;
  }

   /**
   * A list of parts included in the terminal package.
   * @return itemsIncluded
  **/
  @ApiModelProperty(value = "A list of parts included in the terminal package.")
  @JsonProperty(JSON_PROPERTY_ITEMS_INCLUDED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getItemsIncluded() {
    return itemsIncluded;
  }


 /**
  * A list of parts included in the terminal package.
  *
  * @param itemsIncluded
  */ 
  @JsonProperty(JSON_PROPERTY_ITEMS_INCLUDED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setItemsIncluded(List<String> itemsIncluded) {
    this.itemsIncluded = itemsIncluded;
  }


  public TerminalProduct name(String name) {
    this.name = name;
    return this;
  }

   /**
   * The descriptive name of the product.
   * @return name
  **/
  @ApiModelProperty(value = "The descriptive name of the product.")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


 /**
  * The descriptive name of the product.
  *
  * @param name
  */ 
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public TerminalProduct price(TerminalProductPrice price) {
    this.price = price;
    return this;
  }

   /**
   * Get price
   * @return price
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TerminalProductPrice getPrice() {
    return price;
  }


 /**
  * price
  *
  * @param price
  */ 
  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrice(TerminalProductPrice price) {
    this.price = price;
  }


  /**
   * Return true if this TerminalProduct object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TerminalProduct terminalProduct = (TerminalProduct) o;
    return Objects.equals(this.description, terminalProduct.description) &&
        Objects.equals(this.id, terminalProduct.id) &&
        Objects.equals(this.itemsIncluded, terminalProduct.itemsIncluded) &&
        Objects.equals(this.name, terminalProduct.name) &&
        Objects.equals(this.price, terminalProduct.price);
  }

  @Override
  public int hashCode() {
    return Objects.hash(description, id, itemsIncluded, name, price);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TerminalProduct {\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    itemsIncluded: ").append(toIndentedString(itemsIncluded)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of TerminalProduct given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of TerminalProduct
   * @throws JsonProcessingException if the JSON string is invalid with respect to TerminalProduct
   */
  public static TerminalProduct fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, TerminalProduct.class);
  }
/**
  * Convert an instance of TerminalProduct to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

