/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.management;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.management.Name2;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * UpdateCompanyUserRequest
 */
@JsonPropertyOrder({
  UpdateCompanyUserRequest.JSON_PROPERTY_ACCOUNT_GROUPS,
  UpdateCompanyUserRequest.JSON_PROPERTY_ACTIVE,
  UpdateCompanyUserRequest.JSON_PROPERTY_ASSOCIATED_MERCHANT_ACCOUNTS,
  UpdateCompanyUserRequest.JSON_PROPERTY_EMAIL,
  UpdateCompanyUserRequest.JSON_PROPERTY_LOGIN_METHOD,
  UpdateCompanyUserRequest.JSON_PROPERTY_NAME,
  UpdateCompanyUserRequest.JSON_PROPERTY_ROLES,
  UpdateCompanyUserRequest.JSON_PROPERTY_TIME_ZONE_CODE
})

public class UpdateCompanyUserRequest {
  public static final String JSON_PROPERTY_ACCOUNT_GROUPS = "accountGroups";
  private List<String> accountGroups = null;

  public static final String JSON_PROPERTY_ACTIVE = "active";
  private Boolean active;

  public static final String JSON_PROPERTY_ASSOCIATED_MERCHANT_ACCOUNTS = "associatedMerchantAccounts";
  private List<String> associatedMerchantAccounts = null;

  public static final String JSON_PROPERTY_EMAIL = "email";
  private String email;

  public static final String JSON_PROPERTY_LOGIN_METHOD = "loginMethod";
  private String loginMethod;

  public static final String JSON_PROPERTY_NAME = "name";
  private Name2 name;

  public static final String JSON_PROPERTY_ROLES = "roles";
  private List<String> roles = null;

  public static final String JSON_PROPERTY_TIME_ZONE_CODE = "timeZoneCode";
  private String timeZoneCode;

  public UpdateCompanyUserRequest() { 
  }

  public UpdateCompanyUserRequest accountGroups(List<String> accountGroups) {
    this.accountGroups = accountGroups;
    return this;
  }

  public UpdateCompanyUserRequest addAccountGroupsItem(String accountGroupsItem) {
    if (this.accountGroups == null) {
      this.accountGroups = new ArrayList<>();
    }
    this.accountGroups.add(accountGroupsItem);
    return this;
  }

   /**
   * The list of [account groups](https://docs.adyen.com/account/account-structure#account-groups) associated with this user.
   * @return accountGroups
  **/
  @ApiModelProperty(value = "The list of [account groups](https://docs.adyen.com/account/account-structure#account-groups) associated with this user.")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_GROUPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getAccountGroups() {
    return accountGroups;
  }


 /**
  * The list of [account groups](https://docs.adyen.com/account/account-structure#account-groups) associated with this user.
  *
  * @param accountGroups
  */ 
  @JsonProperty(JSON_PROPERTY_ACCOUNT_GROUPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountGroups(List<String> accountGroups) {
    this.accountGroups = accountGroups;
  }


  public UpdateCompanyUserRequest active(Boolean active) {
    this.active = active;
    return this;
  }

   /**
   * Indicates whether this user is active.
   * @return active
  **/
  @ApiModelProperty(value = "Indicates whether this user is active.")
  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getActive() {
    return active;
  }


 /**
  * Indicates whether this user is active.
  *
  * @param active
  */ 
  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActive(Boolean active) {
    this.active = active;
  }


  public UpdateCompanyUserRequest associatedMerchantAccounts(List<String> associatedMerchantAccounts) {
    this.associatedMerchantAccounts = associatedMerchantAccounts;
    return this;
  }

  public UpdateCompanyUserRequest addAssociatedMerchantAccountsItem(String associatedMerchantAccountsItem) {
    if (this.associatedMerchantAccounts == null) {
      this.associatedMerchantAccounts = new ArrayList<>();
    }
    this.associatedMerchantAccounts.add(associatedMerchantAccountsItem);
    return this;
  }

   /**
   * The list of [merchant accounts](https://docs.adyen.com/account/account-structure#merchant-accounts) to associate the user with.
   * @return associatedMerchantAccounts
  **/
  @ApiModelProperty(value = "The list of [merchant accounts](https://docs.adyen.com/account/account-structure#merchant-accounts) to associate the user with.")
  @JsonProperty(JSON_PROPERTY_ASSOCIATED_MERCHANT_ACCOUNTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getAssociatedMerchantAccounts() {
    return associatedMerchantAccounts;
  }


 /**
  * The list of [merchant accounts](https://docs.adyen.com/account/account-structure#merchant-accounts) to associate the user with.
  *
  * @param associatedMerchantAccounts
  */ 
  @JsonProperty(JSON_PROPERTY_ASSOCIATED_MERCHANT_ACCOUNTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAssociatedMerchantAccounts(List<String> associatedMerchantAccounts) {
    this.associatedMerchantAccounts = associatedMerchantAccounts;
  }


  public UpdateCompanyUserRequest email(String email) {
    this.email = email;
    return this;
  }

   /**
   * The email address of the user.
   * @return email
  **/
  @ApiModelProperty(value = "The email address of the user.")
  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getEmail() {
    return email;
  }


 /**
  * The email address of the user.
  *
  * @param email
  */ 
  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEmail(String email) {
    this.email = email;
  }


  public UpdateCompanyUserRequest loginMethod(String loginMethod) {
    this.loginMethod = loginMethod;
    return this;
  }

   /**
   * The requested login method for the user. To use SSO, you must already have SSO configured with Adyen before creating the user.  Possible values: **Username &amp; account**, **Email**, or **SSO** 
   * @return loginMethod
  **/
  @ApiModelProperty(value = "The requested login method for the user. To use SSO, you must already have SSO configured with Adyen before creating the user.  Possible values: **Username & account**, **Email**, or **SSO** ")
  @JsonProperty(JSON_PROPERTY_LOGIN_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLoginMethod() {
    return loginMethod;
  }


 /**
  * The requested login method for the user. To use SSO, you must already have SSO configured with Adyen before creating the user.  Possible values: **Username &amp; account**, **Email**, or **SSO** 
  *
  * @param loginMethod
  */ 
  @JsonProperty(JSON_PROPERTY_LOGIN_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLoginMethod(String loginMethod) {
    this.loginMethod = loginMethod;
  }


  public UpdateCompanyUserRequest name(Name2 name) {
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Name2 getName() {
    return name;
  }


 /**
  * name
  *
  * @param name
  */ 
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(Name2 name) {
    this.name = name;
  }


  public UpdateCompanyUserRequest roles(List<String> roles) {
    this.roles = roles;
    return this;
  }

  public UpdateCompanyUserRequest addRolesItem(String rolesItem) {
    if (this.roles == null) {
      this.roles = new ArrayList<>();
    }
    this.roles.add(rolesItem);
    return this;
  }

   /**
   * The list of [roles](https://docs.adyen.com/account/user-roles) for this user.
   * @return roles
  **/
  @ApiModelProperty(value = "The list of [roles](https://docs.adyen.com/account/user-roles) for this user.")
  @JsonProperty(JSON_PROPERTY_ROLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getRoles() {
    return roles;
  }


 /**
  * The list of [roles](https://docs.adyen.com/account/user-roles) for this user.
  *
  * @param roles
  */ 
  @JsonProperty(JSON_PROPERTY_ROLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoles(List<String> roles) {
    this.roles = roles;
  }


  public UpdateCompanyUserRequest timeZoneCode(String timeZoneCode) {
    this.timeZoneCode = timeZoneCode;
    return this;
  }

   /**
   * The [tz database name](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones) of the time zone of the user. For example, **Europe/Amsterdam**.
   * @return timeZoneCode
  **/
  @ApiModelProperty(value = "The [tz database name](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones) of the time zone of the user. For example, **Europe/Amsterdam**.")
  @JsonProperty(JSON_PROPERTY_TIME_ZONE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTimeZoneCode() {
    return timeZoneCode;
  }


 /**
  * The [tz database name](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones) of the time zone of the user. For example, **Europe/Amsterdam**.
  *
  * @param timeZoneCode
  */ 
  @JsonProperty(JSON_PROPERTY_TIME_ZONE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimeZoneCode(String timeZoneCode) {
    this.timeZoneCode = timeZoneCode;
  }


  /**
   * Return true if this UpdateCompanyUserRequest object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpdateCompanyUserRequest updateCompanyUserRequest = (UpdateCompanyUserRequest) o;
    return Objects.equals(this.accountGroups, updateCompanyUserRequest.accountGroups) &&
        Objects.equals(this.active, updateCompanyUserRequest.active) &&
        Objects.equals(this.associatedMerchantAccounts, updateCompanyUserRequest.associatedMerchantAccounts) &&
        Objects.equals(this.email, updateCompanyUserRequest.email) &&
        Objects.equals(this.loginMethod, updateCompanyUserRequest.loginMethod) &&
        Objects.equals(this.name, updateCompanyUserRequest.name) &&
        Objects.equals(this.roles, updateCompanyUserRequest.roles) &&
        Objects.equals(this.timeZoneCode, updateCompanyUserRequest.timeZoneCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountGroups, active, associatedMerchantAccounts, email, loginMethod, name, roles, timeZoneCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpdateCompanyUserRequest {\n");
    sb.append("    accountGroups: ").append(toIndentedString(accountGroups)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    associatedMerchantAccounts: ").append(toIndentedString(associatedMerchantAccounts)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    loginMethod: ").append(toIndentedString(loginMethod)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    roles: ").append(toIndentedString(roles)).append("\n");
    sb.append("    timeZoneCode: ").append(toIndentedString(timeZoneCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of UpdateCompanyUserRequest given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of UpdateCompanyUserRequest
   * @throws JsonProcessingException if the JSON string is invalid with respect to UpdateCompanyUserRequest
   */
  public static UpdateCompanyUserRequest fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, UpdateCompanyUserRequest.class);
  }
/**
  * Convert an instance of UpdateCompanyUserRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

