/*
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.balanceplatform;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * AddressRequirement
 */
@JsonPropertyOrder({
  AddressRequirement.JSON_PROPERTY_DESCRIPTION,
  AddressRequirement.JSON_PROPERTY_REQUIRED_ADDRESS_FIELDS,
  AddressRequirement.JSON_PROPERTY_TYPE
})

public class AddressRequirement {
  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  /**
   * Gets or Sets requiredAddressFields
   */
  public enum RequiredAddressFieldsEnum {
    CITY("city"),
    
    COUNTRY("country"),
    
    LINE1("line1"),
    
    POSTALCODE("postalCode"),
    
    STATEORPROVINCE("stateOrProvince");

    private String value;

    RequiredAddressFieldsEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RequiredAddressFieldsEnum fromValue(String value) {
      for (RequiredAddressFieldsEnum b : RequiredAddressFieldsEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_REQUIRED_ADDRESS_FIELDS = "requiredAddressFields";
  private List<RequiredAddressFieldsEnum> requiredAddressFields = null;

  /**
   * **addressRequirement**
   */
  public enum TypeEnum {
    ADDRESSREQUIREMENT("addressRequirement");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public AddressRequirement() { 
  }

  public AddressRequirement description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Specifies the required address related fields for a particular route.
   * @return description
  **/
  @ApiModelProperty(value = "Specifies the required address related fields for a particular route.")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


 /**
  * Specifies the required address related fields for a particular route.
  *
  * @param description
  */ 
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public AddressRequirement requiredAddressFields(List<RequiredAddressFieldsEnum> requiredAddressFields) {
    this.requiredAddressFields = requiredAddressFields;
    return this;
  }

  public AddressRequirement addRequiredAddressFieldsItem(RequiredAddressFieldsEnum requiredAddressFieldsItem) {
    if (this.requiredAddressFields == null) {
      this.requiredAddressFields = new ArrayList<>();
    }
    this.requiredAddressFields.add(requiredAddressFieldsItem);
    return this;
  }

   /**
   * List of address fields.
   * @return requiredAddressFields
  **/
  @ApiModelProperty(value = "List of address fields.")
  @JsonProperty(JSON_PROPERTY_REQUIRED_ADDRESS_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<RequiredAddressFieldsEnum> getRequiredAddressFields() {
    return requiredAddressFields;
  }


 /**
  * List of address fields.
  *
  * @param requiredAddressFields
  */ 
  @JsonProperty(JSON_PROPERTY_REQUIRED_ADDRESS_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRequiredAddressFields(List<RequiredAddressFieldsEnum> requiredAddressFields) {
    this.requiredAddressFields = requiredAddressFields;
  }


  public AddressRequirement type(TypeEnum type) {
    this.type = type;
    return this;
  }

   /**
   * **addressRequirement**
   * @return type
  **/
  @ApiModelProperty(required = true, value = "**addressRequirement**")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


 /**
  * **addressRequirement**
  *
  * @param type
  */ 
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  /**
   * Return true if this AddressRequirement object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AddressRequirement addressRequirement = (AddressRequirement) o;
    return Objects.equals(this.description, addressRequirement.description) &&
        Objects.equals(this.requiredAddressFields, addressRequirement.requiredAddressFields) &&
        Objects.equals(this.type, addressRequirement.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(description, requiredAddressFields, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AddressRequirement {\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    requiredAddressFields: ").append(toIndentedString(requiredAddressFields)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of AddressRequirement given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of AddressRequirement
   * @throws JsonProcessingException if the JSON string is invalid with respect to AddressRequirement
   */
  public static AddressRequirement fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, AddressRequirement.class);
  }
/**
  * Convert an instance of AddressRequirement to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

