/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.checkout;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.checkout.CardBrandDetails;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * CardDetailsResponse
 */
@JsonPropertyOrder({
  CardDetailsResponse.JSON_PROPERTY_BRANDS,
  CardDetailsResponse.JSON_PROPERTY_ISSUING_COUNTRY_CODE
})

public class CardDetailsResponse {
  public static final String JSON_PROPERTY_BRANDS = "brands";
  private List<CardBrandDetails> brands = null;

  public static final String JSON_PROPERTY_ISSUING_COUNTRY_CODE = "issuingCountryCode";
  private String issuingCountryCode;

  public CardDetailsResponse() { 
  }

  public CardDetailsResponse brands(List<CardBrandDetails> brands) {
    this.brands = brands;
    return this;
  }

  public CardDetailsResponse addBrandsItem(CardBrandDetails brandsItem) {
    if (this.brands == null) {
      this.brands = new ArrayList<>();
    }
    this.brands.add(brandsItem);
    return this;
  }

   /**
   * The list of brands identified for the card.
   * @return brands
  **/
  @ApiModelProperty(value = "The list of brands identified for the card.")
  @JsonProperty(JSON_PROPERTY_BRANDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<CardBrandDetails> getBrands() {
    return brands;
  }


 /**
  * The list of brands identified for the card.
  *
  * @param brands
  */ 
  @JsonProperty(JSON_PROPERTY_BRANDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBrands(List<CardBrandDetails> brands) {
    this.brands = brands;
  }


  public CardDetailsResponse issuingCountryCode(String issuingCountryCode) {
    this.issuingCountryCode = issuingCountryCode;
    return this;
  }

   /**
   * The two-letter country code  of the country where the card was issued.
   * @return issuingCountryCode
  **/
  @ApiModelProperty(value = "The two-letter country code  of the country where the card was issued.")
  @JsonProperty(JSON_PROPERTY_ISSUING_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIssuingCountryCode() {
    return issuingCountryCode;
  }


 /**
  * The two-letter country code  of the country where the card was issued.
  *
  * @param issuingCountryCode
  */ 
  @JsonProperty(JSON_PROPERTY_ISSUING_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIssuingCountryCode(String issuingCountryCode) {
    this.issuingCountryCode = issuingCountryCode;
  }


  /**
   * Return true if this CardDetailsResponse object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CardDetailsResponse cardDetailsResponse = (CardDetailsResponse) o;
    return Objects.equals(this.brands, cardDetailsResponse.brands) &&
        Objects.equals(this.issuingCountryCode, cardDetailsResponse.issuingCountryCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(brands, issuingCountryCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CardDetailsResponse {\n");
    sb.append("    brands: ").append(toIndentedString(brands)).append("\n");
    sb.append("    issuingCountryCode: ").append(toIndentedString(issuingCountryCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of CardDetailsResponse given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of CardDetailsResponse
   * @throws JsonProcessingException if the JSON string is invalid with respect to CardDetailsResponse
   */
  public static CardDetailsResponse fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, CardDetailsResponse.class);
  }
/**
  * Convert an instance of CardDetailsResponse to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

