/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayfund;

import com.adyen.model.marketpayfund.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"destinationAccountCode", "merchantReference", "sourceAccountCode"})
public class SetupBeneficiaryRequest {
    public static final String JSON_PROPERTY_DESTINATION_ACCOUNT_CODE = "destinationAccountCode";
    private String destinationAccountCode;
    public static final String JSON_PROPERTY_MERCHANT_REFERENCE = "merchantReference";
    private String merchantReference;
    public static final String JSON_PROPERTY_SOURCE_ACCOUNT_CODE = "sourceAccountCode";
    private String sourceAccountCode;

    public SetupBeneficiaryRequest destinationAccountCode(String destinationAccountCode) {
        this.destinationAccountCode = destinationAccountCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The destination account code.")
    @JsonProperty(value="destinationAccountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDestinationAccountCode() {
        return this.destinationAccountCode;
    }

    @JsonProperty(value="destinationAccountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDestinationAccountCode(String destinationAccountCode) {
        this.destinationAccountCode = destinationAccountCode;
    }

    public SetupBeneficiaryRequest merchantReference(String merchantReference) {
        this.merchantReference = merchantReference;
        return this;
    }

    @ApiModelProperty(value="A value that can be supplied at the discretion of the executing user.")
    @JsonProperty(value="merchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantReference() {
        return this.merchantReference;
    }

    @JsonProperty(value="merchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantReference(String merchantReference) {
        this.merchantReference = merchantReference;
    }

    public SetupBeneficiaryRequest sourceAccountCode(String sourceAccountCode) {
        this.sourceAccountCode = sourceAccountCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The benefactor account.")
    @JsonProperty(value="sourceAccountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSourceAccountCode() {
        return this.sourceAccountCode;
    }

    @JsonProperty(value="sourceAccountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceAccountCode(String sourceAccountCode) {
        this.sourceAccountCode = sourceAccountCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetupBeneficiaryRequest setupBeneficiaryRequest = (SetupBeneficiaryRequest)o;
        return Objects.equals(this.destinationAccountCode, setupBeneficiaryRequest.destinationAccountCode) && Objects.equals(this.merchantReference, setupBeneficiaryRequest.merchantReference) && Objects.equals(this.sourceAccountCode, setupBeneficiaryRequest.sourceAccountCode);
    }

    public int hashCode() {
        return Objects.hash(this.destinationAccountCode, this.merchantReference, this.sourceAccountCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SetupBeneficiaryRequest {\n");
        sb.append("    destinationAccountCode: ").append(this.toIndentedString(this.destinationAccountCode)).append("\n");
        sb.append("    merchantReference: ").append(this.toIndentedString(this.merchantReference)).append("\n");
        sb.append("    sourceAccountCode: ").append(this.toIndentedString(this.sourceAccountCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static SetupBeneficiaryRequest fromJson(String jsonString) throws JsonProcessingException {
        return (SetupBeneficiaryRequest)JSON.getMapper().readValue(jsonString, SetupBeneficiaryRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

