/*
 * Transfers API
 *
 * The version of the OpenAPI document: 4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.transfers;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * CardIdentification
 */
@JsonPropertyOrder({
  CardIdentification.JSON_PROPERTY_EXPIRY_MONTH,
  CardIdentification.JSON_PROPERTY_EXPIRY_YEAR,
  CardIdentification.JSON_PROPERTY_ISSUE_NUMBER,
  CardIdentification.JSON_PROPERTY_NUMBER,
  CardIdentification.JSON_PROPERTY_START_MONTH,
  CardIdentification.JSON_PROPERTY_START_YEAR,
  CardIdentification.JSON_PROPERTY_STORED_PAYMENT_METHOD_ID
})

public class CardIdentification {
  public static final String JSON_PROPERTY_EXPIRY_MONTH = "expiryMonth";
  private String expiryMonth;

  public static final String JSON_PROPERTY_EXPIRY_YEAR = "expiryYear";
  private String expiryYear;

  public static final String JSON_PROPERTY_ISSUE_NUMBER = "issueNumber";
  private String issueNumber;

  public static final String JSON_PROPERTY_NUMBER = "number";
  private String number;

  public static final String JSON_PROPERTY_START_MONTH = "startMonth";
  private String startMonth;

  public static final String JSON_PROPERTY_START_YEAR = "startYear";
  private String startYear;

  public static final String JSON_PROPERTY_STORED_PAYMENT_METHOD_ID = "storedPaymentMethodId";
  private String storedPaymentMethodId;

  public CardIdentification() { 
  }

  public CardIdentification expiryMonth(String expiryMonth) {
    this.expiryMonth = expiryMonth;
    return this;
  }

   /**
   * The expiry month of the card.  Format: two digits. Add a leading zero for single-digit months. For example: * 03 &#x3D; March * 11 &#x3D; November
   * @return expiryMonth
  **/
  @ApiModelProperty(value = "The expiry month of the card.  Format: two digits. Add a leading zero for single-digit months. For example: * 03 = March * 11 = November")
  @JsonProperty(JSON_PROPERTY_EXPIRY_MONTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExpiryMonth() {
    return expiryMonth;
  }


 /**
  * The expiry month of the card.  Format: two digits. Add a leading zero for single-digit months. For example: * 03 &#x3D; March * 11 &#x3D; November
  *
  * @param expiryMonth
  */ 
  @JsonProperty(JSON_PROPERTY_EXPIRY_MONTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExpiryMonth(String expiryMonth) {
    this.expiryMonth = expiryMonth;
  }


  public CardIdentification expiryYear(String expiryYear) {
    this.expiryYear = expiryYear;
    return this;
  }

   /**
   * The expiry year of the card.  Format: four digits. For example: 2020
   * @return expiryYear
  **/
  @ApiModelProperty(value = "The expiry year of the card.  Format: four digits. For example: 2020")
  @JsonProperty(JSON_PROPERTY_EXPIRY_YEAR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExpiryYear() {
    return expiryYear;
  }


 /**
  * The expiry year of the card.  Format: four digits. For example: 2020
  *
  * @param expiryYear
  */ 
  @JsonProperty(JSON_PROPERTY_EXPIRY_YEAR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExpiryYear(String expiryYear) {
    this.expiryYear = expiryYear;
  }


  public CardIdentification issueNumber(String issueNumber) {
    this.issueNumber = issueNumber;
    return this;
  }

   /**
   * The issue number of the card. Applies only to some UK debit cards.
   * @return issueNumber
  **/
  @ApiModelProperty(value = "The issue number of the card. Applies only to some UK debit cards.")
  @JsonProperty(JSON_PROPERTY_ISSUE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIssueNumber() {
    return issueNumber;
  }


 /**
  * The issue number of the card. Applies only to some UK debit cards.
  *
  * @param issueNumber
  */ 
  @JsonProperty(JSON_PROPERTY_ISSUE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIssueNumber(String issueNumber) {
    this.issueNumber = issueNumber;
  }


  public CardIdentification number(String number) {
    this.number = number;
    return this;
  }

   /**
   * The card number without any separators.  For security, the response only includes the last four digits of the card number.
   * @return number
  **/
  @ApiModelProperty(value = "The card number without any separators.  For security, the response only includes the last four digits of the card number.")
  @JsonProperty(JSON_PROPERTY_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getNumber() {
    return number;
  }


 /**
  * The card number without any separators.  For security, the response only includes the last four digits of the card number.
  *
  * @param number
  */ 
  @JsonProperty(JSON_PROPERTY_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumber(String number) {
    this.number = number;
  }


  public CardIdentification startMonth(String startMonth) {
    this.startMonth = startMonth;
    return this;
  }

   /**
   * The month when the card was issued. Applies only to some UK debit cards.  Format: two digits. Add a leading zero for single-digit months. For example: * 03 &#x3D; March * 11 &#x3D; November
   * @return startMonth
  **/
  @ApiModelProperty(value = "The month when the card was issued. Applies only to some UK debit cards.  Format: two digits. Add a leading zero for single-digit months. For example: * 03 = March * 11 = November")
  @JsonProperty(JSON_PROPERTY_START_MONTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStartMonth() {
    return startMonth;
  }


 /**
  * The month when the card was issued. Applies only to some UK debit cards.  Format: two digits. Add a leading zero for single-digit months. For example: * 03 &#x3D; March * 11 &#x3D; November
  *
  * @param startMonth
  */ 
  @JsonProperty(JSON_PROPERTY_START_MONTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartMonth(String startMonth) {
    this.startMonth = startMonth;
  }


  public CardIdentification startYear(String startYear) {
    this.startYear = startYear;
    return this;
  }

   /**
   * The year when the card was issued. Applies only to some UK debit cards.  Format: four digits. For example: 2020
   * @return startYear
  **/
  @ApiModelProperty(value = "The year when the card was issued. Applies only to some UK debit cards.  Format: four digits. For example: 2020")
  @JsonProperty(JSON_PROPERTY_START_YEAR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStartYear() {
    return startYear;
  }


 /**
  * The year when the card was issued. Applies only to some UK debit cards.  Format: four digits. For example: 2020
  *
  * @param startYear
  */ 
  @JsonProperty(JSON_PROPERTY_START_YEAR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartYear(String startYear) {
    this.startYear = startYear;
  }


  public CardIdentification storedPaymentMethodId(String storedPaymentMethodId) {
    this.storedPaymentMethodId = storedPaymentMethodId;
    return this;
  }

   /**
   * The unique [token](/payouts/payout-service/pay-out-to-cards/manage-card-information#save-card-details) created to identify the counterparty.  
   * @return storedPaymentMethodId
  **/
  @ApiModelProperty(value = "The unique [token](/payouts/payout-service/pay-out-to-cards/manage-card-information#save-card-details) created to identify the counterparty.  ")
  @JsonProperty(JSON_PROPERTY_STORED_PAYMENT_METHOD_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStoredPaymentMethodId() {
    return storedPaymentMethodId;
  }


 /**
  * The unique [token](/payouts/payout-service/pay-out-to-cards/manage-card-information#save-card-details) created to identify the counterparty.  
  *
  * @param storedPaymentMethodId
  */ 
  @JsonProperty(JSON_PROPERTY_STORED_PAYMENT_METHOD_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStoredPaymentMethodId(String storedPaymentMethodId) {
    this.storedPaymentMethodId = storedPaymentMethodId;
  }


  /**
   * Return true if this CardIdentification object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CardIdentification cardIdentification = (CardIdentification) o;
    return Objects.equals(this.expiryMonth, cardIdentification.expiryMonth) &&
        Objects.equals(this.expiryYear, cardIdentification.expiryYear) &&
        Objects.equals(this.issueNumber, cardIdentification.issueNumber) &&
        Objects.equals(this.number, cardIdentification.number) &&
        Objects.equals(this.startMonth, cardIdentification.startMonth) &&
        Objects.equals(this.startYear, cardIdentification.startYear) &&
        Objects.equals(this.storedPaymentMethodId, cardIdentification.storedPaymentMethodId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(expiryMonth, expiryYear, issueNumber, number, startMonth, startYear, storedPaymentMethodId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CardIdentification {\n");
    sb.append("    expiryMonth: ").append(toIndentedString(expiryMonth)).append("\n");
    sb.append("    expiryYear: ").append(toIndentedString(expiryYear)).append("\n");
    sb.append("    issueNumber: ").append(toIndentedString(issueNumber)).append("\n");
    sb.append("    number: ").append(toIndentedString(number)).append("\n");
    sb.append("    startMonth: ").append(toIndentedString(startMonth)).append("\n");
    sb.append("    startYear: ").append(toIndentedString(startYear)).append("\n");
    sb.append("    storedPaymentMethodId: ").append(toIndentedString(storedPaymentMethodId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of CardIdentification given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of CardIdentification
   * @throws JsonProcessingException if the JSON string is invalid with respect to CardIdentification
   */
  public static CardIdentification fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, CardIdentification.class);
  }
/**
  * Convert an instance of CardIdentification to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

