/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayfund;

import com.adyen.model.marketpayfund.Amount;
import com.adyen.model.marketpayfund.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"balance", "onHoldBalance", "pendingBalance"})
public class DetailBalance {
    public static final String JSON_PROPERTY_BALANCE = "balance";
    private List<Amount> balance = null;
    public static final String JSON_PROPERTY_ON_HOLD_BALANCE = "onHoldBalance";
    private List<Amount> onHoldBalance = null;
    public static final String JSON_PROPERTY_PENDING_BALANCE = "pendingBalance";
    private List<Amount> pendingBalance = null;

    public DetailBalance balance(List<Amount> balance) {
        this.balance = balance;
        return this;
    }

    public DetailBalance addBalanceItem(Amount balanceItem) {
        if (this.balance == null) {
            this.balance = new ArrayList<Amount>();
        }
        this.balance.add(balanceItem);
        return this;
    }

    @ApiModelProperty(value="The list of balances held by the account.")
    @JsonProperty(value="balance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Amount> getBalance() {
        return this.balance;
    }

    @JsonProperty(value="balance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalance(List<Amount> balance) {
        this.balance = balance;
    }

    public DetailBalance onHoldBalance(List<Amount> onHoldBalance) {
        this.onHoldBalance = onHoldBalance;
        return this;
    }

    public DetailBalance addOnHoldBalanceItem(Amount onHoldBalanceItem) {
        if (this.onHoldBalance == null) {
            this.onHoldBalance = new ArrayList<Amount>();
        }
        this.onHoldBalance.add(onHoldBalanceItem);
        return this;
    }

    @ApiModelProperty(value="The list of on hold balances held by the account.")
    @JsonProperty(value="onHoldBalance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Amount> getOnHoldBalance() {
        return this.onHoldBalance;
    }

    @JsonProperty(value="onHoldBalance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOnHoldBalance(List<Amount> onHoldBalance) {
        this.onHoldBalance = onHoldBalance;
    }

    public DetailBalance pendingBalance(List<Amount> pendingBalance) {
        this.pendingBalance = pendingBalance;
        return this;
    }

    public DetailBalance addPendingBalanceItem(Amount pendingBalanceItem) {
        if (this.pendingBalance == null) {
            this.pendingBalance = new ArrayList<Amount>();
        }
        this.pendingBalance.add(pendingBalanceItem);
        return this;
    }

    @ApiModelProperty(value="The list of pending balances held by the account.")
    @JsonProperty(value="pendingBalance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Amount> getPendingBalance() {
        return this.pendingBalance;
    }

    @JsonProperty(value="pendingBalance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPendingBalance(List<Amount> pendingBalance) {
        this.pendingBalance = pendingBalance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DetailBalance detailBalance = (DetailBalance)o;
        return Objects.equals(this.balance, detailBalance.balance) && Objects.equals(this.onHoldBalance, detailBalance.onHoldBalance) && Objects.equals(this.pendingBalance, detailBalance.pendingBalance);
    }

    public int hashCode() {
        return Objects.hash(this.balance, this.onHoldBalance, this.pendingBalance);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DetailBalance {\n");
        sb.append("    balance: ").append(this.toIndentedString(this.balance)).append("\n");
        sb.append("    onHoldBalance: ").append(this.toIndentedString(this.onHoldBalance)).append("\n");
        sb.append("    pendingBalance: ").append(this.toIndentedString(this.pendingBalance)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static DetailBalance fromJson(String jsonString) throws JsonProcessingException {
        return (DetailBalance)JSON.getMapper().readValue(jsonString, DetailBalance.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

