/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.checkout;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.checkout.Amount;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * CheckoutBankTransferAction
 */
@JsonPropertyOrder({
  CheckoutBankTransferAction.JSON_PROPERTY_ACCOUNT_NUMBER,
  CheckoutBankTransferAction.JSON_PROPERTY_BENEFICIARY,
  CheckoutBankTransferAction.JSON_PROPERTY_BIC,
  CheckoutBankTransferAction.JSON_PROPERTY_DOWNLOAD_URL,
  CheckoutBankTransferAction.JSON_PROPERTY_IBAN,
  CheckoutBankTransferAction.JSON_PROPERTY_PAYMENT_METHOD_TYPE,
  CheckoutBankTransferAction.JSON_PROPERTY_REFERENCE,
  CheckoutBankTransferAction.JSON_PROPERTY_ROUTING_NUMBER,
  CheckoutBankTransferAction.JSON_PROPERTY_SHOPPER_EMAIL,
  CheckoutBankTransferAction.JSON_PROPERTY_SORT_CODE,
  CheckoutBankTransferAction.JSON_PROPERTY_TOTAL_AMOUNT,
  CheckoutBankTransferAction.JSON_PROPERTY_TYPE,
  CheckoutBankTransferAction.JSON_PROPERTY_URL
})

public class CheckoutBankTransferAction {
  public static final String JSON_PROPERTY_ACCOUNT_NUMBER = "accountNumber";
  private String accountNumber;

  public static final String JSON_PROPERTY_BENEFICIARY = "beneficiary";
  private String beneficiary;

  public static final String JSON_PROPERTY_BIC = "bic";
  private String bic;

  public static final String JSON_PROPERTY_DOWNLOAD_URL = "downloadUrl";
  private String downloadUrl;

  public static final String JSON_PROPERTY_IBAN = "iban";
  private String iban;

  public static final String JSON_PROPERTY_PAYMENT_METHOD_TYPE = "paymentMethodType";
  private String paymentMethodType;

  public static final String JSON_PROPERTY_REFERENCE = "reference";
  private String reference;

  public static final String JSON_PROPERTY_ROUTING_NUMBER = "routingNumber";
  private String routingNumber;

  public static final String JSON_PROPERTY_SHOPPER_EMAIL = "shopperEmail";
  private String shopperEmail;

  public static final String JSON_PROPERTY_SORT_CODE = "sortCode";
  private String sortCode;

  public static final String JSON_PROPERTY_TOTAL_AMOUNT = "totalAmount";
  private Amount totalAmount;

  /**
   * The type of the action.
   */
  public enum TypeEnum {
    BANKTRANSFER("bankTransfer");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_URL = "url";
  private String url;

  public CheckoutBankTransferAction() { 
  }

  public CheckoutBankTransferAction accountNumber(String accountNumber) {
    this.accountNumber = accountNumber;
    return this;
  }

   /**
   * The account number of the bank transfer.
   * @return accountNumber
  **/
  @ApiModelProperty(value = "The account number of the bank transfer.")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAccountNumber() {
    return accountNumber;
  }


 /**
  * The account number of the bank transfer.
  *
  * @param accountNumber
  */ 
  @JsonProperty(JSON_PROPERTY_ACCOUNT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccountNumber(String accountNumber) {
    this.accountNumber = accountNumber;
  }


  public CheckoutBankTransferAction beneficiary(String beneficiary) {
    this.beneficiary = beneficiary;
    return this;
  }

   /**
   * The name of the account holder.
   * @return beneficiary
  **/
  @ApiModelProperty(value = "The name of the account holder.")
  @JsonProperty(JSON_PROPERTY_BENEFICIARY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBeneficiary() {
    return beneficiary;
  }


 /**
  * The name of the account holder.
  *
  * @param beneficiary
  */ 
  @JsonProperty(JSON_PROPERTY_BENEFICIARY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBeneficiary(String beneficiary) {
    this.beneficiary = beneficiary;
  }


  public CheckoutBankTransferAction bic(String bic) {
    this.bic = bic;
    return this;
  }

   /**
   * The BIC of the IBAN.
   * @return bic
  **/
  @ApiModelProperty(value = "The BIC of the IBAN.")
  @JsonProperty(JSON_PROPERTY_BIC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBic() {
    return bic;
  }


 /**
  * The BIC of the IBAN.
  *
  * @param bic
  */ 
  @JsonProperty(JSON_PROPERTY_BIC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBic(String bic) {
    this.bic = bic;
  }


  public CheckoutBankTransferAction downloadUrl(String downloadUrl) {
    this.downloadUrl = downloadUrl;
    return this;
  }

   /**
   * The url to download payment details with.
   * @return downloadUrl
  **/
  @ApiModelProperty(value = "The url to download payment details with.")
  @JsonProperty(JSON_PROPERTY_DOWNLOAD_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDownloadUrl() {
    return downloadUrl;
  }


 /**
  * The url to download payment details with.
  *
  * @param downloadUrl
  */ 
  @JsonProperty(JSON_PROPERTY_DOWNLOAD_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDownloadUrl(String downloadUrl) {
    this.downloadUrl = downloadUrl;
  }


  public CheckoutBankTransferAction iban(String iban) {
    this.iban = iban;
    return this;
  }

   /**
   * The IBAN of the bank transfer.
   * @return iban
  **/
  @ApiModelProperty(value = "The IBAN of the bank transfer.")
  @JsonProperty(JSON_PROPERTY_IBAN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIban() {
    return iban;
  }


 /**
  * The IBAN of the bank transfer.
  *
  * @param iban
  */ 
  @JsonProperty(JSON_PROPERTY_IBAN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIban(String iban) {
    this.iban = iban;
  }


  public CheckoutBankTransferAction paymentMethodType(String paymentMethodType) {
    this.paymentMethodType = paymentMethodType;
    return this;
  }

   /**
   * Specifies the payment method.
   * @return paymentMethodType
  **/
  @ApiModelProperty(value = "Specifies the payment method.")
  @JsonProperty(JSON_PROPERTY_PAYMENT_METHOD_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPaymentMethodType() {
    return paymentMethodType;
  }


 /**
  * Specifies the payment method.
  *
  * @param paymentMethodType
  */ 
  @JsonProperty(JSON_PROPERTY_PAYMENT_METHOD_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentMethodType(String paymentMethodType) {
    this.paymentMethodType = paymentMethodType;
  }


  public CheckoutBankTransferAction reference(String reference) {
    this.reference = reference;
    return this;
  }

   /**
   * The transfer reference.
   * @return reference
  **/
  @ApiModelProperty(value = "The transfer reference.")
  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReference() {
    return reference;
  }


 /**
  * The transfer reference.
  *
  * @param reference
  */ 
  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReference(String reference) {
    this.reference = reference;
  }


  public CheckoutBankTransferAction routingNumber(String routingNumber) {
    this.routingNumber = routingNumber;
    return this;
  }

   /**
   * The routing number of the bank transfer.
   * @return routingNumber
  **/
  @ApiModelProperty(value = "The routing number of the bank transfer.")
  @JsonProperty(JSON_PROPERTY_ROUTING_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRoutingNumber() {
    return routingNumber;
  }


 /**
  * The routing number of the bank transfer.
  *
  * @param routingNumber
  */ 
  @JsonProperty(JSON_PROPERTY_ROUTING_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoutingNumber(String routingNumber) {
    this.routingNumber = routingNumber;
  }


  public CheckoutBankTransferAction shopperEmail(String shopperEmail) {
    this.shopperEmail = shopperEmail;
    return this;
  }

   /**
   * The e-mail of the shopper, included if an e-mail was sent to the shopper.
   * @return shopperEmail
  **/
  @ApiModelProperty(value = "The e-mail of the shopper, included if an e-mail was sent to the shopper.")
  @JsonProperty(JSON_PROPERTY_SHOPPER_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getShopperEmail() {
    return shopperEmail;
  }


 /**
  * The e-mail of the shopper, included if an e-mail was sent to the shopper.
  *
  * @param shopperEmail
  */ 
  @JsonProperty(JSON_PROPERTY_SHOPPER_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperEmail(String shopperEmail) {
    this.shopperEmail = shopperEmail;
  }


  public CheckoutBankTransferAction sortCode(String sortCode) {
    this.sortCode = sortCode;
    return this;
  }

   /**
   * The sort code of the bank transfer.
   * @return sortCode
  **/
  @ApiModelProperty(value = "The sort code of the bank transfer.")
  @JsonProperty(JSON_PROPERTY_SORT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSortCode() {
    return sortCode;
  }


 /**
  * The sort code of the bank transfer.
  *
  * @param sortCode
  */ 
  @JsonProperty(JSON_PROPERTY_SORT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSortCode(String sortCode) {
    this.sortCode = sortCode;
  }


  public CheckoutBankTransferAction totalAmount(Amount totalAmount) {
    this.totalAmount = totalAmount;
    return this;
  }

   /**
   * Get totalAmount
   * @return totalAmount
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Amount getTotalAmount() {
    return totalAmount;
  }


 /**
  * totalAmount
  *
  * @param totalAmount
  */ 
  @JsonProperty(JSON_PROPERTY_TOTAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalAmount(Amount totalAmount) {
    this.totalAmount = totalAmount;
  }


  public CheckoutBankTransferAction type(TypeEnum type) {
    this.type = type;
    return this;
  }

   /**
   * The type of the action.
   * @return type
  **/
  @ApiModelProperty(required = true, value = "The type of the action.")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


 /**
  * The type of the action.
  *
  * @param type
  */ 
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public CheckoutBankTransferAction url(String url) {
    this.url = url;
    return this;
  }

   /**
   * Specifies the URL to redirect to.
   * @return url
  **/
  @ApiModelProperty(value = "Specifies the URL to redirect to.")
  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUrl() {
    return url;
  }


 /**
  * Specifies the URL to redirect to.
  *
  * @param url
  */ 
  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUrl(String url) {
    this.url = url;
  }


  /**
   * Return true if this CheckoutBankTransferAction object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CheckoutBankTransferAction checkoutBankTransferAction = (CheckoutBankTransferAction) o;
    return Objects.equals(this.accountNumber, checkoutBankTransferAction.accountNumber) &&
        Objects.equals(this.beneficiary, checkoutBankTransferAction.beneficiary) &&
        Objects.equals(this.bic, checkoutBankTransferAction.bic) &&
        Objects.equals(this.downloadUrl, checkoutBankTransferAction.downloadUrl) &&
        Objects.equals(this.iban, checkoutBankTransferAction.iban) &&
        Objects.equals(this.paymentMethodType, checkoutBankTransferAction.paymentMethodType) &&
        Objects.equals(this.reference, checkoutBankTransferAction.reference) &&
        Objects.equals(this.routingNumber, checkoutBankTransferAction.routingNumber) &&
        Objects.equals(this.shopperEmail, checkoutBankTransferAction.shopperEmail) &&
        Objects.equals(this.sortCode, checkoutBankTransferAction.sortCode) &&
        Objects.equals(this.totalAmount, checkoutBankTransferAction.totalAmount) &&
        Objects.equals(this.type, checkoutBankTransferAction.type) &&
        Objects.equals(this.url, checkoutBankTransferAction.url);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountNumber, beneficiary, bic, downloadUrl, iban, paymentMethodType, reference, routingNumber, shopperEmail, sortCode, totalAmount, type, url);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CheckoutBankTransferAction {\n");
    sb.append("    accountNumber: ").append(toIndentedString(accountNumber)).append("\n");
    sb.append("    beneficiary: ").append(toIndentedString(beneficiary)).append("\n");
    sb.append("    bic: ").append(toIndentedString(bic)).append("\n");
    sb.append("    downloadUrl: ").append(toIndentedString(downloadUrl)).append("\n");
    sb.append("    iban: ").append(toIndentedString(iban)).append("\n");
    sb.append("    paymentMethodType: ").append(toIndentedString(paymentMethodType)).append("\n");
    sb.append("    reference: ").append(toIndentedString(reference)).append("\n");
    sb.append("    routingNumber: ").append(toIndentedString(routingNumber)).append("\n");
    sb.append("    shopperEmail: ").append(toIndentedString(shopperEmail)).append("\n");
    sb.append("    sortCode: ").append(toIndentedString(sortCode)).append("\n");
    sb.append("    totalAmount: ").append(toIndentedString(totalAmount)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of CheckoutBankTransferAction given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of CheckoutBankTransferAction
   * @throws JsonProcessingException if the JSON string is invalid with respect to CheckoutBankTransferAction
   */
  public static CheckoutBankTransferAction fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, CheckoutBankTransferAction.class);
  }
/**
  * Convert an instance of CheckoutBankTransferAction to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

