/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.management;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.management.AccelInfo;
import com.adyen.model.management.AfterpayTouchInfo;
import com.adyen.model.management.AmexInfo;
import com.adyen.model.management.ApplePayInfo;
import com.adyen.model.management.BcmcInfo;
import com.adyen.model.management.CartesBancairesInfo;
import com.adyen.model.management.ClearpayInfo;
import com.adyen.model.management.GenericPmWithTdiInfo;
import com.adyen.model.management.GiroPayInfo;
import com.adyen.model.management.GooglePayInfo;
import com.adyen.model.management.KlarnaInfo;
import com.adyen.model.management.MealVoucherFRInfo;
import com.adyen.model.management.NyceInfo;
import com.adyen.model.management.PayMeInfo;
import com.adyen.model.management.PayPalInfo;
import com.adyen.model.management.PulseInfo;
import com.adyen.model.management.SodexoInfo;
import com.adyen.model.management.SofortInfo;
import com.adyen.model.management.StarInfo;
import com.adyen.model.management.SwishInfo;
import com.adyen.model.management.TicketInfo;
import com.adyen.model.management.TwintInfo;
import com.adyen.model.management.VippsInfo;
import com.adyen.model.management.WeChatPayInfo;
import com.adyen.model.management.WeChatPayPosInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * PaymentMethod
 */
@JsonPropertyOrder({
  PaymentMethod.JSON_PROPERTY_ACCEL,
  PaymentMethod.JSON_PROPERTY_AFTERPAY_TOUCH,
  PaymentMethod.JSON_PROPERTY_ALLOWED,
  PaymentMethod.JSON_PROPERTY_AMEX,
  PaymentMethod.JSON_PROPERTY_APPLE_PAY,
  PaymentMethod.JSON_PROPERTY_BCMC,
  PaymentMethod.JSON_PROPERTY_BUSINESS_LINE_ID,
  PaymentMethod.JSON_PROPERTY_CARTES_BANCAIRES,
  PaymentMethod.JSON_PROPERTY_CLEARPAY,
  PaymentMethod.JSON_PROPERTY_COUNTRIES,
  PaymentMethod.JSON_PROPERTY_CUP,
  PaymentMethod.JSON_PROPERTY_CURRENCIES,
  PaymentMethod.JSON_PROPERTY_CUSTOM_ROUTING_FLAGS,
  PaymentMethod.JSON_PROPERTY_DINERS,
  PaymentMethod.JSON_PROPERTY_DISCOVER,
  PaymentMethod.JSON_PROPERTY_EFTPOS_AUSTRALIA,
  PaymentMethod.JSON_PROPERTY_ENABLED,
  PaymentMethod.JSON_PROPERTY_GIRO_PAY,
  PaymentMethod.JSON_PROPERTY_GIROCARD,
  PaymentMethod.JSON_PROPERTY_GOOGLE_PAY,
  PaymentMethod.JSON_PROPERTY_ID,
  PaymentMethod.JSON_PROPERTY_IDEAL,
  PaymentMethod.JSON_PROPERTY_INTERAC_CARD,
  PaymentMethod.JSON_PROPERTY_JCB,
  PaymentMethod.JSON_PROPERTY_KLARNA,
  PaymentMethod.JSON_PROPERTY_MAESTRO,
  PaymentMethod.JSON_PROPERTY_MC,
  PaymentMethod.JSON_PROPERTY_MEAL_VOUCHER_F_R,
  PaymentMethod.JSON_PROPERTY_NYCE,
  PaymentMethod.JSON_PROPERTY_PAYME,
  PaymentMethod.JSON_PROPERTY_PAYPAL,
  PaymentMethod.JSON_PROPERTY_PULSE,
  PaymentMethod.JSON_PROPERTY_REFERENCE,
  PaymentMethod.JSON_PROPERTY_SHOPPER_INTERACTION,
  PaymentMethod.JSON_PROPERTY_SODEXO,
  PaymentMethod.JSON_PROPERTY_SOFORT,
  PaymentMethod.JSON_PROPERTY_STAR,
  PaymentMethod.JSON_PROPERTY_STORE_IDS,
  PaymentMethod.JSON_PROPERTY_SWISH,
  PaymentMethod.JSON_PROPERTY_TICKET,
  PaymentMethod.JSON_PROPERTY_TWINT,
  PaymentMethod.JSON_PROPERTY_TYPE,
  PaymentMethod.JSON_PROPERTY_VERIFICATION_STATUS,
  PaymentMethod.JSON_PROPERTY_VIPPS,
  PaymentMethod.JSON_PROPERTY_VISA,
  PaymentMethod.JSON_PROPERTY_WECHATPAY,
  PaymentMethod.JSON_PROPERTY_WECHATPAY_POS
})

public class PaymentMethod {
  public static final String JSON_PROPERTY_ACCEL = "accel";
  private AccelInfo accel;

  public static final String JSON_PROPERTY_AFTERPAY_TOUCH = "afterpayTouch";
  private AfterpayTouchInfo afterpayTouch;

  public static final String JSON_PROPERTY_ALLOWED = "allowed";
  private Boolean allowed;

  public static final String JSON_PROPERTY_AMEX = "amex";
  private AmexInfo amex;

  public static final String JSON_PROPERTY_APPLE_PAY = "applePay";
  private ApplePayInfo applePay;

  public static final String JSON_PROPERTY_BCMC = "bcmc";
  private BcmcInfo bcmc;

  public static final String JSON_PROPERTY_BUSINESS_LINE_ID = "businessLineId";
  private String businessLineId;

  public static final String JSON_PROPERTY_CARTES_BANCAIRES = "cartesBancaires";
  private CartesBancairesInfo cartesBancaires;

  public static final String JSON_PROPERTY_CLEARPAY = "clearpay";
  private ClearpayInfo clearpay;

  public static final String JSON_PROPERTY_COUNTRIES = "countries";
  private List<String> countries = null;

  public static final String JSON_PROPERTY_CUP = "cup";
  private GenericPmWithTdiInfo cup;

  public static final String JSON_PROPERTY_CURRENCIES = "currencies";
  private List<String> currencies = null;

  public static final String JSON_PROPERTY_CUSTOM_ROUTING_FLAGS = "customRoutingFlags";
  private List<String> customRoutingFlags = null;

  public static final String JSON_PROPERTY_DINERS = "diners";
  private GenericPmWithTdiInfo diners;

  public static final String JSON_PROPERTY_DISCOVER = "discover";
  private GenericPmWithTdiInfo discover;

  public static final String JSON_PROPERTY_EFTPOS_AUSTRALIA = "eftpos_australia";
  private GenericPmWithTdiInfo eftposAustralia;

  public static final String JSON_PROPERTY_ENABLED = "enabled";
  private Boolean enabled;

  public static final String JSON_PROPERTY_GIRO_PAY = "giroPay";
  private GiroPayInfo giroPay;

  public static final String JSON_PROPERTY_GIROCARD = "girocard";
  private GenericPmWithTdiInfo girocard;

  public static final String JSON_PROPERTY_GOOGLE_PAY = "googlePay";
  private GooglePayInfo googlePay;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_IDEAL = "ideal";
  private GenericPmWithTdiInfo ideal;

  public static final String JSON_PROPERTY_INTERAC_CARD = "interac_card";
  private GenericPmWithTdiInfo interacCard;

  public static final String JSON_PROPERTY_JCB = "jcb";
  private GenericPmWithTdiInfo jcb;

  public static final String JSON_PROPERTY_KLARNA = "klarna";
  private KlarnaInfo klarna;

  public static final String JSON_PROPERTY_MAESTRO = "maestro";
  private GenericPmWithTdiInfo maestro;

  public static final String JSON_PROPERTY_MC = "mc";
  private GenericPmWithTdiInfo mc;

  public static final String JSON_PROPERTY_MEAL_VOUCHER_F_R = "mealVoucher_FR";
  private MealVoucherFRInfo mealVoucherFR;

  public static final String JSON_PROPERTY_NYCE = "nyce";
  private NyceInfo nyce;

  public static final String JSON_PROPERTY_PAYME = "payme";
  private PayMeInfo payme;

  public static final String JSON_PROPERTY_PAYPAL = "paypal";
  private PayPalInfo paypal;

  public static final String JSON_PROPERTY_PULSE = "pulse";
  private PulseInfo pulse;

  public static final String JSON_PROPERTY_REFERENCE = "reference";
  private String reference;

  public static final String JSON_PROPERTY_SHOPPER_INTERACTION = "shopperInteraction";
  private String shopperInteraction;

  public static final String JSON_PROPERTY_SODEXO = "sodexo";
  private SodexoInfo sodexo;

  public static final String JSON_PROPERTY_SOFORT = "sofort";
  private SofortInfo sofort;

  public static final String JSON_PROPERTY_STAR = "star";
  private StarInfo star;

  public static final String JSON_PROPERTY_STORE_IDS = "storeIds";
  private List<String> storeIds = null;

  public static final String JSON_PROPERTY_SWISH = "swish";
  private SwishInfo swish;

  public static final String JSON_PROPERTY_TICKET = "ticket";
  private TicketInfo ticket;

  public static final String JSON_PROPERTY_TWINT = "twint";
  private TwintInfo twint;

  public static final String JSON_PROPERTY_TYPE = "type";
  private String type;

  /**
   * Payment method status. Possible values: * **valid** * **pending** * **invalid** * **rejected**
   */
  public enum VerificationStatusEnum {
    VALID("valid"),
    
    PENDING("pending"),
    
    INVALID("invalid"),
    
    REJECTED("rejected");

    private String value;

    VerificationStatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static VerificationStatusEnum fromValue(String value) {
      for (VerificationStatusEnum b : VerificationStatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_VERIFICATION_STATUS = "verificationStatus";
  private VerificationStatusEnum verificationStatus;

  public static final String JSON_PROPERTY_VIPPS = "vipps";
  private VippsInfo vipps;

  public static final String JSON_PROPERTY_VISA = "visa";
  private GenericPmWithTdiInfo visa;

  public static final String JSON_PROPERTY_WECHATPAY = "wechatpay";
  private WeChatPayInfo wechatpay;

  public static final String JSON_PROPERTY_WECHATPAY_POS = "wechatpay_pos";
  private WeChatPayPosInfo wechatpayPos;

  public PaymentMethod() { 
  }

  public PaymentMethod accel(AccelInfo accel) {
    this.accel = accel;
    return this;
  }

   /**
   * Get accel
   * @return accel
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ACCEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AccelInfo getAccel() {
    return accel;
  }


 /**
  * accel
  *
  * @param accel
  */ 
  @JsonProperty(JSON_PROPERTY_ACCEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccel(AccelInfo accel) {
    this.accel = accel;
  }


  public PaymentMethod afterpayTouch(AfterpayTouchInfo afterpayTouch) {
    this.afterpayTouch = afterpayTouch;
    return this;
  }

   /**
   * Get afterpayTouch
   * @return afterpayTouch
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_AFTERPAY_TOUCH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AfterpayTouchInfo getAfterpayTouch() {
    return afterpayTouch;
  }


 /**
  * afterpayTouch
  *
  * @param afterpayTouch
  */ 
  @JsonProperty(JSON_PROPERTY_AFTERPAY_TOUCH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAfterpayTouch(AfterpayTouchInfo afterpayTouch) {
    this.afterpayTouch = afterpayTouch;
  }


  public PaymentMethod allowed(Boolean allowed) {
    this.allowed = allowed;
    return this;
  }

   /**
   * Indicates whether receiving payments is allowed. This value is set to **true** by Adyen after screening your merchant account.
   * @return allowed
  **/
  @ApiModelProperty(value = "Indicates whether receiving payments is allowed. This value is set to **true** by Adyen after screening your merchant account.")
  @JsonProperty(JSON_PROPERTY_ALLOWED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAllowed() {
    return allowed;
  }


 /**
  * Indicates whether receiving payments is allowed. This value is set to **true** by Adyen after screening your merchant account.
  *
  * @param allowed
  */ 
  @JsonProperty(JSON_PROPERTY_ALLOWED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllowed(Boolean allowed) {
    this.allowed = allowed;
  }


  public PaymentMethod amex(AmexInfo amex) {
    this.amex = amex;
    return this;
  }

   /**
   * Get amex
   * @return amex
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_AMEX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AmexInfo getAmex() {
    return amex;
  }


 /**
  * amex
  *
  * @param amex
  */ 
  @JsonProperty(JSON_PROPERTY_AMEX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmex(AmexInfo amex) {
    this.amex = amex;
  }


  public PaymentMethod applePay(ApplePayInfo applePay) {
    this.applePay = applePay;
    return this;
  }

   /**
   * Get applePay
   * @return applePay
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_APPLE_PAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApplePayInfo getApplePay() {
    return applePay;
  }


 /**
  * applePay
  *
  * @param applePay
  */ 
  @JsonProperty(JSON_PROPERTY_APPLE_PAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApplePay(ApplePayInfo applePay) {
    this.applePay = applePay;
  }


  public PaymentMethod bcmc(BcmcInfo bcmc) {
    this.bcmc = bcmc;
    return this;
  }

   /**
   * Get bcmc
   * @return bcmc
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_BCMC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BcmcInfo getBcmc() {
    return bcmc;
  }


 /**
  * bcmc
  *
  * @param bcmc
  */ 
  @JsonProperty(JSON_PROPERTY_BCMC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBcmc(BcmcInfo bcmc) {
    this.bcmc = bcmc;
  }


  public PaymentMethod businessLineId(String businessLineId) {
    this.businessLineId = businessLineId;
    return this;
  }

   /**
   * The unique identifier of the business line. Required if you are a [platform model](https://docs.adyen.com/platforms).
   * @return businessLineId
  **/
  @ApiModelProperty(value = "The unique identifier of the business line. Required if you are a [platform model](https://docs.adyen.com/platforms).")
  @JsonProperty(JSON_PROPERTY_BUSINESS_LINE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBusinessLineId() {
    return businessLineId;
  }


 /**
  * The unique identifier of the business line. Required if you are a [platform model](https://docs.adyen.com/platforms).
  *
  * @param businessLineId
  */ 
  @JsonProperty(JSON_PROPERTY_BUSINESS_LINE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBusinessLineId(String businessLineId) {
    this.businessLineId = businessLineId;
  }


  public PaymentMethod cartesBancaires(CartesBancairesInfo cartesBancaires) {
    this.cartesBancaires = cartesBancaires;
    return this;
  }

   /**
   * Get cartesBancaires
   * @return cartesBancaires
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CARTES_BANCAIRES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CartesBancairesInfo getCartesBancaires() {
    return cartesBancaires;
  }


 /**
  * cartesBancaires
  *
  * @param cartesBancaires
  */ 
  @JsonProperty(JSON_PROPERTY_CARTES_BANCAIRES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCartesBancaires(CartesBancairesInfo cartesBancaires) {
    this.cartesBancaires = cartesBancaires;
  }


  public PaymentMethod clearpay(ClearpayInfo clearpay) {
    this.clearpay = clearpay;
    return this;
  }

   /**
   * Get clearpay
   * @return clearpay
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CLEARPAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ClearpayInfo getClearpay() {
    return clearpay;
  }


 /**
  * clearpay
  *
  * @param clearpay
  */ 
  @JsonProperty(JSON_PROPERTY_CLEARPAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClearpay(ClearpayInfo clearpay) {
    this.clearpay = clearpay;
  }


  public PaymentMethod countries(List<String> countries) {
    this.countries = countries;
    return this;
  }

  public PaymentMethod addCountriesItem(String countriesItem) {
    if (this.countries == null) {
      this.countries = new ArrayList<>();
    }
    this.countries.add(countriesItem);
    return this;
  }

   /**
   * The list of countries where a payment method is available. By default, all countries supported by the payment method.
   * @return countries
  **/
  @ApiModelProperty(value = "The list of countries where a payment method is available. By default, all countries supported by the payment method.")
  @JsonProperty(JSON_PROPERTY_COUNTRIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getCountries() {
    return countries;
  }


 /**
  * The list of countries where a payment method is available. By default, all countries supported by the payment method.
  *
  * @param countries
  */ 
  @JsonProperty(JSON_PROPERTY_COUNTRIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountries(List<String> countries) {
    this.countries = countries;
  }


  public PaymentMethod cup(GenericPmWithTdiInfo cup) {
    this.cup = cup;
    return this;
  }

   /**
   * Get cup
   * @return cup
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GenericPmWithTdiInfo getCup() {
    return cup;
  }


 /**
  * cup
  *
  * @param cup
  */ 
  @JsonProperty(JSON_PROPERTY_CUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCup(GenericPmWithTdiInfo cup) {
    this.cup = cup;
  }


  public PaymentMethod currencies(List<String> currencies) {
    this.currencies = currencies;
    return this;
  }

  public PaymentMethod addCurrenciesItem(String currenciesItem) {
    if (this.currencies == null) {
      this.currencies = new ArrayList<>();
    }
    this.currencies.add(currenciesItem);
    return this;
  }

   /**
   * The list of currencies that a payment method supports. By default, all currencies supported by the payment method.
   * @return currencies
  **/
  @ApiModelProperty(value = "The list of currencies that a payment method supports. By default, all currencies supported by the payment method.")
  @JsonProperty(JSON_PROPERTY_CURRENCIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getCurrencies() {
    return currencies;
  }


 /**
  * The list of currencies that a payment method supports. By default, all currencies supported by the payment method.
  *
  * @param currencies
  */ 
  @JsonProperty(JSON_PROPERTY_CURRENCIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrencies(List<String> currencies) {
    this.currencies = currencies;
  }


  public PaymentMethod customRoutingFlags(List<String> customRoutingFlags) {
    this.customRoutingFlags = customRoutingFlags;
    return this;
  }

  public PaymentMethod addCustomRoutingFlagsItem(String customRoutingFlagsItem) {
    if (this.customRoutingFlags == null) {
      this.customRoutingFlags = new ArrayList<>();
    }
    this.customRoutingFlags.add(customRoutingFlagsItem);
    return this;
  }

   /**
   * The list of custom routing flags to route payment to the intended acquirer.
   * @return customRoutingFlags
  **/
  @ApiModelProperty(value = "The list of custom routing flags to route payment to the intended acquirer.")
  @JsonProperty(JSON_PROPERTY_CUSTOM_ROUTING_FLAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getCustomRoutingFlags() {
    return customRoutingFlags;
  }


 /**
  * The list of custom routing flags to route payment to the intended acquirer.
  *
  * @param customRoutingFlags
  */ 
  @JsonProperty(JSON_PROPERTY_CUSTOM_ROUTING_FLAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomRoutingFlags(List<String> customRoutingFlags) {
    this.customRoutingFlags = customRoutingFlags;
  }


  public PaymentMethod diners(GenericPmWithTdiInfo diners) {
    this.diners = diners;
    return this;
  }

   /**
   * Get diners
   * @return diners
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DINERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GenericPmWithTdiInfo getDiners() {
    return diners;
  }


 /**
  * diners
  *
  * @param diners
  */ 
  @JsonProperty(JSON_PROPERTY_DINERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDiners(GenericPmWithTdiInfo diners) {
    this.diners = diners;
  }


  public PaymentMethod discover(GenericPmWithTdiInfo discover) {
    this.discover = discover;
    return this;
  }

   /**
   * Get discover
   * @return discover
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DISCOVER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GenericPmWithTdiInfo getDiscover() {
    return discover;
  }


 /**
  * discover
  *
  * @param discover
  */ 
  @JsonProperty(JSON_PROPERTY_DISCOVER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDiscover(GenericPmWithTdiInfo discover) {
    this.discover = discover;
  }


  public PaymentMethod eftposAustralia(GenericPmWithTdiInfo eftposAustralia) {
    this.eftposAustralia = eftposAustralia;
    return this;
  }

   /**
   * Get eftposAustralia
   * @return eftposAustralia
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_EFTPOS_AUSTRALIA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GenericPmWithTdiInfo getEftposAustralia() {
    return eftposAustralia;
  }


 /**
  * eftposAustralia
  *
  * @param eftposAustralia
  */ 
  @JsonProperty(JSON_PROPERTY_EFTPOS_AUSTRALIA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEftposAustralia(GenericPmWithTdiInfo eftposAustralia) {
    this.eftposAustralia = eftposAustralia;
  }


  public PaymentMethod enabled(Boolean enabled) {
    this.enabled = enabled;
    return this;
  }

   /**
   * Indicates whether the payment method is enabled (**true**) or disabled (**false**).
   * @return enabled
  **/
  @ApiModelProperty(value = "Indicates whether the payment method is enabled (**true**) or disabled (**false**).")
  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEnabled() {
    return enabled;
  }


 /**
  * Indicates whether the payment method is enabled (**true**) or disabled (**false**).
  *
  * @param enabled
  */ 
  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }


  public PaymentMethod giroPay(GiroPayInfo giroPay) {
    this.giroPay = giroPay;
    return this;
  }

   /**
   * Get giroPay
   * @return giroPay
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_GIRO_PAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GiroPayInfo getGiroPay() {
    return giroPay;
  }


 /**
  * giroPay
  *
  * @param giroPay
  */ 
  @JsonProperty(JSON_PROPERTY_GIRO_PAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGiroPay(GiroPayInfo giroPay) {
    this.giroPay = giroPay;
  }


  public PaymentMethod girocard(GenericPmWithTdiInfo girocard) {
    this.girocard = girocard;
    return this;
  }

   /**
   * Get girocard
   * @return girocard
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_GIROCARD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GenericPmWithTdiInfo getGirocard() {
    return girocard;
  }


 /**
  * girocard
  *
  * @param girocard
  */ 
  @JsonProperty(JSON_PROPERTY_GIROCARD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGirocard(GenericPmWithTdiInfo girocard) {
    this.girocard = girocard;
  }


  public PaymentMethod googlePay(GooglePayInfo googlePay) {
    this.googlePay = googlePay;
    return this;
  }

   /**
   * Get googlePay
   * @return googlePay
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_GOOGLE_PAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GooglePayInfo getGooglePay() {
    return googlePay;
  }


 /**
  * googlePay
  *
  * @param googlePay
  */ 
  @JsonProperty(JSON_PROPERTY_GOOGLE_PAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGooglePay(GooglePayInfo googlePay) {
    this.googlePay = googlePay;
  }


  public PaymentMethod id(String id) {
    this.id = id;
    return this;
  }

   /**
   * The identifier of the resource.
   * @return id
  **/
  @ApiModelProperty(required = true, value = "The identifier of the resource.")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


 /**
  * The identifier of the resource.
  *
  * @param id
  */ 
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public PaymentMethod ideal(GenericPmWithTdiInfo ideal) {
    this.ideal = ideal;
    return this;
  }

   /**
   * Get ideal
   * @return ideal
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_IDEAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GenericPmWithTdiInfo getIdeal() {
    return ideal;
  }


 /**
  * ideal
  *
  * @param ideal
  */ 
  @JsonProperty(JSON_PROPERTY_IDEAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdeal(GenericPmWithTdiInfo ideal) {
    this.ideal = ideal;
  }


  public PaymentMethod interacCard(GenericPmWithTdiInfo interacCard) {
    this.interacCard = interacCard;
    return this;
  }

   /**
   * Get interacCard
   * @return interacCard
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INTERAC_CARD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GenericPmWithTdiInfo getInteracCard() {
    return interacCard;
  }


 /**
  * interacCard
  *
  * @param interacCard
  */ 
  @JsonProperty(JSON_PROPERTY_INTERAC_CARD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInteracCard(GenericPmWithTdiInfo interacCard) {
    this.interacCard = interacCard;
  }


  public PaymentMethod jcb(GenericPmWithTdiInfo jcb) {
    this.jcb = jcb;
    return this;
  }

   /**
   * Get jcb
   * @return jcb
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_JCB)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GenericPmWithTdiInfo getJcb() {
    return jcb;
  }


 /**
  * jcb
  *
  * @param jcb
  */ 
  @JsonProperty(JSON_PROPERTY_JCB)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setJcb(GenericPmWithTdiInfo jcb) {
    this.jcb = jcb;
  }


  public PaymentMethod klarna(KlarnaInfo klarna) {
    this.klarna = klarna;
    return this;
  }

   /**
   * Get klarna
   * @return klarna
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_KLARNA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KlarnaInfo getKlarna() {
    return klarna;
  }


 /**
  * klarna
  *
  * @param klarna
  */ 
  @JsonProperty(JSON_PROPERTY_KLARNA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setKlarna(KlarnaInfo klarna) {
    this.klarna = klarna;
  }


  public PaymentMethod maestro(GenericPmWithTdiInfo maestro) {
    this.maestro = maestro;
    return this;
  }

   /**
   * Get maestro
   * @return maestro
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MAESTRO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GenericPmWithTdiInfo getMaestro() {
    return maestro;
  }


 /**
  * maestro
  *
  * @param maestro
  */ 
  @JsonProperty(JSON_PROPERTY_MAESTRO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaestro(GenericPmWithTdiInfo maestro) {
    this.maestro = maestro;
  }


  public PaymentMethod mc(GenericPmWithTdiInfo mc) {
    this.mc = mc;
    return this;
  }

   /**
   * Get mc
   * @return mc
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GenericPmWithTdiInfo getMc() {
    return mc;
  }


 /**
  * mc
  *
  * @param mc
  */ 
  @JsonProperty(JSON_PROPERTY_MC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMc(GenericPmWithTdiInfo mc) {
    this.mc = mc;
  }


  public PaymentMethod mealVoucherFR(MealVoucherFRInfo mealVoucherFR) {
    this.mealVoucherFR = mealVoucherFR;
    return this;
  }

   /**
   * Get mealVoucherFR
   * @return mealVoucherFR
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MEAL_VOUCHER_F_R)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MealVoucherFRInfo getMealVoucherFR() {
    return mealVoucherFR;
  }


 /**
  * mealVoucherFR
  *
  * @param mealVoucherFR
  */ 
  @JsonProperty(JSON_PROPERTY_MEAL_VOUCHER_F_R)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMealVoucherFR(MealVoucherFRInfo mealVoucherFR) {
    this.mealVoucherFR = mealVoucherFR;
  }


  public PaymentMethod nyce(NyceInfo nyce) {
    this.nyce = nyce;
    return this;
  }

   /**
   * Get nyce
   * @return nyce
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_NYCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public NyceInfo getNyce() {
    return nyce;
  }


 /**
  * nyce
  *
  * @param nyce
  */ 
  @JsonProperty(JSON_PROPERTY_NYCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNyce(NyceInfo nyce) {
    this.nyce = nyce;
  }


  public PaymentMethod payme(PayMeInfo payme) {
    this.payme = payme;
    return this;
  }

   /**
   * Get payme
   * @return payme
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAYME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PayMeInfo getPayme() {
    return payme;
  }


 /**
  * payme
  *
  * @param payme
  */ 
  @JsonProperty(JSON_PROPERTY_PAYME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPayme(PayMeInfo payme) {
    this.payme = payme;
  }


  public PaymentMethod paypal(PayPalInfo paypal) {
    this.paypal = paypal;
    return this;
  }

   /**
   * Get paypal
   * @return paypal
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PAYPAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PayPalInfo getPaypal() {
    return paypal;
  }


 /**
  * paypal
  *
  * @param paypal
  */ 
  @JsonProperty(JSON_PROPERTY_PAYPAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaypal(PayPalInfo paypal) {
    this.paypal = paypal;
  }


  public PaymentMethod pulse(PulseInfo pulse) {
    this.pulse = pulse;
    return this;
  }

   /**
   * Get pulse
   * @return pulse
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PULSE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PulseInfo getPulse() {
    return pulse;
  }


 /**
  * pulse
  *
  * @param pulse
  */ 
  @JsonProperty(JSON_PROPERTY_PULSE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPulse(PulseInfo pulse) {
    this.pulse = pulse;
  }


  public PaymentMethod reference(String reference) {
    this.reference = reference;
    return this;
  }

   /**
   * Your reference for the payment method. Supported characters a-z, A-Z, 0-9.
   * @return reference
  **/
  @ApiModelProperty(value = "Your reference for the payment method. Supported characters a-z, A-Z, 0-9.")
  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReference() {
    return reference;
  }


 /**
  * Your reference for the payment method. Supported characters a-z, A-Z, 0-9.
  *
  * @param reference
  */ 
  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReference(String reference) {
    this.reference = reference;
  }


  public PaymentMethod shopperInteraction(String shopperInteraction) {
    this.shopperInteraction = shopperInteraction;
    return this;
  }

   /**
   * The sales channel.
   * @return shopperInteraction
  **/
  @ApiModelProperty(value = "The sales channel.")
  @JsonProperty(JSON_PROPERTY_SHOPPER_INTERACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getShopperInteraction() {
    return shopperInteraction;
  }


 /**
  * The sales channel.
  *
  * @param shopperInteraction
  */ 
  @JsonProperty(JSON_PROPERTY_SHOPPER_INTERACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShopperInteraction(String shopperInteraction) {
    this.shopperInteraction = shopperInteraction;
  }


  public PaymentMethod sodexo(SodexoInfo sodexo) {
    this.sodexo = sodexo;
    return this;
  }

   /**
   * Get sodexo
   * @return sodexo
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SODEXO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SodexoInfo getSodexo() {
    return sodexo;
  }


 /**
  * sodexo
  *
  * @param sodexo
  */ 
  @JsonProperty(JSON_PROPERTY_SODEXO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSodexo(SodexoInfo sodexo) {
    this.sodexo = sodexo;
  }


  public PaymentMethod sofort(SofortInfo sofort) {
    this.sofort = sofort;
    return this;
  }

   /**
   * Get sofort
   * @return sofort
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOFORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SofortInfo getSofort() {
    return sofort;
  }


 /**
  * sofort
  *
  * @param sofort
  */ 
  @JsonProperty(JSON_PROPERTY_SOFORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSofort(SofortInfo sofort) {
    this.sofort = sofort;
  }


  public PaymentMethod star(StarInfo star) {
    this.star = star;
    return this;
  }

   /**
   * Get star
   * @return star
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_STAR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StarInfo getStar() {
    return star;
  }


 /**
  * star
  *
  * @param star
  */ 
  @JsonProperty(JSON_PROPERTY_STAR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStar(StarInfo star) {
    this.star = star;
  }


  public PaymentMethod storeIds(List<String> storeIds) {
    this.storeIds = storeIds;
    return this;
  }

  public PaymentMethod addStoreIdsItem(String storeIdsItem) {
    if (this.storeIds == null) {
      this.storeIds = new ArrayList<>();
    }
    this.storeIds.add(storeIdsItem);
    return this;
  }

   /**
   * The unique identifier of the store for which to configure the payment method, if any.
   * @return storeIds
  **/
  @ApiModelProperty(value = "The unique identifier of the store for which to configure the payment method, if any.")
  @JsonProperty(JSON_PROPERTY_STORE_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getStoreIds() {
    return storeIds;
  }


 /**
  * The unique identifier of the store for which to configure the payment method, if any.
  *
  * @param storeIds
  */ 
  @JsonProperty(JSON_PROPERTY_STORE_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStoreIds(List<String> storeIds) {
    this.storeIds = storeIds;
  }


  public PaymentMethod swish(SwishInfo swish) {
    this.swish = swish;
    return this;
  }

   /**
   * Get swish
   * @return swish
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SWISH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SwishInfo getSwish() {
    return swish;
  }


 /**
  * swish
  *
  * @param swish
  */ 
  @JsonProperty(JSON_PROPERTY_SWISH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSwish(SwishInfo swish) {
    this.swish = swish;
  }


  public PaymentMethod ticket(TicketInfo ticket) {
    this.ticket = ticket;
    return this;
  }

   /**
   * Get ticket
   * @return ticket
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TICKET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TicketInfo getTicket() {
    return ticket;
  }


 /**
  * ticket
  *
  * @param ticket
  */ 
  @JsonProperty(JSON_PROPERTY_TICKET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTicket(TicketInfo ticket) {
    this.ticket = ticket;
  }


  public PaymentMethod twint(TwintInfo twint) {
    this.twint = twint;
    return this;
  }

   /**
   * Get twint
   * @return twint
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TWINT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TwintInfo getTwint() {
    return twint;
  }


 /**
  * twint
  *
  * @param twint
  */ 
  @JsonProperty(JSON_PROPERTY_TWINT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTwint(TwintInfo twint) {
    this.twint = twint;
  }


  public PaymentMethod type(String type) {
    this.type = type;
    return this;
  }

   /**
   * Payment method [variant](https://docs.adyen.com/development-resources/paymentmethodvariant#management-api).
   * @return type
  **/
  @ApiModelProperty(value = "Payment method [variant](https://docs.adyen.com/development-resources/paymentmethodvariant#management-api).")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getType() {
    return type;
  }


 /**
  * Payment method [variant](https://docs.adyen.com/development-resources/paymentmethodvariant#management-api).
  *
  * @param type
  */ 
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(String type) {
    this.type = type;
  }


  public PaymentMethod verificationStatus(VerificationStatusEnum verificationStatus) {
    this.verificationStatus = verificationStatus;
    return this;
  }

   /**
   * Payment method status. Possible values: * **valid** * **pending** * **invalid** * **rejected**
   * @return verificationStatus
  **/
  @ApiModelProperty(value = "Payment method status. Possible values: * **valid** * **pending** * **invalid** * **rejected**")
  @JsonProperty(JSON_PROPERTY_VERIFICATION_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public VerificationStatusEnum getVerificationStatus() {
    return verificationStatus;
  }


 /**
  * Payment method status. Possible values: * **valid** * **pending** * **invalid** * **rejected**
  *
  * @param verificationStatus
  */ 
  @JsonProperty(JSON_PROPERTY_VERIFICATION_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVerificationStatus(VerificationStatusEnum verificationStatus) {
    this.verificationStatus = verificationStatus;
  }


  public PaymentMethod vipps(VippsInfo vipps) {
    this.vipps = vipps;
    return this;
  }

   /**
   * Get vipps
   * @return vipps
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_VIPPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public VippsInfo getVipps() {
    return vipps;
  }


 /**
  * vipps
  *
  * @param vipps
  */ 
  @JsonProperty(JSON_PROPERTY_VIPPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVipps(VippsInfo vipps) {
    this.vipps = vipps;
  }


  public PaymentMethod visa(GenericPmWithTdiInfo visa) {
    this.visa = visa;
    return this;
  }

   /**
   * Get visa
   * @return visa
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_VISA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GenericPmWithTdiInfo getVisa() {
    return visa;
  }


 /**
  * visa
  *
  * @param visa
  */ 
  @JsonProperty(JSON_PROPERTY_VISA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVisa(GenericPmWithTdiInfo visa) {
    this.visa = visa;
  }


  public PaymentMethod wechatpay(WeChatPayInfo wechatpay) {
    this.wechatpay = wechatpay;
    return this;
  }

   /**
   * Get wechatpay
   * @return wechatpay
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_WECHATPAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public WeChatPayInfo getWechatpay() {
    return wechatpay;
  }


 /**
  * wechatpay
  *
  * @param wechatpay
  */ 
  @JsonProperty(JSON_PROPERTY_WECHATPAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWechatpay(WeChatPayInfo wechatpay) {
    this.wechatpay = wechatpay;
  }


  public PaymentMethod wechatpayPos(WeChatPayPosInfo wechatpayPos) {
    this.wechatpayPos = wechatpayPos;
    return this;
  }

   /**
   * Get wechatpayPos
   * @return wechatpayPos
  **/
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_WECHATPAY_POS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public WeChatPayPosInfo getWechatpayPos() {
    return wechatpayPos;
  }


 /**
  * wechatpayPos
  *
  * @param wechatpayPos
  */ 
  @JsonProperty(JSON_PROPERTY_WECHATPAY_POS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWechatpayPos(WeChatPayPosInfo wechatpayPos) {
    this.wechatpayPos = wechatpayPos;
  }


  /**
   * Return true if this PaymentMethod object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentMethod paymentMethod = (PaymentMethod) o;
    return Objects.equals(this.accel, paymentMethod.accel) &&
        Objects.equals(this.afterpayTouch, paymentMethod.afterpayTouch) &&
        Objects.equals(this.allowed, paymentMethod.allowed) &&
        Objects.equals(this.amex, paymentMethod.amex) &&
        Objects.equals(this.applePay, paymentMethod.applePay) &&
        Objects.equals(this.bcmc, paymentMethod.bcmc) &&
        Objects.equals(this.businessLineId, paymentMethod.businessLineId) &&
        Objects.equals(this.cartesBancaires, paymentMethod.cartesBancaires) &&
        Objects.equals(this.clearpay, paymentMethod.clearpay) &&
        Objects.equals(this.countries, paymentMethod.countries) &&
        Objects.equals(this.cup, paymentMethod.cup) &&
        Objects.equals(this.currencies, paymentMethod.currencies) &&
        Objects.equals(this.customRoutingFlags, paymentMethod.customRoutingFlags) &&
        Objects.equals(this.diners, paymentMethod.diners) &&
        Objects.equals(this.discover, paymentMethod.discover) &&
        Objects.equals(this.eftposAustralia, paymentMethod.eftposAustralia) &&
        Objects.equals(this.enabled, paymentMethod.enabled) &&
        Objects.equals(this.giroPay, paymentMethod.giroPay) &&
        Objects.equals(this.girocard, paymentMethod.girocard) &&
        Objects.equals(this.googlePay, paymentMethod.googlePay) &&
        Objects.equals(this.id, paymentMethod.id) &&
        Objects.equals(this.ideal, paymentMethod.ideal) &&
        Objects.equals(this.interacCard, paymentMethod.interacCard) &&
        Objects.equals(this.jcb, paymentMethod.jcb) &&
        Objects.equals(this.klarna, paymentMethod.klarna) &&
        Objects.equals(this.maestro, paymentMethod.maestro) &&
        Objects.equals(this.mc, paymentMethod.mc) &&
        Objects.equals(this.mealVoucherFR, paymentMethod.mealVoucherFR) &&
        Objects.equals(this.nyce, paymentMethod.nyce) &&
        Objects.equals(this.payme, paymentMethod.payme) &&
        Objects.equals(this.paypal, paymentMethod.paypal) &&
        Objects.equals(this.pulse, paymentMethod.pulse) &&
        Objects.equals(this.reference, paymentMethod.reference) &&
        Objects.equals(this.shopperInteraction, paymentMethod.shopperInteraction) &&
        Objects.equals(this.sodexo, paymentMethod.sodexo) &&
        Objects.equals(this.sofort, paymentMethod.sofort) &&
        Objects.equals(this.star, paymentMethod.star) &&
        Objects.equals(this.storeIds, paymentMethod.storeIds) &&
        Objects.equals(this.swish, paymentMethod.swish) &&
        Objects.equals(this.ticket, paymentMethod.ticket) &&
        Objects.equals(this.twint, paymentMethod.twint) &&
        Objects.equals(this.type, paymentMethod.type) &&
        Objects.equals(this.verificationStatus, paymentMethod.verificationStatus) &&
        Objects.equals(this.vipps, paymentMethod.vipps) &&
        Objects.equals(this.visa, paymentMethod.visa) &&
        Objects.equals(this.wechatpay, paymentMethod.wechatpay) &&
        Objects.equals(this.wechatpayPos, paymentMethod.wechatpayPos);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accel, afterpayTouch, allowed, amex, applePay, bcmc, businessLineId, cartesBancaires, clearpay, countries, cup, currencies, customRoutingFlags, diners, discover, eftposAustralia, enabled, giroPay, girocard, googlePay, id, ideal, interacCard, jcb, klarna, maestro, mc, mealVoucherFR, nyce, payme, paypal, pulse, reference, shopperInteraction, sodexo, sofort, star, storeIds, swish, ticket, twint, type, verificationStatus, vipps, visa, wechatpay, wechatpayPos);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentMethod {\n");
    sb.append("    accel: ").append(toIndentedString(accel)).append("\n");
    sb.append("    afterpayTouch: ").append(toIndentedString(afterpayTouch)).append("\n");
    sb.append("    allowed: ").append(toIndentedString(allowed)).append("\n");
    sb.append("    amex: ").append(toIndentedString(amex)).append("\n");
    sb.append("    applePay: ").append(toIndentedString(applePay)).append("\n");
    sb.append("    bcmc: ").append(toIndentedString(bcmc)).append("\n");
    sb.append("    businessLineId: ").append(toIndentedString(businessLineId)).append("\n");
    sb.append("    cartesBancaires: ").append(toIndentedString(cartesBancaires)).append("\n");
    sb.append("    clearpay: ").append(toIndentedString(clearpay)).append("\n");
    sb.append("    countries: ").append(toIndentedString(countries)).append("\n");
    sb.append("    cup: ").append(toIndentedString(cup)).append("\n");
    sb.append("    currencies: ").append(toIndentedString(currencies)).append("\n");
    sb.append("    customRoutingFlags: ").append(toIndentedString(customRoutingFlags)).append("\n");
    sb.append("    diners: ").append(toIndentedString(diners)).append("\n");
    sb.append("    discover: ").append(toIndentedString(discover)).append("\n");
    sb.append("    eftposAustralia: ").append(toIndentedString(eftposAustralia)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    giroPay: ").append(toIndentedString(giroPay)).append("\n");
    sb.append("    girocard: ").append(toIndentedString(girocard)).append("\n");
    sb.append("    googlePay: ").append(toIndentedString(googlePay)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    ideal: ").append(toIndentedString(ideal)).append("\n");
    sb.append("    interacCard: ").append(toIndentedString(interacCard)).append("\n");
    sb.append("    jcb: ").append(toIndentedString(jcb)).append("\n");
    sb.append("    klarna: ").append(toIndentedString(klarna)).append("\n");
    sb.append("    maestro: ").append(toIndentedString(maestro)).append("\n");
    sb.append("    mc: ").append(toIndentedString(mc)).append("\n");
    sb.append("    mealVoucherFR: ").append(toIndentedString(mealVoucherFR)).append("\n");
    sb.append("    nyce: ").append(toIndentedString(nyce)).append("\n");
    sb.append("    payme: ").append(toIndentedString(payme)).append("\n");
    sb.append("    paypal: ").append(toIndentedString(paypal)).append("\n");
    sb.append("    pulse: ").append(toIndentedString(pulse)).append("\n");
    sb.append("    reference: ").append(toIndentedString(reference)).append("\n");
    sb.append("    shopperInteraction: ").append(toIndentedString(shopperInteraction)).append("\n");
    sb.append("    sodexo: ").append(toIndentedString(sodexo)).append("\n");
    sb.append("    sofort: ").append(toIndentedString(sofort)).append("\n");
    sb.append("    star: ").append(toIndentedString(star)).append("\n");
    sb.append("    storeIds: ").append(toIndentedString(storeIds)).append("\n");
    sb.append("    swish: ").append(toIndentedString(swish)).append("\n");
    sb.append("    ticket: ").append(toIndentedString(ticket)).append("\n");
    sb.append("    twint: ").append(toIndentedString(twint)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    verificationStatus: ").append(toIndentedString(verificationStatus)).append("\n");
    sb.append("    vipps: ").append(toIndentedString(vipps)).append("\n");
    sb.append("    visa: ").append(toIndentedString(visa)).append("\n");
    sb.append("    wechatpay: ").append(toIndentedString(wechatpay)).append("\n");
    sb.append("    wechatpayPos: ").append(toIndentedString(wechatpayPos)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of PaymentMethod given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of PaymentMethod
   * @throws JsonProcessingException if the JSON string is invalid with respect to PaymentMethod
   */
  public static PaymentMethod fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, PaymentMethod.class);
  }
/**
  * Convert an instance of PaymentMethod to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

