/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.checkout;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * GooglePayDonations
 */
@JsonPropertyOrder({
  GooglePayDonations.JSON_PROPERTY_CHECKOUT_ATTEMPT_ID,
  GooglePayDonations.JSON_PROPERTY_FUNDING_SOURCE,
  GooglePayDonations.JSON_PROPERTY_GOOGLE_PAY_CARD_NETWORK,
  GooglePayDonations.JSON_PROPERTY_GOOGLE_PAY_TOKEN,
  GooglePayDonations.JSON_PROPERTY_RECURRING_DETAIL_REFERENCE,
  GooglePayDonations.JSON_PROPERTY_STORED_PAYMENT_METHOD_ID,
  GooglePayDonations.JSON_PROPERTY_THREE_D_S2_SDK_VERSION,
  GooglePayDonations.JSON_PROPERTY_TYPE
})

public class GooglePayDonations {
  public static final String JSON_PROPERTY_CHECKOUT_ATTEMPT_ID = "checkoutAttemptId";
  private String checkoutAttemptId;

  /**
   * The funding source that should be used when multiple sources are available. For Brazilian combo cards, by default the funding source is credit. To use debit, set this value to **debit**.
   */
  public enum FundingSourceEnum {
    CREDIT("credit"),
    
    DEBIT("debit");

    private String value;

    FundingSourceEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static FundingSourceEnum fromValue(String value) {
      for (FundingSourceEnum b : FundingSourceEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_FUNDING_SOURCE = "fundingSource";
  private FundingSourceEnum fundingSource;

  public static final String JSON_PROPERTY_GOOGLE_PAY_CARD_NETWORK = "googlePayCardNetwork";
  private String googlePayCardNetwork;

  public static final String JSON_PROPERTY_GOOGLE_PAY_TOKEN = "googlePayToken";
  private String googlePayToken;

  public static final String JSON_PROPERTY_RECURRING_DETAIL_REFERENCE = "recurringDetailReference";
  @Deprecated // deprecated since Adyen Checkout API v49: Use `storedPaymentMethodId` instead.
  private String recurringDetailReference;

  public static final String JSON_PROPERTY_STORED_PAYMENT_METHOD_ID = "storedPaymentMethodId";
  private String storedPaymentMethodId;

  public static final String JSON_PROPERTY_THREE_D_S2_SDK_VERSION = "threeDS2SdkVersion";
  private String threeDS2SdkVersion;

  /**
   * **googlepay**, **paywithgoogle**
   */
  public enum TypeEnum {
    GOOGLEPAY("googlepay");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public GooglePayDonations() { 
  }

  /**
   * The checkout attempt identifier.
   *
   * @param checkoutAttemptId
   * @return the current {@code GooglePayDonations} instance, allowing for method chaining
   */
  public GooglePayDonations checkoutAttemptId(String checkoutAttemptId) {
    this.checkoutAttemptId = checkoutAttemptId;
    return this;
  }

  /**
   * The checkout attempt identifier.
   * @return checkoutAttemptId
   */
  @ApiModelProperty(value = "The checkout attempt identifier.")
  @JsonProperty(JSON_PROPERTY_CHECKOUT_ATTEMPT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCheckoutAttemptId() {
    return checkoutAttemptId;
  }

  /**
   * The checkout attempt identifier.
   *
   * @param checkoutAttemptId
   */ 
  @JsonProperty(JSON_PROPERTY_CHECKOUT_ATTEMPT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCheckoutAttemptId(String checkoutAttemptId) {
    this.checkoutAttemptId = checkoutAttemptId;
  }

  /**
   * The funding source that should be used when multiple sources are available. For Brazilian combo cards, by default the funding source is credit. To use debit, set this value to **debit**.
   *
   * @param fundingSource
   * @return the current {@code GooglePayDonations} instance, allowing for method chaining
   */
  public GooglePayDonations fundingSource(FundingSourceEnum fundingSource) {
    this.fundingSource = fundingSource;
    return this;
  }

  /**
   * The funding source that should be used when multiple sources are available. For Brazilian combo cards, by default the funding source is credit. To use debit, set this value to **debit**.
   * @return fundingSource
   */
  @ApiModelProperty(value = "The funding source that should be used when multiple sources are available. For Brazilian combo cards, by default the funding source is credit. To use debit, set this value to **debit**.")
  @JsonProperty(JSON_PROPERTY_FUNDING_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public FundingSourceEnum getFundingSource() {
    return fundingSource;
  }

  /**
   * The funding source that should be used when multiple sources are available. For Brazilian combo cards, by default the funding source is credit. To use debit, set this value to **debit**.
   *
   * @param fundingSource
   */ 
  @JsonProperty(JSON_PROPERTY_FUNDING_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFundingSource(FundingSourceEnum fundingSource) {
    this.fundingSource = fundingSource;
  }

  /**
   * The selected payment card network. 
   *
   * @param googlePayCardNetwork
   * @return the current {@code GooglePayDonations} instance, allowing for method chaining
   */
  public GooglePayDonations googlePayCardNetwork(String googlePayCardNetwork) {
    this.googlePayCardNetwork = googlePayCardNetwork;
    return this;
  }

  /**
   * The selected payment card network. 
   * @return googlePayCardNetwork
   */
  @ApiModelProperty(value = "The selected payment card network. ")
  @JsonProperty(JSON_PROPERTY_GOOGLE_PAY_CARD_NETWORK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getGooglePayCardNetwork() {
    return googlePayCardNetwork;
  }

  /**
   * The selected payment card network. 
   *
   * @param googlePayCardNetwork
   */ 
  @JsonProperty(JSON_PROPERTY_GOOGLE_PAY_CARD_NETWORK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGooglePayCardNetwork(String googlePayCardNetwork) {
    this.googlePayCardNetwork = googlePayCardNetwork;
  }

  /**
   * The &#x60;token&#x60; that you obtained from the [Google Pay API](https://developers.google.com/pay/api/web/reference/response-objects#PaymentData) &#x60;PaymentData&#x60; response.
   *
   * @param googlePayToken
   * @return the current {@code GooglePayDonations} instance, allowing for method chaining
   */
  public GooglePayDonations googlePayToken(String googlePayToken) {
    this.googlePayToken = googlePayToken;
    return this;
  }

  /**
   * The &#x60;token&#x60; that you obtained from the [Google Pay API](https://developers.google.com/pay/api/web/reference/response-objects#PaymentData) &#x60;PaymentData&#x60; response.
   * @return googlePayToken
   */
  @ApiModelProperty(required = true, value = "The `token` that you obtained from the [Google Pay API](https://developers.google.com/pay/api/web/reference/response-objects#PaymentData) `PaymentData` response.")
  @JsonProperty(JSON_PROPERTY_GOOGLE_PAY_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getGooglePayToken() {
    return googlePayToken;
  }

  /**
   * The &#x60;token&#x60; that you obtained from the [Google Pay API](https://developers.google.com/pay/api/web/reference/response-objects#PaymentData) &#x60;PaymentData&#x60; response.
   *
   * @param googlePayToken
   */ 
  @JsonProperty(JSON_PROPERTY_GOOGLE_PAY_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGooglePayToken(String googlePayToken) {
    this.googlePayToken = googlePayToken;
  }

  /**
   * This is the &#x60;recurringDetailReference&#x60; returned in the response when you created the token.
   *
   * @param recurringDetailReference
   * @return the current {@code GooglePayDonations} instance, allowing for method chaining
   *
   * @deprecated since Adyen Checkout API v49
   * Use &#x60;storedPaymentMethodId&#x60; instead.
   */
  @Deprecated
  public GooglePayDonations recurringDetailReference(String recurringDetailReference) {
    this.recurringDetailReference = recurringDetailReference;
    return this;
  }

  /**
   * This is the &#x60;recurringDetailReference&#x60; returned in the response when you created the token.
   * @return recurringDetailReference
   *
   * @deprecated since Adyen Checkout API v49
   * Use &#x60;storedPaymentMethodId&#x60; instead.
   */
  @Deprecated
  @ApiModelProperty(value = "This is the `recurringDetailReference` returned in the response when you created the token.")
  @JsonProperty(JSON_PROPERTY_RECURRING_DETAIL_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getRecurringDetailReference() {
    return recurringDetailReference;
  }

  /**
   * This is the &#x60;recurringDetailReference&#x60; returned in the response when you created the token.
   *
   * @param recurringDetailReference
   *
   * @deprecated since Adyen Checkout API v49
   * Use &#x60;storedPaymentMethodId&#x60; instead.
   */ 
  @Deprecated
  @JsonProperty(JSON_PROPERTY_RECURRING_DETAIL_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecurringDetailReference(String recurringDetailReference) {
    this.recurringDetailReference = recurringDetailReference;
  }

  /**
   * This is the &#x60;recurringDetailReference&#x60; returned in the response when you created the token.
   *
   * @param storedPaymentMethodId
   * @return the current {@code GooglePayDonations} instance, allowing for method chaining
   */
  public GooglePayDonations storedPaymentMethodId(String storedPaymentMethodId) {
    this.storedPaymentMethodId = storedPaymentMethodId;
    return this;
  }

  /**
   * This is the &#x60;recurringDetailReference&#x60; returned in the response when you created the token.
   * @return storedPaymentMethodId
   */
  @ApiModelProperty(value = "This is the `recurringDetailReference` returned in the response when you created the token.")
  @JsonProperty(JSON_PROPERTY_STORED_PAYMENT_METHOD_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getStoredPaymentMethodId() {
    return storedPaymentMethodId;
  }

  /**
   * This is the &#x60;recurringDetailReference&#x60; returned in the response when you created the token.
   *
   * @param storedPaymentMethodId
   */ 
  @JsonProperty(JSON_PROPERTY_STORED_PAYMENT_METHOD_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStoredPaymentMethodId(String storedPaymentMethodId) {
    this.storedPaymentMethodId = storedPaymentMethodId;
  }

  /**
   * Required for mobile integrations. Version of the 3D Secure 2 mobile SDK.
   *
   * @param threeDS2SdkVersion
   * @return the current {@code GooglePayDonations} instance, allowing for method chaining
   */
  public GooglePayDonations threeDS2SdkVersion(String threeDS2SdkVersion) {
    this.threeDS2SdkVersion = threeDS2SdkVersion;
    return this;
  }

  /**
   * Required for mobile integrations. Version of the 3D Secure 2 mobile SDK.
   * @return threeDS2SdkVersion
   */
  @ApiModelProperty(value = "Required for mobile integrations. Version of the 3D Secure 2 mobile SDK.")
  @JsonProperty(JSON_PROPERTY_THREE_D_S2_SDK_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getThreeDS2SdkVersion() {
    return threeDS2SdkVersion;
  }

  /**
   * Required for mobile integrations. Version of the 3D Secure 2 mobile SDK.
   *
   * @param threeDS2SdkVersion
   */ 
  @JsonProperty(JSON_PROPERTY_THREE_D_S2_SDK_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThreeDS2SdkVersion(String threeDS2SdkVersion) {
    this.threeDS2SdkVersion = threeDS2SdkVersion;
  }

  /**
   * **googlepay**, **paywithgoogle**
   *
   * @param type
   * @return the current {@code GooglePayDonations} instance, allowing for method chaining
   */
  public GooglePayDonations type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * **googlepay**, **paywithgoogle**
   * @return type
   */
  @ApiModelProperty(value = "**googlepay**, **paywithgoogle**")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * **googlepay**, **paywithgoogle**
   *
   * @param type
   */ 
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /**
   * Return true if this GooglePayDonations object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GooglePayDonations googlePayDonations = (GooglePayDonations) o;
    return Objects.equals(this.checkoutAttemptId, googlePayDonations.checkoutAttemptId) &&
        Objects.equals(this.fundingSource, googlePayDonations.fundingSource) &&
        Objects.equals(this.googlePayCardNetwork, googlePayDonations.googlePayCardNetwork) &&
        Objects.equals(this.googlePayToken, googlePayDonations.googlePayToken) &&
        Objects.equals(this.recurringDetailReference, googlePayDonations.recurringDetailReference) &&
        Objects.equals(this.storedPaymentMethodId, googlePayDonations.storedPaymentMethodId) &&
        Objects.equals(this.threeDS2SdkVersion, googlePayDonations.threeDS2SdkVersion) &&
        Objects.equals(this.type, googlePayDonations.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(checkoutAttemptId, fundingSource, googlePayCardNetwork, googlePayToken, recurringDetailReference, storedPaymentMethodId, threeDS2SdkVersion, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GooglePayDonations {\n");
    sb.append("    checkoutAttemptId: ").append(toIndentedString(checkoutAttemptId)).append("\n");
    sb.append("    fundingSource: ").append(toIndentedString(fundingSource)).append("\n");
    sb.append("    googlePayCardNetwork: ").append(toIndentedString(googlePayCardNetwork)).append("\n");
    sb.append("    googlePayToken: ").append(toIndentedString(googlePayToken)).append("\n");
    sb.append("    recurringDetailReference: ").append(toIndentedString(recurringDetailReference)).append("\n");
    sb.append("    storedPaymentMethodId: ").append(toIndentedString(storedPaymentMethodId)).append("\n");
    sb.append("    threeDS2SdkVersion: ").append(toIndentedString(threeDS2SdkVersion)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of GooglePayDonations given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of GooglePayDonations
   * @throws JsonProcessingException if the JSON string is invalid with respect to GooglePayDonations
   */
  public static GooglePayDonations fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, GooglePayDonations.class);
  }
/**
  * Convert an instance of GooglePayDonations to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
