/*
 * Account API
 * This API is used for the classic integration. If you are just starting your implementation, refer to our [new integration guide](https://docs.adyen.com/marketplaces-and-platforms) instead.  The Account API provides endpoints for managing account-related entities on your platform. These related entities include account holders, accounts, bank accounts, shareholders, and verification-related documents. The management operations include actions such as creation, retrieval, updating, and deletion of them.  For more information, refer to our [documentation](https://docs.adyen.com/marketplaces-and-platforms/classic). ## Authentication Your Adyen contact will provide your API credential and an API key. To connect to the API, add an `X-API-Key` header with the API key as the value, for example:   ``` curl -H \"Content-Type: application/json\" \\ -H \"X-API-Key: YOUR_API_KEY\" \\ ... ```  Alternatively, you can use the username and password to connect to the API using basic authentication. For example:  ``` curl -U \"ws@MarketPlace.YOUR_PLATFORM_ACCOUNT\":\"YOUR_WS_PASSWORD\" \\ -H \"Content-Type: application/json\" \\ ... ``` When going live, you need to generate new web service user credentials to access the [live endpoints](https://docs.adyen.com/development-resources/live-endpoints).  ## Versioning The Account API supports [versioning](https://docs.adyen.com/development-resources/versioning) using a version suffix in the endpoint URL. This suffix has the following format: \"vXX\", where XX is the version number.  For example: ``` https://cal-test.adyen.com/cal/services/Account/v6/createAccountHolder ```
 *
 * The version of the OpenAPI document: 6
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.marketpayaccount;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * PersonalDocumentData
 */
@JsonPropertyOrder({
  PersonalDocumentData.JSON_PROPERTY_EXPIRATION_DATE,
  PersonalDocumentData.JSON_PROPERTY_ISSUER_COUNTRY,
  PersonalDocumentData.JSON_PROPERTY_ISSUER_STATE,
  PersonalDocumentData.JSON_PROPERTY_NUMBER,
  PersonalDocumentData.JSON_PROPERTY_TYPE
})

public class PersonalDocumentData {
  public static final String JSON_PROPERTY_EXPIRATION_DATE = "expirationDate";
  private String expirationDate;

  public static final String JSON_PROPERTY_ISSUER_COUNTRY = "issuerCountry";
  private String issuerCountry;

  public static final String JSON_PROPERTY_ISSUER_STATE = "issuerState";
  private String issuerState;

  public static final String JSON_PROPERTY_NUMBER = "number";
  private String number;

  /**
   * The type of the document. Possible values: **ID**, **DRIVINGLICENSE**, **PASSPORT**, **SOCIALSECURITY**, **VISA**.  To delete an existing entry for a document &#x60;type&#x60;, send only the &#x60;type&#x60; field in your request. 
   */
  public enum TypeEnum {
    DRIVINGLICENSE("DRIVINGLICENSE"),
    
    ID("ID"),
    
    PASSPORT("PASSPORT"),
    
    SOCIALSECURITY("SOCIALSECURITY"),
    
    VISA("VISA");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public PersonalDocumentData() { 
  }

  public PersonalDocumentData expirationDate(String expirationDate) {
    this.expirationDate = expirationDate;
    return this;
  }

   /**
   * The expiry date of the document,   in ISO-8601 YYYY-MM-DD format. For example, **2000-01-31**.
   * @return expirationDate
  **/
  @ApiModelProperty(value = "The expiry date of the document,   in ISO-8601 YYYY-MM-DD format. For example, **2000-01-31**.")
  @JsonProperty(JSON_PROPERTY_EXPIRATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExpirationDate() {
    return expirationDate;
  }


  @JsonProperty(JSON_PROPERTY_EXPIRATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExpirationDate(String expirationDate) {
    this.expirationDate = expirationDate;
  }


  public PersonalDocumentData issuerCountry(String issuerCountry) {
    this.issuerCountry = issuerCountry;
    return this;
  }

   /**
   * The country where the document was issued, in the two-character  [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format. For example, **NL**.
   * @return issuerCountry
  **/
  @ApiModelProperty(value = "The country where the document was issued, in the two-character  [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format. For example, **NL**.")
  @JsonProperty(JSON_PROPERTY_ISSUER_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIssuerCountry() {
    return issuerCountry;
  }


  @JsonProperty(JSON_PROPERTY_ISSUER_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIssuerCountry(String issuerCountry) {
    this.issuerCountry = issuerCountry;
  }


  public PersonalDocumentData issuerState(String issuerState) {
    this.issuerState = issuerState;
    return this;
  }

   /**
   * The state where the document was issued (if applicable).
   * @return issuerState
  **/
  @ApiModelProperty(value = "The state where the document was issued (if applicable).")
  @JsonProperty(JSON_PROPERTY_ISSUER_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIssuerState() {
    return issuerState;
  }


  @JsonProperty(JSON_PROPERTY_ISSUER_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIssuerState(String issuerState) {
    this.issuerState = issuerState;
  }


  public PersonalDocumentData number(String number) {
    this.number = number;
    return this;
  }

   /**
   * The number in the document.
   * @return number
  **/
  @ApiModelProperty(value = "The number in the document.")
  @JsonProperty(JSON_PROPERTY_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getNumber() {
    return number;
  }


  @JsonProperty(JSON_PROPERTY_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumber(String number) {
    this.number = number;
  }


  public PersonalDocumentData type(TypeEnum type) {
    this.type = type;
    return this;
  }

   /**
   * The type of the document. Possible values: **ID**, **DRIVINGLICENSE**, **PASSPORT**, **SOCIALSECURITY**, **VISA**.  To delete an existing entry for a document &#x60;type&#x60;, send only the &#x60;type&#x60; field in your request. 
   * @return type
  **/
  @ApiModelProperty(required = true, value = "The type of the document. Possible values: **ID**, **DRIVINGLICENSE**, **PASSPORT**, **SOCIALSECURITY**, **VISA**.  To delete an existing entry for a document `type`, send only the `type` field in your request. ")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  /**
   * Return true if this PersonalDocumentData object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PersonalDocumentData personalDocumentData = (PersonalDocumentData) o;
    return Objects.equals(this.expirationDate, personalDocumentData.expirationDate) &&
        Objects.equals(this.issuerCountry, personalDocumentData.issuerCountry) &&
        Objects.equals(this.issuerState, personalDocumentData.issuerState) &&
        Objects.equals(this.number, personalDocumentData.number) &&
        Objects.equals(this.type, personalDocumentData.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(expirationDate, issuerCountry, issuerState, number, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PersonalDocumentData {\n");
    sb.append("    expirationDate: ").append(toIndentedString(expirationDate)).append("\n");
    sb.append("    issuerCountry: ").append(toIndentedString(issuerCountry)).append("\n");
    sb.append("    issuerState: ").append(toIndentedString(issuerState)).append("\n");
    sb.append("    number: ").append(toIndentedString(number)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of PersonalDocumentData given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of PersonalDocumentData
   * @throws JsonProcessingException if the JSON string is invalid with respect to PersonalDocumentData
   */
  public static PersonalDocumentData fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, PersonalDocumentData.class);
  }
/**
  * Convert an instance of PersonalDocumentData to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}

