/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.adyen.service.legalentitymanagement;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.legalentitymanagement.CheckTaxElectronicDeliveryConsentResponse;
import com.adyen.model.legalentitymanagement.ServiceError;
import com.adyen.model.legalentitymanagement.SetTaxElectronicDeliveryConsentRequest;
import com.adyen.model.RequestOptions;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class TaxEDeliveryConsentApi extends Service {

    public static final String API_VERSION = "3";

    protected String baseURL;

    /**
    * Tax eDelivery consent constructor in {@link com.adyen.service.legalentitymanagement package}.
    * @param client {@link Client } (required)
    */
    public TaxEDeliveryConsentApi(Client client) {
        super(client);
        this.baseURL = createBaseURL("https://kyc-test.adyen.com/lem/v3");
    }

    /**
    * Tax eDelivery consent constructor in {@link com.adyen.service.legalentitymanagement package}.
    * Please use this constructor only if you would like to pass along your own url for routing or testing purposes. The latest API version is defined in this class as a constant.
    * @param client {@link Client } (required)
    * @param baseURL {@link String } (required)
    */
    public TaxEDeliveryConsentApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    /**
    * Check the status of consent for electronic delivery of tax forms
    *
    * @param id {@link String } The unique identifier of the legal entity. For sole proprietorships, this is the individual legal entity ID of the owner. For organizations, this is the ID of the organization. (required)
    * @return {@link CheckTaxElectronicDeliveryConsentResponse }
    * @throws ApiException if fails to make API call
    */
    public CheckTaxElectronicDeliveryConsentResponse checkStatusOfConsentForElectronicDeliveryOfTaxForms(String id) throws ApiException, IOException {
        return checkStatusOfConsentForElectronicDeliveryOfTaxForms(id, null);
    }

    /**
    * Check the status of consent for electronic delivery of tax forms
    *
    * @param id {@link String } The unique identifier of the legal entity. For sole proprietorships, this is the individual legal entity ID of the owner. For organizations, this is the ID of the organization. (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @return {@link CheckTaxElectronicDeliveryConsentResponse }
    * @throws ApiException if fails to make API call
    */
    public CheckTaxElectronicDeliveryConsentResponse checkStatusOfConsentForElectronicDeliveryOfTaxForms(String id, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);

        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/legalEntities/{id}/checkTaxElectronicDeliveryConsent", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return CheckTaxElectronicDeliveryConsentResponse.fromJson(jsonResult);
    }

    /**
    * Set the consent status for electronic delivery of tax forms
    *
    * @param id {@link String } The unique identifier of the legal entity. For sole proprietorships, this is the individual legal entity ID of the owner. For organizations, this is the ID of the organization. (required)
    * @param setTaxElectronicDeliveryConsentRequest {@link SetTaxElectronicDeliveryConsentRequest }  (required)
    * @throws ApiException if fails to make API call
    */
    public void setConsentStatusForElectronicDeliveryOfTaxForms(String id, SetTaxElectronicDeliveryConsentRequest setTaxElectronicDeliveryConsentRequest) throws ApiException, IOException {
        setConsentStatusForElectronicDeliveryOfTaxForms(id, setTaxElectronicDeliveryConsentRequest, null);
    }

    /**
    * Set the consent status for electronic delivery of tax forms
    *
    * @param id {@link String } The unique identifier of the legal entity. For sole proprietorships, this is the individual legal entity ID of the owner. For organizations, this is the ID of the organization. (required)
    * @param setTaxElectronicDeliveryConsentRequest {@link SetTaxElectronicDeliveryConsentRequest }  (required)
    * @param requestOptions {@link RequestOptions } Object to store additional data such as idempotency-keys (optional)
    * @throws ApiException if fails to make API call
    */
    public void setConsentStatusForElectronicDeliveryOfTaxForms(String id, SetTaxElectronicDeliveryConsentRequest setTaxElectronicDeliveryConsentRequest, RequestOptions requestOptions) throws ApiException, IOException {
        //Add path params
        Map<String, String> pathParams = new HashMap<>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);

        String requestBody = setTaxElectronicDeliveryConsentRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/legalEntities/{id}/setTaxElectronicDeliveryConsent", null);
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
    }
}
