/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.legalentitymanagement;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * TaxReportingClassification
 */
@JsonPropertyOrder({
  TaxReportingClassification.JSON_PROPERTY_BUSINESS_TYPE,
  TaxReportingClassification.JSON_PROPERTY_FINANCIAL_INSTITUTION_NUMBER,
  TaxReportingClassification.JSON_PROPERTY_MAIN_SOURCE_OF_INCOME,
  TaxReportingClassification.JSON_PROPERTY_TYPE
})

public class TaxReportingClassification {
  /**
   * The organization&#39;s business type.  Possible values: **other**, **listedPublicCompany**, **subsidiaryOfListedPublicCompany**, **governmentalOrganization**, **internationalOrganization**, **financialInstitution**.
   */
  public enum BusinessTypeEnum {
    OTHER("other"),
    
    LISTEDPUBLICCOMPANY("listedPublicCompany"),
    
    SUBSIDIARYOFLISTEDPUBLICCOMPANY("subsidiaryOfListedPublicCompany"),
    
    GOVERNMENTALORGANIZATION("governmentalOrganization"),
    
    INTERNATIONALORGANIZATION("internationalOrganization"),
    
    FINANCIALINSTITUTION("financialInstitution");

    private String value;

    BusinessTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static BusinessTypeEnum fromValue(String value) {
      for (BusinessTypeEnum b : BusinessTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_BUSINESS_TYPE = "businessType";
  private BusinessTypeEnum businessType;

  public static final String JSON_PROPERTY_FINANCIAL_INSTITUTION_NUMBER = "financialInstitutionNumber";
  private String financialInstitutionNumber;

  /**
   * The organization&#39;s main source of income. Only required if &#x60;businessType&#x60; is **other**.  Possible values: **businessOperation**, **realEstateSales**, **investmentInterestOrRoyalty**, **propertyRental**, **other**.
   */
  public enum MainSourceOfIncomeEnum {
    BUSINESSOPERATION("businessOperation"),
    
    REALESTATESALES("realEstateSales"),
    
    INVESTMENTINTERESTORROYALTY("investmentInterestOrRoyalty"),
    
    PROPERTYRENTAL("propertyRental"),
    
    OTHER("other");

    private String value;

    MainSourceOfIncomeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static MainSourceOfIncomeEnum fromValue(String value) {
      for (MainSourceOfIncomeEnum b : MainSourceOfIncomeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_MAIN_SOURCE_OF_INCOME = "mainSourceOfIncome";
  private MainSourceOfIncomeEnum mainSourceOfIncome;

  /**
   * The tax reporting classification type.  Possible values: **nonFinancialNonReportable**, **financialNonReportable**, **nonFinancialActive**, **nonFinancialPassive**.
   */
  public enum TypeEnum {
    NONFINANCIALNONREPORTABLE("nonFinancialNonReportable"),
    
    FINANCIALNONREPORTABLE("financialNonReportable"),
    
    NONFINANCIALACTIVE("nonFinancialActive"),
    
    NONFINANCIALPASSIVE("nonFinancialPassive");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public TaxReportingClassification() { 
  }

  /**
   * The organization&#39;s business type.  Possible values: **other**, **listedPublicCompany**, **subsidiaryOfListedPublicCompany**, **governmentalOrganization**, **internationalOrganization**, **financialInstitution**.
   *
   * @param businessType
   * @return the current {@code TaxReportingClassification} instance, allowing for method chaining
   */
  public TaxReportingClassification businessType(BusinessTypeEnum businessType) {
    this.businessType = businessType;
    return this;
  }

  /**
   * The organization&#39;s business type.  Possible values: **other**, **listedPublicCompany**, **subsidiaryOfListedPublicCompany**, **governmentalOrganization**, **internationalOrganization**, **financialInstitution**.
   * @return businessType
   */
  @ApiModelProperty(value = "The organization's business type.  Possible values: **other**, **listedPublicCompany**, **subsidiaryOfListedPublicCompany**, **governmentalOrganization**, **internationalOrganization**, **financialInstitution**.")
  @JsonProperty(JSON_PROPERTY_BUSINESS_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public BusinessTypeEnum getBusinessType() {
    return businessType;
  }

  /**
   * The organization&#39;s business type.  Possible values: **other**, **listedPublicCompany**, **subsidiaryOfListedPublicCompany**, **governmentalOrganization**, **internationalOrganization**, **financialInstitution**.
   *
   * @param businessType
   */ 
  @JsonProperty(JSON_PROPERTY_BUSINESS_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBusinessType(BusinessTypeEnum businessType) {
    this.businessType = businessType;
  }

  /**
   * The Global Intermediary Identification Number (GIIN) required for FATCA. Only required if the organization is a US financial institution and the &#x60;businessType&#x60; is **financialInstitution**.
   *
   * @param financialInstitutionNumber
   * @return the current {@code TaxReportingClassification} instance, allowing for method chaining
   */
  public TaxReportingClassification financialInstitutionNumber(String financialInstitutionNumber) {
    this.financialInstitutionNumber = financialInstitutionNumber;
    return this;
  }

  /**
   * The Global Intermediary Identification Number (GIIN) required for FATCA. Only required if the organization is a US financial institution and the &#x60;businessType&#x60; is **financialInstitution**.
   * @return financialInstitutionNumber
   */
  @ApiModelProperty(value = "The Global Intermediary Identification Number (GIIN) required for FATCA. Only required if the organization is a US financial institution and the `businessType` is **financialInstitution**.")
  @JsonProperty(JSON_PROPERTY_FINANCIAL_INSTITUTION_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getFinancialInstitutionNumber() {
    return financialInstitutionNumber;
  }

  /**
   * The Global Intermediary Identification Number (GIIN) required for FATCA. Only required if the organization is a US financial institution and the &#x60;businessType&#x60; is **financialInstitution**.
   *
   * @param financialInstitutionNumber
   */ 
  @JsonProperty(JSON_PROPERTY_FINANCIAL_INSTITUTION_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFinancialInstitutionNumber(String financialInstitutionNumber) {
    this.financialInstitutionNumber = financialInstitutionNumber;
  }

  /**
   * The organization&#39;s main source of income. Only required if &#x60;businessType&#x60; is **other**.  Possible values: **businessOperation**, **realEstateSales**, **investmentInterestOrRoyalty**, **propertyRental**, **other**.
   *
   * @param mainSourceOfIncome
   * @return the current {@code TaxReportingClassification} instance, allowing for method chaining
   */
  public TaxReportingClassification mainSourceOfIncome(MainSourceOfIncomeEnum mainSourceOfIncome) {
    this.mainSourceOfIncome = mainSourceOfIncome;
    return this;
  }

  /**
   * The organization&#39;s main source of income. Only required if &#x60;businessType&#x60; is **other**.  Possible values: **businessOperation**, **realEstateSales**, **investmentInterestOrRoyalty**, **propertyRental**, **other**.
   * @return mainSourceOfIncome
   */
  @ApiModelProperty(value = "The organization's main source of income. Only required if `businessType` is **other**.  Possible values: **businessOperation**, **realEstateSales**, **investmentInterestOrRoyalty**, **propertyRental**, **other**.")
  @JsonProperty(JSON_PROPERTY_MAIN_SOURCE_OF_INCOME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public MainSourceOfIncomeEnum getMainSourceOfIncome() {
    return mainSourceOfIncome;
  }

  /**
   * The organization&#39;s main source of income. Only required if &#x60;businessType&#x60; is **other**.  Possible values: **businessOperation**, **realEstateSales**, **investmentInterestOrRoyalty**, **propertyRental**, **other**.
   *
   * @param mainSourceOfIncome
   */ 
  @JsonProperty(JSON_PROPERTY_MAIN_SOURCE_OF_INCOME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMainSourceOfIncome(MainSourceOfIncomeEnum mainSourceOfIncome) {
    this.mainSourceOfIncome = mainSourceOfIncome;
  }

  /**
   * The tax reporting classification type.  Possible values: **nonFinancialNonReportable**, **financialNonReportable**, **nonFinancialActive**, **nonFinancialPassive**.
   *
   * @param type
   * @return the current {@code TaxReportingClassification} instance, allowing for method chaining
   */
  public TaxReportingClassification type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * The tax reporting classification type.  Possible values: **nonFinancialNonReportable**, **financialNonReportable**, **nonFinancialActive**, **nonFinancialPassive**.
   * @return type
   */
  @ApiModelProperty(value = "The tax reporting classification type.  Possible values: **nonFinancialNonReportable**, **financialNonReportable**, **nonFinancialActive**, **nonFinancialPassive**.")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * The tax reporting classification type.  Possible values: **nonFinancialNonReportable**, **financialNonReportable**, **nonFinancialActive**, **nonFinancialPassive**.
   *
   * @param type
   */ 
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /**
   * Return true if this TaxReportingClassification object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TaxReportingClassification taxReportingClassification = (TaxReportingClassification) o;
    return Objects.equals(this.businessType, taxReportingClassification.businessType) &&
        Objects.equals(this.financialInstitutionNumber, taxReportingClassification.financialInstitutionNumber) &&
        Objects.equals(this.mainSourceOfIncome, taxReportingClassification.mainSourceOfIncome) &&
        Objects.equals(this.type, taxReportingClassification.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(businessType, financialInstitutionNumber, mainSourceOfIncome, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TaxReportingClassification {\n");
    sb.append("    businessType: ").append(toIndentedString(businessType)).append("\n");
    sb.append("    financialInstitutionNumber: ").append(toIndentedString(financialInstitutionNumber)).append("\n");
    sb.append("    mainSourceOfIncome: ").append(toIndentedString(mainSourceOfIncome)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of TaxReportingClassification given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of TaxReportingClassification
   * @throws JsonProcessingException if the JSON string is invalid with respect to TaxReportingClassification
   */
  public static TaxReportingClassification fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, TaxReportingClassification.class);
  }
/**
  * Convert an instance of TaxReportingClassification to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
