/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.management;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.management.PaginationLinks;
import com.adyen.model.management.PaymentMethod;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * PaymentMethodResponse
 */
@JsonPropertyOrder({
  PaymentMethodResponse.JSON_PROPERTY_LINKS,
  PaymentMethodResponse.JSON_PROPERTY_DATA,
  PaymentMethodResponse.JSON_PROPERTY_ITEMS_TOTAL,
  PaymentMethodResponse.JSON_PROPERTY_PAGES_TOTAL,
  PaymentMethodResponse.JSON_PROPERTY_TYPES_WITH_ERRORS
})

public class PaymentMethodResponse {
  public static final String JSON_PROPERTY_LINKS = "_links";
  private PaginationLinks links;

  public static final String JSON_PROPERTY_DATA = "data";
  private List<PaymentMethod> data = null;

  public static final String JSON_PROPERTY_ITEMS_TOTAL = "itemsTotal";
  private Integer itemsTotal;

  public static final String JSON_PROPERTY_PAGES_TOTAL = "pagesTotal";
  private Integer pagesTotal;

  /**
   * Gets or Sets typesWithErrors
   */
  public enum TypesWithErrorsEnum {
    ACCEL("accel"),
    
    AFTERPAYTOUCH("afterpaytouch"),
    
    ALELO("alelo"),
    
    ALIPAY("alipay"),
    
    ALIPAY_HK("alipay_hk"),
    
    AMEX("amex"),
    
    APPLEPAY("applepay"),
    
    BANESE_CARD("banese_card"),
    
    BANESE_CARD_CREDIT("banese_card_credit"),
    
    BANESE_CARD_DEBIT("banese_card_debit"),
    
    BANESE_CARD_PREPAID("banese_card_prepaid"),
    
    BCMC("bcmc"),
    
    BLIK("blik"),
    
    CARTEBANCAIRE("cartebancaire"),
    
    CLEARPAY("clearpay"),
    
    CLICKTOPAY("clicktopay"),
    
    CREDTODOS("credtodos"),
    
    CREDTODOS_PRIVATE_CREDIT("credtodos_private_credit"),
    
    CREDTODOS_PRIVATE_DEBIT("credtodos_private_debit"),
    
    CUP("cup"),
    
    DINERS("diners"),
    
    DIRECTDEBIT_GB("directdebit_GB"),
    
    DISCOVER("discover"),
    
    EBANKING_FI("ebanking_FI"),
    
    EFTPOS_AUSTRALIA("eftpos_australia"),
    
    ELO("elo"),
    
    ELOCREDIT("elocredit"),
    
    ELODEBIT("elodebit"),
    
    GIROCARD("girocard"),
    
    GOOGLEPAY("googlepay"),
    
    HIPER("hiper"),
    
    HIPERCARD("hipercard"),
    
    IDEAL("ideal"),
    
    INTERAC_CARD("interac_card"),
    
    JCB("jcb"),
    
    KLARNA("klarna"),
    
    KLARNA_ACCOUNT("klarna_account"),
    
    KLARNA_PAYNOW("klarna_paynow"),
    
    MAESTRO("maestro"),
    
    MBWAY("mbway"),
    
    MC("mc"),
    
    MCDEBIT("mcdebit"),
    
    MEALVOUCHER_FR("mealVoucher_FR"),
    
    MOBILEPAY("mobilepay"),
    
    MULTIBANCO("multibanco"),
    
    NYCE("nyce"),
    
    ONLINEBANKING_PL("onlineBanking_PL"),
    
    PAYBYBANK("paybybank"),
    
    PAYME("payme"),
    
    PAYME_POS("payme_pos"),
    
    PAYNOW("paynow"),
    
    PAYNOW_POS("paynow_pos"),
    
    PAYPAL("paypal"),
    
    PAYSHOP("payshop"),
    
    PULSE("pulse"),
    
    SODEXO("sodexo"),
    
    STAR("star"),
    
    SWISH("swish"),
    
    TICKET("ticket"),
    
    TODO_GIFTCARD("todo_giftcard"),
    
    TRUSTLY("trustly"),
    
    TWINT("twint"),
    
    TWINT_POS("twint_pos"),
    
    UP_BRAZIL_CREDIT("up_brazil_credit"),
    
    VALE_REFEICAO("vale_refeicao"),
    
    VALE_REFEICAO_PREPAID("vale_refeicao_prepaid"),
    
    VIPPS("vipps"),
    
    VISA("visa"),
    
    VISADEBIT("visadebit"),
    
    VPAY("vpay"),
    
    WECHATPAY("wechatpay"),
    
    WECHATPAY_POS("wechatpay_pos");

    private String value;

    TypesWithErrorsEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypesWithErrorsEnum fromValue(String value) {
      for (TypesWithErrorsEnum b : TypesWithErrorsEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPES_WITH_ERRORS = "typesWithErrors";
  private List<TypesWithErrorsEnum> typesWithErrors = null;

  public PaymentMethodResponse() { 
  }

  /**
   * links
   *
   * @param links
   * @return the current {@code PaymentMethodResponse} instance, allowing for method chaining
   */
  public PaymentMethodResponse links(PaginationLinks links) {
    this.links = links;
    return this;
  }

  /**
   * links
   * @return links
   */
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public PaginationLinks getLinks() {
    return links;
  }

  /**
   * links
   *
   * @param links
   */ 
  @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLinks(PaginationLinks links) {
    this.links = links;
  }

  /**
   * The list of supported payment methods and their details.
   *
   * @param data
   * @return the current {@code PaymentMethodResponse} instance, allowing for method chaining
   */
  public PaymentMethodResponse data(List<PaymentMethod> data) {
    this.data = data;
    return this;
  }

  public PaymentMethodResponse addDataItem(PaymentMethod dataItem) {
    if (this.data == null) {
      this.data = new ArrayList<>();
    }
    this.data.add(dataItem);
    return this;
  }

  /**
   * The list of supported payment methods and their details.
   * @return data
   */
  @ApiModelProperty(value = "The list of supported payment methods and their details.")
  @JsonProperty(JSON_PROPERTY_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<PaymentMethod> getData() {
    return data;
  }

  /**
   * The list of supported payment methods and their details.
   *
   * @param data
   */ 
  @JsonProperty(JSON_PROPERTY_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setData(List<PaymentMethod> data) {
    this.data = data;
  }

  /**
   * Total number of items.
   *
   * @param itemsTotal
   * @return the current {@code PaymentMethodResponse} instance, allowing for method chaining
   */
  public PaymentMethodResponse itemsTotal(Integer itemsTotal) {
    this.itemsTotal = itemsTotal;
    return this;
  }

  /**
   * Total number of items.
   * @return itemsTotal
   */
  @ApiModelProperty(required = true, value = "Total number of items.")
  @JsonProperty(JSON_PROPERTY_ITEMS_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getItemsTotal() {
    return itemsTotal;
  }

  /**
   * Total number of items.
   *
   * @param itemsTotal
   */ 
  @JsonProperty(JSON_PROPERTY_ITEMS_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setItemsTotal(Integer itemsTotal) {
    this.itemsTotal = itemsTotal;
  }

  /**
   * Total number of pages.
   *
   * @param pagesTotal
   * @return the current {@code PaymentMethodResponse} instance, allowing for method chaining
   */
  public PaymentMethodResponse pagesTotal(Integer pagesTotal) {
    this.pagesTotal = pagesTotal;
    return this;
  }

  /**
   * Total number of pages.
   * @return pagesTotal
   */
  @ApiModelProperty(required = true, value = "Total number of pages.")
  @JsonProperty(JSON_PROPERTY_PAGES_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Integer getPagesTotal() {
    return pagesTotal;
  }

  /**
   * Total number of pages.
   *
   * @param pagesTotal
   */ 
  @JsonProperty(JSON_PROPERTY_PAGES_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPagesTotal(Integer pagesTotal) {
    this.pagesTotal = pagesTotal;
  }

  /**
   * Payment method types with errors.
   *
   * @param typesWithErrors
   * @return the current {@code PaymentMethodResponse} instance, allowing for method chaining
   */
  public PaymentMethodResponse typesWithErrors(List<TypesWithErrorsEnum> typesWithErrors) {
    this.typesWithErrors = typesWithErrors;
    return this;
  }

  public PaymentMethodResponse addTypesWithErrorsItem(TypesWithErrorsEnum typesWithErrorsItem) {
    if (this.typesWithErrors == null) {
      this.typesWithErrors = new ArrayList<>();
    }
    this.typesWithErrors.add(typesWithErrorsItem);
    return this;
  }

  /**
   * Payment method types with errors.
   * @return typesWithErrors
   */
  @ApiModelProperty(value = "Payment method types with errors.")
  @JsonProperty(JSON_PROPERTY_TYPES_WITH_ERRORS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<TypesWithErrorsEnum> getTypesWithErrors() {
    return typesWithErrors;
  }

  /**
   * Payment method types with errors.
   *
   * @param typesWithErrors
   */ 
  @JsonProperty(JSON_PROPERTY_TYPES_WITH_ERRORS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTypesWithErrors(List<TypesWithErrorsEnum> typesWithErrors) {
    this.typesWithErrors = typesWithErrors;
  }

  /**
   * Return true if this PaymentMethodResponse object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentMethodResponse paymentMethodResponse = (PaymentMethodResponse) o;
    return Objects.equals(this.links, paymentMethodResponse.links) &&
        Objects.equals(this.data, paymentMethodResponse.data) &&
        Objects.equals(this.itemsTotal, paymentMethodResponse.itemsTotal) &&
        Objects.equals(this.pagesTotal, paymentMethodResponse.pagesTotal) &&
        Objects.equals(this.typesWithErrors, paymentMethodResponse.typesWithErrors);
  }

  @Override
  public int hashCode() {
    return Objects.hash(links, data, itemsTotal, pagesTotal, typesWithErrors);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentMethodResponse {\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("    data: ").append(toIndentedString(data)).append("\n");
    sb.append("    itemsTotal: ").append(toIndentedString(itemsTotal)).append("\n");
    sb.append("    pagesTotal: ").append(toIndentedString(pagesTotal)).append("\n");
    sb.append("    typesWithErrors: ").append(toIndentedString(typesWithErrors)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of PaymentMethodResponse given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of PaymentMethodResponse
   * @throws JsonProcessingException if the JSON string is invalid with respect to PaymentMethodResponse
   */
  public static PaymentMethodResponse fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, PaymentMethodResponse.class);
  }
/**
  * Convert an instance of PaymentMethodResponse to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
