/*
 * POS Mobile API
 *
 * The version of the OpenAPI document: 68
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.posmobile;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * CreateSessionResponse
 */
@JsonPropertyOrder({
  CreateSessionResponse.JSON_PROPERTY_ID,
  CreateSessionResponse.JSON_PROPERTY_INSTALLATION_ID,
  CreateSessionResponse.JSON_PROPERTY_MERCHANT_ACCOUNT,
  CreateSessionResponse.JSON_PROPERTY_SDK_DATA,
  CreateSessionResponse.JSON_PROPERTY_STORE
})

public class CreateSessionResponse {
  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_INSTALLATION_ID = "installationId";
  private String installationId;

  public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
  private String merchantAccount;

  public static final String JSON_PROPERTY_SDK_DATA = "sdkData";
  private String sdkData;

  public static final String JSON_PROPERTY_STORE = "store";
  private String store;

  public CreateSessionResponse() { 
  }

  /**
   * The unique identifier of the session.
   *
   * @param id
   * @return the current {@code CreateSessionResponse} instance, allowing for method chaining
   */
  public CreateSessionResponse id(String id) {
    this.id = id;
    return this;
  }

  /**
   * The unique identifier of the session.
   * @return id
   */
  @ApiModelProperty(value = "The unique identifier of the session.")
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getId() {
    return id;
  }

  /**
   * The unique identifier of the session.
   *
   * @param id
   */ 
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }

  /**
   * The unique identifier of the SDK installation. If you create the [Terminal API](https://docs.adyen.com/point-of-sale/design-your-integration/terminal-api/) transaction request on your backend, use this as the &#x60;POIID&#x60; in the &#x60;MessageHeader&#x60; of the request.
   *
   * @param installationId
   * @return the current {@code CreateSessionResponse} instance, allowing for method chaining
   */
  public CreateSessionResponse installationId(String installationId) {
    this.installationId = installationId;
    return this;
  }

  /**
   * The unique identifier of the SDK installation. If you create the [Terminal API](https://docs.adyen.com/point-of-sale/design-your-integration/terminal-api/) transaction request on your backend, use this as the &#x60;POIID&#x60; in the &#x60;MessageHeader&#x60; of the request.
   * @return installationId
   */
  @ApiModelProperty(value = "The unique identifier of the SDK installation. If you create the [Terminal API](https://docs.adyen.com/point-of-sale/design-your-integration/terminal-api/) transaction request on your backend, use this as the `POIID` in the `MessageHeader` of the request.")
  @JsonProperty(JSON_PROPERTY_INSTALLATION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getInstallationId() {
    return installationId;
  }

  /**
   * The unique identifier of the SDK installation. If you create the [Terminal API](https://docs.adyen.com/point-of-sale/design-your-integration/terminal-api/) transaction request on your backend, use this as the &#x60;POIID&#x60; in the &#x60;MessageHeader&#x60; of the request.
   *
   * @param installationId
   */ 
  @JsonProperty(JSON_PROPERTY_INSTALLATION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInstallationId(String installationId) {
    this.installationId = installationId;
  }

  /**
   * The unique identifier of your merchant account.
   *
   * @param merchantAccount
   * @return the current {@code CreateSessionResponse} instance, allowing for method chaining
   */
  public CreateSessionResponse merchantAccount(String merchantAccount) {
    this.merchantAccount = merchantAccount;
    return this;
  }

  /**
   * The unique identifier of your merchant account.
   * @return merchantAccount
   */
  @ApiModelProperty(value = "The unique identifier of your merchant account.")
  @JsonProperty(JSON_PROPERTY_MERCHANT_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMerchantAccount() {
    return merchantAccount;
  }

  /**
   * The unique identifier of your merchant account.
   *
   * @param merchantAccount
   */ 
  @JsonProperty(JSON_PROPERTY_MERCHANT_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantAccount(String merchantAccount) {
    this.merchantAccount = merchantAccount;
  }

  /**
   * The data that the SDK uses to authenticate responses from the Adyen payments platform. Pass this value to your POS app.
   *
   * @param sdkData
   * @return the current {@code CreateSessionResponse} instance, allowing for method chaining
   */
  public CreateSessionResponse sdkData(String sdkData) {
    this.sdkData = sdkData;
    return this;
  }

  /**
   * The data that the SDK uses to authenticate responses from the Adyen payments platform. Pass this value to your POS app.
   * @return sdkData
   */
  @ApiModelProperty(value = "The data that the SDK uses to authenticate responses from the Adyen payments platform. Pass this value to your POS app.")
  @JsonProperty(JSON_PROPERTY_SDK_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getSdkData() {
    return sdkData;
  }

  /**
   * The data that the SDK uses to authenticate responses from the Adyen payments platform. Pass this value to your POS app.
   *
   * @param sdkData
   */ 
  @JsonProperty(JSON_PROPERTY_SDK_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSdkData(String sdkData) {
    this.sdkData = sdkData;
  }

  /**
   * The unique identifier of the store that you want to process transactions for.
   *
   * @param store
   * @return the current {@code CreateSessionResponse} instance, allowing for method chaining
   */
  public CreateSessionResponse store(String store) {
    this.store = store;
    return this;
  }

  /**
   * The unique identifier of the store that you want to process transactions for.
   * @return store
   */
  @ApiModelProperty(value = "The unique identifier of the store that you want to process transactions for.")
  @JsonProperty(JSON_PROPERTY_STORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getStore() {
    return store;
  }

  /**
   * The unique identifier of the store that you want to process transactions for.
   *
   * @param store
   */ 
  @JsonProperty(JSON_PROPERTY_STORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStore(String store) {
    this.store = store;
  }

  /**
   * Return true if this CreateSessionResponse object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateSessionResponse createSessionResponse = (CreateSessionResponse) o;
    return Objects.equals(this.id, createSessionResponse.id) &&
        Objects.equals(this.installationId, createSessionResponse.installationId) &&
        Objects.equals(this.merchantAccount, createSessionResponse.merchantAccount) &&
        Objects.equals(this.sdkData, createSessionResponse.sdkData) &&
        Objects.equals(this.store, createSessionResponse.store);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, installationId, merchantAccount, sdkData, store);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateSessionResponse {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    installationId: ").append(toIndentedString(installationId)).append("\n");
    sb.append("    merchantAccount: ").append(toIndentedString(merchantAccount)).append("\n");
    sb.append("    sdkData: ").append(toIndentedString(sdkData)).append("\n");
    sb.append("    store: ").append(toIndentedString(store)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of CreateSessionResponse given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of CreateSessionResponse
   * @throws JsonProcessingException if the JSON string is invalid with respect to CreateSessionResponse
   */
  public static CreateSessionResponse fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, CreateSessionResponse.class);
  }
/**
  * Convert an instance of CreateSessionResponse to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
