/*
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.checkout;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * Amounts
 */
@JsonPropertyOrder({
  Amounts.JSON_PROPERTY_CURRENCY,
  Amounts.JSON_PROPERTY_VALUES
})

public class Amounts {
  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private String currency;

  public static final String JSON_PROPERTY_VALUES = "values";
  private List<Long> values = new ArrayList<>();

  public Amounts() { 
  }

  /**
   * The three-character [ISO currency code](https://docs.adyen.com/development-resources/currency-codes/).
   *
   * @param currency
   * @return the current {@code Amounts} instance, allowing for method chaining
   */
  public Amounts currency(String currency) {
    this.currency = currency;
    return this;
  }

  /**
   * The three-character [ISO currency code](https://docs.adyen.com/development-resources/currency-codes/).
   * @return currency
   */
  @ApiModelProperty(required = true, value = "The three-character [ISO currency code](https://docs.adyen.com/development-resources/currency-codes/).")
  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getCurrency() {
    return currency;
  }

  /**
   * The three-character [ISO currency code](https://docs.adyen.com/development-resources/currency-codes/).
   *
   * @param currency
   */ 
  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrency(String currency) {
    this.currency = currency;
  }

  /**
   * The amounts of the donation (in [minor units](https://docs.adyen.com/development-resources/currency-codes/)).
   *
   * @param values
   * @return the current {@code Amounts} instance, allowing for method chaining
   */
  public Amounts values(List<Long> values) {
    this.values = values;
    return this;
  }

  public Amounts addValuesItem(Long valuesItem) {
    this.values.add(valuesItem);
    return this;
  }

  /**
   * The amounts of the donation (in [minor units](https://docs.adyen.com/development-resources/currency-codes/)).
   * @return values
   */
  @ApiModelProperty(required = true, value = "The amounts of the donation (in [minor units](https://docs.adyen.com/development-resources/currency-codes/)).")
  @JsonProperty(JSON_PROPERTY_VALUES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public List<Long> getValues() {
    return values;
  }

  /**
   * The amounts of the donation (in [minor units](https://docs.adyen.com/development-resources/currency-codes/)).
   *
   * @param values
   */ 
  @JsonProperty(JSON_PROPERTY_VALUES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValues(List<Long> values) {
    this.values = values;
  }

  /**
   * Return true if this Amounts object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Amounts amounts = (Amounts) o;
    return Objects.equals(this.currency, amounts.currency) &&
        Objects.equals(this.values, amounts.values);
  }

  @Override
  public int hashCode() {
    return Objects.hash(currency, values);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Amounts {\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    values: ").append(toIndentedString(values)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of Amounts given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Amounts
   * @throws JsonProcessingException if the JSON string is invalid with respect to Amounts
   */
  public static Amounts fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, Amounts.class);
  }
/**
  * Convert an instance of Amounts to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
