/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.management;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.adyen.model.management.TransactionDescriptionInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * JCBInfo
 */
@JsonPropertyOrder({
  JCBInfo.JSON_PROPERTY_MID_NUMBER,
  JCBInfo.JSON_PROPERTY_REUSE_MID_NUMBER,
  JCBInfo.JSON_PROPERTY_SERVICE_LEVEL,
  JCBInfo.JSON_PROPERTY_TRANSACTION_DESCRIPTION
})

public class JCBInfo {
  public static final String JSON_PROPERTY_MID_NUMBER = "midNumber";
  private String midNumber;

  public static final String JSON_PROPERTY_REUSE_MID_NUMBER = "reuseMidNumber";
  private Boolean reuseMidNumber;

  /**
   * Specifies the service level (settlement type) of this payment method. Possible values: * **noContract** — Adyen holds the contract with JCB. * **gatewayContract** — JCB receives the settlement and handles disputes. They then pay out to the merchant directly.
   */
  public enum ServiceLevelEnum {
    NOCONTRACT("noContract"),
    
    GATEWAYCONTRACT("gatewayContract");

    private String value;

    ServiceLevelEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ServiceLevelEnum fromValue(String value) {
      for (ServiceLevelEnum b : ServiceLevelEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SERVICE_LEVEL = "serviceLevel";
  private ServiceLevelEnum serviceLevel;

  public static final String JSON_PROPERTY_TRANSACTION_DESCRIPTION = "transactionDescription";
  private TransactionDescriptionInfo transactionDescription;

  public JCBInfo() { 
  }

  /**
   * MID (Merchant ID) number. Format: 10 numeric characters.  Must be provided for both &#x60;noContract&#x60; and &#x60;gatewayContract&#x60; service levels.
   *
   * @param midNumber
   * @return the current {@code JCBInfo} instance, allowing for method chaining
   */
  public JCBInfo midNumber(String midNumber) {
    this.midNumber = midNumber;
    return this;
  }

  /**
   * MID (Merchant ID) number. Format: 10 numeric characters.  Must be provided for both &#x60;noContract&#x60; and &#x60;gatewayContract&#x60; service levels.
   * @return midNumber
   */
  @ApiModelProperty(value = "MID (Merchant ID) number. Format: 10 numeric characters.  Must be provided for both `noContract` and `gatewayContract` service levels.")
  @JsonProperty(JSON_PROPERTY_MID_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMidNumber() {
    return midNumber;
  }

  /**
   * MID (Merchant ID) number. Format: 10 numeric characters.  Must be provided for both &#x60;noContract&#x60; and &#x60;gatewayContract&#x60; service levels.
   *
   * @param midNumber
   */ 
  @JsonProperty(JSON_PROPERTY_MID_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMidNumber(String midNumber) {
    this.midNumber = midNumber;
  }

  /**
   * Indicates whether the JCB Merchant ID is reused from a previously setup JCB payment method.  This is applicable for both &#x60;noContract&#x60; and &#x60;gatewayContract&#x60; service levels.  The default value is &#x60;false&#x60;.
   *
   * @param reuseMidNumber
   * @return the current {@code JCBInfo} instance, allowing for method chaining
   */
  public JCBInfo reuseMidNumber(Boolean reuseMidNumber) {
    this.reuseMidNumber = reuseMidNumber;
    return this;
  }

  /**
   * Indicates whether the JCB Merchant ID is reused from a previously setup JCB payment method.  This is applicable for both &#x60;noContract&#x60; and &#x60;gatewayContract&#x60; service levels.  The default value is &#x60;false&#x60;.
   * @return reuseMidNumber
   */
  @ApiModelProperty(value = "Indicates whether the JCB Merchant ID is reused from a previously setup JCB payment method.  This is applicable for both `noContract` and `gatewayContract` service levels.  The default value is `false`.")
  @JsonProperty(JSON_PROPERTY_REUSE_MID_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getReuseMidNumber() {
    return reuseMidNumber;
  }

  /**
   * Indicates whether the JCB Merchant ID is reused from a previously setup JCB payment method.  This is applicable for both &#x60;noContract&#x60; and &#x60;gatewayContract&#x60; service levels.  The default value is &#x60;false&#x60;.
   *
   * @param reuseMidNumber
   */ 
  @JsonProperty(JSON_PROPERTY_REUSE_MID_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReuseMidNumber(Boolean reuseMidNumber) {
    this.reuseMidNumber = reuseMidNumber;
  }

  /**
   * Specifies the service level (settlement type) of this payment method. Possible values: * **noContract** — Adyen holds the contract with JCB. * **gatewayContract** — JCB receives the settlement and handles disputes. They then pay out to the merchant directly.
   *
   * @param serviceLevel
   * @return the current {@code JCBInfo} instance, allowing for method chaining
   */
  public JCBInfo serviceLevel(ServiceLevelEnum serviceLevel) {
    this.serviceLevel = serviceLevel;
    return this;
  }

  /**
   * Specifies the service level (settlement type) of this payment method. Possible values: * **noContract** — Adyen holds the contract with JCB. * **gatewayContract** — JCB receives the settlement and handles disputes. They then pay out to the merchant directly.
   * @return serviceLevel
   */
  @ApiModelProperty(required = true, value = "Specifies the service level (settlement type) of this payment method. Possible values: * **noContract** — Adyen holds the contract with JCB. * **gatewayContract** — JCB receives the settlement and handles disputes. They then pay out to the merchant directly.")
  @JsonProperty(JSON_PROPERTY_SERVICE_LEVEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public ServiceLevelEnum getServiceLevel() {
    return serviceLevel;
  }

  /**
   * Specifies the service level (settlement type) of this payment method. Possible values: * **noContract** — Adyen holds the contract with JCB. * **gatewayContract** — JCB receives the settlement and handles disputes. They then pay out to the merchant directly.
   *
   * @param serviceLevel
   */ 
  @JsonProperty(JSON_PROPERTY_SERVICE_LEVEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setServiceLevel(ServiceLevelEnum serviceLevel) {
    this.serviceLevel = serviceLevel;
  }

  /**
   * transactionDescription
   *
   * @param transactionDescription
   * @return the current {@code JCBInfo} instance, allowing for method chaining
   */
  public JCBInfo transactionDescription(TransactionDescriptionInfo transactionDescription) {
    this.transactionDescription = transactionDescription;
    return this;
  }

  /**
   * transactionDescription
   * @return transactionDescription
   */
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TRANSACTION_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TransactionDescriptionInfo getTransactionDescription() {
    return transactionDescription;
  }

  /**
   * transactionDescription
   *
   * @param transactionDescription
   */ 
  @JsonProperty(JSON_PROPERTY_TRANSACTION_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransactionDescription(TransactionDescriptionInfo transactionDescription) {
    this.transactionDescription = transactionDescription;
  }

  /**
   * Return true if this JCBInfo object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JCBInfo jcBInfo = (JCBInfo) o;
    return Objects.equals(this.midNumber, jcBInfo.midNumber) &&
        Objects.equals(this.reuseMidNumber, jcBInfo.reuseMidNumber) &&
        Objects.equals(this.serviceLevel, jcBInfo.serviceLevel) &&
        Objects.equals(this.transactionDescription, jcBInfo.transactionDescription);
  }

  @Override
  public int hashCode() {
    return Objects.hash(midNumber, reuseMidNumber, serviceLevel, transactionDescription);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JCBInfo {\n");
    sb.append("    midNumber: ").append(toIndentedString(midNumber)).append("\n");
    sb.append("    reuseMidNumber: ").append(toIndentedString(reuseMidNumber)).append("\n");
    sb.append("    serviceLevel: ").append(toIndentedString(serviceLevel)).append("\n");
    sb.append("    transactionDescription: ").append(toIndentedString(transactionDescription)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of JCBInfo given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of JCBInfo
   * @throws JsonProcessingException if the JSON string is invalid with respect to JCBInfo
   */
  public static JCBInfo fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, JCBInfo.class);
  }
/**
  * Convert an instance of JCBInfo to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
