/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.configurationwebhooks;

import com.adyen.model.configurationwebhooks.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"capabilities", "entityIds", "expiresAt"})
public class VerificationDeadline {
    public static final String JSON_PROPERTY_CAPABILITIES = "capabilities";
    private List<CapabilitiesEnum> capabilities = new ArrayList<CapabilitiesEnum>();
    public static final String JSON_PROPERTY_ENTITY_IDS = "entityIds";
    private List<String> entityIds = null;
    public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
    private OffsetDateTime expiresAt;

    public VerificationDeadline capabilities(List<CapabilitiesEnum> capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public VerificationDeadline addCapabilitiesItem(CapabilitiesEnum capabilitiesItem) {
        this.capabilities.add(capabilitiesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The names of the capabilities to be disallowed.")
    @JsonProperty(value="capabilities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<CapabilitiesEnum> getCapabilities() {
        return this.capabilities;
    }

    @JsonProperty(value="capabilities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCapabilities(List<CapabilitiesEnum> capabilities) {
        this.capabilities = capabilities;
    }

    public VerificationDeadline entityIds(List<String> entityIds) {
        this.entityIds = entityIds;
        return this;
    }

    public VerificationDeadline addEntityIdsItem(String entityIdsItem) {
        if (this.entityIds == null) {
            this.entityIds = new ArrayList<String>();
        }
        this.entityIds.add(entityIdsItem);
        return this;
    }

    @ApiModelProperty(value="The unique identifiers of the bank account(s) that the deadline applies to")
    @JsonProperty(value="entityIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getEntityIds() {
        return this.entityIds;
    }

    @JsonProperty(value="entityIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEntityIds(List<String> entityIds) {
        this.entityIds = entityIds;
    }

    public VerificationDeadline expiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @ApiModelProperty(required=true, value="The date that verification is due by before capabilities are disallowed.")
    @JsonProperty(value="expiresAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    @JsonProperty(value="expiresAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerificationDeadline verificationDeadline = (VerificationDeadline)o;
        return Objects.equals(this.capabilities, verificationDeadline.capabilities) && Objects.equals(this.entityIds, verificationDeadline.entityIds) && Objects.equals(this.expiresAt, verificationDeadline.expiresAt);
    }

    public int hashCode() {
        return Objects.hash(this.capabilities, this.entityIds, this.expiresAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VerificationDeadline {\n");
        sb.append("    capabilities: ").append(this.toIndentedString(this.capabilities)).append("\n");
        sb.append("    entityIds: ").append(this.toIndentedString(this.entityIds)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static VerificationDeadline fromJson(String jsonString) throws JsonProcessingException {
        return (VerificationDeadline)JSON.getMapper().readValue(jsonString, VerificationDeadline.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum CapabilitiesEnum {
        ACCEPTEXTERNALFUNDING("acceptExternalFunding"),
        ACCEPTPSPFUNDING("acceptPspFunding"),
        ACCEPTTRANSACTIONINRESTRICTEDCOUNTRIES("acceptTransactionInRestrictedCountries"),
        ACCEPTTRANSACTIONINRESTRICTEDCOUNTRIESCOMMERCIAL("acceptTransactionInRestrictedCountriesCommercial"),
        ACCEPTTRANSACTIONINRESTRICTEDCOUNTRIESCONSUMER("acceptTransactionInRestrictedCountriesConsumer"),
        ACCEPTTRANSACTIONINRESTRICTEDINDUSTRIES("acceptTransactionInRestrictedIndustries"),
        ACCEPTTRANSACTIONINRESTRICTEDINDUSTRIESCOMMERCIAL("acceptTransactionInRestrictedIndustriesCommercial"),
        ACCEPTTRANSACTIONINRESTRICTEDINDUSTRIESCONSUMER("acceptTransactionInRestrictedIndustriesConsumer"),
        ACQUIRING("acquiring"),
        ATMWITHDRAWAL("atmWithdrawal"),
        ATMWITHDRAWALCOMMERCIAL("atmWithdrawalCommercial"),
        ATMWITHDRAWALCONSUMER("atmWithdrawalConsumer"),
        ATMWITHDRAWALINRESTRICTEDCOUNTRIES("atmWithdrawalInRestrictedCountries"),
        ATMWITHDRAWALINRESTRICTEDCOUNTRIESCOMMERCIAL("atmWithdrawalInRestrictedCountriesCommercial"),
        ATMWITHDRAWALINRESTRICTEDCOUNTRIESCONSUMER("atmWithdrawalInRestrictedCountriesConsumer"),
        AUTHORISEDPAYMENTINSTRUMENTUSER("authorisedPaymentInstrumentUser"),
        GETGRANTOFFERS("getGrantOffers"),
        ISSUEBANKACCOUNT("issueBankAccount"),
        ISSUECARD("issueCard"),
        ISSUECARDCOMMERCIAL("issueCardCommercial"),
        ISSUECARDCONSUMER("issueCardConsumer"),
        ISSUECREDITLIMIT("issueCreditLimit"),
        LOCALACCEPTANCE("localAcceptance"),
        PAYOUT("payout"),
        PAYOUTTOTRANSFERINSTRUMENT("payoutToTransferInstrument"),
        PROCESSING("processing"),
        RECEIVEFROMBALANCEACCOUNT("receiveFromBalanceAccount"),
        RECEIVEFROMPLATFORMPAYMENTS("receiveFromPlatformPayments"),
        RECEIVEFROMTHIRDPARTY("receiveFromThirdParty"),
        RECEIVEFROMTRANSFERINSTRUMENT("receiveFromTransferInstrument"),
        RECEIVEGRANTS("receiveGrants"),
        RECEIVEPAYMENTS("receivePayments"),
        SENDTOBALANCEACCOUNT("sendToBalanceAccount"),
        SENDTOTHIRDPARTY("sendToThirdParty"),
        SENDTOTRANSFERINSTRUMENT("sendToTransferInstrument"),
        THIRDPARTYFUNDING("thirdPartyFunding"),
        USECARD("useCard"),
        USECARDCOMMERCIAL("useCardCommercial"),
        USECARDCONSUMER("useCardConsumer"),
        USECARDINRESTRICTEDCOUNTRIES("useCardInRestrictedCountries"),
        USECARDINRESTRICTEDCOUNTRIESCOMMERCIAL("useCardInRestrictedCountriesCommercial"),
        USECARDINRESTRICTEDCOUNTRIESCONSUMER("useCardInRestrictedCountriesConsumer"),
        USECARDINRESTRICTEDINDUSTRIES("useCardInRestrictedIndustries"),
        USECARDINRESTRICTEDINDUSTRIESCOMMERCIAL("useCardInRestrictedIndustriesCommercial"),
        USECARDINRESTRICTEDINDUSTRIESCONSUMER("useCardInRestrictedIndustriesConsumer"),
        WITHDRAWFROMATM("withdrawFromAtm"),
        WITHDRAWFROMATMCOMMERCIAL("withdrawFromAtmCommercial"),
        WITHDRAWFROMATMCONSUMER("withdrawFromAtmConsumer"),
        WITHDRAWFROMATMINRESTRICTEDCOUNTRIES("withdrawFromAtmInRestrictedCountries"),
        WITHDRAWFROMATMINRESTRICTEDCOUNTRIESCOMMERCIAL("withdrawFromAtmInRestrictedCountriesCommercial"),
        WITHDRAWFROMATMINRESTRICTEDCOUNTRIESCONSUMER("withdrawFromAtmInRestrictedCountriesConsumer");

        private String value;

        private CapabilitiesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CapabilitiesEnum fromValue(String value) {
            for (CapabilitiesEnum b : CapabilitiesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

