/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.configurationwebhooks;

import com.adyen.model.configurationwebhooks.JSON;
import com.adyen.model.configurationwebhooks.RemediatingAction;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"capabilities", "code", "message", "type", "remediatingActions"})
@JsonTypeName(value="VerificationError-recursive")
public class VerificationErrorRecursive {
    public static final String JSON_PROPERTY_CAPABILITIES = "capabilities";
    private List<CapabilitiesEnum> capabilities = null;
    public static final String JSON_PROPERTY_CODE = "code";
    private String code;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_REMEDIATING_ACTIONS = "remediatingActions";
    private List<RemediatingAction> remediatingActions = null;

    public VerificationErrorRecursive capabilities(List<CapabilitiesEnum> capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public VerificationErrorRecursive addCapabilitiesItem(CapabilitiesEnum capabilitiesItem) {
        if (this.capabilities == null) {
            this.capabilities = new ArrayList<CapabilitiesEnum>();
        }
        this.capabilities.add(capabilitiesItem);
        return this;
    }

    @ApiModelProperty(value="Contains the capabilities that the verification error applies to.")
    @JsonProperty(value="capabilities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<CapabilitiesEnum> getCapabilities() {
        return this.capabilities;
    }

    @JsonProperty(value="capabilities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCapabilities(List<CapabilitiesEnum> capabilities) {
        this.capabilities = capabilities;
    }

    public VerificationErrorRecursive code(String code) {
        this.code = code;
        return this;
    }

    @ApiModelProperty(value="The verification error code.")
    @JsonProperty(value="code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCode() {
        return this.code;
    }

    @JsonProperty(value="code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCode(String code) {
        this.code = code;
    }

    public VerificationErrorRecursive message(String message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(value="A description of the error.")
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMessage(String message) {
        this.message = message;
    }

    public VerificationErrorRecursive type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of error.   Possible values: **invalidInput**, **dataMissing**.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public VerificationErrorRecursive remediatingActions(List<RemediatingAction> remediatingActions) {
        this.remediatingActions = remediatingActions;
        return this;
    }

    public VerificationErrorRecursive addRemediatingActionsItem(RemediatingAction remediatingActionsItem) {
        if (this.remediatingActions == null) {
            this.remediatingActions = new ArrayList<RemediatingAction>();
        }
        this.remediatingActions.add(remediatingActionsItem);
        return this;
    }

    @ApiModelProperty(value="Contains the actions that you can take to resolve the verification error.")
    @JsonProperty(value="remediatingActions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<RemediatingAction> getRemediatingActions() {
        return this.remediatingActions;
    }

    @JsonProperty(value="remediatingActions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRemediatingActions(List<RemediatingAction> remediatingActions) {
        this.remediatingActions = remediatingActions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerificationErrorRecursive verificationErrorRecursive = (VerificationErrorRecursive)o;
        return Objects.equals(this.capabilities, verificationErrorRecursive.capabilities) && Objects.equals(this.code, verificationErrorRecursive.code) && Objects.equals(this.message, verificationErrorRecursive.message) && Objects.equals((Object)this.type, (Object)verificationErrorRecursive.type) && Objects.equals(this.remediatingActions, verificationErrorRecursive.remediatingActions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.capabilities, this.code, this.message, this.type, this.remediatingActions});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VerificationErrorRecursive {\n");
        sb.append("    capabilities: ").append(this.toIndentedString(this.capabilities)).append("\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    remediatingActions: ").append(this.toIndentedString(this.remediatingActions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static VerificationErrorRecursive fromJson(String jsonString) throws JsonProcessingException {
        return (VerificationErrorRecursive)JSON.getMapper().readValue(jsonString, VerificationErrorRecursive.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        DATAMISSING("dataMissing"),
        INVALIDINPUT("invalidInput"),
        PENDINGSTATUS("pendingStatus");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum CapabilitiesEnum {
        ACCEPTEXTERNALFUNDING("acceptExternalFunding"),
        ACCEPTPSPFUNDING("acceptPspFunding"),
        ACCEPTTRANSACTIONINRESTRICTEDCOUNTRIES("acceptTransactionInRestrictedCountries"),
        ACCEPTTRANSACTIONINRESTRICTEDCOUNTRIESCOMMERCIAL("acceptTransactionInRestrictedCountriesCommercial"),
        ACCEPTTRANSACTIONINRESTRICTEDCOUNTRIESCONSUMER("acceptTransactionInRestrictedCountriesConsumer"),
        ACCEPTTRANSACTIONINRESTRICTEDINDUSTRIES("acceptTransactionInRestrictedIndustries"),
        ACCEPTTRANSACTIONINRESTRICTEDINDUSTRIESCOMMERCIAL("acceptTransactionInRestrictedIndustriesCommercial"),
        ACCEPTTRANSACTIONINRESTRICTEDINDUSTRIESCONSUMER("acceptTransactionInRestrictedIndustriesConsumer"),
        ACQUIRING("acquiring"),
        ATMWITHDRAWAL("atmWithdrawal"),
        ATMWITHDRAWALCOMMERCIAL("atmWithdrawalCommercial"),
        ATMWITHDRAWALCONSUMER("atmWithdrawalConsumer"),
        ATMWITHDRAWALINRESTRICTEDCOUNTRIES("atmWithdrawalInRestrictedCountries"),
        ATMWITHDRAWALINRESTRICTEDCOUNTRIESCOMMERCIAL("atmWithdrawalInRestrictedCountriesCommercial"),
        ATMWITHDRAWALINRESTRICTEDCOUNTRIESCONSUMER("atmWithdrawalInRestrictedCountriesConsumer"),
        AUTHORISEDPAYMENTINSTRUMENTUSER("authorisedPaymentInstrumentUser"),
        GETGRANTOFFERS("getGrantOffers"),
        ISSUEBANKACCOUNT("issueBankAccount"),
        ISSUECARD("issueCard"),
        ISSUECARDCOMMERCIAL("issueCardCommercial"),
        ISSUECARDCONSUMER("issueCardConsumer"),
        ISSUECREDITLIMIT("issueCreditLimit"),
        LOCALACCEPTANCE("localAcceptance"),
        PAYOUT("payout"),
        PAYOUTTOTRANSFERINSTRUMENT("payoutToTransferInstrument"),
        PROCESSING("processing"),
        RECEIVEFROMBALANCEACCOUNT("receiveFromBalanceAccount"),
        RECEIVEFROMPLATFORMPAYMENTS("receiveFromPlatformPayments"),
        RECEIVEFROMTHIRDPARTY("receiveFromThirdParty"),
        RECEIVEFROMTRANSFERINSTRUMENT("receiveFromTransferInstrument"),
        RECEIVEGRANTS("receiveGrants"),
        RECEIVEPAYMENTS("receivePayments"),
        SENDTOBALANCEACCOUNT("sendToBalanceAccount"),
        SENDTOTHIRDPARTY("sendToThirdParty"),
        SENDTOTRANSFERINSTRUMENT("sendToTransferInstrument"),
        THIRDPARTYFUNDING("thirdPartyFunding"),
        USECARD("useCard"),
        USECARDCOMMERCIAL("useCardCommercial"),
        USECARDCONSUMER("useCardConsumer"),
        USECARDINRESTRICTEDCOUNTRIES("useCardInRestrictedCountries"),
        USECARDINRESTRICTEDCOUNTRIESCOMMERCIAL("useCardInRestrictedCountriesCommercial"),
        USECARDINRESTRICTEDCOUNTRIESCONSUMER("useCardInRestrictedCountriesConsumer"),
        USECARDINRESTRICTEDINDUSTRIES("useCardInRestrictedIndustries"),
        USECARDINRESTRICTEDINDUSTRIESCOMMERCIAL("useCardInRestrictedIndustriesCommercial"),
        USECARDINRESTRICTEDINDUSTRIESCONSUMER("useCardInRestrictedIndustriesConsumer"),
        WITHDRAWFROMATM("withdrawFromAtm"),
        WITHDRAWFROMATMCOMMERCIAL("withdrawFromAtmCommercial"),
        WITHDRAWFROMATMCONSUMER("withdrawFromAtmConsumer"),
        WITHDRAWFROMATMINRESTRICTEDCOUNTRIES("withdrawFromAtmInRestrictedCountries"),
        WITHDRAWFROMATMINRESTRICTEDCOUNTRIESCOMMERCIAL("withdrawFromAtmInRestrictedCountriesCommercial"),
        WITHDRAWFROMATMINRESTRICTEDCOUNTRIESCONSUMER("withdrawFromAtmInRestrictedCountriesConsumer");

        private String value;

        private CapabilitiesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CapabilitiesEnum fromValue(String value) {
            for (CapabilitiesEnum b : CapabilitiesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

