/*
 * Legal Entity Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.legalentitymanagement;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * SourceOfFunds
 */
@JsonPropertyOrder({
  SourceOfFunds.JSON_PROPERTY_ACQUIRING_BUSINESS_LINE_ID,
  SourceOfFunds.JSON_PROPERTY_ADYEN_PROCESSED_FUNDS,
  SourceOfFunds.JSON_PROPERTY_DESCRIPTION,
  SourceOfFunds.JSON_PROPERTY_TYPE
})

public class SourceOfFunds {
  public static final String JSON_PROPERTY_ACQUIRING_BUSINESS_LINE_ID = "acquiringBusinessLineId";
  @Deprecated // deprecated since Legal Entity Management API v3: This field will be removed in v4.
  private String acquiringBusinessLineId;

  public static final String JSON_PROPERTY_ADYEN_PROCESSED_FUNDS = "adyenProcessedFunds";
  private Boolean adyenProcessedFunds;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  /**
   * The type of the source of funds. Possible value: **business**.
   */
  public enum TypeEnum {
    BUSINESS("business");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public SourceOfFunds() { 
  }

  /**
   * The unique identifier of the business line that will be the source of funds.This must be a business line for a **receivePayments** or **receiveFromPlatformPayments** capability.
   *
   * @param acquiringBusinessLineId
   * @return the current {@code SourceOfFunds} instance, allowing for method chaining
   *
   * @deprecated since Legal Entity Management API v3
   * This field will be removed in v4.
   */
  @Deprecated
  public SourceOfFunds acquiringBusinessLineId(String acquiringBusinessLineId) {
    this.acquiringBusinessLineId = acquiringBusinessLineId;
    return this;
  }

  /**
   * The unique identifier of the business line that will be the source of funds.This must be a business line for a **receivePayments** or **receiveFromPlatformPayments** capability.
   * @return acquiringBusinessLineId
   *
   * @deprecated since Legal Entity Management API v3
   * This field will be removed in v4.
   */
  @Deprecated
  @ApiModelProperty(value = "The unique identifier of the business line that will be the source of funds.This must be a business line for a **receivePayments** or **receiveFromPlatformPayments** capability.")
  @JsonProperty(JSON_PROPERTY_ACQUIRING_BUSINESS_LINE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getAcquiringBusinessLineId() {
    return acquiringBusinessLineId;
  }

  /**
   * The unique identifier of the business line that will be the source of funds.This must be a business line for a **receivePayments** or **receiveFromPlatformPayments** capability.
   *
   * @param acquiringBusinessLineId
   *
   * @deprecated since Legal Entity Management API v3
   * This field will be removed in v4.
   */ 
  @Deprecated
  @JsonProperty(JSON_PROPERTY_ACQUIRING_BUSINESS_LINE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAcquiringBusinessLineId(String acquiringBusinessLineId) {
    this.acquiringBusinessLineId = acquiringBusinessLineId;
  }

  /**
   * Indicates whether the funds are coming from transactions processed by Adyen. If **false**, a &#x60;description&#x60; is required.
   *
   * @param adyenProcessedFunds
   * @return the current {@code SourceOfFunds} instance, allowing for method chaining
   */
  public SourceOfFunds adyenProcessedFunds(Boolean adyenProcessedFunds) {
    this.adyenProcessedFunds = adyenProcessedFunds;
    return this;
  }

  /**
   * Indicates whether the funds are coming from transactions processed by Adyen. If **false**, a &#x60;description&#x60; is required.
   * @return adyenProcessedFunds
   */
  @ApiModelProperty(value = "Indicates whether the funds are coming from transactions processed by Adyen. If **false**, a `description` is required.")
  @JsonProperty(JSON_PROPERTY_ADYEN_PROCESSED_FUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getAdyenProcessedFunds() {
    return adyenProcessedFunds;
  }

  /**
   * Indicates whether the funds are coming from transactions processed by Adyen. If **false**, a &#x60;description&#x60; is required.
   *
   * @param adyenProcessedFunds
   */ 
  @JsonProperty(JSON_PROPERTY_ADYEN_PROCESSED_FUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdyenProcessedFunds(Boolean adyenProcessedFunds) {
    this.adyenProcessedFunds = adyenProcessedFunds;
  }

  /**
   * Text describing the source of funds. For example, for &#x60;type&#x60; **business**, provide a description of where the business transactions come from, such as payments through bank transfer. Required when &#x60;adyenProcessedFunds&#x60; is **false**.
   *
   * @param description
   * @return the current {@code SourceOfFunds} instance, allowing for method chaining
   */
  public SourceOfFunds description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Text describing the source of funds. For example, for &#x60;type&#x60; **business**, provide a description of where the business transactions come from, such as payments through bank transfer. Required when &#x60;adyenProcessedFunds&#x60; is **false**.
   * @return description
   */
  @ApiModelProperty(value = "Text describing the source of funds. For example, for `type` **business**, provide a description of where the business transactions come from, such as payments through bank transfer. Required when `adyenProcessedFunds` is **false**.")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getDescription() {
    return description;
  }

  /**
   * Text describing the source of funds. For example, for &#x60;type&#x60; **business**, provide a description of where the business transactions come from, such as payments through bank transfer. Required when &#x60;adyenProcessedFunds&#x60; is **false**.
   *
   * @param description
   */ 
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   * The type of the source of funds. Possible value: **business**.
   *
   * @param type
   * @return the current {@code SourceOfFunds} instance, allowing for method chaining
   */
  public SourceOfFunds type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * The type of the source of funds. Possible value: **business**.
   * @return type
   */
  @ApiModelProperty(value = "The type of the source of funds. Possible value: **business**.")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public TypeEnum getType() {
    return type;
  }

  /**
   * The type of the source of funds. Possible value: **business**.
   *
   * @param type
   */ 
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /**
   * Return true if this SourceOfFunds object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SourceOfFunds sourceOfFunds = (SourceOfFunds) o;
    return Objects.equals(this.acquiringBusinessLineId, sourceOfFunds.acquiringBusinessLineId) &&
        Objects.equals(this.adyenProcessedFunds, sourceOfFunds.adyenProcessedFunds) &&
        Objects.equals(this.description, sourceOfFunds.description) &&
        Objects.equals(this.type, sourceOfFunds.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(acquiringBusinessLineId, adyenProcessedFunds, description, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SourceOfFunds {\n");
    sb.append("    acquiringBusinessLineId: ").append(toIndentedString(acquiringBusinessLineId)).append("\n");
    sb.append("    adyenProcessedFunds: ").append(toIndentedString(adyenProcessedFunds)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of SourceOfFunds given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of SourceOfFunds
   * @throws JsonProcessingException if the JSON string is invalid with respect to SourceOfFunds
   */
  public static SourceOfFunds fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, SourceOfFunds.class);
  }
/**
  * Convert an instance of SourceOfFunds to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
