/*
 * Management API
 *
 * The version of the OpenAPI document: 3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.management;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * SupportedCardTypes
 */
@JsonPropertyOrder({
  SupportedCardTypes.JSON_PROPERTY_CREDIT,
  SupportedCardTypes.JSON_PROPERTY_DEBIT,
  SupportedCardTypes.JSON_PROPERTY_DEFERRED_DEBIT,
  SupportedCardTypes.JSON_PROPERTY_PREPAID,
  SupportedCardTypes.JSON_PROPERTY_UNKNOWN
})

public class SupportedCardTypes {
  public static final String JSON_PROPERTY_CREDIT = "credit";
  private Boolean credit;

  public static final String JSON_PROPERTY_DEBIT = "debit";
  private Boolean debit;

  public static final String JSON_PROPERTY_DEFERRED_DEBIT = "deferredDebit";
  private Boolean deferredDebit;

  public static final String JSON_PROPERTY_PREPAID = "prepaid";
  private Boolean prepaid;

  public static final String JSON_PROPERTY_UNKNOWN = "unknown";
  private Boolean unknown;

  public SupportedCardTypes() { 
  }

  /**
   * Set to **true** to accept credit cards.
   *
   * @param credit
   * @return the current {@code SupportedCardTypes} instance, allowing for method chaining
   */
  public SupportedCardTypes credit(Boolean credit) {
    this.credit = credit;
    return this;
  }

  /**
   * Set to **true** to accept credit cards.
   * @return credit
   */
  @ApiModelProperty(value = "Set to **true** to accept credit cards.")
  @JsonProperty(JSON_PROPERTY_CREDIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getCredit() {
    return credit;
  }

  /**
   * Set to **true** to accept credit cards.
   *
   * @param credit
   */ 
  @JsonProperty(JSON_PROPERTY_CREDIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCredit(Boolean credit) {
    this.credit = credit;
  }

  /**
   * Set to **true** to accept debit cards.
   *
   * @param debit
   * @return the current {@code SupportedCardTypes} instance, allowing for method chaining
   */
  public SupportedCardTypes debit(Boolean debit) {
    this.debit = debit;
    return this;
  }

  /**
   * Set to **true** to accept debit cards.
   * @return debit
   */
  @ApiModelProperty(value = "Set to **true** to accept debit cards.")
  @JsonProperty(JSON_PROPERTY_DEBIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getDebit() {
    return debit;
  }

  /**
   * Set to **true** to accept debit cards.
   *
   * @param debit
   */ 
  @JsonProperty(JSON_PROPERTY_DEBIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDebit(Boolean debit) {
    this.debit = debit;
  }

  /**
   * Set to **true** to accept cards that allow deferred debit.
   *
   * @param deferredDebit
   * @return the current {@code SupportedCardTypes} instance, allowing for method chaining
   */
  public SupportedCardTypes deferredDebit(Boolean deferredDebit) {
    this.deferredDebit = deferredDebit;
    return this;
  }

  /**
   * Set to **true** to accept cards that allow deferred debit.
   * @return deferredDebit
   */
  @ApiModelProperty(value = "Set to **true** to accept cards that allow deferred debit.")
  @JsonProperty(JSON_PROPERTY_DEFERRED_DEBIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getDeferredDebit() {
    return deferredDebit;
  }

  /**
   * Set to **true** to accept cards that allow deferred debit.
   *
   * @param deferredDebit
   */ 
  @JsonProperty(JSON_PROPERTY_DEFERRED_DEBIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeferredDebit(Boolean deferredDebit) {
    this.deferredDebit = deferredDebit;
  }

  /**
   * Set to **true** to accept prepaid cards.
   *
   * @param prepaid
   * @return the current {@code SupportedCardTypes} instance, allowing for method chaining
   */
  public SupportedCardTypes prepaid(Boolean prepaid) {
    this.prepaid = prepaid;
    return this;
  }

  /**
   * Set to **true** to accept prepaid cards.
   * @return prepaid
   */
  @ApiModelProperty(value = "Set to **true** to accept prepaid cards.")
  @JsonProperty(JSON_PROPERTY_PREPAID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getPrepaid() {
    return prepaid;
  }

  /**
   * Set to **true** to accept prepaid cards.
   *
   * @param prepaid
   */ 
  @JsonProperty(JSON_PROPERTY_PREPAID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrepaid(Boolean prepaid) {
    this.prepaid = prepaid;
  }

  /**
   * Set to **true** to accept card types for which the terminal can&#39;t determine the funding source while offline.
   *
   * @param unknown
   * @return the current {@code SupportedCardTypes} instance, allowing for method chaining
   */
  public SupportedCardTypes unknown(Boolean unknown) {
    this.unknown = unknown;
    return this;
  }

  /**
   * Set to **true** to accept card types for which the terminal can&#39;t determine the funding source while offline.
   * @return unknown
   */
  @ApiModelProperty(value = "Set to **true** to accept card types for which the terminal can't determine the funding source while offline.")
  @JsonProperty(JSON_PROPERTY_UNKNOWN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public Boolean getUnknown() {
    return unknown;
  }

  /**
   * Set to **true** to accept card types for which the terminal can&#39;t determine the funding source while offline.
   *
   * @param unknown
   */ 
  @JsonProperty(JSON_PROPERTY_UNKNOWN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUnknown(Boolean unknown) {
    this.unknown = unknown;
  }

  /**
   * Return true if this SupportedCardTypes object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SupportedCardTypes supportedCardTypes = (SupportedCardTypes) o;
    return Objects.equals(this.credit, supportedCardTypes.credit) &&
        Objects.equals(this.debit, supportedCardTypes.debit) &&
        Objects.equals(this.deferredDebit, supportedCardTypes.deferredDebit) &&
        Objects.equals(this.prepaid, supportedCardTypes.prepaid) &&
        Objects.equals(this.unknown, supportedCardTypes.unknown);
  }

  @Override
  public int hashCode() {
    return Objects.hash(credit, debit, deferredDebit, prepaid, unknown);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SupportedCardTypes {\n");
    sb.append("    credit: ").append(toIndentedString(credit)).append("\n");
    sb.append("    debit: ").append(toIndentedString(debit)).append("\n");
    sb.append("    deferredDebit: ").append(toIndentedString(deferredDebit)).append("\n");
    sb.append("    prepaid: ").append(toIndentedString(prepaid)).append("\n");
    sb.append("    unknown: ").append(toIndentedString(unknown)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of SupportedCardTypes given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of SupportedCardTypes
   * @throws JsonProcessingException if the JSON string is invalid with respect to SupportedCardTypes
   */
  public static SupportedCardTypes fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, SupportedCardTypes.class);
  }
/**
  * Convert an instance of SupportedCardTypes to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
