/*
 * Payments App API
 *
 * The version of the OpenAPI document: 1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.adyen.model.paymentsapp;

import java.util.Objects;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;


/**
 * PaymentsAppDto
 */
@JsonPropertyOrder({
  PaymentsAppDto.JSON_PROPERTY_INSTALLATION_ID,
  PaymentsAppDto.JSON_PROPERTY_MERCHANT_ACCOUNT_CODE,
  PaymentsAppDto.JSON_PROPERTY_MERCHANT_STORE_CODE,
  PaymentsAppDto.JSON_PROPERTY_STATUS
})

public class PaymentsAppDto {
  public static final String JSON_PROPERTY_INSTALLATION_ID = "installationId";
  private String installationId;

  public static final String JSON_PROPERTY_MERCHANT_ACCOUNT_CODE = "merchantAccountCode";
  private String merchantAccountCode;

  public static final String JSON_PROPERTY_MERCHANT_STORE_CODE = "merchantStoreCode";
  private String merchantStoreCode;

  public static final String JSON_PROPERTY_STATUS = "status";
  private String status;

  public PaymentsAppDto() { 
  }

  /**
   * The unique identifier of the Payments App instance.
   *
   * @param installationId
   * @return the current {@code PaymentsAppDto} instance, allowing for method chaining
   */
  public PaymentsAppDto installationId(String installationId) {
    this.installationId = installationId;
    return this;
  }

  /**
   * The unique identifier of the Payments App instance.
   * @return installationId
   */
  @ApiModelProperty(required = true, value = "The unique identifier of the Payments App instance.")
  @JsonProperty(JSON_PROPERTY_INSTALLATION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getInstallationId() {
    return installationId;
  }

  /**
   * The unique identifier of the Payments App instance.
   *
   * @param installationId
   */ 
  @JsonProperty(JSON_PROPERTY_INSTALLATION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInstallationId(String installationId) {
    this.installationId = installationId;
  }

  /**
   * The account code associated with the Payments App instance.
   *
   * @param merchantAccountCode
   * @return the current {@code PaymentsAppDto} instance, allowing for method chaining
   */
  public PaymentsAppDto merchantAccountCode(String merchantAccountCode) {
    this.merchantAccountCode = merchantAccountCode;
    return this;
  }

  /**
   * The account code associated with the Payments App instance.
   * @return merchantAccountCode
   */
  @ApiModelProperty(required = true, value = "The account code associated with the Payments App instance.")
  @JsonProperty(JSON_PROPERTY_MERCHANT_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMerchantAccountCode() {
    return merchantAccountCode;
  }

  /**
   * The account code associated with the Payments App instance.
   *
   * @param merchantAccountCode
   */ 
  @JsonProperty(JSON_PROPERTY_MERCHANT_ACCOUNT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantAccountCode(String merchantAccountCode) {
    this.merchantAccountCode = merchantAccountCode;
  }

  /**
   * The store code associated with the Payments App instance.
   *
   * @param merchantStoreCode
   * @return the current {@code PaymentsAppDto} instance, allowing for method chaining
   */
  public PaymentsAppDto merchantStoreCode(String merchantStoreCode) {
    this.merchantStoreCode = merchantStoreCode;
    return this;
  }

  /**
   * The store code associated with the Payments App instance.
   * @return merchantStoreCode
   */
  @ApiModelProperty(value = "The store code associated with the Payments App instance.")
  @JsonProperty(JSON_PROPERTY_MERCHANT_STORE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getMerchantStoreCode() {
    return merchantStoreCode;
  }

  /**
   * The store code associated with the Payments App instance.
   *
   * @param merchantStoreCode
   */ 
  @JsonProperty(JSON_PROPERTY_MERCHANT_STORE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMerchantStoreCode(String merchantStoreCode) {
    this.merchantStoreCode = merchantStoreCode;
  }

  /**
   * The status of the Payments App instance.
   *
   * @param status
   * @return the current {@code PaymentsAppDto} instance, allowing for method chaining
   */
  public PaymentsAppDto status(String status) {
    this.status = status;
    return this;
  }

  /**
   * The status of the Payments App instance.
   * @return status
   */
  @ApiModelProperty(required = true, value = "The status of the Payments App instance.")
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public String getStatus() {
    return status;
  }

  /**
   * The status of the Payments App instance.
   *
   * @param status
   */ 
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(String status) {
    this.status = status;
  }

  /**
   * Return true if this PaymentsAppDto object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentsAppDto paymentsAppDto = (PaymentsAppDto) o;
    return Objects.equals(this.installationId, paymentsAppDto.installationId) &&
        Objects.equals(this.merchantAccountCode, paymentsAppDto.merchantAccountCode) &&
        Objects.equals(this.merchantStoreCode, paymentsAppDto.merchantStoreCode) &&
        Objects.equals(this.status, paymentsAppDto.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(installationId, merchantAccountCode, merchantStoreCode, status);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentsAppDto {\n");
    sb.append("    installationId: ").append(toIndentedString(installationId)).append("\n");
    sb.append("    merchantAccountCode: ").append(toIndentedString(merchantAccountCode)).append("\n");
    sb.append("    merchantStoreCode: ").append(toIndentedString(merchantStoreCode)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

/**
   * Create an instance of PaymentsAppDto given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of PaymentsAppDto
   * @throws JsonProcessingException if the JSON string is invalid with respect to PaymentsAppDto
   */
  public static PaymentsAppDto fromJson(String jsonString) throws JsonProcessingException {
    return JSON.getMapper().readValue(jsonString, PaymentsAppDto.class);
  }
/**
  * Convert an instance of PaymentsAppDto to an JSON string
  *
  * @return JSON string
  */
  public String toJson() throws JsonProcessingException {
    return JSON.getMapper().writeValueAsString(this);
  }
}
